/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.part;

import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.LibraryBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTStatementVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.PrimitiveType;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.compiler.internal.core.validation.part.FunctionContainerValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class LibraryValidator
extends FunctionContainerValidator {
    String libraryName = "";
    Library library = null;

    public LibraryValidator(IProblemRequestor problemRequestor, LibraryBinding partBinding, ICompilerOptions compilerOptions) {
        super(problemRequestor, partBinding, compilerOptions);
        this.libraryName = partBinding.getCaseSensitiveName();
    }

    @Override
    public boolean visit(Library alibrary) {
        this.library = alibrary;
        this.partNode = alibrary;
        EGLNameValidator.validate(this.library.getName(), 22, this.problemRequestor, this.compilerOptions);
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(alibrary);
        this.checkCallInterface(alibrary.getName(), (LibraryBinding)alibrary.getName().resolveBinding());
        return true;
    }

    @Override
    public boolean visit(ClassDataDeclaration classDataDeclaration) {
        super.visit(classDataDeclaration);
        return false;
    }

    @Override
    public boolean visit(NestedFunction nestedFunction) {
        super.visit(nestedFunction);
        this.validateLibraryFunctions(nestedFunction);
        return false;
    }

    private void validateLibraryFunctions(final NestedFunction nestedFunction) {
        final LibraryBinding libBinding = (LibraryBinding)this.partBinding;
        if (InternUtil.intern((String)nestedFunction.getName().getCanonicalName()) == InternUtil.intern((String)"main")) {
            this.problemRequestor.acceptProblem((Node)this.library.getName(), 5600, new String[]{this.libraryName});
            return;
        }
        nestedFunction.accept(new AbstractASTStatementVisitor(){

            @Override
            public void visitStatement(Statement stmt) {
                if (libBinding.getAnnotation(new String[]{"egl", "core"}, "NativeLibrary") != null) {
                    LibraryValidator.this.problemRequestor.acceptProblem(stmt, 5612);
                }
            }

            @Override
            public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
                if (libBinding.getAnnotation(new String[]{"egl", "core"}, "NativeLibrary") != null) {
                    LibraryValidator.this.problemRequestor.acceptProblem((Node)functionDataDeclaration, functionDataDeclaration.isConstant() ? 5611 : 5613, new String[]{((SimpleName)functionDataDeclaration.getNames().get(0)).getCanonicalName(), nestedFunction.getName().getCanonicalName()});
                }
                return false;
            }
        });
        nestedFunction.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(FunctionParameter functionParameter) {
                Type parmType = functionParameter.getType();
                ITypeBinding binding = parmType.resolveTypeBinding();
                if (parmType.isPrimitiveType()) {
                    PrimitiveType pType = (PrimitiveType)parmType;
                    int primitiveInt = pType.getPrimitive().getType();
                    int primitiveLength = ((PrimitiveTypeBinding)binding).getLength();
                    if ((primitiveInt == 2 || primitiveInt == 13 || primitiveInt == 15 || primitiveInt == 16 || primitiveInt == 4 || primitiveInt == 5 || primitiveInt == 11 || primitiveInt == 9 || primitiveInt == 20) && (!pType.hasPrimLength() || pType.hasPrimLength() && primitiveLength == 0)) {
                        LibraryValidator.this.problemRequestor.acceptProblem((Node)parmType, 5602, new String[]{functionParameter.getName().getCanonicalName(), parmType.getCanonicalName(), nestedFunction.getName().getCanonicalName(), LibraryValidator.this.libraryName});
                    }
                    if (functionParameter.getAttrType() == FunctionParameter.AttrType.FIELD) {
                        LibraryValidator.this.problemRequestor.acceptProblem((Node)functionParameter, 5604, new String[]{functionParameter.getName().getCanonicalName(), nestedFunction.getName().getCanonicalName(), LibraryValidator.this.libraryName, "field"});
                    }
                }
                if (libBinding.getAnnotation(new String[]{"egl", "core"}, "NativeLibrary") != null) {
                    if (StatementValidator.isValidBinding(binding) && (binding.getKind() == 6 || binding.getKind() == 7)) {
                        LibraryValidator.this.problemRequestor.acceptProblem((Node)parmType, 5608, new String[]{functionParameter.getName().getCanonicalName(), nestedFunction.getName().getCanonicalName(), LibraryValidator.this.libraryName});
                    }
                    if (parmType.isArrayType()) {
                        LibraryValidator.this.problemRequestor.acceptProblem((Node)functionParameter, 5606, new String[]{functionParameter.getName().getCanonicalName(), nestedFunction.getName().getCanonicalName(), LibraryValidator.this.libraryName});
                    }
                    if (functionParameter.isParmConst()) {
                        LibraryValidator.this.problemRequestor.acceptProblem((Node)functionParameter, 5605, new String[]{functionParameter.getName().getCanonicalName(), nestedFunction.getName().getCanonicalName(), LibraryValidator.this.libraryName, "const"});
                    }
                }
                return true;
            }
        });
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        super.visit(settingsBlock);
        return false;
    }

    @Override
    public boolean visit(UseStatement useStatement) {
        super.visit(useStatement);
        LibraryBinding libBinding = (LibraryBinding)this.partBinding;
        if (libBinding.getAnnotation(new String[]{"egl", "core"}, "NativeLibrary") != null) {
            this.problemRequestor.acceptProblem((Node)useStatement, 5616, new String[]{((Name)useStatement.getNames().get(0)).getCanonicalName(), libBinding.getCaseSensitiveName()});
        }
        return false;
    }

    private void checkCallInterface(Name libraryNameNode, LibraryBinding libraryBinding) {
        IAnnotationBinding aBinding = libraryBinding.getAnnotation(new String[]{"egl", "io", "dli"}, "DLI");
        if (aBinding != null && (aBinding = (IAnnotationBinding)aBinding.findData(InternUtil.intern((String)"callInterface"))) != IBinding.NOT_FOUND_BINDING && InternUtil.intern((String)"CBLTDLI") == ((EnumerationDataBinding)aBinding.getValue()).getName()) {
            this.problemRequestor.acceptProblem(libraryNameNode, 7946);
        }
    }
}

