/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ArrayAccess;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.AssignmentStatement;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.SubstringAccess;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.VAGenResolutionWarningsValidator;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.statement.LValueValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.RValueValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class AssignmentStatementValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;
    private IPartBinding enclosingPart;

    public AssignmentStatementValidator(IProblemRequestor problemRequestor, ICompilerOptions compilerOptions, IPartBinding enclosingPart) {
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
        this.enclosingPart = enclosingPart;
    }

    @Override
    public boolean visit(AssignmentStatement assignmentStatement) {
        Assignment assignment = assignmentStatement.getAssignment();
        Expression lhs = assignment.getLeftHandSide();
        Expression rhs = assignment.getRightHandSide();
        ITypeBinding lhsBinding = lhs.resolveTypeBinding();
        ITypeBinding rhsBinding = rhs.resolveTypeBinding();
        IDataBinding lhsDataBinding = lhs.resolveDataBinding();
        IDataBinding rhsDataBinding = rhs.resolveDataBinding();
        new VAGenResolutionWarningsValidator(this.problemRequestor, this.compilerOptions).checkOperands(this.enclosingPart, lhs, rhs, assignment);
        return this.validateAssignment(assignmentStatement.getAssignment().getOperator(), lhs, rhs, lhsBinding, rhsBinding, lhsDataBinding, rhsDataBinding, false, DefaultBinder.isArithmeticAssignment(assignment));
    }

    public boolean validateAssignment(Assignment.Operator assignmentOperator, Expression lhs, Expression rhs, ITypeBinding lhsBinding, ITypeBinding rhsBinding, IDataBinding lhsDataBinding, IDataBinding rhsDataBinding, boolean bDeclaration, boolean isArithmetic) {
        return this.validateAssignment(assignmentOperator, lhs, rhs, lhsBinding, rhsBinding, lhsDataBinding, rhsDataBinding, bDeclaration, isArithmetic, new LValueValidator.DefaultLValueValidationRules());
    }

    public boolean validateAssignment(Assignment.Operator assignmentOperator, Expression lhs, Expression rhs, ITypeBinding lhsBinding, ITypeBinding rhsBinding, IDataBinding lhsDataBinding, IDataBinding rhsDataBinding, boolean bDeclaration, boolean isArithmetic, LValueValidator.ILValueValidationRules lvalueValidationRules) {
        if (lhs instanceof SubstringAccess) {
            this.problemRequestor.acceptProblem((Node)lhs, 6649, new String[0]);
        }
        if (Assignment.Operator.PLUS == assignmentOperator && this.isStringType(lhsBinding)) {
            if (StatementValidator.isValidBinding(lhsDataBinding)) {
                new LValueValidator(this.problemRequestor, this.compilerOptions, lhsDataBinding, lhs, lvalueValidationRules).validate();
            }
            if (StatementValidator.isValidBinding(rhsDataBinding)) {
                new RValueValidator(this.problemRequestor, this.compilerOptions, rhsDataBinding, rhs).validate();
            }
            return false;
        }
        if (Assignment.Operator.CONCAT == assignmentOperator && StatementValidator.isValidBinding(lhsBinding) && 2 == lhsBinding.getKind() && (!StatementValidator.isValidBinding(rhsBinding) || 2 != rhsBinding.getKind())) {
            lhsBinding = ((ArrayTypeBinding)lhsBinding).getElementType();
        }
        if (Assignment.Operator.XOR == assignmentOperator || Assignment.Operator.OR == assignmentOperator || Assignment.Operator.AND == assignmentOperator) {
            rhsBinding = PrimitiveTypeBinding.getInstance(Primitive.INT);
        }
        if (StatementValidator.isValidBinding(lhsBinding) && lhsBinding.getAnnotation(new String[]{"egl", "io", "dli"}, "PSBRecord") != null && StatementValidator.isValidBinding(rhsBinding) && rhsBinding.getAnnotation(new String[]{"egl", "io", "dli"}, "PSBRecord") != null) {
            this.problemRequestor.acceptProblem((Node)lhs, 6653, new String[]{"PSBRecord", "PSBRecord", String.valueOf(lhs.getCanonicalString()) + " = " + rhs.getCanonicalString()});
            return false;
        }
        if (StatementValidator.isValidBinding(rhsBinding) && (rhsBinding.getKind() == 6 || rhsBinding.getKind() == 6)) {
            boolean isError;
            boolean bl = isError = !StatementValidator.isValidBinding(lhsBinding);
            if (!isError) {
                Primitive type;
                boolean isRecord = lhsBinding.getKind() == 7 || lhsBinding.getKind() == 6;
                boolean isChar = false;
                if (lhsBinding.getKind() == 3 && ((type = ((PrimitiveTypeBinding)lhsBinding).getPrimitive()) == Primitive.CHAR || type == Primitive.MBCHAR || type == Primitive.HEX || type == Primitive.ANY || type == Primitive.DBCHARLIT)) {
                    isChar = true;
                }
                if (!isRecord && !isChar) {
                    isError = true;
                }
            }
            if (isError) {
                this.problemRequestor.acceptProblem((Node)rhs, 6651, new String[]{rhs.getCanonicalString(), lhs.getCanonicalString()});
                return false;
            }
        }
        if (StatementValidator.isValidBinding(lhsBinding) && lhsBinding.getKind() == 7 && StatementValidator.isValidBinding(rhsBinding) && rhsBinding.getKind() == 6) {
            this.problemRequestor.acceptProblem(rhs, 4030);
            return false;
        }
        if (StatementValidator.isValidBinding(lhsBinding) && lhsBinding.getKind() == 6) {
            Primitive type;
            if (StatementValidator.isValidBinding(rhsBinding) && rhsBinding.getKind() == 7) {
                this.problemRequestor.acceptProblem(rhs, 4029);
                return false;
            }
            if (StatementValidator.isValidBinding(rhsBinding) && rhsBinding.getKind() == 3 && (type = ((PrimitiveTypeBinding)rhsBinding).getPrimitive()) != Primitive.CHAR && type != Primitive.MBCHAR && type != Primitive.HEX && type != Primitive.ANY && type != Primitive.DBCHARLIT && (type != Primitive.STRING || ((PrimitiveTypeBinding)rhsBinding).getLength() == 0)) {
                this.problemRequestor.acceptProblem((Node)rhs, 6650, new String[]{lhs.getCanonicalString()});
                return false;
            }
        }
        if (StatementValidator.isValidBinding(lhsBinding) && lhsBinding.getKind() == 21) {
            final Expression expr = lhs;
            ErrorASTVisitor astVisitor = new ErrorASTVisitor(){

                @Override
                public boolean visit(SimpleName simpleName) {
                    if (StatementValidator.isValidBinding(simpleName.resolveTypeBinding()) && simpleName.resolveTypeBinding().getKind() == 22) {
                        AssignmentStatementValidator.this.problemRequestor.acceptProblem(expr, 7744);
                        this.error = true;
                    }
                    return false;
                }
            };
            lhs.accept(astVisitor);
            if (astVisitor.hasError()) {
                return false;
            }
        }
        if (StatementValidator.isValidBinding(lhsBinding) && StatementValidator.isValidBinding(rhsBinding) && StatementValidator.isArrayOrMultiplyOccuring(lhsDataBinding) && StatementValidator.isArrayOrMultiplyOccuring(rhsDataBinding) && (26 == lhsBinding.getKind() && 26 != rhsBinding.getKind() || 26 == rhsBinding.getKind() && 26 != lhsBinding.getKind())) {
            this.problemRequestor.acceptProblem((Node)rhs, 6714, new String[]{lhsDataBinding.getCaseSensitiveName(), rhsDataBinding.getCaseSensitiveName()});
            return false;
        }
        if (StatementValidator.isValidBinding(lhsBinding) && 26 == lhsBinding.getKind() && StatementValidator.isValidBinding(rhsBinding) && !rhsBinding.isDynamic()) {
            this.problemRequestor.acceptProblem((Node)rhs, 6715, new String[]{lhs.getCanonicalString(), rhs.getCanonicalString()});
            return false;
        }
        if (StatementValidator.isValidBinding(rhsBinding) && 26 == rhsBinding.getKind() && StatementValidator.isValidBinding(lhsBinding) && !lhsBinding.isDynamic()) {
            this.problemRequestor.acceptProblem((Node)rhs, 6715, new String[]{lhs.getCanonicalString(), rhs.getCanonicalString()});
            return false;
        }
        if (!isArithmetic) {
            boolean compatible;
            boolean bl = compatible = TypeCompatibilityUtil.isMoveCompatible(lhsBinding, rhsBinding, rhs, this.compilerOptions) || StatementValidator.isValidBinding(rhsBinding) && (rhsBinding.isDynamic() || TypeCompatibilityUtil.areCompatibleExceptions(rhsBinding, lhsBinding, this.compilerOptions));
            if (!compatible) {
                this.problemRequestor.acceptProblem((Node)rhs, 6653, new String[]{lhsBinding != null ? StatementValidator.getShortTypeString(lhsBinding) : lhs.getCanonicalString(), rhsBinding != null ? StatementValidator.getShortTypeString(rhsBinding) : rhs.getCanonicalString(), String.valueOf(lhs.getCanonicalString()) + " = " + rhs.getCanonicalString()});
            }
        }
        if (StatementValidator.isValidBinding(lhsDataBinding)) {
            new LValueValidator(this.problemRequestor, this.compilerOptions, lhsDataBinding, lhs, lvalueValidationRules).validate();
        }
        if (StatementValidator.isValidBinding(rhsDataBinding)) {
            new RValueValidator(this.problemRequestor, this.compilerOptions, rhsDataBinding, rhs).validate();
        }
        if (Binding.isValidBinding(lhsBinding) && Binding.isValidBinding(rhsBinding) && rhsBinding.getKind() == 25 && !lhsBinding.isNullable()) {
            this.problemRequestor.acceptProblem((Node)lhs, 6757, new String[]{lhs.getCanonicalString()});
        }
        return false;
    }

    private String getCanonicalStringNoSubscripts(Expression expr) {
        final String[] result = new String[1];
        expr.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visitExpression(Expression expression) {
                result[0] = expression.getCanonicalString();
                return false;
            }

            @Override
            public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                return true;
            }

            @Override
            public boolean visit(ArrayAccess arrayAccess) {
                arrayAccess.getArray().accept(this);
                return false;
            }

            @Override
            public boolean visit(SubstringAccess substringAccess) {
                substringAccess.getPrimary().accept(this);
                return false;
            }
        });
        return result[0];
    }

    private boolean isStringType(ITypeBinding type) {
        if (!Binding.isValidBinding(type)) {
            return false;
        }
        return type.getKind() == 3 && Primitive.isStringType(((PrimitiveTypeBinding)type).getPrimitive());
    }

    private class ErrorASTVisitor
    extends AbstractASTVisitor {
        boolean error = false;

        private ErrorASTVisitor() {
        }

        public boolean hasError() {
            return this.error;
        }
    }
}

