/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.ArrayList;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.sqltokenizer.EGLPrimeToken;
import org.eclipse.edt.compiler.internal.sqltokenizer.EGLSQLClauseTree;
import org.eclipse.edt.compiler.internal.sqltokenizer.EGLSQLParser;

public class SQLStatementValidator {
    public static void checkAddClauses(WithInlineSQLClause withInlineSQLClause, EGLSQLParser parser, IProblemRequestor problemRequestor) {
        ArrayList clauseKeywords = parser.getSqlClauseKeywordsUsed();
        if (!clauseKeywords.contains("insert")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6501, new String[]{"add".toUpperCase(), String.valueOf("insert".toUpperCase()) + " " + "into".toUpperCase()});
        }
        if (!clauseKeywords.contains("columns")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6502, new String[]{"add".toUpperCase()});
        }
        if (!clauseKeywords.contains("values")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6501, new String[]{"add".toUpperCase(), "values".toUpperCase()});
        }
        SQLStatementValidator.checkAddClauseOrder(withInlineSQLClause, problemRequestor, clauseKeywords);
        SQLStatementValidator.checkAddExtraDupeClauses(withInlineSQLClause, parser, problemRequestor);
    }

    public static int getPartitionEndOffset(WithInlineSQLClause withInlineSQLClause) {
        return SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause) + withInlineSQLClause.getSqlStmt().getLength();
    }

    public static int getPartitionStartOffset(WithInlineSQLClause withInlineSQLClause) {
        return withInlineSQLClause.getSqlStmt().getOffset();
    }

    public static int getStatementStartOffset(WithInlineSQLClause withInlineSQLClause) {
        return withInlineSQLClause.getSqlStmt().getValueOffset();
    }

    protected static void checkAddExtraDupeClauses(WithInlineSQLClause withInlineSQLClause, EGLSQLParser parser, IProblemRequestor problemRequestor) {
        ArrayList allClauses = parser.getSqlClauses();
        EGLSQLClauseTree clause = parser.getInsertIntoTokens();
        if (clause != null) {
            SQLStatementValidator.checkEmptyClause(withInlineSQLClause, clause, parser, problemRequestor);
            allClauses.remove(clause);
        }
        if ((clause = parser.getColumnsTokens()) != null) {
            allClauses.remove(clause);
        }
        if ((clause = parser.getValuesTokens()) != null) {
            SQLStatementValidator.checkEmptyClause(withInlineSQLClause, clause, parser, problemRequestor);
            allClauses.remove(clause);
        }
        int ii = 0;
        while (ii < allClauses.size()) {
            EGLPrimeToken clauseKeyword = ((EGLSQLClauseTree)allClauses.get(ii)).getClauseKeyword();
            if (!SQLStatementValidator.startsWithParen(allClauses, ii, clauseKeyword)) {
                if (clauseKeyword.getType() == 11 || clauseKeyword.getType() == 4) {
                    problemRequestor.acceptProblem(SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset(), SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset() + clauseKeyword.getText().length(), 2, 6506, new String[]{"add".toUpperCase(), SQLStatementValidator.getKeyword((EGLSQLClauseTree)allClauses.get(ii))});
                } else {
                    problemRequestor.acceptProblem(SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset(), SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset() + clauseKeyword.getText().length(), 2, 6507, new String[]{"add".toUpperCase(), SQLStatementValidator.getKeyword((EGLSQLClauseTree)allClauses.get(ii))});
                }
            }
            ++ii;
        }
    }

    protected static void checkAddClauseOrder(WithInlineSQLClause withInlineSQLClause, IProblemRequestor problemRequestor, ArrayList clauseKeywords) {
        if (clauseKeywords.indexOf("insert") > -1 && clauseKeywords.indexOf("values") > -1 && clauseKeywords.indexOf("insert") > clauseKeywords.indexOf("values")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{"add".toUpperCase(), String.valueOf("insert".toUpperCase()) + " " + "into".toUpperCase(), "values".toUpperCase()});
        }
        if (clauseKeywords.indexOf("columns") > -1 && clauseKeywords.indexOf("values") > -1 && clauseKeywords.indexOf("columns") > clauseKeywords.indexOf("values")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6505, new String[]{"add".toUpperCase(), "values".toUpperCase()});
        }
    }

    public static void checkEmptyClause(WithInlineSQLClause withInlineSQLClause, EGLSQLClauseTree clause, EGLSQLParser parser, IProblemRequestor problemRequestor) {
        EGLSQLClauseTree whereClause;
        int keywords = 1;
        if (clause.getThirdKeyword() != null) {
            keywords = 3;
        } else if (clause.getSecondKeyword() != null) {
            keywords = 2;
        }
        if (clause.size() == keywords) {
            int token = clause.size() - 1;
            if (keywords == 2) {
                --token;
            }
            if (keywords == 3) {
                token -= 2;
            }
            problemRequestor.acceptProblem(SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clause.getClauseKeyword().getOffset(), SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clause.getClauseKeyword().getOffset() + clause.getToken(token).getText().length(), 2, 6531, new String[]{SQLStatementValidator.getKeyword(clause)});
        }
        if (clause.getClauseKeyword().getType() == 8 && clause.size() > 2 && clause.getToken(1).getType() == 28 && (whereClause = parser.getClauseWOCommentsAndHostVariables(clause)).size() == 1) {
            problemRequestor.acceptProblem(SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clause.getToken(1).getOffset(), SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clause.getLastToken().getOffset() + clause.getLastToken().getText().length(), 2, 6545);
        }
    }

    protected static String getKeyword(EGLSQLClauseTree tree) {
        StringBuffer keywordText = new StringBuffer();
        keywordText.append(tree.getClauseKeyword().getText().toUpperCase());
        if (tree.getSecondKeyword() != null) {
            keywordText.append(" " + tree.getSecondKeyword().getText().toUpperCase());
            if (tree.getThirdKeyword() != null) {
                keywordText.append(" " + tree.getThirdKeyword().getText().toUpperCase());
            }
        }
        return keywordText.toString();
    }

    public static void checkReplaceClauses(WithInlineSQLClause withInlineSQLClause, EGLSQLParser parser, IProblemRequestor problemRequestor) {
        ArrayList clauseKeywords = parser.getSqlClauseKeywordsUsed();
        if (!clauseKeywords.contains("update")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6501, new String[]{"replace".toUpperCase(), "update".toUpperCase()});
        }
        if (!clauseKeywords.contains("set")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6501, new String[]{"replace".toUpperCase(), "set".toUpperCase()});
        }
        SQLStatementValidator.checkReplaceClauseOrder(withInlineSQLClause, parser, problemRequestor, clauseKeywords);
        SQLStatementValidator.checkReplaceExtraDupeClauses(withInlineSQLClause, parser, problemRequestor);
    }

    protected static void checkReplaceExtraDupeClauses(WithInlineSQLClause withInlineSQLClause, EGLSQLParser parser, IProblemRequestor problemRequestor) {
        EGLSQLClauseTree whereClause;
        EGLSQLClauseTree whereCurrentClause;
        ArrayList allClauses = parser.getSqlClauses();
        EGLSQLClauseTree clause = parser.getUpdateTokens();
        if (clause != null) {
            SQLStatementValidator.checkEmptyClause(withInlineSQLClause, clause, parser, problemRequestor);
            allClauses.remove(clause);
        }
        if ((clause = parser.getSetTokens()) != null) {
            SQLStatementValidator.checkEmptyClause(withInlineSQLClause, clause, parser, problemRequestor);
            allClauses.remove(clause);
        }
        if ((whereCurrentClause = parser.getWhereCurrentOfTokens()) != null) {
            SQLStatementValidator.checkEmptyClause(withInlineSQLClause, whereCurrentClause, parser, problemRequestor);
            allClauses.remove(whereCurrentClause);
        }
        if ((whereClause = parser.getWhereTokens()) != null) {
            SQLStatementValidator.checkEmptyClause(withInlineSQLClause, whereClause, parser, problemRequestor);
        }
        if (whereCurrentClause == null) {
            allClauses.remove(whereClause);
        }
        int ii = 0;
        while (ii < allClauses.size()) {
            EGLPrimeToken clauseKeyword = ((EGLSQLClauseTree)allClauses.get(ii)).getClauseKeyword();
            if (!SQLStatementValidator.startsWithParen(allClauses, ii, clauseKeyword)) {
                if (clauseKeyword.getType() == 5 || clauseKeyword.getType() == 6 || parser.getWhereCurrentOfTokens() != null || parser.getWhereTokens() != null) {
                    problemRequestor.acceptProblem(SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset(), SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset() + clauseKeyword.getText().length(), 2, 6506, new String[]{"replace".toUpperCase(), SQLStatementValidator.getKeyword((EGLSQLClauseTree)allClauses.get(ii))});
                } else {
                    problemRequestor.acceptProblem(SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset(), SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset() + clauseKeyword.getText().length(), 2, 6507, new String[]{"replace".toUpperCase(), SQLStatementValidator.getKeyword((EGLSQLClauseTree)allClauses.get(ii))});
                }
            }
            ++ii;
        }
    }

    protected static void checkReplaceClauseOrder(WithInlineSQLClause withInlineSQLClause, EGLSQLParser parser, IProblemRequestor problemRequestor, ArrayList clauseKeywords) {
        if (clauseKeywords.indexOf("update") > -1 && clauseKeywords.indexOf("set") > -1 && clauseKeywords.indexOf("update") > clauseKeywords.indexOf("set")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{"replace".toUpperCase(), "update".toUpperCase(), "set".toUpperCase()});
        }
        if (parser.getWhereCurrentOfTokens() != null) {
            if (clauseKeywords.indexOf("set") > -1 && clauseKeywords.indexOf("where") > -1 && clauseKeywords.indexOf("set") > clauseKeywords.indexOf("where")) {
                problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{"replace".toUpperCase(), "set".toUpperCase(), String.valueOf("where".toUpperCase()) + " " + "current".toUpperCase() + " " + "of".toUpperCase()});
            }
            if (clauseKeywords.indexOf("update") > -1 && clauseKeywords.indexOf("where") > -1 && clauseKeywords.indexOf("update") > clauseKeywords.indexOf("where")) {
                problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{"replace".toUpperCase(), "update".toUpperCase(), String.valueOf("where".toUpperCase()) + " " + "current".toUpperCase() + " " + "of".toUpperCase()});
            }
        } else if (parser.getWhereTokens() != null) {
            if (clauseKeywords.indexOf("set") > -1 && clauseKeywords.indexOf("where") > -1 && clauseKeywords.indexOf("set") > clauseKeywords.indexOf("where")) {
                problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{"replace".toUpperCase(), "set".toUpperCase(), "where".toUpperCase()});
            }
            if (clauseKeywords.indexOf("update") > -1 && clauseKeywords.indexOf("where") > -1 && clauseKeywords.indexOf("update") > clauseKeywords.indexOf("where")) {
                problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{"replace".toUpperCase(), "update".toUpperCase(), "where".toUpperCase()});
            }
        }
    }

    public static void checkGetAndOpenClauses(WithInlineSQLClause withInlineSQLClause, EGLSQLParser parser, IProblemRequestor problemRequestor, String stmtType, boolean arrayIO) {
        ArrayList clauseKeywords = parser.getSqlClauseKeywordsUsed();
        if (clauseKeywords.contains("call") && (stmtType.equals("open") || arrayIO)) {
            SQLStatementValidator.checkGetAndOpenCallExtraDupeClauses(withInlineSQLClause, parser, problemRequestor);
        } else {
            if (!clauseKeywords.contains("select")) {
                problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6501, new String[]{stmtType.toUpperCase(), "select".toUpperCase()});
            }
            if (!clauseKeywords.contains("from")) {
                problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6501, new String[]{stmtType.toUpperCase(), "from".toUpperCase()});
            }
            SQLStatementValidator.checkGetAndOpenClauseOrder(withInlineSQLClause, problemRequestor, clauseKeywords, stmtType);
            SQLStatementValidator.checkGetAndOpenExtraDupeClauses(withInlineSQLClause, parser, problemRequestor, stmtType);
        }
    }

    protected static void checkGetAndOpenCallExtraDupeClauses(WithInlineSQLClause withInlineSQLClause, EGLSQLParser parser, IProblemRequestor problemRequestor) {
        ArrayList allClauses = (ArrayList)parser.getSqlClauses().clone();
        EGLSQLClauseTree clause = parser.getCallTokens();
        if (clause != null) {
            allClauses.remove(clause);
        }
        int ii = 0;
        while (ii < allClauses.size()) {
            EGLPrimeToken clauseKeyword = ((EGLSQLClauseTree)allClauses.get(ii)).getClauseKeyword();
            if (!SQLStatementValidator.startsWithParen(allClauses, ii, clauseKeyword)) {
                if (clauseKeyword.getType() == 17) {
                    problemRequestor.acceptProblem(SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset(), SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset() + clauseKeyword.getText().length(), 2, 6506, new String[]{"open".toUpperCase(), "call".toUpperCase()});
                } else if (clauseKeyword.getType() == 1 || clauseKeyword.getType() == 3 || clauseKeyword.getType() == 12 || clauseKeyword.getType() == 8 || clauseKeyword.getType() == 10 || clauseKeyword.getType() == 7 || clauseKeyword.getType() == 9) {
                    problemRequestor.acceptProblem(SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset(), SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset() + clauseKeyword.getText().length(), 2, 6525, new String[]{"open".toUpperCase(), SQLStatementValidator.getKeyword((EGLSQLClauseTree)allClauses.get(ii))});
                } else {
                    problemRequestor.acceptProblem(SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset(), SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset() + clauseKeyword.getText().length(), 2, 6507, new String[]{"open".toUpperCase(), SQLStatementValidator.getKeyword((EGLSQLClauseTree)allClauses.get(ii))});
                }
            }
            ++ii;
        }
    }

    private static boolean startsWithParen(ArrayList allClauses, int ii, EGLPrimeToken clauseKeyword) {
        EGLSQLClauseTree executeSQL;
        return clauseKeyword.getType() == 57 && (executeSQL = (EGLSQLClauseTree)allClauses.get(ii)).size() == 1 && executeSQL.getToken(0).getType() == 22;
    }

    protected static void checkGetAndOpenExtraDupeClauses(WithInlineSQLClause withInlineSQLClause, EGLSQLParser parser, IProblemRequestor problemRequestor, String stmtType) {
        ArrayList allClauses = (ArrayList)parser.getSqlClauses().clone();
        EGLSQLClauseTree clause = parser.getSelectTokens();
        if (clause != null) {
            SQLStatementValidator.checkEmptyClause(withInlineSQLClause, clause, parser, problemRequestor);
            allClauses.remove(clause);
        }
        if ((clause = parser.getFromTokens()) != null) {
            SQLStatementValidator.checkEmptyClause(withInlineSQLClause, clause, parser, problemRequestor);
            allClauses.remove(clause);
        }
        if ((clause = parser.getForUpdateOfTokens()) != null) {
            if (clause.getThirdKeyword() != null) {
                SQLStatementValidator.checkEmptyClause(withInlineSQLClause, clause, parser, problemRequestor);
            }
            allClauses.remove(clause);
        }
        if ((clause = parser.getWhereTokens()) != null) {
            SQLStatementValidator.checkEmptyClause(withInlineSQLClause, clause, parser, problemRequestor);
            allClauses.remove(clause);
        }
        if ((clause = parser.getGroupByTokens()) != null) {
            SQLStatementValidator.checkEmptyClause(withInlineSQLClause, clause, parser, problemRequestor);
            allClauses.remove(clause);
        }
        if ((clause = parser.getHavingTokens()) != null) {
            SQLStatementValidator.checkEmptyClause(withInlineSQLClause, clause, parser, problemRequestor);
            allClauses.remove(clause);
        }
        if ((clause = parser.getOrderByTokens()) != null) {
            SQLStatementValidator.checkEmptyClause(withInlineSQLClause, clause, parser, problemRequestor);
            allClauses.remove(clause);
        }
        int ii = 0;
        while (ii < allClauses.size()) {
            EGLPrimeToken clauseKeyword = ((EGLSQLClauseTree)allClauses.get(ii)).getClauseKeyword();
            if (!SQLStatementValidator.startsWithParen(allClauses, ii, clauseKeyword)) {
                if (clauseKeyword.getType() == 1 || clauseKeyword.getType() == 3 || clauseKeyword.getType() == 12 || clauseKeyword.getType() == 8 || clauseKeyword.getType() == 10 || clauseKeyword.getType() == 7 || clauseKeyword.getType() == 9) {
                    if (!parser.hasUnion()) {
                        problemRequestor.acceptProblem(SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset(), SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset() + clauseKeyword.getText().length(), 2, 6506, new String[]{stmtType.toUpperCase(), SQLStatementValidator.getKeyword((EGLSQLClauseTree)allClauses.get(ii))});
                    }
                } else {
                    problemRequestor.acceptProblem(SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset(), SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset() + clauseKeyword.getText().length(), 2, 6507, new String[]{stmtType.toUpperCase(), SQLStatementValidator.getKeyword((EGLSQLClauseTree)allClauses.get(ii))});
                }
            }
            ++ii;
        }
    }

    protected static void checkGetAndOpenClauseOrder(WithInlineSQLClause withInlineSQLClause, IProblemRequestor problemRequestor, ArrayList clauseKeywords, String stmtType) {
        if (clauseKeywords.indexOf("select") > -1 && clauseKeywords.indexOf("from") > -1 && clauseKeywords.indexOf("select") > clauseKeywords.indexOf("from")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{stmtType.toUpperCase(), "select".toUpperCase(), "from".toUpperCase()});
        }
        if (clauseKeywords.indexOf("select") > -1 && clauseKeywords.indexOf("where") > -1 && clauseKeywords.indexOf("select") > clauseKeywords.indexOf("where")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{stmtType.toUpperCase(), "select".toUpperCase(), "where".toUpperCase()});
        }
        if (clauseKeywords.indexOf("select") > -1 && clauseKeywords.indexOf("order") > -1 && clauseKeywords.indexOf("select") > clauseKeywords.indexOf("order")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{stmtType.toUpperCase(), "select".toUpperCase(), String.valueOf("order".toUpperCase()) + " " + "by".toUpperCase()});
        }
        if (clauseKeywords.indexOf("select") > -1 && clauseKeywords.indexOf("group") > -1 && clauseKeywords.indexOf("select") > clauseKeywords.indexOf("group")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{stmtType.toUpperCase(), "select".toUpperCase(), String.valueOf("group".toUpperCase()) + " " + "by".toUpperCase()});
        }
        if (clauseKeywords.indexOf("select") > -1 && clauseKeywords.indexOf("having") > -1 && clauseKeywords.indexOf("select") > clauseKeywords.indexOf("having")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{stmtType.toUpperCase(), "select".toUpperCase(), "having".toUpperCase()});
        }
        if (clauseKeywords.indexOf("from") > -1 && clauseKeywords.indexOf("order") > -1 && clauseKeywords.indexOf("from") > clauseKeywords.indexOf("order")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{stmtType.toUpperCase(), "from".toUpperCase(), String.valueOf("order".toUpperCase()) + " " + "by".toUpperCase()});
        }
        if (clauseKeywords.indexOf("from") > -1 && clauseKeywords.indexOf("where") > -1 && clauseKeywords.indexOf("from") > clauseKeywords.indexOf("where")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{stmtType.toUpperCase(), "from".toUpperCase(), "where".toUpperCase()});
        }
        if (clauseKeywords.indexOf("from") > -1 && clauseKeywords.indexOf("group") > -1 && clauseKeywords.indexOf("from") > clauseKeywords.indexOf("group")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{stmtType.toUpperCase(), "from".toUpperCase(), String.valueOf("group".toUpperCase()) + " " + "by".toUpperCase()});
        }
        if (clauseKeywords.indexOf("from") > -1 && clauseKeywords.indexOf("having") > -1 && clauseKeywords.indexOf("from") > clauseKeywords.indexOf("having")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{stmtType.toUpperCase(), "from".toUpperCase(), "having".toUpperCase()});
        }
        if (clauseKeywords.indexOf("where") > -1 && clauseKeywords.indexOf("order") > -1 && clauseKeywords.indexOf("where") > clauseKeywords.indexOf("order")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{stmtType.toUpperCase(), "where".toUpperCase(), String.valueOf("order".toUpperCase()) + " " + "by".toUpperCase()});
        }
        if (clauseKeywords.indexOf("where") > -1 && clauseKeywords.indexOf("group") > -1 && clauseKeywords.indexOf("where") > clauseKeywords.indexOf("group")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{stmtType.toUpperCase(), "where".toUpperCase(), String.valueOf("group".toUpperCase()) + " " + "by".toUpperCase()});
        }
        if (clauseKeywords.indexOf("where") > -1 && clauseKeywords.indexOf("having") > -1 && clauseKeywords.indexOf("where") > clauseKeywords.indexOf("having")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{stmtType.toUpperCase(), "where".toUpperCase(), "having".toUpperCase()});
        }
        if (clauseKeywords.indexOf("group") > -1 && clauseKeywords.indexOf("order") > -1 && clauseKeywords.indexOf("group") > clauseKeywords.indexOf("order")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{stmtType.toUpperCase(), String.valueOf("group".toUpperCase()) + " " + "by".toUpperCase(), String.valueOf("order".toUpperCase()) + " " + "by".toUpperCase()});
        }
        if (clauseKeywords.indexOf("having") > -1 && clauseKeywords.indexOf("order") > -1 && clauseKeywords.indexOf("having") > clauseKeywords.indexOf("order")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{stmtType.toUpperCase(), "having".toUpperCase(), String.valueOf("order".toUpperCase()) + " " + "by".toUpperCase()});
        }
        if (clauseKeywords.indexOf("for") > -1 && clauseKeywords.indexOf("for") < clauseKeywords.size() - 1) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6517, new String[]{stmtType.toUpperCase()});
        }
    }

    public static void checkForUpdateClause(WithInlineSQLClause withInlineSQLClause, ArrayList clauseKeywords, IProblemRequestor problemRequestor, String stmtType) {
        if (!clauseKeywords.contains("for")) {
            String insertOne = String.valueOf(stmtType.toUpperCase()) + " " + "forUpdate".toUpperCase();
            String insertTwo = String.valueOf("for".toUpperCase()) + " " + "update".toUpperCase() + " " + "or" + " " + "for".toUpperCase() + " " + "update".toUpperCase() + " " + "of".toUpperCase();
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6501, new String[]{insertOne, insertTwo});
        }
    }

    public static void checkDeleteClauses(WithInlineSQLClause withInlineSQLClause, EGLSQLParser parser, IProblemRequestor problemRequestor) {
        ArrayList clauseKeywords = parser.getSqlClauseKeywordsUsed();
        if (!clauseKeywords.contains("delete")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6501, new String[]{"delete".toUpperCase(), "delete".toUpperCase()});
        }
        SQLStatementValidator.checkDeleteClauseOrder(withInlineSQLClause, parser, problemRequestor, clauseKeywords);
        SQLStatementValidator.checkDeleteExtraDupeClauses(withInlineSQLClause, parser, problemRequestor);
    }

    private static void checkDeleteExtraDupeClauses(WithInlineSQLClause withInlineSQLClause, EGLSQLParser parser, IProblemRequestor problemRequestor) {
        EGLSQLClauseTree whereClause;
        EGLSQLClauseTree whereCurrentClause;
        ArrayList allClauses = parser.getSqlClauses();
        EGLSQLClauseTree clause = parser.getDeleteTokens();
        if (clause != null) {
            allClauses.remove(clause);
        }
        if ((clause = parser.getFromTokens()) != null) {
            SQLStatementValidator.checkEmptyClause(withInlineSQLClause, clause, parser, problemRequestor);
            allClauses.remove(clause);
        }
        if ((whereCurrentClause = parser.getWhereCurrentOfTokens()) != null) {
            SQLStatementValidator.checkEmptyClause(withInlineSQLClause, whereCurrentClause, parser, problemRequestor);
            allClauses.remove(whereCurrentClause);
        }
        if ((whereClause = parser.getWhereTokens()) != null) {
            SQLStatementValidator.checkEmptyClause(withInlineSQLClause, whereClause, parser, problemRequestor);
        }
        if (whereCurrentClause == null) {
            allClauses.remove(whereClause);
        }
        int ii = 0;
        while (ii < allClauses.size()) {
            EGLPrimeToken clauseKeyword = ((EGLSQLClauseTree)allClauses.get(ii)).getClauseKeyword();
            if (!SQLStatementValidator.startsWithParen(allClauses, ii, clauseKeyword)) {
                if (clauseKeyword.getType() == 18 || clauseKeyword.getType() == 3 || parser.getWhereCurrentOfTokens() != null || parser.getWhereTokens() != null) {
                    problemRequestor.acceptProblem(SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset(), SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset() + clauseKeyword.getText().length(), 2, 6506, new String[]{"delete".toUpperCase(), SQLStatementValidator.getKeyword((EGLSQLClauseTree)allClauses.get(ii))});
                } else {
                    problemRequestor.acceptProblem(SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset(), SQLStatementValidator.getStatementStartOffset(withInlineSQLClause) + clauseKeyword.getOffset() + clauseKeyword.getText().length(), 2, 6507, new String[]{"delete".toUpperCase(), SQLStatementValidator.getKeyword((EGLSQLClauseTree)allClauses.get(ii))});
                }
            }
            ++ii;
        }
    }

    private static void checkDeleteClauseOrder(WithInlineSQLClause withInlineSQLClause, EGLSQLParser parser, IProblemRequestor problemRequestor, ArrayList clauseKeywords) {
        if (clauseKeywords.indexOf("delete") > -1 && clauseKeywords.indexOf("from") > -1 && clauseKeywords.indexOf("delete") > clauseKeywords.indexOf("from")) {
            problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{"delete".toUpperCase(), "delete".toUpperCase(), "from".toUpperCase()});
        }
        if (parser.getWhereCurrentOfTokens() != null) {
            if (clauseKeywords.indexOf("from") > -1 && clauseKeywords.indexOf("where") > -1 && clauseKeywords.indexOf("from") > clauseKeywords.indexOf("where")) {
                problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{"delete".toUpperCase(), "from".toUpperCase(), String.valueOf("where".toUpperCase()) + " " + "current".toUpperCase() + " " + "of".toUpperCase()});
            }
            if (clauseKeywords.indexOf("delete") > -1 && clauseKeywords.indexOf("where") > -1 && clauseKeywords.indexOf("delete") > clauseKeywords.indexOf("where")) {
                problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{"delete".toUpperCase(), "delete".toUpperCase(), String.valueOf("where".toUpperCase()) + " " + "current".toUpperCase() + " " + "of".toUpperCase()});
            }
        } else if (parser.getWhereTokens() != null) {
            if (clauseKeywords.indexOf("from") > -1 && clauseKeywords.indexOf("where") > -1 && clauseKeywords.indexOf("from") > clauseKeywords.indexOf("where")) {
                problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{"delete".toUpperCase(), "from".toUpperCase(), "where".toUpperCase()});
            }
            if (clauseKeywords.indexOf("delete") > -1 && clauseKeywords.indexOf("where") > -1 && clauseKeywords.indexOf("delete") > clauseKeywords.indexOf("where")) {
                problemRequestor.acceptProblem(SQLStatementValidator.getPartitionStartOffset(withInlineSQLClause), SQLStatementValidator.getPartitionEndOffset(withInlineSQLClause), 2, 6503, new String[]{"delete".toUpperCase(), "delete".toUpperCase(), "where".toUpperCase()});
            }
        }
    }
}

