/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.IPartSubTypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.ProgramBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTPartVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.PassingClause;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.ReturningToInvocationTargetClause;
import org.eclipse.edt.compiler.core.ast.ShowStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.statement.ConverseStatementValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidatorConstants;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class ShowStatementValidator
extends DefaultASTVisitor
implements IOStatementValidatorConstants {
    private IPartBinding enclosingPart;
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;

    public ShowStatementValidator(IProblemRequestor problemRequestor, IPartBinding enclosingPart, ICompilerOptions compilerOptions) {
        this.problemRequestor = problemRequestor;
        this.enclosingPart = enclosingPart;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(ShowStatement ashowStatement) {
        StatementValidator.validateIOTargetsContainer(ashowStatement.getIOObjects(), this.problemRequestor, ConverseStatementValidator.getTargetsContainerChecker());
        this.validateContainer(ashowStatement);
        ashowStatement.accept(new AbstractASTVisitor(){
            Node passing = null;
            Node returning = null;
            ProgramBinding program = null;
            ITypeBinding recordBinding = null;

            @Override
            public boolean visit(PassingClause passingClause) {
                this.passing = passingClause;
                Expression expr = passingClause.getExpression();
                ITypeBinding typeBinding = expr.resolveTypeBinding();
                if (ShowStatementValidator.this.enclosingPart != null && ShowStatementValidator.this.enclosingPart.getAnnotation(EGLUIGATEWAY, "UIProgram") != null) {
                    ShowStatementValidator.this.problemRequestor.acceptProblem((Node)expr, 6600, new String[0]);
                } else if (StatementValidator.isValidBinding(typeBinding)) {
                    if (typeBinding.getKind() != 7 && typeBinding.getKind() != 6) {
                        ShowStatementValidator.this.problemRequestor.acceptProblem((Node)expr, 6541, new String[]{expr.getCanonicalString()});
                    } else {
                        this.recordBinding = typeBinding;
                    }
                }
                return false;
            }

            @Override
            public boolean visit(ReturningToInvocationTargetClause returningToInvocationTarget) {
                this.returning = returningToInvocationTarget;
                this.program = ShowStatementValidator.this.getProgram(returningToInvocationTarget.getExpression());
                return false;
            }

            @Override
            public void endVisit(ShowStatement showStatement) {
                Expression expr;
                ITypeBinding typeBinding;
                if (this.passing != null && this.returning == null) {
                    ShowStatementValidator.this.problemRequestor.acceptProblem(this.passing, 5183);
                }
                if (StatementValidator.isValidBinding(typeBinding = (expr = showStatement.getPageRecordOrForm()).resolveTypeBinding())) {
                    if (ShowStatementValidator.this.enclosingPart != null && (ShowStatementValidator.this.enclosingPart.getKind() == 11 || ShowStatementValidator.this.enclosingPart.getAnnotation(EGLUIGATEWAY, "UIProgram") != null)) {
                        if (!StatementValidator.isFlexibleBasicOrSQL(typeBinding)) {
                            ShowStatementValidator.this.problemRequestor.acceptProblem((Node)expr, 6601, new String[]{expr.getCanonicalString()});
                        }
                        if (Binding.isValidBinding(this.program) && this.program.getAnnotation(EGLUIGATEWAY, "UIProgram") == null) {
                            ShowStatementValidator.this.problemRequestor.acceptProblem(this.returning, 6573, new String[]{this.program.getCaseSensitiveName()});
                        }
                    } else {
                        if (typeBinding.getAnnotation(EGLUITEXT, "TextForm") == null && typeBinding.getAnnotation(EGLUIWEBTRANSACTION, "VGUIRecord") == null) {
                            ShowStatementValidator.this.problemRequestor.acceptProblem(expr, 7507);
                        }
                        if (typeBinding.getAnnotation(EGLUITEXT, "TextForm") != null && this.returning == null) {
                            ShowStatementValidator.this.problemRequestor.acceptProblem(expr, 7508);
                        }
                    }
                }
                if (this.program != null && this.recordBinding != null) {
                    ITypeBinding type;
                    boolean error;
                    if (this.recordBinding.getAnnotation(EGLUIWEBTRANSACTION, "VGUIRecord") == null) {
                        error = false;
                        type = null;
                        IPartSubTypeAnnotationTypeBinding subType = this.program.getSubType();
                        if (subType != null) {
                            IDataBinding inputRecordDBinding = this.program.getAnnotation(subType).findData(InternUtil.intern((String)"inputRecord"));
                            if (IBinding.NOT_FOUND_BINDING != inputRecordDBinding) {
                                IDataBinding classFieldBinding = (IDataBinding)((IAnnotationBinding)inputRecordDBinding).getValue();
                                if (StatementValidator.isValidBinding(classFieldBinding)) {
                                    if (StatementValidator.isValidBinding(classFieldBinding.getType()) && !TypeCompatibilityUtil.isMoveCompatible(classFieldBinding.getType(), this.recordBinding, null, ShowStatementValidator.this.compilerOptions)) {
                                        error = true;
                                        type = classFieldBinding.getType();
                                    }
                                } else {
                                    error = true;
                                }
                            } else {
                                error = true;
                            }
                            if (error) {
                                ShowStatementValidator.this.problemRequestor.acceptProblem(this.returning, 6711, new String[]{this.program.getCaseSensitiveName(), type != null ? StatementValidator.getQualifiedName(type) : "", StatementValidator.getQualifiedName(this.recordBinding)});
                            }
                        }
                    }
                    if (this.recordBinding.getAnnotation(EGLUIWEBTRANSACTION, "VGUIRecord") != null) {
                        error = false;
                        type = null;
                        if (this.program.getAnnotation(EGLUIWEBTRANSACTION, "VGWebTransaction") != null) {
                            IDataBinding inputRecordDBinding = this.program.getAnnotation(EGLUIWEBTRANSACTION, "VGWebTransaction").findData(InternUtil.intern((String)"inputUIRecord"));
                            if (IBinding.NOT_FOUND_BINDING != inputRecordDBinding) {
                                IDataBinding classFieldBinding = (IDataBinding)((IAnnotationBinding)inputRecordDBinding).getValue();
                                if (StatementValidator.isValidBinding(classFieldBinding) && StatementValidator.isValidBinding(classFieldBinding.getType()) && 6 != this.recordBinding.getKind()) {
                                    error = true;
                                    type = classFieldBinding.getType();
                                }
                            } else {
                                error = true;
                            }
                            if (error) {
                                ShowStatementValidator.this.problemRequestor.acceptProblem(this.returning, 6723, new String[]{this.program.getCaseSensitiveName(), type != null ? StatementValidator.getQualifiedName(type) : "", StatementValidator.getQualifiedName(this.recordBinding)});
                            }
                        }
                    }
                }
            }
        });
        return false;
    }

    private void validateContainer(final ShowStatement showStatement) {
        Node parent = showStatement.getParent();
        Node child = showStatement;
        while (parent.getParent() != null) {
            child = parent;
            parent = parent.getParent();
        }
        ((Node)child).accept(new AbstractASTPartVisitor(){

            @Override
            public boolean visit(Program program) {
                IBinding typeBinding = program.getName().resolveBinding();
                if (StatementValidator.isValidBinding(typeBinding)) {
                    if (typeBinding.getAnnotation(EGLCORE, "BasicProgram") != null) {
                        ShowStatementValidator.this.problemRequestor.acceptProblem((Node)showStatement, 6551, new String[]{"show"});
                    } else if (typeBinding.getAnnotation(EGLUITEXT, "TextUIProgram") != null && program.getParameters().size() > 0) {
                        ShowStatementValidator.this.problemRequestor.acceptProblem((Node)showStatement, 6557, new String[]{"show"});
                    }
                    Expression expr = showStatement.getPageRecordOrForm();
                    ITypeBinding recordBinding = expr.resolveTypeBinding();
                    if (StatementValidator.isValidBinding(recordBinding) && recordBinding.getAnnotation(EGLUIWEBTRANSACTION, "VGUIRecord") != null && typeBinding.getAnnotation(EGLUIWEBTRANSACTION, "VGWebTransaction") == null) {
                        ShowStatementValidator.this.problemRequestor.acceptProblem(expr, 7779);
                    }
                }
                return false;
            }

            @Override
            public void visitPart(Part part) {
            }
        });
    }

    private ProgramBinding getProgram(Expression expr) {
        ProgramBinding program = null;
        ITypeBinding tBinding = expr.resolveTypeBinding();
        if (tBinding != null && tBinding != IBinding.NOT_FOUND_BINDING && tBinding.getKind() == 13) {
            program = (ProgramBinding)tBinding;
        }
        return program;
    }
}

