/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.statement;

import java.util.HashMap;
import java.util.List;
import org.eclipse.edt.compiler.binding.DataItemBinding;
import org.eclipse.edt.compiler.binding.DataTableBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.MutuallyExclusiveAnnotationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.binding.UsedTypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTPartVisitor;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.AnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.annotation.SelectedValueItemAnnotationValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.IOStatementValidatorConstants;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class UseStatementValidator
extends DefaultASTVisitor
implements IOStatementValidatorConstants {
    private IPartBinding parent;
    private String canonicalParentName;
    private IProblemRequestor problemRequestor;
    private ICompilerOptions compilerOptions;
    private final MutuallyExclusiveAnnotationAnnotationTypeBinding[] MUTUALEXCLUSIONCHECKS = new MutuallyExclusiveAnnotationAnnotationTypeBinding[]{new MutuallyExclusiveAnnotationAnnotationTypeBinding(InternUtil.internCaseSensitive((String)"selectedRowItem"), new String[]{InternUtil.internCaseSensitive((String)"selectedValueItem")})};

    public UseStatementValidator(IPartBinding binding, String canonicalParentName, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.parent = binding;
        this.problemRequestor = problemRequestor;
        this.canonicalParentName = canonicalParentName;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(final UseStatement useStatement) {
        if (!StatementValidator.isValidBinding(this.parent)) {
            return false;
        }
        if (!StatementValidator.isValidBinding(useStatement.getUsedTypeBinding().getType())) {
            return false;
        }
        if (useStatement.getNames().size() == 0) {
            return false;
        }
        new AnnotationValidator(this.problemRequestor, this.compilerOptions).validateAnnotationTarget(useStatement);
        this.checkProperties(useStatement);
        useStatement.getParent().accept(new AbstractASTPartVisitor(){

            @Override
            public boolean visit(Service service) {
                this.validateMsgTable();
                if (useStatement.getUsedTypeBinding().getType().getKind() == 14) {
                    UseStatementValidator.this.problemRequestor.acceptProblem((Node)useStatement.getNames().get(0), 7802);
                } else if (useStatement.getUsedTypeBinding().getType().getKind() == 9) {
                    UseStatementValidator.this.problemRequestor.acceptProblem((Node)useStatement.getNames().get(0), 7811);
                }
                return false;
            }

            @Override
            public boolean visit(Handler pageHandler) {
                this.validateHandlers("handler");
                this.validateMsgTable();
                return false;
            }

            @Override
            public boolean visit(Program program) {
                this.validateProgLibTarget("program");
                this.validateMsgTable();
                if (UseStatementValidator.this.parent.getAnnotation(EGLUIWEBTRANSACTION, "VGWebTransaction") != null && useStatement.getUsedTypeBinding().getType().getKind() == 9) {
                    UseStatementValidator.this.problemRequestor.acceptProblem((Node)useStatement.getNames().get(0), 7772);
                }
                if (useStatement.getUsedTypeBinding().getAnnotation(EGLCORE, "DeleteAfterUse") != null && !UseStatementValidator.this.compilerOptions.isVAGCompatible()) {
                    UseStatementValidator.this.problemRequestor.acceptProblem((Node)useStatement.getNames().get(0), 4937, new String[]{"deleteAfterUse"});
                }
                return false;
            }

            @Override
            public boolean visit(Library library) {
                this.validateProgLibTarget("library");
                this.validateMsgTable();
                return false;
            }

            protected void validateMsgTable() {
                StructureItemBinding binding;
                DataTableBinding dt;
                if (UseStatementValidator.this.parent.getAnnotation(EGLUIWEBTRANSACTION, "VGWebTransaction") == null && useStatement.getUsedTypeBinding().getType().getAnnotation(EGLCORE, "MsgTable") != null && (dt = (DataTableBinding)useStatement.getUsedTypeBinding().getType()).getStructureItems().size() > 0 && StatementValidator.isValidBinding(binding = (StructureItemBinding)dt.getStructureItems().get(0)) && StatementValidator.isValidBinding(binding.getType())) {
                    ITypeBinding typeBinding = binding.getType();
                    boolean error = false;
                    if (typeBinding.getKind() == 3 && ((PrimitiveTypeBinding)typeBinding).getPrimitive() != Primitive.NUM) {
                        error = true;
                    } else if (typeBinding.getKind() == 17 && ((DataItemBinding)typeBinding).getPrimitiveTypeBinding().getPrimitive() != Primitive.NUM) {
                        error = true;
                    } else if (typeBinding.getKind() != 3 && typeBinding.getKind() != 17) {
                        error = true;
                    }
                    if (error) {
                        UseStatementValidator.this.problemRequestor.acceptProblem((Node)useStatement.getNames().get(0), 4182, new String[]{((Name)useStatement.getNames().get(0)).getCanonicalName()});
                    }
                }
            }

            protected void validateProgLibTarget(String type) {
                if (useStatement.getUsedTypeBinding().getType().getKind() != 9 && useStatement.getUsedTypeBinding().getType().getKind() != 5 && useStatement.getUsedTypeBinding().getType().getKind() != 11 && useStatement.getUsedTypeBinding().getType().getKind() != 19) {
                    UseStatementValidator.this.problemRequestor.acceptProblem((Node)useStatement.getNames().get(0), 4930, new String[]{((Name)useStatement.getNames().get(0)).getCanonicalName(), type, UseStatementValidator.this.canonicalParentName});
                }
            }

            protected void validateHandlers(String handlertypename) {
                if (useStatement.getUsedTypeBinding().getType().getKind() == 9) {
                    UseStatementValidator.this.problemRequestor.acceptProblem((Node)useStatement.getNames().get(0), 5379, new String[]{((Name)useStatement.getNames().get(0)).getCanonicalName(), handlertypename, UseStatementValidator.this.canonicalParentName});
                }
            }

            @Override
            public void visitPart(Part part) {
            }
        });
        return false;
    }

    private void checkProperties(UseStatement useStatement) {
        UsedTypeBinding usedTypeBinding = useStatement.getUsedTypeBinding();
        if (usedTypeBinding != null) {
            List annotations = usedTypeBinding.getAnnotations();
            HashMap<String, IAnnotationBinding> allAnnotations = new HashMap<String, IAnnotationBinding>();
            for (IAnnotationBinding aBinding : annotations) {
                allAnnotations.put(aBinding.getName(), aBinding);
            }
            Name firstName = (Name)useStatement.getNames().get(0);
            int i = 0;
            while (i < this.MUTUALEXCLUSIONCHECKS.length) {
                this.MUTUALEXCLUSIONCHECKS[i].validate(firstName, firstName, null, usedTypeBinding.getCaseSensitiveName(), allAnnotations, this.problemRequestor, this.compilerOptions);
                ++i;
            }
            new SelectedValueItemAnnotationValidator().doValidate(firstName, firstName, usedTypeBinding, usedTypeBinding.getType(), firstName.getCanonicalName(), allAnnotations, this.problemRequestor, this.compilerOptions);
        }
    }
}

