/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.egl2mof;

import java.util.Iterator;
import java.util.Stack;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.LocalVariableBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AssignmentStatement;
import org.eclipse.edt.compiler.core.ast.CaseStatement;
import org.eclipse.edt.compiler.core.ast.ContinueStatement;
import org.eclipse.edt.compiler.core.ast.EmptyStatement;
import org.eclipse.edt.compiler.core.ast.ExitStatement;
import org.eclipse.edt.compiler.core.ast.ForStatement;
import org.eclipse.edt.compiler.core.ast.ForwardStatement;
import org.eclipse.edt.compiler.core.ast.FreeSQLStatement;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionInvocationStatement;
import org.eclipse.edt.compiler.core.ast.GetByPositionStatement;
import org.eclipse.edt.compiler.core.ast.GotoStatement;
import org.eclipse.edt.compiler.core.ast.LabelStatement;
import org.eclipse.edt.compiler.core.ast.MoveStatement;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.OpenUIStatement;
import org.eclipse.edt.compiler.core.ast.OtherwiseClause;
import org.eclipse.edt.compiler.core.ast.PrintStatement;
import org.eclipse.edt.compiler.core.ast.ReturnStatement;
import org.eclipse.edt.compiler.core.ast.SetValuesStatement;
import org.eclipse.edt.compiler.core.ast.ShowStatement;
import org.eclipse.edt.compiler.core.ast.TransferStatement;
import org.eclipse.edt.compiler.core.ast.TryStatement;
import org.eclipse.edt.compiler.core.ast.WhenClause;
import org.eclipse.edt.compiler.internal.egl2mof.DefaultIOStatementGenerator;
import org.eclipse.edt.compiler.internal.egl2mof.Egl2MofMember;
import org.eclipse.edt.compiler.internal.egl2mof.IOStatementGenerator;
import org.eclipse.edt.compiler.internal.egl2mof.eglx.persistence.sql.SQLActionStatementGenerator;
import org.eclipse.edt.compiler.internal.egl2mof.eglx.services.ServicesActionStatementGenerator;
import org.eclipse.edt.compiler.internal.egl2mof.sql.SQLIOStatementGenerator;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.egl.AddStatement;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.CallStatement;
import org.eclipse.edt.mof.egl.CloseStatement;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.ConverseStatement;
import org.eclipse.edt.mof.egl.DeclarationExpression;
import org.eclipse.edt.mof.egl.DeleteStatement;
import org.eclipse.edt.mof.egl.DisplayStatement;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.ExceptionBlock;
import org.eclipse.edt.mof.egl.ExecuteStatement;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.ForEachStatement;
import org.eclipse.edt.mof.egl.FreeSqlStatement;
import org.eclipse.edt.mof.egl.FunctionStatement;
import org.eclipse.edt.mof.egl.GetByKeyStatement;
import org.eclipse.edt.mof.egl.GoToStatement;
import org.eclipse.edt.mof.egl.IfStatement;
import org.eclipse.edt.mof.egl.LHSExpr;
import org.eclipse.edt.mof.egl.LocalVariableDeclarationStatement;
import org.eclipse.edt.mof.egl.OpenStatement;
import org.eclipse.edt.mof.egl.Parameter;
import org.eclipse.edt.mof.egl.PrepareStatement;
import org.eclipse.edt.mof.egl.ReplaceStatement;
import org.eclipse.edt.mof.egl.SetStatement;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StatementBlock;
import org.eclipse.edt.mof.egl.ThrowStatement;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.WhileStatement;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.serialization.IEnvironment;

abstract class Egl2MofStatement
extends Egl2MofMember {
    Stack<org.eclipse.edt.mof.egl.LabelStatement> caseLabelStack = new Stack();
    int caseLabelCounter = 0;

    static {
        IOStatementGenerator.Registry.put("egl.io.sql.SQLRecord", SQLIOStatementGenerator.class);
        IOStatementGenerator.Registry.put("egl.lang", DefaultIOStatementGenerator.class);
        IOStatementGenerator.Registry.put("eglx.persistence.sql", SQLActionStatementGenerator.class);
        IOStatementGenerator.Registry.put("eglx.services", ServicesActionStatementGenerator.class);
    }

    Egl2MofStatement(IEnvironment env) {
        super(env);
    }

    protected void setElementInformation(Node node, Statement stmt) {
        stmt.setContainer((Container)this.getCurrentFunctionMember());
        super.setElementInformation(node, (EObject)stmt);
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.AddStatement node) {
        IOStatementGenerator generator = this.getGeneratorFor(node);
        AddStatement stmt = generator.genAddStatement(node, this.eObjects);
        this.setElementInformation((Node)node, (Statement)stmt);
        this.stack.push(stmt);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.CloseStatement node) {
        IOStatementGenerator generator = this.getGeneratorFor(node);
        CloseStatement stmt = generator.genCloseStatement(node, this.eObjects);
        this.setElementInformation((Node)node, (Statement)stmt);
        this.stack.push(stmt);
        return false;
    }

    @Override
    public boolean visit(AssignmentStatement assignmentStatement) {
        org.eclipse.edt.mof.egl.AssignmentStatement stmt = this.factory.createAssignmentStatement();
        assignmentStatement.getAssignment().accept(this);
        stmt.setExpr((Expression)this.stack.pop());
        this.setElementInformation((Node)assignmentStatement, (Statement)stmt);
        this.stack.push(stmt);
        return false;
    }

    @Override
    public boolean visit(SetValuesStatement setValuesStatement) {
        org.eclipse.edt.mof.egl.SetValuesStatement stmt = this.factory.createSetValuesStatement();
        setValuesStatement.getSetValuesExpression().accept(this);
        stmt.setExpr((Expression)this.stack.pop());
        this.setElementInformation((Node)setValuesStatement, (Statement)stmt);
        this.stack.push(stmt);
        return false;
    }

    @Override
    public boolean visit(FunctionDataDeclaration decl) {
        LocalVariableDeclarationStatement stmt = this.factory.createLocalVariableDeclarationStatement();
        this.stack.push(stmt);
        DeclarationExpression expr = this.factory.createDeclarationExpression();
        for (Name name : decl.getNames()) {
            if (!Binding.isValidBinding(name.resolveDataBinding())) continue;
            LocalVariableBinding binding = (LocalVariableBinding)name.resolveDataBinding();
            Object field = binding.isConstant() ? this.factory.createConstantField() : this.factory.createField();
            field.setName(binding.getCaseSensitiveName());
            EObject objType = this.mofTypeFor(binding.getType());
            if (objType instanceof Type) {
                field.setType((Type)this.mofTypeFor(binding.getType()));
            }
            field.setIsNullable(binding.getType().isNullable());
            field.setContainer((Container)this.getCurrentFunctionMember());
            this.addInitializers(decl.getInitializer(), decl.getSettingsBlockOpt(), (Field)field, decl.getType());
            expr.getFields().add(field);
            this.setElementInformation((Node)name, (EObject)field);
            this.eObjects.put(binding, field);
        }
        this.setElementInformation((Node)decl, (EObject)expr);
        this.setElementInformation((Node)decl, (Statement)stmt);
        stmt.setExpression(expr);
        return false;
    }

    @Override
    public boolean visit(ReturnStatement stmt) {
        org.eclipse.edt.mof.egl.ReturnStatement irStmt = this.factory.createReturnStatement();
        this.stack.push(irStmt);
        if (stmt.getParenthesizedExprOpt() != null) {
            stmt.getParenthesizedExprOpt().accept(this);
            irStmt.setExpression((Expression)this.stack.pop());
        }
        this.setElementInformation((Node)stmt, (Statement)irStmt);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.CallStatement callStatement) {
        IOStatementGenerator generator = this.getGeneratorFor(callStatement);
        CallStatement stmt = generator.genCallStatement(callStatement, this.eObjects);
        callStatement.getInvocationTarget().accept(this);
        stmt.setInvocationTarget((Expression)this.stack.pop());
        if (callStatement.hasArguments()) {
            for (Node node : callStatement.getArguments()) {
                node.accept(this);
                stmt.getArguments().add((Expression)this.stack.pop());
            }
        }
        if (callStatement.getCallbackTarget() != null) {
            callStatement.getCallbackTarget().accept(this);
            stmt.setCallback((Expression)this.stack.pop());
        }
        if (callStatement.getErrorCallbackTarget() != null) {
            callStatement.getErrorCallbackTarget().accept(this);
            stmt.setErrorCallback((Expression)this.stack.pop());
        }
        this.setElementInformation((Node)callStatement, (Statement)stmt);
        this.stack.push(stmt);
        if (callStatement.hasSettingsBlock()) {
            this.processSettings((Element)stmt, callStatement.getSettingsBlock());
        }
        return false;
    }

    private Expression addWhenCriterion(Expression criterion, Expression condition) {
        if (condition instanceof BinaryExpression) {
            BinaryExpression binExp = (BinaryExpression)condition;
            Expression expr = this.addWhenCriterion(criterion, binExp.getLHS());
            binExp.setLHS(expr);
            expr = this.addWhenCriterion(criterion, binExp.getRHS());
            binExp.setRHS(expr);
            return condition;
        }
        BinaryExpression binExp = this.factory.createBinaryExpression();
        binExp.setLHS(criterion);
        binExp.setRHS(condition);
        binExp.setOperator("==");
        return binExp;
    }

    @Override
    public boolean visit(CaseStatement caseStatement) {
        IfStatement stmt = null;
        Expression criterion = null;
        StatementBlock block = this.factory.createStatementBlock();
        org.eclipse.edt.mof.egl.LabelStatement label = this.factory.createLabelStatement();
        label.setLabel("eze_CaseLabel_" + this.caseLabelCounter);
        ++this.caseLabelCounter;
        this.caseLabelStack.push(label);
        this.setElementInformation((Node)caseStatement, (Statement)label);
        block.getStatements().add(label);
        if (caseStatement.hasCriterion()) {
            caseStatement.getCriterion().accept(this);
            criterion = (Expression)this.stack.pop();
        }
        IfStatement current = null;
        for (Node node : caseStatement.getWhenClauses()) {
            node.accept(this);
            IfStatement when = (IfStatement)this.stack.pop();
            if (criterion != null) {
                when.setCondition(this.addWhenCriterion(criterion, when.getCondition()));
            }
            if (stmt == null) {
                stmt = current = when;
                continue;
            }
            current.setFalseBranch((Statement)when);
            current = when;
        }
        if (caseStatement.getDefaultClause() != null) {
            caseStatement.getDefaultClause().accept(this);
            current.setFalseBranch((Statement)this.stack.pop());
        }
        block.getStatements().add(stmt);
        this.stack.push(block);
        this.setElementInformation((Node)caseStatement, (Statement)stmt);
        return false;
    }

    @Override
    public void endVisit(CaseStatement caseStatement) {
        this.caseLabelStack.pop();
    }

    @Override
    public boolean visit(OtherwiseClause otherwiseClause) {
        StatementBlock block = this.factory.createStatementBlock();
        this.setElementInformation((Node)otherwiseClause, (Statement)block);
        this.stack.push(block);
        for (Node node : otherwiseClause.getStatements()) {
            node.accept(this);
            block.getStatements().add((Statement)this.stack.pop());
        }
        return false;
    }

    @Override
    public boolean visit(WhenClause whenClause) {
        IfStatement clause = this.factory.createIfStatement();
        Expression prevCond = null;
        for (Node node : whenClause.getExpr_plus()) {
            node.accept(this);
            Expression expr = (Expression)this.stack.pop();
            if (prevCond != null) {
                BinaryExpression binExp = this.factory.createBinaryExpression();
                binExp.setLHS(prevCond);
                binExp.setRHS(expr);
                binExp.setOperator("||");
                expr = binExp;
            }
            prevCond = expr;
            clause.setCondition(expr);
        }
        StatementBlock block = this.factory.createStatementBlock();
        for (Node node : whenClause.getStmts()) {
            node.accept(this);
            block.getStatements().add((Statement)this.stack.pop());
        }
        clause.setTrueBranch((Statement)block);
        this.stack.push(clause);
        this.setElementInformation((Node)whenClause, (Statement)clause);
        this.setElementInformation((Node)whenClause, (Statement)block);
        return false;
    }

    @Override
    public boolean visit(ContinueStatement node) {
        org.eclipse.edt.mof.egl.ContinueStatement stmt = this.factory.createContinueStatement();
        stmt.setLabel(stmt.getLabel());
        if (node.isContinueFor()) {
            stmt.setContinueType(Integer.valueOf(1));
        } else if (node.isContinueForEach()) {
            stmt.setContinueType(Integer.valueOf(2));
        } else if (node.isContinueOpenUI()) {
            stmt.setContinueType(Integer.valueOf(3));
        } else if (node.isContinueWhile()) {
            stmt.setContinueType(Integer.valueOf(4));
        }
        this.stack.push(stmt);
        this.setElementInformation((Node)node, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.ConverseStatement converseStatement) {
        IOStatementGenerator generator = this.getGeneratorFor(converseStatement);
        ConverseStatement stmt = generator.genConverseStatement(converseStatement, this.eObjects);
        this.stack.push(stmt);
        this.setElementInformation((Node)converseStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.DeleteStatement deleteStatement) {
        IOStatementGenerator generator = this.getGeneratorFor(deleteStatement);
        DeleteStatement stmt = generator.genDeleteStatement(deleteStatement, this.eObjects);
        this.stack.push(stmt);
        this.setElementInformation((Node)deleteStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.DisplayStatement displayStatement) {
        IOStatementGenerator generator = this.getGeneratorFor(displayStatement);
        DisplayStatement stmt = generator.genDisplayStatement(displayStatement, this.eObjects);
        this.stack.push(stmt);
        this.setElementInformation((Node)displayStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(EmptyStatement emptyStatement) {
        org.eclipse.edt.mof.egl.EmptyStatement stmt = this.factory.createEmptyStatement();
        this.stack.push(stmt);
        this.setElementInformation((Node)emptyStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.ExecuteStatement executeStatement) {
        IOStatementGenerator generator = this.getGeneratorFor(executeStatement);
        ExecuteStatement stmt = generator.genExecuteStatement(executeStatement, this.eObjects);
        this.stack.push(stmt);
        this.setElementInformation((Node)executeStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(ExitStatement node) {
        org.eclipse.edt.mof.egl.ExitStatement ext = this.factory.createExitStatement();
        ext.setLabel(node.getLabel());
        if (node.isExitCase()) {
            if (this.caseLabelStack.isEmpty()) {
                ext.setExitStatementType(Integer.valueOf(1));
            } else {
                ext.setLabel(this.caseLabelStack.peek().getLabel());
            }
        } else if (node.isExitFor()) {
            ext.setExitStatementType(Integer.valueOf(3));
        } else if (node.isExitForEach()) {
            ext.setExitStatementType(Integer.valueOf(5));
        } else if (node.isExitIf()) {
            ext.setExitStatementType(Integer.valueOf(2));
        } else if (node.isExitOpenUI()) {
            ext.setExitStatementType(Integer.valueOf(6));
        } else if (node.isExitProgram()) {
            ext.setExitStatementType(Integer.valueOf(7));
        } else if (node.isExitRunUnit()) {
            ext.setExitStatementType(Integer.valueOf(9));
        } else if (node.isExitStack()) {
            ext.setExitStatementType(Integer.valueOf(9));
        } else if (node.isExitWhile()) {
            ext.setExitStatementType(Integer.valueOf(4));
        }
        if (node.getReturnCode() != null) {
            node.getReturnCode().accept(this);
            ext.setReturnExpr((Expression)this.stack.pop());
        }
        if (node.hasSettingsBlock()) {
            this.processSettings((Element)ext, node.getSettingsBlock());
        }
        this.stack.push(ext);
        this.setElementInformation((Node)node, (Statement)ext);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.ForEachStatement forEachStatement) {
        IOStatementGenerator generator = this.getGeneratorFor(forEachStatement);
        ForEachStatement stmt = generator.genForEachStatement(forEachStatement, this.eObjects);
        this.stack.push(stmt);
        this.setElementInformation((Node)forEachStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(ForStatement forStatement) {
        org.eclipse.edt.mof.egl.ForStatement stmt = this.factory.createForStatement();
        if (forStatement.getCounterVariable() == null) {
            DeclarationExpression decl = this.factory.createDeclarationExpression();
            Field field = this.factory.createField();
            field.setName(forStatement.getVariableDeclarationName().getCanonicalName());
            ITypeBinding type = forStatement.getVariableDeclarationType().resolveTypeBinding();
            field.setType((Type)this.mofTypeFor(type));
            decl.getFields().add(field);
            this.eObjects.put(forStatement.getVariableDeclarationName().resolveDataBinding(), field);
            stmt.setDeclarationExpression(decl);
            this.setElementInformation((Node)forStatement.getVariableDeclarationName(), (EObject)field);
            this.setElementInformation((Node)forStatement.getVariableDeclarationName(), (EObject)decl);
        } else {
            forStatement.getCounterVariable().accept(this);
            stmt.setCounterVariable((Expression)this.stack.pop());
        }
        if (forStatement.getDeltaExpression() != null) {
            forStatement.getDeltaExpression().accept(this);
            stmt.setDeltaExpression((Expression)this.stack.pop());
            stmt.setIsIncrement(Boolean.valueOf(forStatement.hasPositiveDelta()));
        }
        if (forStatement.getFromIndex() != null) {
            forStatement.getFromIndex().accept(this);
            stmt.setFromExpression((Expression)this.stack.pop());
        }
        if (forStatement.getEndIndex() != null) {
            forStatement.getEndIndex().accept(this);
            stmt.setToExpression((Expression)this.stack.pop());
        }
        StatementBlock block = this.factory.createStatementBlock();
        for (Node node : forStatement.getStmts()) {
            node.accept(this);
            block.getStatements().add((Statement)this.stack.pop());
        }
        stmt.setBody((Statement)block);
        this.stack.push(stmt);
        this.setElementInformation((Node)forStatement, (Statement)stmt);
        this.setElementInformation((Node)forStatement, (Statement)block);
        return false;
    }

    @Override
    public boolean visit(ForwardStatement forwardStatement) {
        org.eclipse.edt.mof.egl.ForwardStatement stmt = this.factory.createForwardStatement();
        if (forwardStatement.hasForwardTarget()) {
            forwardStatement.getForwardTarget().accept(this);
            stmt.setForwardToTarget((Expression)this.stack.pop());
        }
        Iterator iterator = forwardStatement.getForwardOptions().iterator();
        while (iterator.hasNext()) {
            Node cfr_ignored_0 = (Node)iterator.next();
        }
        for (Node node : forwardStatement.getArguments()) {
            node.accept(this);
            stmt.getArguments().add((Expression)this.stack.pop());
        }
        this.stack.push(stmt);
        this.setElementInformation((Node)forwardStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(FreeSQLStatement freeSQLStatement) {
        FreeSqlStatement stmt = this.factory.createFreeSqlStatement();
        this.stack.push(stmt);
        this.setElementInformation((Node)freeSQLStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(FunctionInvocationStatement functionInvocationStatement) {
        FunctionStatement stmt = this.factory.createFunctionStatement();
        functionInvocationStatement.getFunctionInvocation().accept(this);
        stmt.setExpr((Expression)this.stack.pop());
        this.stack.push(stmt);
        this.setElementInformation((Node)functionInvocationStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(GetByPositionStatement getByPositionStatement) {
        IOStatementGenerator generator = this.getGeneratorFor(getByPositionStatement);
        org.eclipse.edt.mof.egl.GetByPositionStatement stmt = generator.genGetByPositionStatement(getByPositionStatement, this.eObjects);
        this.stack.push(stmt);
        this.setElementInformation((Node)getByPositionStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.GetByKeyStatement getByKeyStatement) {
        IOStatementGenerator generator = this.getGeneratorFor(getByKeyStatement);
        GetByKeyStatement stmt = generator.genGetByKeyStatement(getByKeyStatement, this.eObjects);
        this.stack.push(stmt);
        this.setElementInformation((Node)getByKeyStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(GotoStatement gotoStatement) {
        GoToStatement stmt = this.factory.createGoToStatement();
        stmt.setLabel(gotoStatement.getLabel());
        this.stack.push(stmt);
        this.setElementInformation((Node)gotoStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.IfStatement ifStatement) {
        IfStatement stmt = this.factory.createIfStatement();
        this.stack.push(stmt);
        this.setElementInformation((Node)ifStatement, (Statement)stmt);
        ifStatement.getCondition().accept(this);
        stmt.setCondition((Expression)this.stack.pop());
        StatementBlock block = this.factory.createStatementBlock();
        this.setElementInformation((Node)ifStatement, (Statement)block);
        stmt.setTrueBranch((Statement)block);
        for (Node node : ifStatement.getStmts()) {
            node.accept(this);
            block.getStatements().add((Statement)this.stack.pop());
        }
        if (ifStatement.hasElse()) {
            block = this.factory.createStatementBlock();
            this.setElementInformation((Node)ifStatement, (Statement)block);
            stmt.setFalseBranch((Statement)block);
            for (Node node : ifStatement.getElse().getStmts()) {
                node.accept(this);
                block.getStatements().add((Statement)this.stack.pop());
            }
        }
        return false;
    }

    @Override
    public boolean visit(LabelStatement labelStatement) {
        org.eclipse.edt.mof.egl.LabelStatement stmt = this.factory.createLabelStatement();
        stmt.setLabel(labelStatement.getLabel());
        this.stack.push(stmt);
        this.setElementInformation((Node)labelStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(MoveStatement moveStatement) {
        org.eclipse.edt.mof.egl.MoveStatement stmt = this.factory.createMoveStatement();
        moveStatement.getSource().accept(this);
        stmt.setSourceExpr((Expression)this.stack.pop());
        moveStatement.getTarget().accept(this);
        stmt.setTargetExpr((LHSExpr)this.stack.pop());
        if (moveStatement.getMoveModifierOpt() != null) {
            if (moveStatement.getMoveModifierOpt().isByName()) {
                stmt.setModifier(1);
            } else if (moveStatement.getMoveModifierOpt().isByPosition()) {
                stmt.setModifier(2);
            } else if (moveStatement.getMoveModifierOpt().isFor()) {
                stmt.setModifier(3);
                moveStatement.getMoveModifierOpt().getExpression().accept(this);
                stmt.setModifierExpr((Expression)this.stack.pop());
            } else if (moveStatement.getMoveModifierOpt().isForAll()) {
                stmt.setModifier(4);
            } else if (moveStatement.getMoveModifierOpt().isWithV60Compat()) {
                stmt.setModifier(5);
            }
        }
        this.stack.push(stmt);
        this.setElementInformation((Node)moveStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.OpenStatement openStatement) {
        IOStatementGenerator generator = this.getGeneratorFor(openStatement);
        OpenStatement stmt = generator.genOpenStatement(openStatement, this.eObjects);
        this.stack.push(stmt);
        this.setElementInformation((Node)openStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(OpenUIStatement openUIStatement) {
        org.eclipse.edt.mof.egl.OpenUIStatement stmt = this.factory.createOpenUIStatement();
        this.stack.push(stmt);
        this.setElementInformation((Node)openUIStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.PrepareStatement prepareStatement) {
        IOStatementGenerator generator = this.getGeneratorFor(prepareStatement);
        PrepareStatement stmt = generator.genPrepareStatement(prepareStatement, this.eObjects);
        this.setElementInformation((Node)prepareStatement, (Statement)stmt);
        this.stack.push(stmt);
        return false;
    }

    @Override
    public boolean visit(PrintStatement printStatement) {
        org.eclipse.edt.mof.egl.PrintStatement stmt = this.factory.createPrintStatement();
        this.stack.push(stmt);
        this.setElementInformation((Node)printStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.ReplaceStatement replaceStatement) {
        IOStatementGenerator generator = this.getGeneratorFor(replaceStatement);
        ReplaceStatement stmt = generator.genReplaceStatement(replaceStatement, this.eObjects);
        this.stack.push(stmt);
        this.setElementInformation((Node)replaceStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.SetStatement setStatement) {
        SetStatement stmt = this.factory.createSetStatement();
        for (Node node : setStatement.getSetTargets()) {
            node.accept(this);
            stmt.getTargets().add((Expression)this.stack.pop());
        }
        for (String state : setStatement.getStates()) {
            stmt.getStates().add(state);
        }
        this.stack.push(stmt);
        this.setElementInformation((Node)setStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(ShowStatement showStatement) {
        IOStatementGenerator generator = this.getGeneratorFor(showStatement);
        org.eclipse.edt.mof.egl.ShowStatement stmt = generator.genShowStatement(showStatement, this.eObjects);
        this.stack.push(stmt);
        this.setElementInformation((Node)showStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.ThrowStatement throwStatement) {
        ThrowStatement stmt = this.factory.createThrowStatement();
        throwStatement.getExpression().accept(this);
        stmt.setException((Expression)this.stack.pop());
        this.stack.push(stmt);
        this.setElementInformation((Node)throwStatement, (Statement)stmt);
        return false;
    }

    @Override
    public boolean visit(TransferStatement transferStatement) {
        org.eclipse.edt.mof.egl.TransferStatement stmt = this.factory.createTransferStatement();
        this.stack.push(stmt);
        this.setElementInformation((Node)transferStatement, (Statement)stmt);
        transferStatement.getInvocationTarget().accept(this);
        stmt.setInvocationTarget((Expression)this.stack.pop());
        if (transferStatement.getPassingRecord() != null) {
            transferStatement.getPassingRecord().accept(this);
            stmt.setPassingRecord((Expression)this.stack.pop());
        }
        int targetType = transferStatement.isToProgram() ? 1 : 2;
        stmt.setTargetType(Integer.valueOf(targetType));
        this.stack.push(stmt);
        if (transferStatement.hasSettingsBlock()) {
            this.processSettings((Element)stmt, transferStatement.getSettingsBlock());
        }
        return false;
    }

    @Override
    public boolean visit(TryStatement tryStatement) {
        org.eclipse.edt.mof.egl.TryStatement stmt = this.factory.createTryStatement();
        this.stack.push(stmt);
        this.setElementInformation((Node)tryStatement, (Statement)stmt);
        StatementBlock block = this.factory.createStatementBlock();
        this.setElementInformation((Node)tryStatement, (Statement)block);
        stmt.setTryBlock(block);
        for (Node node : tryStatement.getStmts()) {
            node.accept(this);
            block.getStatements().add((Statement)this.stack.pop());
        }
        for (Node node : tryStatement.getOnExceptionBlocks()) {
            node.accept(this);
            stmt.getExceptionBlocks().add((ExceptionBlock)this.stack.pop());
        }
        return false;
    }

    @Override
    public boolean visit(OnExceptionBlock onExceptionBlock) {
        ExceptionBlock block = this.factory.createExceptionBlock();
        this.stack.push(block);
        this.setElementInformation((Node)onExceptionBlock, (Statement)block);
        if (onExceptionBlock.getExceptionName() != null) {
            Parameter ex = this.factory.createParameter();
            this.setElementInformation((Node)onExceptionBlock.getExceptionName(), (EObject)ex);
            ex.setName(onExceptionBlock.getExceptionName().getCaseSensitiveIdentifier());
            ITypeBinding type = onExceptionBlock.getExceptionType().resolveTypeBinding();
            ex.setType((Type)this.mofTypeFor(type));
            this.eObjects.put(onExceptionBlock.getExceptionName().resolveDataBinding(), ex);
            block.setException(ex);
        }
        for (Node node : onExceptionBlock.getStmts()) {
            node.accept(this);
            block.getStatements().add((Statement)this.stack.pop());
        }
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.WhileStatement whileStatement) {
        WhileStatement stmt = this.factory.createWhileStatement();
        this.stack.push(stmt);
        this.setElementInformation((Node)whileStatement, (Statement)stmt);
        whileStatement.getExpr().accept(this);
        stmt.setCondition((Expression)this.stack.pop());
        StatementBlock block = this.factory.createStatementBlock();
        this.setElementInformation((Node)whileStatement, (Statement)block);
        stmt.setBody((Statement)block);
        for (Node node : whileStatement.getStmts()) {
            node.accept(this);
            block.getStatements().add((Statement)this.stack.pop());
        }
        return false;
    }

    private IOStatementGenerator getGeneratorFor(org.eclipse.edt.compiler.core.ast.Statement node) {
        Class<? extends IOStatementGenerator> generatorClass = this.primGetGeneratorFor(node);
        if (generatorClass != null) {
            try {
                IOStatementGenerator generator = generatorClass.newInstance();
                generator.setCurrentPart(this.currentPart);
                generator.setContext(this.context);
                generator.setEnvironment(this.env);
                return generator;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private Class<? extends IOStatementGenerator> primGetGeneratorFor(org.eclipse.edt.compiler.core.ast.Statement node) {
        final Class[] generator = new Class[1];
        node.accept(new AbstractASTExpressionVisitor(){

            @Override
            public boolean visit(FromOrToExpressionClause clause) {
                ITypeBinding type;
                if (generator[0] == null && clause.getExpression() != null && (type = clause.getExpression().resolveTypeBinding()) != null && type.getPackageName() != null) {
                    String key = IRUtils.concatWithSeparator((String[])type.getPackageName(), (String)".");
                    generator[0] = IOStatementGenerator.Registry.get(key);
                }
                return false;
            }
        });
        if (generator[0] == null && !(node instanceof org.eclipse.edt.compiler.core.ast.CallStatement)) {
            return IOStatementGenerator.Registry.get("eglx.persistence.sql");
        }
        if (generator[0] == null && node instanceof org.eclipse.edt.compiler.core.ast.CallStatement) {
            return IOStatementGenerator.Registry.get("eglx.services");
        }
        return generator[0];
    }

    private boolean isDliStatement(org.eclipse.edt.compiler.core.ast.Statement stmt) {
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.AddStatement) {
            return ((org.eclipse.edt.compiler.core.ast.AddStatement)stmt).getDliInfo() != null;
        }
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.DeleteStatement) {
            return ((org.eclipse.edt.compiler.core.ast.DeleteStatement)stmt).getDliInfo() != null;
        }
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.GetByKeyStatement) {
            return ((org.eclipse.edt.compiler.core.ast.GetByKeyStatement)stmt).getDliInfo() != null;
        }
        if (stmt instanceof GetByPositionStatement) {
            return ((GetByPositionStatement)stmt).getDliInfo() != null;
        }
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.ReplaceStatement) {
            return ((org.eclipse.edt.compiler.core.ast.ReplaceStatement)stmt).getDliInfo() != null;
        }
        return false;
    }

    private boolean isSqlStatement(org.eclipse.edt.compiler.core.ast.Statement stmt) {
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.AddStatement) {
            return ((org.eclipse.edt.compiler.core.ast.AddStatement)stmt).getSqlInfo() != null;
        }
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.DeleteStatement) {
            return ((org.eclipse.edt.compiler.core.ast.DeleteStatement)stmt).getSqlInfo() != null;
        }
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.ExecuteStatement) {
            return true;
        }
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.ForEachStatement) {
            return true;
        }
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.GetByKeyStatement) {
            return ((org.eclipse.edt.compiler.core.ast.GetByKeyStatement)stmt).getSqlInfo() != null;
        }
        if (stmt instanceof GetByPositionStatement) {
            return !this.isDliStatement(stmt);
        }
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.OpenStatement) {
            return ((org.eclipse.edt.compiler.core.ast.OpenStatement)stmt).getSqlInfo() != null;
        }
        if (stmt instanceof org.eclipse.edt.compiler.core.ast.ReplaceStatement) {
            return ((org.eclipse.edt.compiler.core.ast.ReplaceStatement)stmt).getSqlInfo() != null;
        }
        return false;
    }
}

