/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.egl2mof.eglx.persistence.sql.validation;

import java.util.List;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AddStatement;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ForExpressionClause;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.egl2mof.eglx.persistence.sql.validation.AbstractSqlStatementValidator;

public class AddStatementValidator
extends AbstractSqlStatementValidator {
    AddStatement statement;
    IProblemRequestor problemRequestor;
    ICompilerOptions compilerOptions;
    FromOrToExpressionClause to;
    ForExpressionClause forExpression;

    public AddStatementValidator(AddStatement statement, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.statement = statement;
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    public void validate() {
        this.initialize();
        this.validateTarget();
        this.validateFor();
    }

    private void validateTarget() {
        int[] offsets;
        Expression expr;
        ITypeBinding type;
        Object o;
        List exprs = this.statement.getTargets();
        boolean isEntity = false;
        if (exprs.size() == 1 && (o = exprs.get(0)) instanceof Expression && this.isEntity(type = (expr = (Expression)o).resolveTypeBinding())) {
            if (this.isAssociationExpression(expr)) {
                this.problemRequestor.acceptProblem((Node)expr, 8508, new String[0]);
                return;
            }
            isEntity = true;
        }
        if (!isEntity && !this.mapsToColumns(exprs)) {
            offsets = this.getOffsets(exprs);
            this.problemRequestor.acceptProblem(offsets[0], offsets[1], 8506, new String[0]);
            return;
        }
        if (!isEntity && this.forExpression == null && !this.mapsToSingleTable(exprs)) {
            offsets = this.getOffsets(exprs);
            this.problemRequestor.acceptProblem(offsets[0], offsets[1], 8518, new String[]{"for"});
            return;
        }
        ITypeBinding targetType = this.getTargetType();
        if (Binding.isValidBinding(targetType) && !this.isSingleTable(targetType)) {
            int[] offsets2 = this.getOffsets(exprs);
            this.problemRequestor.acceptProblem(offsets2[0], offsets2[1], 8515, new String[0]);
            return;
        }
    }

    private void validateFor() {
        if (this.forExpression != null) {
            ITypeBinding type;
            if (this.to != null && Binding.isValidBinding(type = this.to.getExpression().resolveTypeBinding()) && this.isResultSet(type)) {
                this.problemRequestor.acceptProblem((Node)this.forExpression, 8510, new String[]{"eglx.persistence.sql.SQLResultSet"});
                return;
            }
            type = this.forExpression.getExpression().resolveTypeBinding();
            if (Binding.isValidBinding(type)) {
                if (!this.isEntityWithID(type) || this.isAssociationExpression(this.forExpression.getExpression())) {
                    this.problemRequestor.acceptProblem((Node)this.forExpression.getExpression(), 8502, new String[]{this.forExpression.getExpression().getCanonicalString()});
                    return;
                }
                ITypeBinding targetType = this.getTargetType();
                if (Binding.isValidBinding(targetType) && !targetType.equals(type)) {
                    this.problemRequestor.acceptProblem((Node)this.forExpression.getExpression(), 8507, new String[]{this.forExpression.getExpression().getCanonicalString(), type.getPackageQualifiedName(), targetType.getPackageQualifiedName()});
                    return;
                }
            }
        }
    }

    private ITypeBinding getTargetType() {
        Expression e;
        ITypeBinding type = null;
        List targets = this.statement.getTargets();
        int size = targets.size();
        if (size > 0 && Binding.isValidBinding(type = (e = (Expression)targets.get(0)).resolveTypeBinding()) && (size != 1 || !this.isEntity(type))) {
            IDataBinding data;
            type = null;
            if (this.mapsToSingleTable(targets) && Binding.isValidBinding(data = e.resolveDataBinding())) {
                type = data.getDeclaringPart();
            }
        }
        if (Binding.isValidBinding(type) && type.getKind() == 2) {
            type = ((ArrayTypeBinding)type).getElementType();
        }
        return type;
    }

    private void initialize() {
        this.statement.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(FromOrToExpressionClause clause) {
                if (AddStatementValidator.this.to == null) {
                    AddStatementValidator.this.to = clause;
                } else {
                    AddStatementValidator.this.problemRequestor.acceptProblem((Node)clause, 6510, new String[]{"add".toUpperCase(), "to".toUpperCase()});
                }
                return false;
            }

            @Override
            public boolean visit(ForExpressionClause forExpressionClause) {
                if (AddStatementValidator.this.forExpression == null) {
                    AddStatementValidator.this.forExpression = forExpressionClause;
                } else {
                    AddStatementValidator.this.problemRequestor.acceptProblem((Node)forExpressionClause, 6510, new String[]{"add".toUpperCase(), "for".toUpperCase()});
                }
                return false;
            }
        });
    }
}

