/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.egl2mof.eglx.persistence.sql.validation;

import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.DeleteStatement;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ForExpressionClause;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.UsingClause;
import org.eclipse.edt.compiler.core.ast.UsingKeysClause;
import org.eclipse.edt.compiler.core.ast.WithExpressionClause;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.egl2mof.eglx.persistence.sql.validation.AbstractSqlStatementValidator;

public class DeleteStatementValidator
extends AbstractSqlStatementValidator {
    DeleteStatement statement;
    IProblemRequestor problemRequestor;
    ICompilerOptions compilerOptions;
    UsingClause using;
    UsingKeysClause usingKeys;
    FromOrToExpressionClause from;
    WithInlineSQLClause withInline;
    WithExpressionClause withExpression;
    ForExpressionClause forExpression;

    public DeleteStatementValidator(DeleteStatement statement, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.statement = statement;
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    public void validate() {
        this.initialize();
        this.validateTarget();
        this.validateDataSource();
        this.validateFor();
    }

    private void validateTarget() {
        Expression target = this.statement.getTarget();
        if (target != null) {
            ITypeBinding targetType = target.resolveTypeBinding();
            if (targetType.getKind() == 3) {
                targetType = target.resolveDataBinding().getDeclaringPart();
            }
            if (!this.isDataExpr(target) || Binding.isValidBinding(targetType) && targetType.getKind() == 2) {
                this.problemRequestor.acceptProblem((Node)target, 8513, new String[0]);
                return;
            }
            if (this.isAssociationExpression(target)) {
                this.problemRequestor.acceptProblem((Node)target, 8508, new String[0]);
                return;
            }
            if (Binding.isValidBinding(targetType) && !this.isSingleTable(targetType)) {
                this.problemRequestor.acceptProblem((Node)target, 8515, new String[0]);
                return;
            }
            if (this.from != null && Binding.isValidBinding(targetType) && this.withExpression == null && this.withInline == null && this.using == null && this.isDataSource(this.from.getExpression().resolveTypeBinding()) && !this.hasID(targetType)) {
                this.problemRequestor.acceptProblem((Node)target, 8509, new String[]{targetType.getPackageQualifiedName()});
                return;
            }
        }
    }

    private void validateDataSource() {
        if (this.statement.getTarget() == null && this.from != null) {
            ITypeBinding type = this.from.getExpression().resolveTypeBinding();
            if (this.isDataSource(type)) {
                if (this.withInline == null && this.withExpression == null) {
                    this.problemRequestor.acceptProblem((Node)this.statement, 8511, new String[]{"eglx.persistence.sql.SQLDataSource"});
                    return;
                }
            } else if (this.isResultSet(type) && (this.withInline != null || this.withExpression != null || this.forExpression != null || this.using != null)) {
                this.problemRequestor.acceptProblem((Node)this.statement, 8512, new String[]{"eglx.persistence.sql.SQLResultSet"});
                return;
            }
        }
    }

    private void validateFor() {
        if (this.forExpression != null) {
            ITypeBinding targetType;
            if (this.statement.getTarget() == null) {
                this.problemRequestor.acceptProblem((Node)this.forExpression, 8514, new String[0]);
                return;
            }
            if (this.withExpression != null || this.withInline != null) {
                this.problemRequestor.acceptProblem((Node)this.statement, 8516, new String[0]);
                return;
            }
            ITypeBinding type = this.forExpression.getExpression().resolveTypeBinding();
            if (Binding.isValidBinding(type) && (!this.isEntityWithID(type) || this.isAssociationExpression(this.forExpression.getExpression()))) {
                this.problemRequestor.acceptProblem((Node)this.forExpression.getExpression(), 8502, new String[]{this.forExpression.getExpression().getCanonicalString()});
                return;
            }
            if (Binding.isValidBinding(type) && Binding.isValidBinding(targetType = this.statement.getTarget().resolveTypeBinding()) && !targetType.equals(type)) {
                this.problemRequestor.acceptProblem((Node)this.forExpression.getExpression(), 8507, new String[]{this.forExpression.getExpression().getCanonicalString(), type.getPackageQualifiedName(), targetType.getPackageQualifiedName()});
                return;
            }
        }
    }

    private void initialize() {
        this.statement.accept(new AbstractASTVisitor(){

            @Override
            public boolean visit(WithInlineSQLClause withInlineSQLClause) {
                if (DeleteStatementValidator.this.withInline == null && DeleteStatementValidator.this.withExpression == null) {
                    DeleteStatementValidator.this.withInline = withInlineSQLClause;
                } else {
                    DeleteStatementValidator.this.problemRequestor.acceptProblem((Node)withInlineSQLClause, 6510, new String[]{"delete".toUpperCase(), "with".toUpperCase()});
                }
                return false;
            }

            @Override
            public boolean visit(WithExpressionClause withExpressionClause) {
                if (DeleteStatementValidator.this.withInline == null && DeleteStatementValidator.this.withExpression == null) {
                    DeleteStatementValidator.this.withExpression = withExpressionClause;
                } else {
                    DeleteStatementValidator.this.problemRequestor.acceptProblem((Node)withExpressionClause, 6510, new String[]{"delete".toUpperCase(), "with".toUpperCase()});
                }
                return false;
            }

            @Override
            public boolean visit(UsingClause usingClause) {
                if (DeleteStatementValidator.this.using == null) {
                    DeleteStatementValidator.this.using = usingClause;
                } else {
                    DeleteStatementValidator.this.problemRequestor.acceptProblem((Node)usingClause, 6510, new String[]{"delete".toUpperCase(), "using".toUpperCase()});
                }
                return false;
            }

            @Override
            public boolean visit(UsingKeysClause usingKeysClause) {
                if (DeleteStatementValidator.this.usingKeys == null) {
                    DeleteStatementValidator.this.usingKeys = usingKeysClause;
                } else {
                    DeleteStatementValidator.this.problemRequestor.acceptProblem((Node)usingKeysClause, 6510, new String[]{"delete".toUpperCase(), "usingKeys".toUpperCase()});
                }
                return false;
            }

            @Override
            public boolean visit(FromOrToExpressionClause clause) {
                if (DeleteStatementValidator.this.from == null) {
                    DeleteStatementValidator.this.from = clause;
                } else {
                    DeleteStatementValidator.this.problemRequestor.acceptProblem((Node)clause, 6510, new String[]{"delete".toUpperCase(), "from".toUpperCase()});
                }
                return false;
            }

            @Override
            public boolean visit(ForExpressionClause forExpressionClause) {
                if (DeleteStatementValidator.this.forExpression == null) {
                    DeleteStatementValidator.this.forExpression = forExpressionClause;
                } else {
                    DeleteStatementValidator.this.problemRequestor.acceptProblem((Node)forExpressionClause, 6510, new String[]{"delete".toUpperCase(), "for".toUpperCase()});
                }
                return false;
            }
        });
    }
}

