/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sdk.compile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.NumberFormat;
import org.eclipse.edt.compiler.internal.core.builder.DefaultProblemRequestor;
import org.eclipse.edt.compiler.internal.sdk.utils.SDKLineTracker;

public class SDKSyntaxProblemRequestor
extends DefaultProblemRequestor {
    private String errorMsgCode;
    private String source;
    private SDKLineTracker lineTracker;
    private File file;
    private boolean processedError = false;

    public SDKSyntaxProblemRequestor(File file, String errorMsgCode) {
        this.errorMsgCode = errorMsgCode;
        this.file = file;
    }

    private SDKLineTracker getLineTracker() {
        if (this.lineTracker == null) {
            this.lineTracker = new SDKLineTracker();
            this.lineTracker.set(this.getSource());
        }
        return this.lineTracker;
    }

    private String getSource() {
        if (this.source == null) {
            this.source = this.getFileContents(this.file);
        }
        return this.source;
    }

    @Override
    public void acceptProblem(int startOffset, int endOffset, int severity, int problemKind, String[] inserts) {
        if (severity == 2) {
            this.setHasError(true);
        }
        String message = this.createMessage(startOffset, endOffset, severity, problemKind, inserts);
        if (severity == 2) {
            this.setHasError(true);
        }
        this.displayProblem(startOffset, endOffset, message);
    }

    protected String createMessage(int startOffset, int endOffset, int severity, int problemKind, String[] inserts) {
        return this.createMessage(startOffset, endOffset, this.getLineNumberOfOffset(startOffset), severity, problemKind, inserts);
    }

    protected String createMessage(int startOffset, int endOffset, int lineNumber, int severity, int problemKind, String[] inserts) {
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setMinimumIntegerDigits(3);
        String message = "";
        message = problemKind != -1 ? this.getErrorMessageText(problemKind, startOffset, lineNumber, severity, SDKSyntaxProblemRequestor.getMessageFromBundle(problemKind, inserts)) : this.getErrorMessageText(problemKind, startOffset, lineNumber, severity, inserts[0]);
        return message;
    }

    private String getErrorMessageText(int problemKind, int startOffset, int lineNumber, int severity, String msgText) {
        StringBuffer result = new StringBuffer();
        result.append(this.getMessagePrefix(problemKind, startOffset, lineNumber, severity));
        result.append(" ");
        result.append(msgText);
        return result.toString();
    }

    private String getMessagePrefix(int problemKind, int startOffset, int lineNumber, int severity) {
        StringBuffer prefix = new StringBuffer();
        prefix.append("IWN.");
        prefix.append(this.errorMsgCode);
        if (problemKind != -1) {
            prefix.append(".");
            prefix.append(Integer.toString(problemKind));
        }
        if (2 == severity) {
            prefix.append(".e");
        } else if (1 == severity) {
            prefix.append(".w");
        } else if (severity == 0) {
            prefix.append(".i");
        }
        prefix.append(" ");
        prefix.append(Integer.toString(lineNumber));
        prefix.append("/");
        int offsetOnLine = startOffset - this.getLineTracker().getLineOffset(lineNumber);
        prefix.append(Integer.toString(offsetOnLine + 1));
        return prefix.toString();
    }

    protected int getLineNumberOfOffset(int offset) {
        return this.getLineTracker().getLineNumberOfOffset(offset);
    }

    private String getFileContents(File file) {
        StringBuffer buffer;
        block16: {
            if (file == null) {
                return new String();
            }
            buffer = new StringBuffer();
            Reader reader = null;
            try {
                try {
                    int cur;
                    reader = new BufferedReader(new FileReader(file));
                    while ((cur = reader.read()) != -1) {
                        buffer.append((char)cur);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buffer.toString();
    }

    private void displayProblem(int startOffset, int endOffset, String message) {
        if (!this.processedError) {
            this.processedError = true;
            this.println(this.file.getAbsolutePath());
        }
        if (startOffset == -1) {
            startOffset = this.getSource().length();
        }
        if (endOffset == -1) {
            endOffset = this.getSource().length();
        }
        try {
            int startLine = this.getLineTracker().getLineNumberOfOffset(startOffset);
            int endLine = this.getLineTracker().getLineNumberOfOffset(endOffset);
            if (startLine == endLine) {
                SDKLineTracker.LineInfo lineInformation = this.getLineTracker().getLineInfo(startLine);
                int lineStart = lineInformation.getOffset();
                int lineEnd = lineStart + lineInformation.getLength();
                this.println(this.getSource().substring(lineStart, lineEnd));
                int i = lineStart;
                while (i < startOffset) {
                    this.print(this.getSource().charAt(i) == '\t' ? "\t" : " ");
                    ++i;
                }
                this.print(endOffset - startOffset <= 1 ? "*" : "<");
                i = startOffset;
                while (i < endOffset - 2) {
                    this.print(this.getSource().charAt(i) == '\t' ? "--------" : "-");
                    ++i;
                }
                if (endOffset - startOffset > 1) {
                    this.print(">");
                }
                this.println();
            } else {
                SDKLineTracker.LineInfo firstLineInformation = this.getLineTracker().getLineInfo(startLine);
                int firstLineStart = firstLineInformation.getOffset();
                int firstLineEnd = firstLineStart + firstLineInformation.getLength();
                this.println(this.getSource().substring(firstLineStart, firstLineEnd));
                int i = firstLineStart;
                while (i < startOffset) {
                    this.print(this.getSource().charAt(i) == '\t' ? "\t" : " ");
                    ++i;
                }
                this.print("<");
                i = startOffset;
                while (i <= firstLineEnd) {
                    this.print(this.getSource().charAt(i) == '\t' ? "--------" : "-");
                    ++i;
                }
                this.println();
                i = startLine + 1;
                while (i < endLine) {
                    SDKLineTracker.LineInfo lineInformation = this.getLineTracker().getLineInfo(i);
                    int lineStart = lineInformation.getOffset();
                    int lineEnd = lineStart + lineInformation.getLength();
                    this.println(this.getSource().substring(lineStart, lineEnd));
                    int j = lineStart;
                    while (j <= lineEnd) {
                        this.print(this.getSource().charAt(i) == '\t' ? "--------" : "-");
                        ++j;
                    }
                    this.println();
                    ++i;
                }
                SDKLineTracker.LineInfo endLineInformation = this.getLineTracker().getLineInfo(endLine);
                int endLineStart = endLineInformation.getOffset();
                int endLineEnd = endLineStart + endLineInformation.getLength();
                this.println(this.getSource().substring(endLineStart, endLineEnd));
                int i2 = endLineStart;
                while (i2 < endOffset - 1) {
                    this.print(this.getSource().charAt(i2) == '\t' ? "--------" : "-");
                    ++i2;
                }
                this.print(">");
                this.println();
            }
            this.println(message);
            this.println("-------------------------------------------------------------------------------");
            this.println();
            this.println();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void println(String string) {
        System.out.println(string);
    }

    public void print(String string) {
        System.out.print(string);
    }

    public void println() {
        System.out.println();
    }
}

