/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sql;

import org.eclipse.edt.compiler.internal.sql.Token;

public class SelectNameToken
extends Token {
    public SelectNameToken(String string, int startOff) {
        super(SelectNameToken.trim(string));
        if (this.string.length() == 0) {
            this.string = " ";
        }
        this.setStartOffset(startOff);
        this.setEndOffset(startOff + string.length() - 1);
    }

    public void append(SelectNameToken token) {
        StringBuffer buff = new StringBuffer(this.string);
        if (this.getEndOffset() + 1 != token.getStartOffset()) {
            buff.append(" ");
        }
        buff.append(token.string);
        this.string = buff.toString();
        this.setEndOffset(this.getStartOffset() + this.string.length() - 1);
    }

    public static String trim(String string) {
        int len = string.length();
        int st = 0;
        char[] val = string.toCharArray();
        while (st < len && val[st] <= ' ') {
            ++st;
        }
        while (st < len && val[len - 1] <= ' ') {
            --len;
        }
        String pre = "";
        String post = "";
        if (st > 0) {
            pre = " ";
        }
        if (len < string.length()) {
            post = " ";
        }
        StringBuffer buff = new StringBuffer();
        buff.append(pre);
        buff.append(string.substring(st, len));
        buff.append(post);
        return buff.toString();
    }

    @Override
    public String getSQLString() {
        return this.string;
    }

    @Override
    public boolean isSelectNameToken() {
        return true;
    }
}

