/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sqltokenizer;

public class EGLPrimeToken {
    protected int type;
    protected String text = null;
    protected int offset;
    protected int line;
    protected int column;
    protected boolean hostVar = false;
    protected boolean whereCurrentOf = false;
    public static final int SELECT = 1;
    public static final int INTO = 2;
    public static final int FROM = 3;
    public static final int VALUES = 4;
    public static final int UPDATE = 5;
    public static final int SET = 6;
    public static final int HAVING = 7;
    public static final int WHERE = 8;
    public static final int ORDER = 9;
    public static final int GROUP = 10;
    public static final int INSERT = 11;
    public static final int FOR = 12;
    public static final int BY = 13;
    public static final int OF = 14;
    public static final int UNION = 15;
    public static final int CURRENT = 16;
    public static final int CALL = 17;
    public static final int DELETE = 18;
    public static final int SEMI = 21;
    public static final int L_PAREN = 22;
    public static final int R_PAREN = 23;
    public static final int L_SQUARE = 24;
    public static final int R_SQUARE = 25;
    public static final int DOT = 26;
    public static final int COLON = 27;
    public static final int HOST_VAR_COLON = 28;
    public static final int BANG = 29;
    public static final int EQUAL = 30;
    public static final int PLUS = 31;
    public static final int MINUS = 32;
    public static final int SPLAT = 33;
    public static final int SLASH = 34;
    public static final int PERCENT = 35;
    public static final int GREATER = 36;
    public static final int GREATER_EQUAL = 37;
    public static final int LESS = 38;
    public static final int LESS_EQUAL = 39;
    public static final int NOT_EQUAL = 40;
    public static final int OR = 41;
    public static final int SQL_OR = 42;
    public static final int AND = 43;
    public static final int SQL_AND = 44;
    public static final int COMMA = 45;
    private int firstDelimiter = 21;
    private int lastDelimiter = 45;
    public static final int IDENTIFIER = 51;
    public static final int SQL_STRING = 52;
    public static final int REAL_NUMBER = 53;
    public static final int FLOAT_NUMBER = 54;
    public static final int INTEGER = 55;
    public static final int COLUMNS = 56;
    public static final int EXECUTE = 57;
    public static final int DEFAULT_SELECT = 58;
    public static final int DELIMITED_NAME = 59;
    public static final int UNKNOWN_EGL = 61;
    public static final int SQLCOMMENT = Integer.MAX_VALUE;

    public EGLPrimeToken(int tokenType, String tokenText, int tokenOffset, int tokenLine, int tokenColumn) {
        this.type = tokenType;
        this.text = tokenText;
        this.offset = tokenOffset;
        this.line = tokenLine;
        this.column = tokenColumn;
    }

    public boolean isDelimiter() {
        return this.type >= this.firstDelimiter && this.type <= this.lastDelimiter;
    }

    public void setHostVar() {
        this.hostVar = true;
    }

    public boolean isHostVar() {
        return this.hostVar;
    }

    public void setWhereCurrentOf() {
        this.whereCurrentOf = true;
    }

    public boolean isWhereCurrentOf() {
        return this.whereCurrentOf;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int off) {
        this.offset = off;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int inputLine) {
        this.line = inputLine;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int inputCol) {
        this.column = inputCol;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int inType) {
        this.type = inType;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String inText) {
        this.text = inText;
    }

    public String toString() {
        return "[\"" + this.getText() + "\",<" + this.type + ">,offset=" + this.offset + ",line=" + this.line + ",column=" + this.column + "]";
    }
}

