/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sqltokenizer;

import java.util.ArrayList;
import org.eclipse.edt.compiler.internal.sqltokenizer.EGLPrimeToken;

public class EGLSQLClauseTree {
    ArrayList tokens = new ArrayList();
    EGLPrimeToken clauseKeyword = null;
    EGLPrimeToken secondKeyword = null;
    EGLPrimeToken thirdKeyword = null;

    public EGLSQLClauseTree() {
        this.clauseKeyword = null;
        this.secondKeyword = null;
        this.thirdKeyword = null;
    }

    public EGLSQLClauseTree(EGLPrimeToken keyword) {
        this.clauseKeyword = keyword;
        this.secondKeyword = null;
        this.thirdKeyword = null;
    }

    public EGLSQLClauseTree(EGLPrimeToken keyword, EGLPrimeToken secondKeyword) {
        this.clauseKeyword = keyword;
        this.secondKeyword = secondKeyword;
        this.thirdKeyword = null;
    }

    public EGLSQLClauseTree(EGLPrimeToken keyword, EGLPrimeToken secondKeyword, EGLPrimeToken thirdKeyword) {
        this.clauseKeyword = keyword;
        this.secondKeyword = secondKeyword;
        this.thirdKeyword = thirdKeyword;
    }

    public void addToken(EGLPrimeToken newToken) {
        this.tokens.add(newToken);
    }

    public void concat(EGLSQLClauseTree tree) {
        this.tokens.addAll(tree.tokens);
    }

    public EGLPrimeToken getClauseKeyword() {
        return this.clauseKeyword;
    }

    public EGLPrimeToken getSecondKeyword() {
        return this.secondKeyword;
    }

    public EGLPrimeToken getThirdKeyword() {
        return this.thirdKeyword;
    }

    public EGLPrimeToken getToken(int index) {
        return (EGLPrimeToken)this.tokens.get(index);
    }

    public int getClauseType() {
        if (this.clauseKeyword == null) {
            return 58;
        }
        return this.clauseKeyword.getType();
    }

    public EGLPrimeToken getFirstToken() {
        if (this.tokens.isEmpty()) {
            return null;
        }
        return (EGLPrimeToken)this.tokens.get(0);
    }

    public EGLPrimeToken getLastToken() {
        if (this.tokens.isEmpty()) {
            return null;
        }
        return (EGLPrimeToken)this.tokens.get(this.tokens.size() - 1);
    }

    public void setClauseKeyword(EGLPrimeToken keyword) {
        this.clauseKeyword = keyword;
    }

    public void setSecondKeyword(EGLPrimeToken secondKeyword) {
        this.secondKeyword = secondKeyword;
    }

    public void setThirdKeyword(EGLPrimeToken thirdKeyword) {
        this.thirdKeyword = thirdKeyword;
    }

    public int size() {
        return this.tokens.size();
    }

    public String toString() {
        int betweenTokens = 0;
        int CRLFpairs = 0;
        int atEndOfPrevious = 0;
        int atBeginningOfCurrent = 0;
        StringBuffer newStr = new StringBuffer("");
        if (this.tokens.size() > 0) {
            this.addBlanks(newStr, ((EGLPrimeToken)this.tokens.get(0)).getColumn() - 1);
            newStr.append(((EGLPrimeToken)this.tokens.get(0)).getText());
        }
        int ii = 1;
        while (ii < this.tokens.size()) {
            betweenTokens = ((EGLPrimeToken)this.tokens.get(ii)).getOffset() - ((EGLPrimeToken)this.tokens.get(ii - 1)).getOffset() - ((EGLPrimeToken)this.tokens.get(ii - 1)).getText().length();
            if (betweenTokens > 0) {
                CRLFpairs = ((EGLPrimeToken)this.tokens.get(ii)).getLine() - ((EGLPrimeToken)this.tokens.get(ii - 1)).getLine();
                if (CRLFpairs > 0) {
                    atEndOfPrevious = betweenTokens - 2 * CRLFpairs - ((EGLPrimeToken)this.tokens.get(ii)).getColumn() + 1;
                    atBeginningOfCurrent = betweenTokens - 2 * CRLFpairs - atEndOfPrevious;
                } else {
                    atEndOfPrevious = betweenTokens;
                    atBeginningOfCurrent = 0;
                }
            } else {
                CRLFpairs = 0;
                atEndOfPrevious = 0;
                atBeginningOfCurrent = 0;
            }
            this.addBlanks(newStr, atEndOfPrevious);
            this.addCRLF(newStr, CRLFpairs);
            this.addBlanks(newStr, atBeginningOfCurrent);
            newStr.append(((EGLPrimeToken)this.tokens.get(ii)).getText());
            ++ii;
        }
        return newStr.toString();
    }

    public void addBlanks(StringBuffer str, int count) {
        if (count > 0) {
            int ii = 1;
            while (ii <= count) {
                str.append(" ");
                ++ii;
            }
        }
    }

    public void addCRLF(StringBuffer str, int count) {
        if (count > 0) {
            int ii = 1;
            while (ii <= count) {
                str.append("\r\n");
                ++ii;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public String toStringNoComments() {
        betweenTokens = 0;
        CRLFpairs = 0;
        atEndOfPrevious = 0;
        atBeginningOfCurrent = 0;
        newStr = new StringBuffer("");
        prevToken = null;
        ii = 0;
        ** GOTO lbl39
        {
            ++ii;
            do {
                if (ii < this.tokens.size() && ((EGLPrimeToken)this.tokens.get(ii)).getType() == 0x7FFFFFFF) continue block0;
                if (ii < this.tokens.size()) {
                    if (prevToken == null) {
                        this.addBlanks(newStr, ((EGLPrimeToken)this.tokens.get(ii)).getColumn() - 1);
                        newStr.append(((EGLPrimeToken)this.tokens.get(ii)).getText());
                        prevToken = (EGLPrimeToken)this.tokens.get(ii);
                    } else {
                        betweenTokens = ((EGLPrimeToken)this.tokens.get(ii)).getOffset() - prevToken.getOffset() - prevToken.getText().length();
                        if (betweenTokens > 0) {
                            CRLFpairs = ((EGLPrimeToken)this.tokens.get(ii)).getLine() - prevToken.getLine();
                            if (CRLFpairs > 0) {
                                atEndOfPrevious = betweenTokens - 2 * CRLFpairs - ((EGLPrimeToken)this.tokens.get(ii)).getColumn() + 1;
                                atBeginningOfCurrent = betweenTokens - 2 * CRLFpairs - atEndOfPrevious;
                            } else {
                                atEndOfPrevious = betweenTokens;
                                atBeginningOfCurrent = 0;
                            }
                        } else {
                            CRLFpairs = 0;
                            atEndOfPrevious = 0;
                            atBeginningOfCurrent = 0;
                        }
                        this.addBlanks(newStr, atEndOfPrevious);
                        this.addCRLF(newStr, CRLFpairs);
                        this.addBlanks(newStr, atBeginningOfCurrent);
                        newStr.append(((EGLPrimeToken)this.tokens.get(ii)).getText());
                        prevToken = (EGLPrimeToken)this.tokens.get(ii);
                    }
                }
                ++ii;
lbl39:
                // 2 sources

            } while (ii < this.tokens.size());
        }
        return newStr.toString();
    }

    public String toStringNoWhiteSpace() {
        StringBuffer newStr = new StringBuffer("");
        int ii = 0;
        while (ii < this.tokens.size()) {
            newStr.append(((EGLPrimeToken)this.tokens.get(ii)).getText());
            ++ii;
        }
        return newStr.toString();
    }
}

