/*
 * Decompiled with CFR 0.152.
 */
package eglx.persistence.sql;

import eglx.lang.AnyException;
import eglx.lang.EDictionary;
import eglx.persistence.sql.SQLException;
import eglx.persistence.sql.SQLWarning;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.edt.javart.RunUnit;
import org.eclipse.edt.javart.Runtime;
import org.eclipse.edt.javart.resources.RecoverableResource;
import org.eclipse.edt.javart.util.JavartUtil;

public class SQLDataSource
implements RecoverableResource {
    public static final int TRANSACTION_ISOLATION_NONE = 0;
    public static final int TRANSACTION_ISOLATION_READ_UNCOMMITTED = 1;
    public static final int TRANSACTION_ISOLATION_READ_COMMITTED = 2;
    public static final int TRANSACTION_ISOLATION_REPEATABLE_READ = 4;
    public static final int TRANSACTION_ISOLATION_SERIALIZABLE = 8;
    private PreparedStatement SetSchema = null;
    private Connection conn;
    private Map<String, List<Statement>> statements;
    private String connectionUrl;
    private Properties properties;

    public SQLDataSource(String connectionUrl) {
        this(connectionUrl, Runtime.getRunUnit());
    }

    public SQLDataSource(String connectionUrl, RunUnit ru) {
        this.connectionUrl = connectionUrl;
        this.statements = new HashMap<String, List<Statement>>();
        this.properties = new Properties();
        ru.registerResource(this);
    }

    public SQLDataSource(String connectionUrl, EDictionary properties) {
        this(connectionUrl);
        if (properties != null) {
            this.properties.putAll((Map<?, ?>)properties);
        }
    }

    public void close() throws SQLException {
        if (this.conn != null) {
            try {
                this.conn.close();
                this.conn = null;
            }
            catch (java.sql.SQLException e) {
                throw JavartUtil.makeEglException(e);
            }
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.conn == null) {
            try {
                this.conn = DriverManager.getConnection(this.connectionUrl, this.properties);
            }
            catch (java.sql.SQLException e) {
                throw JavartUtil.makeEglException(e);
            }
        }
        return this.conn;
    }

    @Override
    public void commit(RunUnit ru) throws AnyException {
        try {
            if (this.conn != null) {
                this.conn.commit();
            }
        }
        catch (java.sql.SQLException e) {
            throw JavartUtil.makeEglException(e);
        }
    }

    @Override
    public void rollback(RunUnit ru) throws AnyException {
        try {
            if (this.conn != null) {
                this.conn.rollback();
            }
        }
        catch (java.sql.SQLException e) {
            throw JavartUtil.makeEglException(e);
        }
    }

    @Override
    public void exit(RunUnit ru) throws AnyException {
        try {
            for (Map.Entry<String, List<Statement>> entry : this.statements.entrySet()) {
                for (Statement s : entry.getValue()) {
                    if (s == null) continue;
                    s.close();
                }
            }
            this.close();
            this.statements.clear();
            ru.getResourceManager().getResourceList().remove(this);
        }
        catch (java.sql.SQLException e) {
            throw JavartUtil.makeEglException(e);
        }
    }

    @Override
    public void transferCleanup(RunUnit ru, boolean toTransaction) throws AnyException {
        if (toTransaction) {
            try {
                for (Map.Entry<String, List<Statement>> entry : this.statements.entrySet()) {
                    for (Statement s : entry.getValue()) {
                        if (s == null) continue;
                        s.close();
                    }
                }
                this.close();
                this.statements.clear();
                ru.getResourceManager().getResourceList().remove(this);
            }
            catch (java.sql.SQLException e) {
                throw JavartUtil.makeEglException(e);
            }
        }
    }

    public void registerStatement(String typeSignature, int index, Statement stmt) {
        List<Statement> stmts = this.statements.get(typeSignature);
        if (stmts == null) {
            stmts = new ArrayList<Statement>();
            this.statements.put(typeSignature, stmts);
        }
        if (index >= stmts.size()) {
            int z = index - stmts.size();
            int i = 0;
            while (i <= z) {
                stmts.add(null);
                ++i;
            }
        }
        stmts.set(index, stmt);
    }

    public Statement getStatement(String typeSignature, Integer index) {
        List<Statement> stmts = this.statements.get(typeSignature);
        return stmts == null ? null : (index < stmts.size() ? stmts.get(index) : null);
    }

    public void setCurrentSchema(String schema) throws SQLException {
        try {
            if (this.SetSchema == null) {
                this.SetSchema = this.getConnection().prepareStatement("set schema ? ");
            }
            this.SetSchema.setString(1, schema);
            this.SetSchema.executeUpdate();
        }
        catch (java.sql.SQLException e) {
            throw JavartUtil.makeEglException(e);
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            return this.getConnection().getAutoCommit();
        }
        catch (java.sql.SQLException e) {
            throw JavartUtil.makeEglException(e);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this.getConnection().setAutoCommit(autoCommit);
        }
        catch (java.sql.SQLException e) {
            throw JavartUtil.makeEglException(e);
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            return this.getConnection().getTransactionIsolation();
        }
        catch (java.sql.SQLException e) {
            throw JavartUtil.makeEglException(e);
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
        try {
            this.getConnection().setTransactionIsolation(level);
        }
        catch (java.sql.SQLException e) {
            throw JavartUtil.makeEglException(e);
        }
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        try {
            return this.getConnection().getMetaData().supportsTransactionIsolationLevel(level);
        }
        catch (java.sql.SQLException e) {
            throw JavartUtil.makeEglException(e);
        }
    }

    public boolean isClosed() throws SQLException {
        try {
            if (this.conn != null) {
                return this.getConnection().isClosed();
            }
            return true;
        }
        catch (java.sql.SQLException e) {
            throw JavartUtil.makeEglException(e);
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            return this.getConnection().isReadOnly();
        }
        catch (java.sql.SQLException e) {
            throw JavartUtil.makeEglException(e);
        }
    }

    public boolean isValid(int timeout) throws SQLException {
        try {
            return this.getConnection().isValid(timeout);
        }
        catch (java.sql.SQLException e) {
            throw JavartUtil.makeEglException(e);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        java.sql.SQLWarning warning;
        block4: {
            if (this.conn == null) {
                return null;
            }
            try {
                warning = this.conn.getWarnings();
                if (warning != null) break block4;
                return null;
            }
            catch (java.sql.SQLException e) {
                throw JavartUtil.makeEglException(e);
            }
        }
        return (SQLWarning)JavartUtil.makeEglException(warning);
    }
}

