/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.resources;

import eglx.lang.AnyException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeSet;
import org.eclipse.edt.javart.EglExit;
import org.eclipse.edt.javart.Executable;
import org.eclipse.edt.javart.ExitProgram;
import org.eclipse.edt.javart.ExitRunUnit;
import org.eclipse.edt.javart.FatalProblem;
import org.eclipse.edt.javart.Program;
import org.eclipse.edt.javart.RunUnit;
import org.eclipse.edt.javart.Transfer;
import org.eclipse.edt.javart.resources.JavartProperties;
import org.eclipse.edt.javart.resources.JavartPropertiesFile;
import org.eclipse.edt.javart.resources.LocalizedText;
import org.eclipse.edt.javart.resources.Platform;
import org.eclipse.edt.javart.resources.RecoverableResource;
import org.eclipse.edt.javart.resources.ResourceManager;
import org.eclipse.edt.javart.resources.StartupInfo;
import org.eclipse.edt.javart.resources.Trace;
import org.eclipse.edt.javart.util.JavartUtil;

public abstract class RunUnitBase
implements RunUnit,
Serializable {
    private static final long serialVersionUID = 10L;
    public static final String VERSION = "0.7";
    private StartupInfo startupInfo;
    protected JavartProperties properties;
    protected Trace trace;
    protected LocalizedText localizedText;
    private transient ResourceManager resourceManager;
    private Executable currentExecutable;
    protected HashMap<String, Executable> libraries;
    private AnyException fatalError;
    private int returnCode;

    public RunUnitBase(StartupInfo startInfo) throws AnyException {
        this.startupInfo = startInfo;
        this.properties = startInfo.getProperties() != null ? startInfo.getProperties() : new JavartPropertiesFile(this.startupInfo.getPropertyFilePath());
        this.trace = new Trace(this.properties.get("egl.trace.type"), this.properties.get("egl.trace.device.option", "2"), this.properties.get("egl.trace.device.spec"));
        this.localizedText = new LocalizedText(this.properties);
        this.resourceManager = new ResourceManager();
        this.libraries = new HashMap();
        if (this.trace.traceIsOn()) {
            this.trace.put("*** " + new Date() + " ***");
            this.trace.put("*** " + this.localizedText.getDateFormatter().format(new Date()) + " ***");
            this.trace.put(" ");
            this.trace.put("RunUnit: " + startInfo.getRuName());
            this.trace.put("Version: 0.7");
            this.trace.put("System: " + Platform.SYSTEM_TYPE);
            this.trace.put(this.properties.getInfo());
            if (this.trace.traceIsOn(512)) {
                this.traceProperties();
            }
            this.trace.put(this.localizedText.getInfo());
            this.trace.put(this.getTrace().getInfo());
            this.trace.put("java.class.path: " + System.getProperty("java.class.path"));
            this.trace.put("java.library.path: " + System.getProperty("java.library.path"));
            this.trace.put(" ");
        }
    }

    @Override
    public StartupInfo getStartupInfo() {
        return this.startupInfo;
    }

    @Override
    public JavartProperties getProperties() {
        return this.properties;
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public void registerResource(RecoverableResource rs) {
        this.resourceManager.register(rs);
    }

    @Override
    public void unregisterResource(RecoverableResource rs) {
        this.resourceManager.unregister(rs);
    }

    @Override
    public void commit() throws AnyException {
        this.resourceManager.commit(this);
    }

    @Override
    public void rollback() throws AnyException {
        this.resourceManager.rollback(this);
    }

    @Override
    public void start(Program program) throws Exception {
        try {
            while (true) {
                try {
                    this.currentExecutable = program;
                    program.main();
                    this.endRunUnit(program);
                    return;
                }
                catch (Transfer trans) {
                    program = this.setupTransfer(trans);
                    continue;
                }
                break;
            }
        }
        catch (EglExit eglExit) {
            this.endRunUnit(program);
        }
        catch (Exception ex) {
            this.endRunUnit(program, ex);
        }
    }

    @Override
    public void endRunUnit(Executable program) throws Exception {
        if (this.trace.traceIsOn()) {
            this.trace.put("endRunUnit " + this.startupInfo.getRuName() + " (normal termination) with returnCode=" + this.returnCode);
        }
        try {
            this.commit();
            this.resourceManager.exit(this);
            this.trace.close();
            this.currentExecutable = null;
        }
        catch (Exception ex) {
            this.endRunUnit(program, ex);
        }
    }

    @Override
    public void endRunUnit(Executable program, Exception ex) throws Exception {
        this.returnCode = 693;
        if (this.trace.traceIsOn()) {
            this.trace.put("endRunUnit " + this.startupInfo.getRuName() + " (error termination) with returnCode=" + this.returnCode);
        }
        this.fatalError = JavartUtil.makeEglException(ex);
        String message = this.fatalError.getMessage();
        if (message.length() == 0) {
            message = this.fatalError.toString();
        }
        System.out.println(message);
        if (AnyException.STACK_TRACES) {
            ex.printStackTrace(System.out);
        }
        try {
            this.rollback();
        }
        catch (Exception exception) {}
        try {
            this.resourceManager.exit(this);
        }
        catch (Exception exception) {}
        this.trace.close();
        this.currentExecutable = null;
    }

    @Override
    public Executable loadLibrary(String name) throws AnyException {
        Executable library = this.libraries.get(name);
        if (library == null) {
            library = this.loadExecutable(name);
            this.libraries.put(name, library);
        }
        return library;
    }

    @Override
    public Executable loadExecutable(String name) throws AnyException {
        try {
            Class<?> pgmClass = Class.forName(name, true, this.getClass().getClassLoader());
            return (Executable)pgmClass.newInstance();
        }
        catch (Throwable ex) {
            if (ex instanceof InvocationTargetException) {
                ex = ((InvocationTargetException)ex).getTargetException();
            }
            FatalProblem problem = new FatalProblem();
            problem.initCause(ex);
            throw problem.fillInMessage("EGL0034E", ex);
        }
    }

    protected static String formatMessageInDefaultLocale(String id, Object[] inserts) {
        ResourceBundle bundle = ResourceBundle.getBundle("com.ibm.javart.messages.MessageBundle");
        String message = bundle.getString(id);
        MessageFormat mf = new MessageFormat(message);
        return mf.format(inserts);
    }

    private void traceProperties() {
        Properties props = this.properties.getProperties();
        if (props != null) {
            Enumeration<?> names = props.propertyNames();
            TreeSet keySet = new TreeSet();
            while (names.hasMoreElements()) {
                keySet.add(names.nextElement());
            }
            for (String key : keySet) {
                String val = props.getProperty(key);
                if (key.equals("egl.jdbc.default.database.user.password")) {
                    val = "?";
                }
                this.trace.put(" > " + key + '=' + val);
            }
        }
    }

    @Override
    public int getReturnCode() {
        return this.returnCode;
    }

    @Override
    public void setReturnCode(int rc) {
        this.returnCode = rc;
    }

    public AnyException getFatalError() {
        return this.fatalError;
    }

    @Override
    public LocalizedText getLocalizedText() {
        return this.localizedText;
    }

    @Override
    public abstract void switchLocale(Locale var1);

    public void exitProgram() throws ExitProgram {
        if (this.trace.traceIsOn()) {
            this.trace.put("Exit Program");
        }
        throw ExitProgram.getSingleton();
    }

    public void exitRunUnit() throws ExitRunUnit {
        if (this.trace.traceIsOn()) {
            this.trace.put("Exit RunUnit");
        }
        throw ExitRunUnit.getSingleton();
    }

    @Override
    public void transferCleanup(boolean toTransaction) {
        this.resourceManager.transferCleanup(this, toTransaction);
        if (toTransaction) {
            this.unloadLibraries();
        }
    }

    public void unloadLibraries() throws AnyException {
        this.libraries.clear();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        String noRollback = this.properties.get("org.eclipse.edt.noRollbackOnSerialize");
        if (noRollback == null) {
            noRollback = Boolean.getBoolean("org.eclipse.edt.noRollbackOnSerialize") ? "true" : "false";
            this.properties.put("org.eclipse.edt.noRollbackOnSerialize", noRollback);
        }
        out.defaultWriteObject();
        if (noRollback.equals("false")) {
            try {
                try {
                    this.resourceManager.rollback(this);
                }
                catch (AnyException je) {
                    throw new IOException(je.getMessage());
                }
            }
            finally {
                try {
                    this.resourceManager.exit(this);
                }
                catch (AnyException je) {
                    throw new IOException(je.getMessage());
                }
            }
            out.writeObject(this.resourceManager);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.resourceManager = "true".equals(this.properties.get("org.eclipse.edt.noRollbackOnSerialize")) ? new ResourceManager() : (ResourceManager)in.readObject();
    }

    @Override
    public Executable getActiveExecutable() throws AnyException {
        return this.currentExecutable;
    }

    @Override
    public void setActiveExecutable(Executable executable) {
        this.currentExecutable = executable;
    }

    private Program setupTransfer(Transfer trans) throws Exception {
        String oldName;
        String newName;
        if (this.newPropertiesNeeded(trans) && !(newName = JavartUtil.removePackageName(trans.name)).equals(oldName = this.currentExecutable._name())) {
            String newPropertiesFilePath = String.valueOf(trans.name.replace('.', '/')) + ".properties";
            this.properties = new JavartPropertiesFile(newPropertiesFilePath);
            this.trace = new Trace(this.properties.get("egl.trace.type"), this.properties.get("egl.trace.device.option", "2"), this.properties.get("egl.trace.device.spec"));
            this.localizedText = new LocalizedText(this.properties);
        }
        Program newProgram = (Program)this.loadExecutable(trans.name);
        if (trans.input != null && newProgram._inputRecord() != null) {
            newProgram._inputRecord().ezeCopy(trans.input);
        }
        return newProgram;
    }

    protected abstract boolean newPropertiesNeeded(Transfer var1);
}

