/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.ui.actions;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.ElseBlock;
import org.eclipse.edt.compiler.core.ast.EmptyStatement;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OnEventBlock;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.OtherwiseClause;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.core.ast.WhenClause;
import org.eclipse.edt.debug.core.breakpoints.EGLLineBreakpoint;
import org.eclipse.edt.debug.internal.ui.EDTDebugUIPlugin;
import org.eclipse.edt.ide.core.internal.model.document.EGLDocument;
import org.eclipse.edt.ide.ui.editor.IEGLEditor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class BreakpointUtils {
    private BreakpointUtils() {
    }

    public static ITextEditor getEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        return (ITextEditor)part.getAdapter(ITextEditor.class);
    }

    public static EGLLineBreakpoint eglLineBreakpointExists(IResource resource, int lineNumber) throws CoreException {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints("org.eclipse.edt.debug.ui.presentation.java");
        int i = 0;
        while (i < breakpoints.length) {
            EGLLineBreakpoint breakpoint;
            IMarker marker;
            if (breakpoints[i] instanceof EGLLineBreakpoint && (marker = (breakpoint = (EGLLineBreakpoint)breakpoints[i]).getMarker()) != null && marker.exists() && "org.eclipse.edt.debug.core.eglLineBreakpointMarker".equals(marker.getType()) && breakpoint.getLineNumber() == lineNumber && resource.equals((Object)marker.getResource())) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    public static boolean isBreakpointValidForStatement(Statement statement) {
        if (statement instanceof EmptyStatement) {
            return false;
        }
        if (statement instanceof FunctionDataDeclaration) {
            return ((FunctionDataDeclaration)statement).getInitializer() != null;
        }
        return true;
    }

    public static boolean isBreakpointValid(IEGLEditor editor, int line) {
        Statement statement = BreakpointUtils.getStatementNode(editor, line);
        if (statement != null) {
            return BreakpointUtils.isBreakpointValidForStatement(statement);
        }
        return false;
    }

    public static Statement getStatementNode(IEGLEditor editor, int line) {
        int docOffset;
        EGLDocument document = (EGLDocument)editor.getViewer().getDocument();
        if (document == null) {
            return null;
        }
        try {
            docOffset = document.getLineOffset(line);
            int lineEndOffset = docOffset + document.getLineLength(line);
            char thechar = document.getChar(docOffset);
            while ((thechar == ' ' || thechar == '\t') && docOffset <= lineEndOffset) {
                thechar = document.getChar(++docOffset);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            EDTDebugUIPlugin.log(e);
            return null;
        }
        Node node = document.getNewModelNodeAtOffset(docOffset);
        if (node == null) {
            return null;
        }
        final Node[] statementContainerNode = new Node[1];
        final List[] statements = new List[1];
        node.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(ElseBlock visitedNode) {
                statementContainerNode[0] = visitedNode;
                statements[0] = visitedNode.getStmts();
                return false;
            }

            public boolean visit(NestedFunction visitedNode) {
                statementContainerNode[0] = visitedNode;
                statements[0] = visitedNode.getStmts();
                return false;
            }

            public boolean visit(OnExceptionBlock visitedNode) {
                statementContainerNode[0] = visitedNode;
                statements[0] = visitedNode.getStmts();
                return false;
            }

            public boolean visit(OnEventBlock visitedNode) {
                statementContainerNode[0] = visitedNode;
                statements[0] = visitedNode.getStatements();
                return false;
            }

            public boolean visit(TopLevelFunction visitedNode) {
                statementContainerNode[0] = visitedNode;
                statements[0] = visitedNode.getStmts();
                return false;
            }

            public boolean visit(WhenClause visitedNode) {
                statementContainerNode[0] = visitedNode;
                statements[0] = visitedNode.getStmts();
                return false;
            }

            public boolean visit(OtherwiseClause visitedNode) {
                statementContainerNode[0] = visitedNode;
                statements[0] = visitedNode.getStatements();
                return false;
            }
        });
        if (statementContainerNode[0] == null) {
            while (node != null && !(node instanceof Statement)) {
                node = node.getParent();
            }
            return (Statement)node;
        }
        Statement statement = null;
        for (Node nodex : statements[0]) {
            if (!(nodex instanceof Statement)) continue;
            statement = (Statement)nodex;
            try {
                int statementLine = document.getLineOfOffset(statement.getOffset()) + 1;
                if (statementLine <= line || !BreakpointUtils.isBreakpointValidForStatement(statement)) continue;
                return statement;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                EDTDebugUIPlugin.log(e);
            }
        }
        return null;
    }
}

