/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.refactoring.IJavaElementMapper;
import org.eclipse.jdt.core.refactoring.RenameTypeArguments;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.TypeReferenceMatch;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringHandleTransplanter;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameLocalVariableProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameMethodProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameNonVirtualMethodProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameVirtualMethodProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenamingNameSuggestor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RippleMethodFinder2;
import org.eclipse.jdt.internal.corext.refactoring.rename.TextMatchUpdater;
import org.eclipse.jdt.internal.corext.refactoring.rename.TypeOccurrenceCollector;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ISimilarDeclarationUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.Changes;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameFinder;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.IResourceMapper;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.IParticipantDescriptorFilter;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameTypeProcessor
extends JavaRenameProcessor
implements ITextUpdating,
IReferenceUpdating,
IQualifiedNameUpdating,
ISimilarDeclarationUpdating,
IResourceMapper,
IJavaElementMapper {
    private static final String ATTRIBUTE_QUALIFIED = "qualified";
    private static final String ATTRIBUTE_TEXTUAL_MATCHES = "textual";
    private static final String ATTRIBUTE_PATTERNS = "patterns";
    private static final String ATTRIBUTE_SIMILAR_DECLARATIONS = "similarDeclarations";
    private static final String ATTRIBUTE_MATCHING_STRATEGY = "matchStrategy";
    private static final GroupCategorySet CATEGORY_TYPE_RENAME = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.refactoring.rename.renameType.type", RefactoringCoreMessages.RenameTypeProcessor_changeCategory_type, RefactoringCoreMessages.RenameTypeProcessor_changeCategory_type_description));
    private static final GroupCategorySet CATEGORY_METHOD_RENAME = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.refactoring.rename.renameType.method", RefactoringCoreMessages.RenameTypeProcessor_changeCategory_method, RefactoringCoreMessages.RenameTypeProcessor_changeCategory_method_description));
    private static final GroupCategorySet CATEGORY_FIELD_RENAME = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.refactoring.rename.renameType.field", RefactoringCoreMessages.RenameTypeProcessor_changeCategory_fields, RefactoringCoreMessages.RenameTypeProcessor_changeCategory_fields_description));
    private static final GroupCategorySet CATEGORY_LOCAL_RENAME = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.refactoring.rename.renameType.local", RefactoringCoreMessages.RenameTypeProcessor_changeCategory_local_variables, RefactoringCoreMessages.RenameTypeProcessor_changeCategory_local_variables_description));
    private IType fType;
    private SearchResultGroup[] fReferences;
    private TextChangeManager fChangeManager;
    private QualifiedNameSearchResult fQualifiedNameSearchResult;
    private boolean fUpdateReferences;
    private boolean fUpdateTextualMatches;
    private boolean fUpdateQualifiedNames;
    private String fFilePatterns;
    private boolean fUpdateSimilarElements;
    private Map<IJavaElement, String> fFinalSimilarElementToName = null;
    private int fRenamingStrategy;
    private LinkedHashMap<IJavaElement, String> fPreloadedElementToName = null;
    private Map<IJavaElement, Boolean> fPreloadedElementToSelection = null;
    private LinkedHashMap<IJavaElement, String> fPreloadedElementToNameDefault = null;
    private String fCachedNewName = null;
    private boolean fCachedRenameSimilarElements = false;
    private int fCachedRenamingStrategy = -1;
    private RefactoringStatus fCachedRefactoringStatus = null;

    public RenameTypeProcessor(IType type) {
        this.fType = type;
        if (type != null) {
            this.setNewElementName(type.getElementName());
        }
        this.fUpdateReferences = true;
        this.fUpdateTextualMatches = false;
        this.fUpdateSimilarElements = false;
        this.fRenamingStrategy = 1;
    }

    public RenameTypeProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null);
        status.merge(this.initialize(arguments));
    }

    public IType getType() {
        return this.fType;
    }

    public String getIdentifier() {
        return "org.eclipse.jdt.ui.renameTypeProcessor";
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fType);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameTypeRefactoring_name;
    }

    @Override
    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fType);
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.fType};
    }

    @Override
    protected RenameModifications computeRenameModifications() {
        RenameModifications result = new RenameModifications();
        result.rename(this.fType, new RenameTypeArguments(this.getNewElementName(), this.getUpdateReferences(), this.getUpdateSimilarDeclarations(), this.getSimilarElements()), this.createParticipantDescriptorFilter());
        if (this.isPrimaryType()) {
            ICompilationUnit cu = this.fType.getCompilationUnit();
            String newCUName = this.getNewCompilationUnit().getElementName();
            result.rename(cu, new RenameArguments(newCUName, this.getUpdateReferences()));
        }
        return result;
    }

    private boolean isPrimaryType() {
        String cuName = this.fType.getCompilationUnit().getElementName();
        String typeName = this.fType.getElementName();
        return Checks.isTopLevel(this.fType) && JavaCore.removeJavaLikeExtension((String)cuName).equals(typeName);
    }

    @Override
    public String getCurrentElementName() {
        return this.fType.getElementName();
    }

    @Override
    public String getCurrentElementQualifier() {
        return JavaModelUtil.getTypeContainerName(this.fType);
    }

    @Override
    public RefactoringStatus checkNewElementName(String newName) {
        Assert.isNotNull((Object)newName, (String)"new name");
        RefactoringStatus result = Checks.checkTypeName(newName, (IJavaElement)this.fType);
        if (Checks.isAlreadyNamed((IJavaElement)this.fType, newName)) {
            result.addFatalError(RefactoringCoreMessages.RenameTypeRefactoring_choose_another_name);
        }
        return result;
    }

    @Override
    public Object getNewElement() {
        if (Checks.isTopLevel(this.fType)) {
            return this.getNewCompilationUnit().getType(this.getNewElementName());
        }
        return this.fType.getDeclaringType().getType(this.getNewElementName());
    }

    private ICompilationUnit getNewCompilationUnit() {
        ICompilationUnit cu = this.fType.getCompilationUnit();
        if (this.isPrimaryType()) {
            IPackageFragment parent = this.fType.getPackageFragment();
            String renamedCUName = JavaModelUtil.getRenamedCUName(cu, this.getNewElementName());
            return parent.getCompilationUnit(renamedCUName);
        }
        return cu;
    }

    protected RenameArguments createRenameArguments() {
        return new RenameTypeArguments(this.getNewElementName(), this.getUpdateReferences(), this.getUpdateSimilarDeclarations(), this.getSimilarElements());
    }

    protected IParticipantDescriptorFilter createParticipantDescriptorFilter() {
        if (!this.getUpdateSimilarDeclarations()) {
            return null;
        }
        return new ParticipantDescriptorFilter();
    }

    @Override
    protected IFile[] getChangedFiles() throws CoreException {
        ArrayList<IFile> result = new ArrayList<IFile>();
        result.addAll(Arrays.asList(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits())));
        if (this.fQualifiedNameSearchResult != null) {
            result.addAll(Arrays.asList(this.fQualifiedNameSearchResult.getAllFiles()));
        }
        if (this.willRenameCU()) {
            result.add(ResourceUtil.getFile(this.fType.getCompilationUnit()));
        }
        return result.toArray(new IFile[result.size()]);
    }

    @Override
    public int getSaveMode() {
        return 4;
    }

    @Override
    public boolean canEnableTextUpdating() {
        return true;
    }

    @Override
    public boolean getUpdateTextualMatches() {
        return this.fUpdateTextualMatches;
    }

    @Override
    public void setUpdateTextualMatches(boolean update) {
        this.fUpdateTextualMatches = update;
    }

    @Override
    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    @Override
    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    @Override
    public boolean canEnableQualifiedNameUpdating() {
        return !this.fType.getPackageFragment().isDefaultPackage() && !(this.fType.getParent() instanceof IType);
    }

    @Override
    public boolean getUpdateQualifiedNames() {
        return this.fUpdateQualifiedNames;
    }

    @Override
    public void setUpdateQualifiedNames(boolean update) {
        this.fUpdateQualifiedNames = update;
    }

    @Override
    public String getFilePatterns() {
        return this.fFilePatterns;
    }

    @Override
    public void setFilePatterns(String patterns) {
        Assert.isNotNull((Object)patterns);
        this.fFilePatterns = patterns;
    }

    @Override
    public boolean canEnableSimilarDeclarationUpdating() {
        String property;
        IProduct product = Platform.getProduct();
        return product == null || !"false".equalsIgnoreCase(property = product.getProperty("org.eclipse.jdt.ui.refactoring.handlesSimilarDeclarations"));
    }

    @Override
    public void setUpdateSimilarDeclarations(boolean update) {
        this.fUpdateSimilarElements = update;
    }

    @Override
    public boolean getUpdateSimilarDeclarations() {
        return this.fUpdateSimilarElements;
    }

    @Override
    public int getMatchStrategy() {
        return this.fRenamingStrategy;
    }

    @Override
    public void setMatchStrategy(int selectedStrategy) {
        this.fRenamingStrategy = selectedStrategy;
    }

    public IJavaElement[] getSimilarElements() {
        if (this.fFinalSimilarElementToName == null) {
            return null;
        }
        Set<IJavaElement> keys = this.fFinalSimilarElementToName.keySet();
        return keys.toArray(new IJavaElement[keys.size()]);
    }

    public IResource getRefactoredResource(IResource element) {
        if (element instanceof IFile && Checks.isTopLevel(this.fType) && element.equals((Object)this.fType.getResource())) {
            return this.getNewCompilationUnit().getResource();
        }
        return element;
    }

    public IJavaElement getRefactoredJavaElement(IJavaElement element) {
        if (element instanceof ICompilationUnit) {
            if (Checks.isTopLevel(this.fType) && element.equals(this.fType.getCompilationUnit())) {
                return this.getNewCompilationUnit();
            }
        } else if (element instanceof IMember) {
            IType newType = (IType)this.getNewElement();
            RefactoringHandleTransplanter transplanter = new RefactoringHandleTransplanter(this.fType, newType, this.fFinalSimilarElementToName);
            return transplanter.transplantHandle((IMember)element);
        }
        return element;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        IType primary = (IType)this.fType.getPrimaryElement();
        if (primary == null || !primary.exists()) {
            String qualifiedTypeName = JavaElementLabels.getElementLabel((IJavaElement)this.fType, 65536L);
            String message = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_does_not_exist, new String[]{BasicElementLabels.getJavaElementName(qualifiedTypeName), BasicElementLabels.getFileName((ITypeRoot)this.fType.getCompilationUnit())});
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        this.fType = primary;
        return Checks.checkIfCuBroken((IMember)this.fType);
    }

    @Override
    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        Assert.isNotNull((Object)this.fType, (String)"type");
        Assert.isNotNull((Object)this.getNewElementName(), (String)"newName");
        RefactoringStatus result = new RefactoringStatus();
        int referenceSearchTicks = this.fUpdateReferences || this.fUpdateSimilarElements ? 15 : 0;
        int affectedCusTicks = this.fUpdateReferences || this.fUpdateSimilarElements ? 10 : 1;
        int similarElementTicks = this.fUpdateSimilarElements ? 85 : 0;
        int createChangeTicks = 5;
        int qualifiedNamesTicks = this.fUpdateQualifiedNames ? 50 : 0;
        try {
            pm.beginTask("", 12 + referenceSearchTicks + affectedCusTicks + similarElementTicks + createChangeTicks + qualifiedNamesTicks);
            pm.setTaskName(RefactoringCoreMessages.RenameTypeRefactoring_checking);
            this.fChangeManager = new TextChangeManager(true);
            result.merge(this.checkNewElementName(this.getNewElementName()));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(Checks.checkIfCuBroken((IMember)this.fType));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            result.merge(this.checkTypesInCompilationUnit());
            pm.worked(1);
            result.merge(this.checkForMethodsWithConstructorNames());
            pm.worked(1);
            result.merge(this.checkImportedTypes());
            pm.worked(1);
            if (Checks.isTopLevel(this.fType) && JdtFlags.isPublic((IMember)this.fType)) {
                result.merge(Checks.checkCompilationUnitNewName(this.fType.getCompilationUnit(), this.getNewElementName()));
            }
            pm.worked(1);
            if (this.isPrimaryType()) {
                result.merge(this.checkNewPathValidity());
            }
            pm.worked(1);
            result.merge(this.checkEnclosingTypes());
            pm.worked(1);
            result.merge(this.checkEnclosedTypes());
            pm.worked(1);
            result.merge(this.checkTypesInPackage());
            pm.worked(1);
            result.merge(this.checkTypesImportedInCu());
            pm.worked(1);
            result.merge(Checks.checkForMainAndNativeMethods(this.fType));
            pm.worked(1);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.analyseEnclosedTypes());
            pm.worked(1);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (this.fUpdateReferences || this.fUpdateSimilarElements) {
                pm.setTaskName(RefactoringCoreMessages.RenameTypeRefactoring_searching);
                result.merge(this.initializeReferences((IProgressMonitor)new SubProgressMonitor(pm, referenceSearchTicks)));
            } else {
                this.fReferences = new SearchResultGroup[0];
            }
            pm.setTaskName(RefactoringCoreMessages.RenameTypeRefactoring_checking);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (this.fUpdateReferences || this.fUpdateSimilarElements) {
                result.merge(this.analyzeAffectedCompilationUnits((IProgressMonitor)new SubProgressMonitor(pm, affectedCusTicks)));
            } else {
                Checks.checkCompileErrorsInAffectedFile(result, this.fType.getResource());
                pm.worked(affectedCusTicks);
            }
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (this.fUpdateSimilarElements) {
                result.merge(this.initializeSimilarElementsRenameProcessors((IProgressMonitor)new SubProgressMonitor(pm, similarElementTicks), context));
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
            }
            this.createChanges((IProgressMonitor)new SubProgressMonitor(pm, createChangeTicks));
            if (this.fUpdateQualifiedNames) {
                this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(pm, qualifiedNamesTicks));
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus initializeReferences(IProgressMonitor monitor) throws JavaModelException, OperationCanceledException {
        Assert.isNotNull((Object)this.fType);
        Assert.isNotNull((Object)this.getNewElementName());
        if (this.fReferences != null && this.getNewElementName().equals(this.fCachedNewName) && this.fCachedRenameSimilarElements == this.getUpdateSimilarDeclarations() && this.fCachedRenamingStrategy == this.fRenamingStrategy) {
            return this.fCachedRefactoringStatus;
        }
        this.fCachedNewName = this.getNewElementName();
        this.fCachedRenameSimilarElements = this.fUpdateSimilarElements;
        this.fCachedRenamingStrategy = this.fRenamingStrategy;
        this.fCachedRefactoringStatus = new RefactoringStatus();
        try {
            SearchPattern pattern = SearchPattern.createPattern((IJavaElement)this.fType, (int)2, (int)24);
            String binaryRefsDescription = Messages.format(RefactoringCoreMessages.ReferencesInBinaryContext_ref_in_binaries_description, BasicElementLabels.getJavaElementName(this.fType.getElementName()));
            ReferencesInBinaryContext binaryRefs = new ReferencesInBinaryContext(binaryRefsDescription);
            this.fReferences = RefactoringSearchEngine.search(pattern, RefactoringScopeFactory.create((IJavaElement)this.fType, true, false), new TypeOccurrenceCollector(this.fType, binaryRefs), monitor, this.fCachedRefactoringStatus);
            binaryRefs.addErrorIfNecessary(this.fCachedRefactoringStatus);
            this.fReferences = Checks.excludeCompilationUnits(this.fReferences, this.fCachedRefactoringStatus);
            this.fPreloadedElementToName = new LinkedHashMap();
            this.fPreloadedElementToSelection = new HashMap<IJavaElement, Boolean>();
            String unQualifiedTypeName = this.fType.getElementName();
            monitor.beginTask("", this.fReferences.length);
            if (this.getUpdateSimilarDeclarations()) {
                RenamingNameSuggestor sugg = new RenamingNameSuggestor(this.fRenamingStrategy);
                int i = 0;
                while (i < this.fReferences.length) {
                    ICompilationUnit cu = this.fReferences[i].getCompilationUnit();
                    if (cu != null) {
                        SearchMatch[] results = this.fReferences[i].getSearchResults();
                        int j = 0;
                        while (j < results.length) {
                            if (results[j] instanceof TypeReferenceMatch) {
                                IJavaElement[] others;
                                TypeReferenceMatch match = (TypeReferenceMatch)results[j];
                                ArrayList<IJavaElement> matches = new ArrayList<IJavaElement>();
                                if (match.getLocalElement() != null) {
                                    if (match.getLocalElement() instanceof ILocalVariable) {
                                        matches.add(match.getLocalElement());
                                    }
                                } else {
                                    matches.add((IJavaElement)match.getElement());
                                }
                                if ((others = match.getOtherElements()) != null) {
                                    matches.addAll(Arrays.asList(others));
                                }
                                for (IJavaElement element : matches) {
                                    boolean isParameter;
                                    if (!(element instanceof IMethod) && !(element instanceof IField) && !(element instanceof ILocalVariable) || !this.isInDeclaredType(match.getOffset(), element)) continue;
                                    if (element instanceof IField) {
                                        IField currentField = (IField)element;
                                        String newFieldName = sugg.suggestNewFieldName(currentField.getJavaProject(), currentField.getElementName(), Flags.isStatic((int)currentField.getFlags()), unQualifiedTypeName, this.getNewElementName());
                                        if (newFieldName == null) continue;
                                        this.fPreloadedElementToName.put((IJavaElement)currentField, newFieldName);
                                        continue;
                                    }
                                    if (element instanceof IMethod) {
                                        IMethod currentMethod = (IMethod)element;
                                        this.addMethodRename(unQualifiedTypeName, sugg, currentMethod);
                                        continue;
                                    }
                                    if (!(element instanceof ILocalVariable)) continue;
                                    ILocalVariable currentLocal = (ILocalVariable)element;
                                    if (currentLocal.isParameter()) {
                                        this.addMethodRename(unQualifiedTypeName, sugg, (IMethod)currentLocal.getParent());
                                        isParameter = true;
                                    } else {
                                        isParameter = false;
                                    }
                                    String newLocalName = sugg.suggestNewLocalName(currentLocal.getJavaProject(), currentLocal.getElementName(), isParameter, unQualifiedTypeName, this.getNewElementName());
                                    if (newLocalName == null) continue;
                                    this.fPreloadedElementToName.put((IJavaElement)currentLocal, newLocalName);
                                }
                            }
                            ++j;
                        }
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                    }
                    ++i;
                }
            }
            for (IJavaElement element : this.fPreloadedElementToName.keySet()) {
                this.fPreloadedElementToSelection.put(element, Boolean.TRUE);
            }
            this.fPreloadedElementToNameDefault = (LinkedHashMap)this.fPreloadedElementToName.clone();
        }
        catch (OperationCanceledException operationCanceledException) {
            this.fReferences = null;
            this.fPreloadedElementToName = null;
            throw new OperationCanceledException();
        }
        return this.fCachedRefactoringStatus;
    }

    private boolean isInDeclaredType(int matchOffset, IJavaElement parentElement) throws JavaModelException {
        if (parentElement != null) {
            int enclosingNameOffset = 0;
            if (parentElement instanceof IMethod || parentElement instanceof IField) {
                enclosingNameOffset = ((IMember)parentElement).getNameRange().getOffset();
            } else if (parentElement instanceof ILocalVariable) {
                enclosingNameOffset = ((ILocalVariable)parentElement).getNameRange().getOffset();
            }
            return matchOffset < enclosingNameOffset;
        }
        return false;
    }

    private void addMethodRename(String unQualifiedTypeName, RenamingNameSuggestor sugg, IMethod currentMethod) throws JavaModelException {
        String newMethodName;
        if (!currentMethod.isConstructor() && (newMethodName = sugg.suggestNewMethodName(currentMethod.getElementName(), unQualifiedTypeName, this.getNewElementName())) != null) {
            this.fPreloadedElementToName.put((IJavaElement)currentMethod, newMethodName);
        }
    }

    private RefactoringStatus checkNewPathValidity() {
        IContainer c = this.fType.getCompilationUnit().getResource().getParent();
        String notRename = RefactoringCoreMessages.RenameTypeRefactoring_will_not_rename;
        IStatus status = c.getWorkspace().validateName(this.getNewElementName(), 1);
        if (status.getSeverity() == 4) {
            return RefactoringStatus.createWarningStatus((String)(String.valueOf(status.getMessage()) + ". " + notRename));
        }
        status = c.getWorkspace().validatePath(this.createNewPath(this.getNewElementName()), 1);
        if (status.getSeverity() == 4) {
            return RefactoringStatus.createWarningStatus((String)(String.valueOf(status.getMessage()) + ". " + notRename));
        }
        return new RefactoringStatus();
    }

    private String createNewPath(String newName) {
        return this.fType.getCompilationUnit().getResource().getFullPath().removeLastSegments(1).append(newName).toString();
    }

    private RefactoringStatus checkTypesImportedInCu() throws CoreException {
        IImportDeclaration imp = RenameTypeProcessor.getImportedType(this.fType.getCompilationUnit(), this.getNewElementName());
        if (imp == null) {
            return null;
        }
        String msg = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_imported, new Object[]{this.getNewElementLabel(), BasicElementLabels.getPathLabel(this.fType.getCompilationUnit().getResource().getFullPath(), false)});
        IJavaElement grandParent = imp.getParent().getParent();
        if (grandParent instanceof ICompilationUnit) {
            return RefactoringStatus.createErrorStatus((String)msg, (RefactoringStatusContext)JavaStatusContext.create(imp));
        }
        return null;
    }

    private RefactoringStatus checkTypesInPackage() throws CoreException {
        IType type = Checks.findTypeInPackage(this.fType.getPackageFragment(), this.getNewElementName());
        if (type == null || !type.exists()) {
            return null;
        }
        String msg = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_exists, new String[]{this.getNewElementLabel(), JavaElementLabels.getElementLabel((IJavaElement)this.fType.getPackageFragment(), JavaElementLabels.ALL_DEFAULT)});
        return RefactoringStatus.createErrorStatus((String)msg, (RefactoringStatusContext)JavaStatusContext.create((IMember)type));
    }

    private RefactoringStatus checkEnclosedTypes() throws CoreException {
        IType enclosedType = RenameTypeProcessor.findEnclosedType(this.fType, this.getNewElementName());
        if (enclosedType == null) {
            return null;
        }
        String msg = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_encloses, new String[]{BasicElementLabels.getJavaElementName(this.fType.getFullyQualifiedName('.')), this.getNewElementLabel()});
        return RefactoringStatus.createErrorStatus((String)msg, (RefactoringStatusContext)JavaStatusContext.create((IMember)enclosedType));
    }

    private RefactoringStatus checkEnclosingTypes() {
        IType enclosingType = RenameTypeProcessor.findEnclosingType(this.fType, this.getNewElementName());
        if (enclosingType == null) {
            return null;
        }
        String msg = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_enclosed, new String[]{BasicElementLabels.getJavaElementName(this.fType.getFullyQualifiedName('.')), this.getNewElementLabel()});
        return RefactoringStatus.createErrorStatus((String)msg, (RefactoringStatusContext)JavaStatusContext.create((IMember)enclosingType));
    }

    private String getNewElementLabel() {
        return BasicElementLabels.getJavaElementName(this.getNewElementName());
    }

    private static IType findEnclosedType(IType type, String newName) throws CoreException {
        IType[] enclosedTypes = type.getTypes();
        int i = 0;
        while (i < enclosedTypes.length) {
            if (newName.equals(enclosedTypes[i].getElementName()) || RenameTypeProcessor.findEnclosedType(enclosedTypes[i], newName) != null) {
                return enclosedTypes[i];
            }
            ++i;
        }
        return null;
    }

    private static IType findEnclosingType(IType type, String newName) {
        IType enclosing = type.getDeclaringType();
        while (enclosing != null) {
            if (newName.equals(enclosing.getElementName())) {
                return enclosing;
            }
            enclosing = enclosing.getDeclaringType();
        }
        return null;
    }

    private static IImportDeclaration getImportedType(ICompilationUnit cu, String typeName) throws CoreException {
        IImportDeclaration[] imports = cu.getImports();
        String dotTypeName = "." + typeName;
        int i = 0;
        while (i < imports.length) {
            if (imports[i].getElementName().endsWith(dotTypeName)) {
                return imports[i];
            }
            ++i;
        }
        return null;
    }

    private RefactoringStatus checkForMethodsWithConstructorNames() throws CoreException {
        IMethod[] methods = this.fType.getMethods();
        int i = 0;
        while (i < methods.length) {
            RefactoringStatus check;
            if (!methods[i].isConstructor() && (check = Checks.checkIfConstructorName(methods[i], methods[i].getElementName(), this.getNewElementName())) != null) {
                return check;
            }
            ++i;
        }
        return null;
    }

    private RefactoringStatus checkImportedTypes() throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IImportDeclaration[] imports = this.fType.getCompilationUnit().getImports();
        int i = 0;
        while (i < imports.length) {
            this.analyzeImportDeclaration(imports[i], result);
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkTypesInCompilationUnit() {
        IType siblingType;
        RefactoringStatus result = new RefactoringStatus();
        if (!Checks.isTopLevel(this.fType) && (siblingType = this.fType.getDeclaringType().getType(this.getNewElementName())).exists()) {
            String msg = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_member_type_exists, new String[]{this.getNewElementLabel(), BasicElementLabels.getJavaElementName(this.fType.getDeclaringType().getFullyQualifiedName('.'))});
            result.addError(msg, JavaStatusContext.create((IMember)siblingType));
        }
        return result;
    }

    private RefactoringStatus analyseEnclosedTypes() throws CoreException {
        final ISourceRange typeRange = this.fType.getSourceRange();
        final RefactoringStatus result = new RefactoringStatus();
        CompilationUnit cuNode = new RefactoringASTParser(4).parse((ITypeRoot)this.fType.getCompilationUnit(), false);
        cuNode.accept(new ASTVisitor(){

            public boolean visit(TypeDeclaration node) {
                if (node.getStartPosition() <= typeRange.getOffset()) {
                    return true;
                }
                if (node.getStartPosition() > typeRange.getOffset() + typeRange.getLength()) {
                    return true;
                }
                if (RenameTypeProcessor.this.getNewElementName().equals(node.getName().getIdentifier())) {
                    RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)RenameTypeProcessor.this.fType.getCompilationUnit(), (ASTNode)node);
                    String msg = null;
                    if (node.isLocalTypeDeclaration()) {
                        msg = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_local_type, new String[]{JavaElementUtil.createSignature((IMember)RenameTypeProcessor.this.fType), RenameTypeProcessor.this.getNewElementLabel()});
                    } else if (node.isMemberTypeDeclaration()) {
                        msg = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_member_type, new String[]{JavaElementUtil.createSignature((IMember)RenameTypeProcessor.this.fType), RenameTypeProcessor.this.getNewElementLabel()});
                    }
                    if (msg != null) {
                        result.addError(msg, context);
                    }
                }
                MethodDeclaration[] methods = node.getMethods();
                int i = 0;
                while (i < methods.length) {
                    if (Modifier.isNative((int)methods[i].getModifiers())) {
                        RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)RenameTypeProcessor.this.fType.getCompilationUnit(), (ASTNode)methods[i]);
                        String msg = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_enclosed_type_native, BasicElementLabels.getJavaElementName(node.getName().getIdentifier()));
                        result.addWarning(msg, context);
                    }
                    ++i;
                }
                return true;
            }
        });
        return result;
    }

    private static ICompilationUnit getCompilationUnit(IImportDeclaration imp) {
        return (ICompilationUnit)imp.getParent().getParent();
    }

    private void analyzeImportedTypes(IType[] types, RefactoringStatus result, IImportDeclaration imp) throws CoreException {
        int i = 0;
        while (i < types.length) {
            if (JdtFlags.isPublic((IMember)types[i]) && types[i].getElementName().equals(this.getNewElementName())) {
                String msg = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_name_conflict1, new Object[]{JavaElementLabels.getElementLabel((IJavaElement)types[i], JavaElementLabels.ALL_FULLY_QUALIFIED), BasicElementLabels.getPathLabel(RenameTypeProcessor.getCompilationUnit(imp).getPath(), false)});
                result.addError(msg, JavaStatusContext.create(imp));
            }
            ++i;
        }
    }

    private static IJavaElement convertFromImportDeclaration(IImportDeclaration declaration) throws CoreException {
        if (declaration.isOnDemand()) {
            String packageName = declaration.getElementName().substring(0, declaration.getElementName().length() - 2);
            return JavaModelUtil.findTypeContainer(declaration.getJavaProject(), packageName);
        }
        return JavaModelUtil.findTypeContainer(declaration.getJavaProject(), declaration.getElementName());
    }

    private void analyzeImportDeclaration(IImportDeclaration imp, RefactoringStatus result) throws CoreException {
        if (!imp.isOnDemand()) {
            return;
        }
        IJavaElement imported = RenameTypeProcessor.convertFromImportDeclaration(imp);
        if (imported == null) {
            return;
        }
        if (imported instanceof IPackageFragment) {
            ICompilationUnit[] cus = ((IPackageFragment)imported).getCompilationUnits();
            int i = 0;
            while (i < cus.length) {
                this.analyzeImportedTypes(cus[i].getTypes(), result, imp);
                ++i;
            }
        } else {
            this.analyzeImportedTypes(((IType)imported).getTypes(), result, imp);
        }
    }

    private RefactoringStatus analyzeAffectedCompilationUnits(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(Checks.checkCompileErrorsInAffectedFiles(this.fReferences, this.fType.getResource()));
        pm.beginTask("", this.fReferences.length);
        result.merge(this.checkConflictingTypes(pm));
        return result;
    }

    private RefactoringStatus checkConflictingTypes(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)this.fType);
        SearchPattern pattern = SearchPattern.createPattern((String)this.getNewElementName(), (int)0, (int)3, (int)24);
        ICompilationUnit[] cusWithReferencesToConflictingTypes = RefactoringSearchEngine.findAffectedCompilationUnits(pattern, scope, pm, result);
        if (cusWithReferencesToConflictingTypes.length == 0) {
            return result;
        }
        ICompilationUnit[] cusWithReferencesToRenamedType = RenameTypeProcessor.getCus(this.fReferences);
        ICompilationUnit[] intersection = RenameTypeProcessor.isIntersectionEmpty(cusWithReferencesToRenamedType, cusWithReferencesToConflictingTypes);
        if (intersection.length == 0) {
            return result;
        }
        int i = 0;
        while (i < intersection.length) {
            RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)intersection[i]);
            String message = Messages.format(RefactoringCoreMessages.RenameTypeRefactoring_another_type, new String[]{this.getNewElementLabel(), BasicElementLabels.getFileName((ITypeRoot)intersection[i])});
            result.addError(message, context);
            ++i;
        }
        return result;
    }

    private static ICompilationUnit[] isIntersectionEmpty(ICompilationUnit[] a1, ICompilationUnit[] a2) {
        HashSet<ICompilationUnit> set1 = new HashSet<ICompilationUnit>(Arrays.asList(a1));
        HashSet<ICompilationUnit> set2 = new HashSet<ICompilationUnit>(Arrays.asList(a2));
        set1.retainAll(set2);
        return set1.toArray(new ICompilationUnit[set1.size()]);
    }

    private static ICompilationUnit[] getCus(SearchResultGroup[] searchResultGroups) {
        ArrayList<ICompilationUnit> cus = new ArrayList<ICompilationUnit>(searchResultGroups.length);
        int i = 0;
        while (i < searchResultGroups.length) {
            ICompilationUnit cu = searchResultGroups[i].getCompilationUnit();
            if (cu != null) {
                cus.add(cu);
            }
            ++i;
        }
        return cus.toArray(new ICompilationUnit[cus.size()]);
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        try {
            TextChange textChange;
            monitor.beginTask(RefactoringCoreMessages.RenameTypeRefactoring_creating_change, 4);
            String project = null;
            IJavaProject javaProject = this.fType.getJavaProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 589826;
            try {
                if (!Flags.isPrivate((int)this.fType.getFlags())) {
                    flags |= 4;
                }
                if (this.fType.isAnonymous() || this.fType.isLocal()) {
                    flags |= 0x40000;
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
            String description = Messages.format(RefactoringCoreMessages.RenameTypeProcessor_descriptor_description_short, BasicElementLabels.getJavaElementName(this.fType.getElementName()));
            String header = Messages.format(RefactoringCoreMessages.RenameTypeProcessor_descriptor_description, new String[]{JavaElementLabels.getElementLabel((IJavaElement)this.fType, JavaElementLabels.ALL_FULLY_QUALIFIED), this.getNewElementLabel()});
            String comment = new JDTRefactoringDescriptorComment(project, this, header).asString();
            RenameJavaElementDescriptor descriptor = RefactoringSignatureDescriptorFactory.createRenameJavaElementDescriptor((String)"org.eclipse.jdt.ui.rename.type");
            descriptor.setProject(project);
            descriptor.setDescription(description);
            descriptor.setComment(comment);
            descriptor.setFlags(flags);
            descriptor.setJavaElement((IJavaElement)this.fType);
            descriptor.setNewName(this.getNewElementName());
            descriptor.setUpdateQualifiedNames(this.fUpdateQualifiedNames);
            descriptor.setUpdateTextualOccurrences(this.fUpdateTextualMatches);
            descriptor.setUpdateReferences(this.fUpdateReferences);
            if (this.fUpdateQualifiedNames && this.fFilePatterns != null && !"".equals(this.fFilePatterns)) {
                descriptor.setFileNamePatterns(this.fFilePatterns);
            }
            descriptor.setUpdateSimilarDeclarations(this.fUpdateSimilarElements);
            descriptor.setMatchStrategy(this.fRenamingStrategy);
            DynamicValidationRefactoringChange result = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)descriptor, RefactoringCoreMessages.RenameTypeProcessor_change_name);
            if (this.fChangeManager.containsChangesIn(this.fType.getCompilationUnit()) && (textChange = this.fChangeManager.get(this.fType.getCompilationUnit())) instanceof TextFileChange) {
                ((TextFileChange)textChange).setSaveMode(2);
            }
            result.addAll((Change[])this.fChangeManager.getAllChanges());
            if (this.willRenameCU()) {
                IResource resource = this.fType.getCompilationUnit().getResource();
                if (resource != null && resource.isLinked()) {
                    String ext = resource.getFileExtension();
                    String renamedResourceName = ext == null ? this.getNewElementName() : String.valueOf(this.getNewElementName()) + '.' + ext;
                    result.add((Change)new RenameResourceChange(this.fType.getCompilationUnit().getPath(), renamedResourceName));
                } else {
                    String renamedCUName = JavaModelUtil.getRenamedCUName(this.fType.getCompilationUnit(), this.getNewElementName());
                    result.add((Change)new RenameCompilationUnitChange(this.fType.getCompilationUnit(), renamedCUName));
                }
            }
            monitor.worked(1);
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = result;
            return dynamicValidationRefactoringChange;
        }
        finally {
            this.fChangeManager = null;
        }
    }

    public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
        if (this.fQualifiedNameSearchResult != null) {
            try {
                Change change = this.fQualifiedNameSearchResult.getSingleChange(Changes.getModifiedFiles(participantChanges));
                return change;
            }
            finally {
                this.fQualifiedNameSearchResult = null;
            }
        }
        return null;
    }

    private boolean willRenameCU() {
        String name = JavaCore.removeJavaLikeExtension((String)this.fType.getCompilationUnit().getElementName());
        if (!Checks.isTopLevel(this.fType) || !name.equals(this.fType.getElementName())) {
            return false;
        }
        if (!this.checkNewPathValidity().isOK()) {
            return false;
        }
        return Checks.checkCompilationUnitNewName(this.fType.getCompilationUnit(), this.getNewElementName()).isOK();
    }

    private void createChanges(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 12);
            pm.setTaskName(RefactoringCoreMessages.RenameTypeProcessor_creating_changes);
            if (this.fUpdateReferences) {
                this.addReferenceUpdates(this.fChangeManager, (IProgressMonitor)new SubProgressMonitor(pm, 3));
            }
            pm.worked(1);
            IResource resource = this.fType.getCompilationUnit().getResource();
            if (resource != null && resource.isLinked() || !this.willRenameCU()) {
                this.addTypeDeclarationUpdate(this.fChangeManager);
                pm.worked(1);
                this.addConstructorRenames(this.fChangeManager);
                pm.worked(1);
            } else {
                pm.worked(2);
            }
            if (this.fUpdateTextualMatches) {
                pm.subTask(RefactoringCoreMessages.RenameTypeRefactoring_searching_text);
                TextMatchUpdater.perform((IProgressMonitor)new SubProgressMonitor(pm, 1), RefactoringScopeFactory.create((IJavaElement)this.fType), this, this.fChangeManager, this.fReferences);
                if (this.fUpdateSimilarElements) {
                    this.addSimilarElementsTextualUpdates(this.fChangeManager, (IProgressMonitor)new SubProgressMonitor(pm, 3));
                }
            }
        }
        finally {
            pm.done();
        }
    }

    private void addTypeDeclarationUpdate(TextChangeManager manager) throws CoreException {
        String name = RefactoringCoreMessages.RenameTypeRefactoring_update;
        int typeNameLength = this.fType.getElementName().length();
        ICompilationUnit cu = this.fType.getCompilationUnit();
        TextChangeCompatibility.addTextEdit(manager.get(cu), name, (TextEdit)new ReplaceEdit(this.fType.getNameRange().getOffset(), typeNameLength, this.getNewElementName()));
    }

    private void addConstructorRenames(TextChangeManager manager) throws CoreException {
        ICompilationUnit cu = this.fType.getCompilationUnit();
        IMethod[] methods = this.fType.getMethods();
        int typeNameLength = this.fType.getElementName().length();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].isConstructor()) {
                String name = RefactoringCoreMessages.RenameTypeRefactoring_rename_constructor;
                TextChangeCompatibility.addTextEdit(manager.get(cu), name, (TextEdit)new ReplaceEdit(methods[i].getNameRange().getOffset(), typeNameLength, this.getNewElementName()));
            }
            ++i;
        }
    }

    private void addReferenceUpdates(TextChangeManager manager, IProgressMonitor pm) {
        pm.beginTask("", this.fReferences.length);
        int i = 0;
        while (i < this.fReferences.length) {
            ICompilationUnit cu = this.fReferences[i].getCompilationUnit();
            if (cu != null) {
                String name = RefactoringCoreMessages.RenameTypeRefactoring_update_reference;
                SearchMatch[] results = this.fReferences[i].getSearchResults();
                int j = 0;
                while (j < results.length) {
                    SearchMatch match = results[j];
                    ReplaceEdit replaceEdit = new ReplaceEdit(match.getOffset(), match.getLength(), this.getNewElementName());
                    TextChangeCompatibility.addTextEdit(manager.get(cu), name, (TextEdit)replaceEdit, CATEGORY_TYPE_RENAME);
                    ++j;
                }
                pm.worked(1);
            }
            ++i;
        }
    }

    private void computeQualifiedNameMatches(IProgressMonitor pm) {
        IPackageFragment fragment = this.fType.getPackageFragment();
        if (this.fQualifiedNameSearchResult == null) {
            this.fQualifiedNameSearchResult = new QualifiedNameSearchResult();
        }
        QualifiedNameFinder.process(this.fQualifiedNameSearchResult, this.fType.getFullyQualifiedName(), String.valueOf(fragment.getElementName()) + "." + this.getNewElementName(), this.fFilePatterns, this.fType.getJavaProject().getProject(), pm);
    }

    private RefactoringStatus initialize(JavaRefactoringArguments extended) {
        String references;
        IJavaElement element;
        String handle = extended.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 7) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.rename.type");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.fType = (IType)element;
        String name = extended.getAttribute("name");
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        this.setNewElementName(name);
        String patterns = extended.getAttribute(ATTRIBUTE_PATTERNS);
        if (patterns != null && !"".equals(patterns)) {
            this.fFilePatterns = patterns;
        }
        if ((references = extended.getAttribute("references")) == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
        }
        this.fUpdateReferences = Boolean.valueOf(references);
        String matches = extended.getAttribute(ATTRIBUTE_TEXTUAL_MATCHES);
        if (matches == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TEXTUAL_MATCHES));
        }
        this.fUpdateTextualMatches = Boolean.valueOf(matches);
        String qualified = extended.getAttribute(ATTRIBUTE_QUALIFIED);
        if (qualified == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_QUALIFIED));
        }
        this.fUpdateQualifiedNames = Boolean.valueOf(qualified);
        String similarDeclarations = extended.getAttribute(ATTRIBUTE_SIMILAR_DECLARATIONS);
        if (similarDeclarations == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_SIMILAR_DECLARATIONS));
        }
        this.fUpdateSimilarElements = Boolean.valueOf(similarDeclarations);
        String similarDeclarationsMatchingStrategy = extended.getAttribute(ATTRIBUTE_MATCHING_STRATEGY);
        if (similarDeclarationsMatchingStrategy != null) {
            try {
                this.fRenamingStrategy = Integer.valueOf(similarDeclarationsMatchingStrategy);
            }
            catch (NumberFormatException numberFormatException) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{similarDeclarationsMatchingStrategy, ATTRIBUTE_QUALIFIED}));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_MATCHING_STRATEGY));
        }
        return new RefactoringStatus();
    }

    private RefactoringStatus initializeSimilarElementsRenameProcessors(IProgressMonitor progressMonitor, CheckConditionsContext context) throws CoreException {
        Assert.isNotNull(this.fPreloadedElementToName);
        Assert.isNotNull(this.fPreloadedElementToSelection);
        RefactoringStatus status = new RefactoringStatus();
        HashSet<IMethod> handledTopLevelMethods = new HashSet<IMethod>();
        HashSet<Warning> warnings = new HashSet<Warning>();
        ArrayList<RefactoringProcessor> processors = new ArrayList<RefactoringProcessor>();
        this.fFinalSimilarElementToName = new HashMap<IJavaElement, String>();
        CompilationUnit currentResolvedCU = null;
        ICompilationUnit currentCU = null;
        int current = 0;
        int max = this.fPreloadedElementToName.size();
        progressMonitor.beginTask("", max * 3);
        progressMonitor.setTaskName(RefactoringCoreMessages.RenameTypeProcessor_checking_similarly_named_declarations_refactoring_conditions);
        for (IJavaElement element : this.fPreloadedElementToName.keySet()) {
            ++current;
            progressMonitor.worked(3);
            if (!this.fPreloadedElementToSelection.get(element).booleanValue() || this.fFinalSimilarElementToName.containsKey(element)) continue;
            ICompilationUnit newCU = (ICompilationUnit)element.getAncestor(5);
            if (!newCU.equals(currentCU)) {
                this.checkCUCompleteConditions(status, currentResolvedCU, currentCU, processors);
                if (status.hasFatalError()) {
                    return status;
                }
                currentResolvedCU = null;
                currentCU = newCU;
                processors.clear();
            }
            String newName = this.fPreloadedElementToName.get(element);
            JavaRenameProcessor processor = null;
            if (element instanceof ILocalVariable) {
                ILocalVariable currentLocal = (ILocalVariable)element;
                if (currentResolvedCU == null) {
                    currentResolvedCU = new RefactoringASTParser(4).parse((ITypeRoot)currentCU, true);
                }
                processor = this.createLocalRenameProcessor(currentLocal, newName, currentResolvedCU);
                if (status.hasFatalError()) {
                    return status;
                }
                this.fFinalSimilarElementToName.put((IJavaElement)currentLocal, newName);
            }
            if (element instanceof IField) {
                IField currentField = (IField)element;
                processor = this.createFieldRenameProcessor(currentField, newName);
                status.merge(this.checkForConflictingRename(currentField, newName));
                if (status.hasFatalError()) {
                    return status;
                }
                this.fFinalSimilarElementToName.put((IJavaElement)currentField, newName);
            }
            if (element instanceof IMethod) {
                IMethod currentMethod = (IMethod)element;
                if (MethodChecks.isVirtual(currentMethod)) {
                    IMethod topmost;
                    IType declaringType = currentMethod.getDeclaringType();
                    ITypeHierarchy hierarchy = null;
                    if (!declaringType.isInterface()) {
                        hierarchy = declaringType.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                    }
                    if ((topmost = MethodChecks.getTopmostMethod(currentMethod, hierarchy, (IProgressMonitor)new NullProgressMonitor())) != null) {
                        currentMethod = topmost;
                    }
                    if (handledTopLevelMethods.contains(currentMethod)) continue;
                    handledTopLevelMethods.add(currentMethod);
                    IMethod[] ripples = RippleMethodFinder2.getRelatedMethods(currentMethod, (IProgressMonitor)new NullProgressMonitor(), null);
                    if (this.checkForWarnings(warnings, newName, ripples)) continue;
                    status.merge(this.checkForConflictingRename(ripples, newName));
                    if (status.hasFatalError()) {
                        return status;
                    }
                    processor = this.createVirtualMethodRenameProcessor(currentMethod, newName, ripples, hierarchy);
                    this.fFinalSimilarElementToName.put((IJavaElement)currentMethod, newName);
                    int i = 0;
                    while (i < ripples.length) {
                        this.fFinalSimilarElementToName.put((IJavaElement)ripples[i], newName);
                        ++i;
                    }
                } else {
                    status.merge(this.checkForConflictingRename(new IMethod[]{currentMethod}, newName));
                    if (status.hasFatalError()) break;
                    this.fFinalSimilarElementToName.put((IJavaElement)currentMethod, newName);
                    processor = this.createNonVirtualMethodRenameProcessor(currentMethod, newName);
                }
            }
            progressMonitor.subTask(Messages.format(RefactoringCoreMessages.RenameTypeProcessor_progress_current_total, new Object[]{String.valueOf(current), String.valueOf(max)}));
            status.merge(processor.checkInitialConditions((IProgressMonitor)new NoOverrideProgressMonitor(progressMonitor, 1)));
            if (status.hasFatalError()) {
                return status;
            }
            status.merge(processor.checkFinalConditions((IProgressMonitor)new NoOverrideProgressMonitor(progressMonitor, 1), context));
            if (status.hasFatalError()) {
                return status;
            }
            processors.add((RefactoringProcessor)processor);
            progressMonitor.worked(1);
            if (!progressMonitor.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        this.checkCUCompleteConditions(status, currentResolvedCU, currentCU, processors);
        status.merge(this.addWarnings(warnings));
        progressMonitor.done();
        return status;
    }

    private void checkCUCompleteConditions(RefactoringStatus status, CompilationUnit currentResolvedCU, ICompilationUnit currentCU, List<RefactoringProcessor> processors) throws CoreException {
        List<RefactoringProcessor> locals = this.getProcessorsOfType(processors, RenameLocalVariableProcessor.class);
        if (!locals.isEmpty()) {
            RenameAnalyzeUtil.LocalAnalyzePackage[] analyzePackages = new RenameAnalyzeUtil.LocalAnalyzePackage[locals.size()];
            TextChangeManager manager = new TextChangeManager();
            int current = 0;
            TextChange textChange = manager.get(currentCU);
            textChange.setKeepPreviewEdits(true);
            for (RenameLocalVariableProcessor renameLocalVariableProcessor : locals) {
                RenameAnalyzeUtil.LocalAnalyzePackage analyzePackage;
                analyzePackages[current] = analyzePackage = renameLocalVariableProcessor.getLocalAnalyzePackage();
                int i = 0;
                while (i < analyzePackage.fOccurenceEdits.length) {
                    TextChangeCompatibility.addTextEdit(textChange, "", analyzePackage.fOccurenceEdits[i], GroupCategorySet.NONE);
                    ++i;
                }
                ++current;
            }
            status.merge(RenameAnalyzeUtil.analyzeLocalRenames(analyzePackages, textChange, currentResolvedCU, false));
        }
    }

    private List<RefactoringProcessor> getProcessorsOfType(List<RefactoringProcessor> processors, Class<RenameLocalVariableProcessor> type) {
        ArrayList<RefactoringProcessor> tmp = new ArrayList<RefactoringProcessor>();
        for (RefactoringProcessor element : processors) {
            if (!element.getClass().equals(type)) continue;
            tmp.add(element);
        }
        return tmp;
    }

    private RefactoringStatus checkForConflictingRename(IMethod[] methods, String newName) {
        RefactoringStatus status = new RefactoringStatus();
        for (IJavaElement element : this.fFinalSimilarElementToName.keySet()) {
            if (!(element instanceof IMethod)) continue;
            IMethod alreadyRegisteredMethod = (IMethod)element;
            String alreadyRegisteredMethodName = this.fFinalSimilarElementToName.get(element);
            int i = 0;
            while (i < methods.length) {
                IMethod method2 = methods[i];
                if (alreadyRegisteredMethodName.equals(newName) && method2.getDeclaringType().equals(alreadyRegisteredMethod.getDeclaringType()) && RenameTypeProcessor.sameParams(alreadyRegisteredMethod, method2)) {
                    String message = Messages.format(RefactoringCoreMessages.RenameTypeProcessor_cannot_rename_methods_same_new_name, new String[]{BasicElementLabels.getJavaElementName(alreadyRegisteredMethod.getElementName()), BasicElementLabels.getJavaElementName(method2.getElementName()), BasicElementLabels.getJavaElementName(alreadyRegisteredMethod.getDeclaringType().getFullyQualifiedName('.')), BasicElementLabels.getJavaElementName(newName)});
                    status.addFatalError(message);
                    return status;
                }
                ++i;
            }
        }
        return status;
    }

    private static boolean sameParams(IMethod method, IMethod method2) {
        if (method.getNumberOfParameters() != method2.getNumberOfParameters()) {
            return false;
        }
        String[] params = method.getParameterTypes();
        String[] params2 = method2.getParameterTypes();
        int i = 0;
        while (i < params.length) {
            String t2;
            String t1 = Signature.getSimpleName((String)Signature.toString((String)params[i]));
            if (!t1.equals(t2 = Signature.getSimpleName((String)Signature.toString((String)params2[i])))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private RefactoringStatus checkForConflictingRename(IField currentField, String newName) {
        RefactoringStatus status = new RefactoringStatus();
        for (IJavaElement element : this.fFinalSimilarElementToName.keySet()) {
            if (!(element instanceof IField)) continue;
            IField alreadyRegisteredField = (IField)element;
            String alreadyRegisteredFieldName = this.fFinalSimilarElementToName.get(element);
            if (!alreadyRegisteredFieldName.equals(newName) || !alreadyRegisteredField.getDeclaringType().equals(currentField.getDeclaringType())) continue;
            String message = Messages.format(RefactoringCoreMessages.RenameTypeProcessor_cannot_rename_fields_same_new_name, new String[]{BasicElementLabels.getJavaElementName(alreadyRegisteredField.getElementName()), BasicElementLabels.getJavaElementName(currentField.getElementName()), BasicElementLabels.getJavaElementName(alreadyRegisteredField.getDeclaringType().getFullyQualifiedName('.')), BasicElementLabels.getJavaElementName(newName)});
            status.addFatalError(message);
            return status;
        }
        return status;
    }

    private RefactoringStatus addWarnings(Set<Warning> warnings) {
        RefactoringStatus status = new RefactoringStatus();
        for (Warning warning : warnings) {
            String message;
            IMethod[] elements = warning.getRipple();
            if (warning.isSelectionWarning()) {
                message = Messages.format(RefactoringCoreMessages.RenameTypeProcessor_deselected_method_is_overridden, new String[]{JavaElementLabels.getElementLabel((IJavaElement)elements[0], JavaElementLabels.ALL_DEFAULT), JavaElementLabels.getElementLabel((IJavaElement)elements[0].getDeclaringType(), JavaElementLabels.ALL_DEFAULT)});
                status.addWarning(message);
            }
            if (warning.isNameWarning()) {
                message = Messages.format(RefactoringCoreMessages.RenameTypeProcessor_renamed_method_is_overridden, new String[]{JavaElementLabels.getElementLabel((IJavaElement)elements[0], JavaElementLabels.ALL_DEFAULT), JavaElementLabels.getElementLabel((IJavaElement)elements[0].getDeclaringType(), JavaElementLabels.ALL_DEFAULT)});
                status.addWarning(message);
            }
            int i = 0;
            while (i < elements.length) {
                this.fPreloadedElementToSelection.put((IJavaElement)elements[i], Boolean.FALSE);
                ++i;
            }
        }
        return status;
    }

    private boolean checkForWarnings(Set<Warning> warnings, String newName, IMethod[] ripples) {
        boolean addSelectionWarning = false;
        boolean addNameWarning = false;
        int i = 0;
        while (i < ripples.length) {
            String newNameOfRipple = this.fPreloadedElementToName.get(ripples[i]);
            Boolean selected = this.fPreloadedElementToSelection.get(ripples[i]);
            if (selected != null) {
                if (!selected.booleanValue()) {
                    addSelectionWarning = true;
                }
                if (!newName.equals(newNameOfRipple)) {
                    addNameWarning = true;
                }
            }
            ++i;
        }
        if (addSelectionWarning || addNameWarning) {
            warnings.add(new Warning(ripples, addSelectionWarning, addNameWarning));
        }
        return addSelectionWarning || addNameWarning;
    }

    private RenameMethodProcessor createVirtualMethodRenameProcessor(IMethod currentMethod, String newMethodName, IMethod[] ripples, ITypeHierarchy hierarchy) {
        RenameVirtualMethodProcessor processor = new RenameVirtualMethodProcessor(currentMethod, ripples, this.fChangeManager, hierarchy, CATEGORY_METHOD_RENAME);
        this.initMethodProcessor(processor, newMethodName);
        return processor;
    }

    private RenameMethodProcessor createNonVirtualMethodRenameProcessor(IMethod currentMethod, String newMethodName) {
        RenameNonVirtualMethodProcessor processor = new RenameNonVirtualMethodProcessor(currentMethod, this.fChangeManager, CATEGORY_METHOD_RENAME);
        this.initMethodProcessor(processor, newMethodName);
        return processor;
    }

    private void initMethodProcessor(RenameMethodProcessor processor, String newMethodName) {
        processor.setNewElementName(newMethodName);
        processor.setUpdateReferences(this.getUpdateReferences());
    }

    private RenameFieldProcessor createFieldRenameProcessor(IField field, String newName) {
        RenameFieldProcessor processor = new RenameFieldProcessor(field, this.fChangeManager, CATEGORY_FIELD_RENAME);
        processor.setNewElementName(newName);
        processor.setRenameGetter(false);
        processor.setRenameSetter(false);
        processor.setUpdateReferences(this.getUpdateReferences());
        processor.setUpdateTextualMatches(false);
        return processor;
    }

    private RenameLocalVariableProcessor createLocalRenameProcessor(ILocalVariable local, String newName, CompilationUnit compilationUnit) {
        RenameLocalVariableProcessor processor = new RenameLocalVariableProcessor(local, this.fChangeManager, compilationUnit, CATEGORY_LOCAL_RENAME);
        processor.setNewElementName(newName);
        processor.setUpdateReferences(this.getUpdateReferences());
        return processor;
    }

    private void addSimilarElementsTextualUpdates(TextChangeManager manager, IProgressMonitor monitor) throws CoreException {
        HashMap<String, String> simpleNames = new HashMap<String, String>();
        ArrayList<String> forbiddenSimpleNames = new ArrayList<String>();
        for (IJavaElement element : this.fFinalSimilarElementToName.keySet()) {
            if (!(element instanceof IField) || forbiddenSimpleNames.contains(element.getElementName())) continue;
            String registeredNewName = (String)simpleNames.get(element.getElementName());
            String newNameToCheck = this.fFinalSimilarElementToName.get(element);
            if (registeredNewName == null) {
                simpleNames.put(element.getElementName(), newNameToCheck);
                continue;
            }
            if (registeredNewName.equals(newNameToCheck)) continue;
            forbiddenSimpleNames.add(element.getElementName());
        }
        for (IJavaElement element : this.fFinalSimilarElementToName.keySet()) {
            if (!(element instanceof IField)) continue;
            IField field = (IField)element;
            String newName = this.fFinalSimilarElementToName.get(field);
            TextMatchUpdater.perform(monitor, RefactoringScopeFactory.create((IJavaElement)field), field.getElementName(), field.getDeclaringType().getFullyQualifiedName(), newName, manager, new SearchResultGroup[0], forbiddenSimpleNames.contains(field.getElementName()));
        }
    }

    public Map<IJavaElement, String> getSimilarElementsToNewNames() {
        return this.fPreloadedElementToName;
    }

    public Map<IJavaElement, Boolean> getSimilarElementsToSelection() {
        return this.fPreloadedElementToSelection;
    }

    public void resetSelectedSimilarElements() {
        Assert.isNotNull(this.fPreloadedElementToName);
        for (IJavaElement element : this.fPreloadedElementToNameDefault.keySet()) {
            this.fPreloadedElementToName.put(element, this.fPreloadedElementToNameDefault.get(element));
            this.fPreloadedElementToSelection.put(element, Boolean.TRUE);
        }
    }

    public boolean hasSimilarElementsToRename() {
        if (!this.fUpdateSimilarElements) {
            return false;
        }
        if (this.fPreloadedElementToName == null) {
            return false;
        }
        return this.fPreloadedElementToName.size() != 0;
    }

    private class NoOverrideProgressMonitor
    extends SubProgressMonitor {
        public NoOverrideProgressMonitor(IProgressMonitor monitor, int ticks) {
            super(monitor, ticks, 2);
        }

        public void setTaskName(String name) {
        }
    }

    public static final class ParticipantDescriptorFilter
    implements IParticipantDescriptorFilter {
        public boolean select(IConfigurationElement element, RefactoringStatus status) {
            IConfigurationElement[] params = element.getChildren("param");
            int i = 0;
            while (i < params.length) {
                IConfigurationElement param = params[i];
                if ("handlesSimilarDeclarations".equals(param.getAttribute("name")) && "false".equals(param.getAttribute("value"))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private class Warning {
        private IMethod[] fRipple;
        private boolean fSelectionWarning;
        private boolean fNameWarning;

        public Warning(IMethod[] ripple, boolean isSelectionWarning, boolean isNameWarning) {
            this.fRipple = ripple;
            this.fSelectionWarning = isSelectionWarning;
            this.fNameWarning = isNameWarning;
        }

        public boolean isNameWarning() {
            return this.fNameWarning;
        }

        public IMethod[] getRipple() {
            return this.fRipple;
        }

        public boolean isSelectionWarning() {
            return this.fSelectionWarning;
        }
    }
}

