/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IField;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.document.utils.AssignmentLocator;
import org.eclipse.edt.ide.rui.document.utils.DocumentUtil;
import org.eclipse.edt.ide.rui.document.utils.EGLWidgetDefinitionDeleteStragegy;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class GridLayoutOperation {
    public static final int ACTION_INSERT_ROW_AHEAD = 1;
    public static final int ACTION_INSERT_ROW_AFTER = 2;
    public static final int ACTION_INSERT_COLUMN_AHEAD = 3;
    public static final int ACTION_INSERT_COLUMN_AFTER = 4;
    public static final int ACTION_DELETE_ROW = 5;
    public static final int ACTION_DELETE_COLUMN = 6;
    private static final String GRID_LAYOUT_TYPE_NAME = InternUtil.intern((String)"GridLayout");
    private static final String CHILDREN_PROPERTY_NAME = InternUtil.intern((String)"children");
    private static final String LAYOUT_DATA_PROPERTY_NAME = InternUtil.intern((String)"layoutData");
    private static final String ROW_PROPERTY_NAME = InternUtil.intern((String)"row");
    private static final String ROWS_PROPERTY_NAME = InternUtil.intern((String)"rows");
    private static final String COLUMN_PROPERTY_NAME = InternUtil.intern((String)"column");
    private static final String COLUMNS_PROPERTY_NAME = InternUtil.intern((String)"columns");
    private static final String HORIZONTAL_SPAN_PROPERTY_NAME = InternUtil.intern((String)"horizontalSpan");
    private static final String VERTICAL_SPAN_PROPERTY_NAME = InternUtil.intern((String)"verticalSpan");
    private IEGLDocument currentDocument;
    private IPart modelPart;
    private IFile currentFile;
    private TextEdit textEdit;
    private List<String> newChildren = new ArrayList<String>();
    private static final int ADD = 1;
    private static final int SUBSTRACT = 2;
    EGLWidgetDefinitionDeleteStragegy deleteStrategy;
    private boolean isLastChild;

    public GridLayoutOperation(IEGLDocument currentDocument, IFile currentFile) {
        this.currentDocument = currentDocument;
        this.currentFile = currentFile;
    }

    public void doOpeation(int iStatementOffset, int iStatementLength, int row, int column, int operationType) {
        try {
            IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this.currentFile);
            IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            String partName = new Path(this.currentFile.getName()).removeFileExtension().toString();
            this.modelPart = sharedWorkingCopy.getPart(partName);
            sharedWorkingCopy.open(null);
            sharedWorkingCopy.reconcile(false, null);
            try {
                try {
                    File fileAST = this.currentDocument.getNewModelEGLFile();
                    ASTRewrite rewrite = ASTRewrite.create((File)fileAST);
                    this.deleteStrategy = new EGLWidgetDefinitionDeleteStragegy(this.currentDocument, this.modelPart, rewrite);
                    Node gridLayoutWidgetName = DocumentUtil.getWidgetNode(this.currentDocument, iStatementOffset, iStatementLength);
                    if (gridLayoutWidgetName != null) {
                        gridLayoutWidgetName.getParent().accept((IASTVisitor)new GridLayoutVisitor(row, column, operationType, rewrite));
                    }
                    this.textEdit.apply((IDocument)this.currentDocument);
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "GridLayout Operation: Error doing GridLayout operation", (Throwable)e));
                    sharedWorkingCopy.destroy();
                }
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
        catch (EGLModelException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "GridLayout Operation: Error creating working copy", (Throwable)e));
        }
    }

    private void modifyProperty(SettingsBlock fieldSettingsBlock, ASTRewrite rewrite, String property, int operationType, int number) {
        AssignmentLocator assignmentLocator = new AssignmentLocator(property);
        fieldSettingsBlock.accept((IASTVisitor)assignmentLocator);
        Assignment assignment = assignmentLocator.getAssignment();
        int value = this.convertToInt(assignment.getRightHandSide().getCanonicalString());
        if (value < number) {
            return;
        }
        switch (operationType) {
            case 1: {
                ++value;
                break;
            }
            case 2: {
                --value;
            }
        }
        rewrite.setText((Node)assignment, String.valueOf(property) + " = " + value);
        this.textEdit = rewrite.rewriteAST((IDocument)this.currentDocument);
    }

    private void modifyHorizontalSpanProperty(SettingsBlock fieldSettingsBlock, ASTRewrite rewrite, int number) {
        AssignmentLocator horizontalSpanAssignmentLocator = new AssignmentLocator(HORIZONTAL_SPAN_PROPERTY_NAME);
        fieldSettingsBlock.accept((IASTVisitor)horizontalSpanAssignmentLocator);
        Assignment horizontalSpanAssignment = horizontalSpanAssignmentLocator.getAssignment();
        if (horizontalSpanAssignment == null) {
            return;
        }
        int horizontalSpan = this.convertToInt(horizontalSpanAssignment.getRightHandSide().getCanonicalString());
        if (horizontalSpan == 1) {
            return;
        }
        AssignmentLocator columnAssignmentLocator = new AssignmentLocator(COLUMN_PROPERTY_NAME);
        fieldSettingsBlock.accept((IASTVisitor)columnAssignmentLocator);
        Assignment columnAssignment = columnAssignmentLocator.getAssignment();
        int column = this.convertToInt(columnAssignment.getRightHandSide().getCanonicalString());
        if (column < number && number < column + horizontalSpan) {
            --horizontalSpan;
        }
        rewrite.setText((Node)horizontalSpanAssignment, String.valueOf(HORIZONTAL_SPAN_PROPERTY_NAME) + " = " + horizontalSpan);
        this.textEdit = rewrite.rewriteAST((IDocument)this.currentDocument);
    }

    private void modifyVerticalSpanProperty(SettingsBlock fieldSettingsBlock, ASTRewrite rewrite, int number) {
        AssignmentLocator verticalSpanAssignmentLocator = new AssignmentLocator(VERTICAL_SPAN_PROPERTY_NAME);
        fieldSettingsBlock.accept((IASTVisitor)verticalSpanAssignmentLocator);
        Assignment verticalSpanAssignment = verticalSpanAssignmentLocator.getAssignment();
        if (verticalSpanAssignment == null) {
            return;
        }
        int verticalSpan = this.convertToInt(verticalSpanAssignment.getRightHandSide().getCanonicalString());
        if (verticalSpan == 1) {
            return;
        }
        AssignmentLocator rowAssignmentLocator = new AssignmentLocator(ROW_PROPERTY_NAME);
        fieldSettingsBlock.accept((IASTVisitor)rowAssignmentLocator);
        Assignment rowAssignment = rowAssignmentLocator.getAssignment();
        int row = this.convertToInt(rowAssignment.getRightHandSide().getCanonicalString());
        if (row < number && number < row + verticalSpan) {
            --verticalSpan;
        }
        rewrite.setText((Node)verticalSpanAssignment, String.valueOf(VERTICAL_SPAN_PROPERTY_NAME) + " = " + verticalSpan);
        this.textEdit = rewrite.rewriteAST((IDocument)this.currentDocument);
    }

    private void deleteOperation(SettingsBlock fieldSettingsBlock, ASTRewrite rewrite, String property, String widgetName, int number) {
        AssignmentLocator assignmentLocator = new AssignmentLocator(property);
        fieldSettingsBlock.accept((IASTVisitor)assignmentLocator);
        Assignment assignment = assignmentLocator.getAssignment();
        int value = this.convertToInt(assignment.getRightHandSide().getCanonicalString());
        if (value == number) {
            try {
                this.deleteStrategy.deleteWidgetDefinition(widgetName);
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "GridLayoutOperation: error when delete", (Throwable)e));
            }
            this.textEdit = this.deleteStrategy.getTextEdit();
            this.newChildren.remove(widgetName);
        } else if (value > number) {
            this.modifyProperty(fieldSettingsBlock, rewrite, property, 2, -1);
        }
    }

    private int convertToInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "GridLayoutOperation: Error convert to int", (Throwable)e));
            return 0;
        }
    }

    private class ChildrenArrayVisitor
    extends DefaultASTVisitor {
        private final int row;
        private final int column;
        private final int operationType;
        private final ASTRewrite rewrite;

        public ChildrenArrayVisitor(int row, int column, int operationType, ASTRewrite rewrite) {
            this.row = row;
            this.column = column;
            this.operationType = operationType;
            this.rewrite = rewrite;
        }

        public boolean visit(Assignment assignment) {
            assignment.getRightHandSide().accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(ArrayLiteral arrayLiteral) {
                    List expressions = arrayLiteral.getExpressions();
                    int i = 0;
                    while (i < expressions.size()) {
                        if (i == expressions.size() - 1) {
                            GridLayoutOperation.this.isLastChild = true;
                        }
                        if (expressions.get(i) instanceof SimpleName) {
                            SimpleName simpleName = (SimpleName)expressions.get(i);
                            GridLayoutOperation.this.newChildren.add(simpleName.getIdentifier());
                            try {
                                IField[] fields = GridLayoutOperation.this.modelPart.getFields();
                                int j = 0;
                                while (j < fields.length) {
                                    Node childWidgetName;
                                    final IField field = fields[j];
                                    if (field.getElementName().equalsIgnoreCase(simpleName.getIdentifier()) && (childWidgetName = GridLayoutOperation.this.currentDocument.getNewModelNodeAtOffset(field.getNameRange().getOffset(), field.getNameRange().getLength())) != null) {
                                        childWidgetName.getParent().accept((IASTVisitor)new DefaultASTVisitor(){

                                            public boolean visit(ClassDataDeclaration classDataDeclaration) {
                                                SettingsBlock fieldSettingsBlock;
                                                if (classDataDeclaration.getSettingsBlockOpt() != null && (fieldSettingsBlock = classDataDeclaration.getSettingsBlockOpt()) != null) {
                                                    AssignmentLocator assignmentLocator = new AssignmentLocator(LAYOUT_DATA_PROPERTY_NAME);
                                                    fieldSettingsBlock.accept((IASTVisitor)assignmentLocator);
                                                    Assignment layoutDataAssignment = assignmentLocator.getAssignment();
                                                    layoutDataAssignment.getRightHandSide().accept((IASTVisitor)new DefaultASTVisitor(){

                                                        public boolean visit(NewExpression newExpression) {
                                                            SettingsBlock fieldSettingsBlock = newExpression.getSettingsBlock();
                                                            switch (ChildrenArrayVisitor.this.operationType) {
                                                                case 1: {
                                                                    GridLayoutOperation.this.modifyProperty(fieldSettingsBlock, ChildrenArrayVisitor.this.rewrite, ROW_PROPERTY_NAME, 1, ChildrenArrayVisitor.this.row);
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    GridLayoutOperation.this.modifyProperty(fieldSettingsBlock, ChildrenArrayVisitor.this.rewrite, ROW_PROPERTY_NAME, 1, ChildrenArrayVisitor.this.row + 1);
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    GridLayoutOperation.this.modifyProperty(fieldSettingsBlock, ChildrenArrayVisitor.this.rewrite, COLUMN_PROPERTY_NAME, 1, ChildrenArrayVisitor.this.column);
                                                                    break;
                                                                }
                                                                case 4: {
                                                                    GridLayoutOperation.this.modifyProperty(fieldSettingsBlock, ChildrenArrayVisitor.this.rewrite, COLUMN_PROPERTY_NAME, 1, ChildrenArrayVisitor.this.column + 1);
                                                                    break;
                                                                }
                                                                case 5: {
                                                                    GridLayoutOperation.this.deleteOperation(fieldSettingsBlock, ChildrenArrayVisitor.this.rewrite, ROW_PROPERTY_NAME, field.getElementName(), ChildrenArrayVisitor.this.row);
                                                                    GridLayoutOperation.this.modifyVerticalSpanProperty(fieldSettingsBlock, ChildrenArrayVisitor.this.rewrite, ChildrenArrayVisitor.this.row);
                                                                    if (!GridLayoutOperation.this.isLastChild) break;
                                                                    ((ChildrenArrayVisitor)((this).this).ChildrenArrayVisitor.this).GridLayoutOperation.this.deleteStrategy.modifyFormManagerEntities();
                                                                    GridLayoutOperation.this.isLastChild = false;
                                                                    break;
                                                                }
                                                                case 6: {
                                                                    GridLayoutOperation.this.deleteOperation(fieldSettingsBlock, ChildrenArrayVisitor.this.rewrite, COLUMN_PROPERTY_NAME, field.getElementName(), ChildrenArrayVisitor.this.column);
                                                                    GridLayoutOperation.this.modifyHorizontalSpanProperty(fieldSettingsBlock, ChildrenArrayVisitor.this.rewrite, ChildrenArrayVisitor.this.column);
                                                                    if (!GridLayoutOperation.this.isLastChild) break;
                                                                    ((ChildrenArrayVisitor)((this).this).ChildrenArrayVisitor.this).GridLayoutOperation.this.deleteStrategy.modifyFormManagerEntities();
                                                                    GridLayoutOperation.this.isLastChild = false;
                                                                }
                                                            }
                                                            return false;
                                                        }
                                                    });
                                                }
                                                return false;
                                            }
                                        });
                                    }
                                    ++j;
                                }
                            }
                            catch (Exception e) {
                                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Get Event Handler: Error finding functions", (Throwable)e));
                            }
                        }
                        ++i;
                    }
                    return false;
                }
            });
            return false;
        }
    }

    private class GridLayoutVisitor
    extends DefaultASTVisitor {
        private final int row;
        private final int column;
        private final int operationType;
        private final ASTRewrite rewrite;

        public GridLayoutVisitor(int row, int column, int operationType, ASTRewrite rewrite) {
            this.row = row;
            this.column = column;
            this.operationType = operationType;
            this.rewrite = rewrite;
        }

        public boolean visit(Handler handler) {
            return true;
        }

        public boolean visit(ClassDataDeclaration classDataDeclaration) {
            SettingsBlock fieldSettingsBlock;
            if (classDataDeclaration.getType().getCanonicalName().equalsIgnoreCase(GRID_LAYOUT_TYPE_NAME) && classDataDeclaration.hasSettingsBlock() && (fieldSettingsBlock = classDataDeclaration.getSettingsBlockOpt()) != null) {
                AssignmentLocator assignmentLocator = new AssignmentLocator(CHILDREN_PROPERTY_NAME);
                fieldSettingsBlock.accept((IASTVisitor)assignmentLocator);
                Assignment childrenAssignment = assignmentLocator.getAssignment();
                if (childrenAssignment != null) {
                    childrenAssignment.accept((IASTVisitor)new ChildrenArrayVisitor(this.row + 1, this.column + 1, this.operationType, this.rewrite));
                }
                switch (this.operationType) {
                    case 1: 
                    case 2: {
                        GridLayoutOperation.this.modifyProperty(fieldSettingsBlock, this.rewrite, ROWS_PROPERTY_NAME, 1, -1);
                        break;
                    }
                    case 3: 
                    case 4: {
                        GridLayoutOperation.this.modifyProperty(fieldSettingsBlock, this.rewrite, COLUMNS_PROPERTY_NAME, 1, -1);
                        break;
                    }
                    case 5: {
                        GridLayoutOperation.this.modifyProperty(fieldSettingsBlock, this.rewrite, ROWS_PROPERTY_NAME, 2, -1);
                        break;
                    }
                    case 6: {
                        GridLayoutOperation.this.modifyProperty(fieldSettingsBlock, this.rewrite, COLUMNS_PROPERTY_NAME, 2, -1);
                    }
                }
                StringBuffer sbChildren = new StringBuffer("children = [ ");
                int i = 0;
                while (i < GridLayoutOperation.this.newChildren.size()) {
                    sbChildren.append((String)GridLayoutOperation.this.newChildren.get(i));
                    if (i < GridLayoutOperation.this.newChildren.size() - 1) {
                        sbChildren.append(", ");
                    }
                    ++i;
                }
                sbChildren.append("]");
                this.rewrite.setText((Node)childrenAssignment, sbChildren.toString());
                GridLayoutOperation.this.textEdit = this.rewrite.rewriteAST((IDocument)GridLayoutOperation.this.currentDocument);
            }
            return false;
        }
    }
}

