/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.compiler.gen;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.internal.interfaces.IGenerationMessageRequestor;
import org.eclipse.edt.compiler.internal.util.IGenerationResultsMessage;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.EGLMessages.EGLMessage;
import org.eclipse.edt.gen.java.JavaGenerator;

public class EclipseJavaGenerator
extends JavaGenerator {
    public EclipseJavaGenerator(AbstractGeneratorCommand processor, IGenerationMessageRequestor requestor) {
        super(processor, requestor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processFile(String fileName) {
        if (this.context.getMessageRequestor().isError()) return;
        IFile outSmapFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(String.valueOf(fileName.substring(0, fileName.length() - this.getFileExtension().length())) + ".eglsmap"));
        ByteArrayInputStream dataStream = null;
        try {
            dataStream = new ByteArrayInputStream(this.context.getSmapData().toString().getBytes("UTF-8"));
            if (outSmapFile.exists()) {
                outSmapFile.setContents((InputStream)dataStream, true, false, null);
            } else {
                outSmapFile.create((InputStream)dataStream, 1, null);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String[] details = new String[]{"UTF-8"};
            EGLMessage message = EGLMessage.createEGLMessage((Map)this.context.getMessageMapping(), (int)1, (String)"9971", null, (String[])details, null);
            this.context.getMessageRequestor().addMessage((IGenerationResultsMessage)message);
            if (dataStream == null) return;
            try {
                dataStream.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (CoreException coreException) {
            try {
                String[] details = new String[]{outSmapFile.getName()};
                EGLMessage message = EGLMessage.createEGLMessage((Map)this.context.getMessageMapping(), (int)1, (String)"9970", null, (String[])details, null);
                this.context.getMessageRequestor().addMessage((IGenerationResultsMessage)message);
                if (dataStream == null) return;
            }
            catch (Throwable throwable) {
                if (dataStream == null) throw throwable;
                try {
                    dataStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                dataStream.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (dataStream == null) return;
        try {
            dataStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public void dumpErrorMessages() {
    }
}

