/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.builder;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.lookup.IBuildPathEntry;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.IIDECompiler;
import org.eclipse.edt.ide.core.internal.builder.BuildManagerChange;
import org.eclipse.edt.ide.core.internal.builder.BuildManagerPackageChange;
import org.eclipse.edt.ide.core.internal.builder.BuildManagerPartChange;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;

public class BuildManager {
    private static final String NO_OUTPUT_LOCATION = "";
    protected static final IPath BUILD_MANAGER_SAVED_FILE = EDTCoreIDEPlugin.getPlugin().getStateLocation().append(".buildmanager");
    public static final int EDT_VERSION = 2;
    public static final int FULL_BUILD_REQUIRED_STATE = -1;
    private static BuildManager INSTANCE = new BuildManager();
    private static final int MAX_PART_CHANGE = 1000;
    private HashMap projectMap;
    private static final String[] NO_REQUIRED_PROJECTS = new String[0];
    private static final String[] NO_SOURCE_LOCATIONS = new String[0];
    private static final BuildPathEntry[] NO_EGLPATH_ENTRIES = new BuildPathEntry[0];
    private static final String NO_COMPILER = "";

    private BuildManager() {
        this.read();
    }

    private void prune() {
        ArrayList<IProject> projectsToRemove = new ArrayList<IProject>();
        for (String projName : this.projectMap.keySet()) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
            if (!project.exists() || !project.isOpen()) {
                projectsToRemove.add(project);
                continue;
            }
            BuildManagerEntry entry = this.getEntry(project);
            if (entry.getState() >= 2) continue;
            entry.setState(-1);
        }
        if (projectsToRemove.size() > 0) {
            for (IProject project : projectsToRemove) {
                this.removeProject(project);
            }
            this.save();
        }
    }

    private void read() {
        File file = BUILD_MANAGER_SAVED_FILE.toFile();
        if (file.exists()) {
            try {
                ObjectInputStream inputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
                try {
                    this.projectMap = (HashMap)inputStream.readObject();
                }
                finally {
                    inputStream.close();
                }
                this.prune();
            }
            catch (Exception exception) {
                this.projectMap = new HashMap();
            }
        } else {
            this.projectMap = new HashMap();
        }
    }

    public static BuildManager getInstance() {
        return INSTANCE;
    }

    public void putProject(IProject project, IProject[] requiredProjects, IContainer[] sourceLocations, IContainer outputLocation, IBuildPathEntry[] pathentries) {
        BuildManagerEntry entry = this.getEntry(project);
        String[] requiredProjectStrings = new String[requiredProjects.length];
        int i = 0;
        while (i < requiredProjects.length) {
            requiredProjectStrings[i] = requiredProjects[i].getName();
            BuildManagerEntry otherEntry = this.getEntry(requiredProjects[i]);
            otherEntry.getDependentMailBoxes().add(entry.getMailBox());
            ++i;
        }
        entry.setRequiredProjects(requiredProjectStrings);
        if (sourceLocations != null) {
            String[] sourceLocationsStrings = new String[sourceLocations.length];
            int i2 = 0;
            while (i2 < sourceLocations.length) {
                sourceLocationsStrings[i2] = sourceLocations[i2].getFullPath().toString();
                ++i2;
            }
            entry.setSourceLocations(sourceLocationsStrings);
        } else {
            entry.setSourceLocations(NO_SOURCE_LOCATIONS);
        }
        if (outputLocation != null) {
            entry.setOutputLocation(outputLocation.getFullPath().toString());
        } else {
            entry.setOutputLocation("");
        }
        IIDECompiler compiler = ProjectSettingsUtility.getCompiler(project);
        if (compiler == null) {
            entry.setCompilerId("");
        } else {
            entry.setCompilerId(compiler.getId());
        }
        if (pathentries != null) {
            BuildPathEntry[] newpaths = new BuildPathEntry[pathentries.length];
            int i3 = 0;
            while (i3 < pathentries.length) {
                IBuildPathEntry newEntry = pathentries[i3];
                newpaths[i3] = new BuildPathEntry(newEntry.isProject() ? 1 : 2, newEntry.getID());
                ++i3;
            }
            entry.setPathEntries(newpaths);
        }
        entry.setState(2);
        entry.getMailBox().clear();
        this.save();
    }

    private BuildManagerEntry getEntry(IProject project) {
        BuildManagerEntry entry = (BuildManagerEntry)this.projectMap.get(project.getName());
        if (entry == null) {
            entry = new BuildManagerEntry();
            this.projectMap.put(project.getName(), entry);
        }
        return entry;
    }

    public void recordPart(IProject project, String[] packageName, String partName, int partType) {
        BuildManagerEntry entry = this.getEntry(project);
        for (MailBox mailBox : entry.getDependentMailBoxes()) {
            mailBox.addChange(new BuildManagerPartChange(packageName, partName, partType));
        }
    }

    public void recordPackage(IProject project, String[] packageName) {
        BuildManagerEntry entry = this.getEntry(project);
        for (MailBox mailBox : entry.getDependentMailBoxes()) {
            mailBox.addChange(new BuildManagerPackageChange(packageName));
        }
    }

    public BuildManagerChange[] getChanges(IProject project) {
        BuildManagerEntry entry = this.getEntry(project);
        return entry.getMailBox().getChanges();
    }

    public boolean isFullBuildRequired(IProject project) {
        BuildManagerEntry entry = this.getEntry(project);
        return entry.getMailBox().isFull();
    }

    public boolean getProjectState(IProject project) {
        BuildManagerEntry entry = this.getEntry(project);
        return entry.getState() == 2;
    }

    public String[] getRequiredProjects(IProject project) {
        BuildManagerEntry entry = this.getEntry(project);
        return entry.getRequiredProjects();
    }

    public BuildPathEntry[] getPathEntries(IProject project) {
        BuildManagerEntry entry = this.getEntry(project);
        return entry.getPathEntries();
    }

    public String[] getSourceLocations(IProject project) {
        BuildManagerEntry entry = this.getEntry(project);
        return entry.getSourceLocations();
    }

    public String getOutputLocation(IProject project) {
        BuildManagerEntry entry = this.getEntry(project);
        return entry.getOutputLocation();
    }

    public String getCompilerId(IProject project) {
        BuildManagerEntry entry = this.getEntry(project);
        return entry.getCompilerId();
    }

    public void setProjectState(IProject project, boolean state) {
        BuildManagerEntry entry = this.getEntry(project);
        entry.setState(state ? 2 : -1);
        this.save();
    }

    private void save() {
        File file = BUILD_MANAGER_SAVED_FILE.toFile();
        try {
            ObjectOutputStream outputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                outputStream.writeObject(this.projectMap);
            }
            finally {
                outputStream.close();
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void clear(IProject project) {
        BuildManagerEntry entry = this.getEntry(project);
        entry.setState(-1);
        entry.getMailBox().clear();
        entry.setRequiredProjects(NO_REQUIRED_PROJECTS);
        entry.setSourceLocations(NO_SOURCE_LOCATIONS);
        entry.setOutputLocation("");
        entry.setPathEntries(NO_EGLPATH_ENTRIES);
        entry.setCompilerId("");
        this.removeDependentProject(entry);
        this.save();
    }

    private void removeDependentProject(BuildManagerEntry entry) {
        MailBox mailBox = entry.getMailBox();
        for (BuildManagerEntry otherEntry : this.projectMap.values()) {
            otherEntry.getDependentMailBoxes().remove(mailBox);
        }
    }

    public void removeProject(IProject project) {
        BuildManagerEntry entry = this.getEntry(project);
        this.removeDependentProject(entry);
        this.projectMap.remove(project.getName());
        this.save();
    }

    public void clearAll() {
        this.projectMap.clear();
        BUILD_MANAGER_SAVED_FILE.toFile().delete();
    }

    public int getCount() {
        return this.projectMap.size();
    }

    static /* synthetic */ String[] access$0() {
        return NO_REQUIRED_PROJECTS;
    }

    static /* synthetic */ String[] access$1() {
        return NO_SOURCE_LOCATIONS;
    }

    static /* synthetic */ BuildPathEntry[] access$2() {
        return NO_EGLPATH_ENTRIES;
    }

    private static class BuildManagerEntry
    implements Serializable {
        private HashSet mailBoxes = new HashSet();
        private MailBox mailBox;
        private int state = -1;
        private String[] requiredProjects = BuildManager.access$0();
        private String[] sourceLocations = BuildManager.access$1();
        private String outputLocation = "";
        private BuildPathEntry[] pathEntries = BuildManager.access$2();
        private String compilerId = "";

        public BuildManagerEntry() {
            this.mailBox = new MailBox();
        }

        public Set getDependentMailBoxes() {
            return this.mailBoxes;
        }

        public MailBox getMailBox() {
            return this.mailBox;
        }

        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
        }

        public String[] getRequiredProjects() {
            return this.requiredProjects;
        }

        public void setRequiredProjects(String[] requiredProjects) {
            this.requiredProjects = requiredProjects;
        }

        public BuildPathEntry[] getPathEntries() {
            return this.pathEntries;
        }

        public void setPathEntries(BuildPathEntry[] pathEntries) {
            this.pathEntries = pathEntries;
        }

        public String[] getSourceLocations() {
            return this.sourceLocations;
        }

        public void setSourceLocations(String[] sourceLocations) {
            this.sourceLocations = sourceLocations;
        }

        public String getOutputLocation() {
            return this.outputLocation;
        }

        public void setOutputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
        }

        public String getCompilerId() {
            return this.compilerId;
        }

        public void setCompilerId(String id) {
            this.compilerId = id;
        }
    }

    public static class BuildPathEntry
    implements Serializable {
        protected static final int ENTRY_TYPE_UNKNOWN = -1;
        protected static final int ENTRY_TYPE_PROJECT = 1;
        protected static final int ENTRY_TYPE_ZIPFILE = 2;
        private int type = -1;
        private String id = "";

        public BuildPathEntry(int type, String id) {
            this.type = type;
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }
    }

    private static class MailBox
    implements Serializable {
        private ArrayList changes = new ArrayList();
        private boolean full = false;

        private MailBox() {
        }

        public boolean isFull() {
            return this.full;
        }

        public void addChange(BuildManagerChange entry) {
            if (!this.full) {
                this.changes.add(entry);
                if (this.changes.size() >= 1000) {
                    this.changes.clear();
                    this.full = true;
                }
            }
        }

        public BuildManagerChange[] getChanges() {
            return this.changes.toArray(new BuildManagerChange[this.changes.size()]);
        }

        public void clear() {
            this.full = false;
            this.changes = new ArrayList();
        }
    }
}

