/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.generation;

import com.ibm.icu.util.StringTokenizer;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.compiler.internal.core.builder.NullBuildNotifier;
import org.eclipse.edt.compiler.internal.interfaces.IGenerationMessageRequestor;
import org.eclipse.edt.compiler.internal.util.EGLMessage;
import org.eclipse.edt.compiler.internal.util.IGenerationResultsMessage;
import org.eclipse.edt.ide.core.CoreIDEPluginStrings;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.edt.ide.core.Logger;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfo;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfoManager;
import org.eclipse.edt.ide.core.internal.utils.StringOutputBuffer;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.mof.egl.InvalidPartTypeException;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PartNotFoundException;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;

public class GenerationQueue {
    protected LinkedHashMap<GenerationUnitKey, GenerationUnit> pendingUnits;
    protected IBuildNotifier notifier;
    protected ProjectInfo projectInfo;
    protected ProjectEnvironment projectEnvironment;
    protected int unitsGenerated;
    private int generateThreshold;
    private float increment;
    public long startTime;
    public static final boolean DEBUG = false;

    public GenerationQueue(IBuildNotifier notifier, IProject project) {
        this.notifier = notifier == null ? NullBuildNotifier.getInstance() : notifier;
        this.pendingUnits = new LinkedHashMap();
        this.increment = 0.4f;
        this.projectInfo = ProjectInfoManager.getInstance().getProjectInfo(project);
        this.projectEnvironment = ProjectEnvironmentManager.getInstance().getProjectEnvironment(project);
    }

    public void addPart(String[] packageName, String caseSensitiveInternedPartName) {
        this.pendingUnits.put(new GenerationUnitKey(packageName, InternUtil.intern((String)caseSensitiveInternedPartName)), new GenerationUnit(packageName, caseSensitiveInternedPartName));
    }

    public void generate() {
        this.initProgress();
        while (!this.pendingUnits.isEmpty()) {
            this.notifier.checkCancel();
            Iterator<GenerationUnit> iterator = this.pendingUnits.values().iterator();
            GenerationUnit genUnit = iterator.next();
            this.generate(genUnit);
        }
    }

    private void initProgress() {
        this.generateThreshold = this.pendingUnits.size();
        this.unitsGenerated = 0;
        if (this.generateThreshold > 0) {
            this.notifier.setProgressPerEGLPart(this.increment / (float)this.generateThreshold);
        }
        this.increment /= 2.0f;
    }

    private void updateProgress() {
        this.notifier.compiled();
        ++this.unitsGenerated;
        if (this.unitsGenerated == this.generateThreshold && !this.pendingUnits.isEmpty()) {
            this.initProgress();
        }
    }

    private void generate(GenerationUnit genUnit) {
        IFile file;
        IGenerationMessageRequestor messageRequestor;
        block18: {
            this.pendingUnits.remove(new GenerationUnitKey(genUnit.packageName, InternUtil.intern((String)genUnit.caseSensitiveInternedPartName)));
            this.notifier.subTask(CoreIDEPluginStrings.bind((String)CoreIDEPluginStrings.GeneratePartsOperation_SubTaskName, (Object)genUnit.caseSensitiveInternedPartName));
            messageRequestor = GenerationQueue.createMessageRequestor();
            file = null;
            try {
                IGenerator[] generators;
                if (this.projectInfo.hasPart(genUnit.packageName, genUnit.caseSensitiveInternedPartName) == 1 || (file = this.projectInfo.getPartOrigin(genUnit.packageName, genUnit.caseSensitiveInternedPartName).getEGLFile()) == null || !file.exists() || (generators = ProjectSettingsUtility.getGenerators((IResource)file)).length == 0) break block18;
                try {
                    Environment.pushEnv((IEnvironment)this.projectEnvironment.getIREnvironment());
                    Part part = this.projectEnvironment.findPart(InternUtil.intern((String[])genUnit.packageName), InternUtil.intern((String)genUnit.caseSensitiveInternedPartName));
                    if (part != null && !part.hasCompileErrors().booleanValue()) {
                        this.invokeGenerators(file, part, messageRequestor, generators, (IEnvironment)this.projectEnvironment.getIREnvironment());
                    }
                }
                finally {
                    Environment.popEnv();
                }
            }
            catch (PartNotFoundException e) {
                this.buildPartNotFoundMessage(e, messageRequestor, genUnit.caseSensitiveInternedPartName);
            }
            catch (RuntimeException e) {
                this.handleRuntimeException(e, messageRequestor, genUnit.caseSensitiveInternedPartName, new HashSet());
            }
            catch (Exception e) {
                this.handleUnknownException(e, messageRequestor);
            }
        }
        if (file != null && file.exists()) {
            try {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = file.findMarkers(EDTCoreIDEPlugin.GENERATION_PROBLEM, true, 1);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    String attr = InternUtil.intern((String)marker.getAttribute("partName", ""));
                    if (attr == genUnit.caseSensitiveInternedPartName) {
                        marker.delete();
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                EDTCoreIDEPlugin.log(e);
            }
            for (IGenerationResultsMessage msg : messageRequestor.getMessages()) {
                if (!msg.isError() && !msg.isWarning()) continue;
                try {
                    IMarker marker = file.createMarker(EDTCoreIDEPlugin.GENERATION_PROBLEM);
                    marker.setAttribute("lineNumber", msg.getStartLine());
                    marker.setAttribute("severity", msg.isError() ? 2 : 1);
                    marker.setAttribute("message", (Object)msg.getBuiltMessage());
                    marker.setAttribute("charStart", msg.getStartOffset());
                    marker.setAttribute("charEnd", msg.getEndOffset());
                    marker.setAttribute("partName", (Object)genUnit.caseSensitiveInternedPartName);
                }
                catch (CoreException e) {
                    throw new BuildException((Throwable)e);
                }
            }
        } else {
            for (IGenerationResultsMessage msg : messageRequestor.getMessages()) {
                if (!msg.isError()) continue;
                EDTCoreIDEPlugin.logErrorMessage(msg.getBuiltMessage());
            }
        }
        this.updateProgress();
    }

    private void invokeGenerators(IFile file, Part part, IGenerationMessageRequestor messageRequestor, IGenerator[] generators, IEnvironment env) throws Exception {
        int i = 0;
        while (i < generators.length) {
            try {
                generators[i].generate(file.getFullPath().toString(), (Part)part.clone(), env, messageRequestor);
            }
            catch (RuntimeException e) {
                this.handleRuntimeException(e, messageRequestor, part.getId(), new HashSet());
            }
            catch (Exception e) {
                this.handleUnknownException(e, messageRequestor);
            }
            ++i;
        }
    }

    protected void handleRuntimeException(RuntimeException e, IGenerationMessageRequestor messageRequestor, String partName, HashSet seen) {
        if (seen.contains(e)) {
            this.handleUnknownException(e, messageRequestor);
            return;
        }
        seen.add(e);
        Throwable cause = e.getCause();
        if (cause instanceof PartNotFoundException) {
            this.buildPartNotFoundMessage((PartNotFoundException)cause, messageRequestor, partName);
            return;
        }
        if (cause instanceof InvalidPartTypeException) {
            this.buildInvalidPartTypeMessage((InvalidPartTypeException)cause, messageRequestor, partName);
            return;
        }
        if (cause instanceof RuntimeException) {
            this.handleRuntimeException((RuntimeException)cause, messageRequestor, partName, seen);
            return;
        }
        this.handleUnknownException(e, messageRequestor);
    }

    protected void handleUnknownException(Exception e, IGenerationMessageRequestor messageRequestor) {
        this.buildExceptionMessage(e, messageRequestor);
        GenerationQueue.buildStackTraceMessages(e, messageRequestor);
        Logger.log(this, "GenerationQueue.generate():  Error during generation", e);
    }

    protected void buildPartNotFoundMessage(PartNotFoundException e, IGenerationMessageRequestor result, String partName) {
        EGLMessage message = EGLMessage.createEGLValidationErrorMessage((String)"9001", null, (String[])new String[]{partName, e.getMessage()});
        result.addMessage((IGenerationResultsMessage)message);
    }

    protected void buildInvalidPartTypeMessage(InvalidPartTypeException e, IGenerationMessageRequestor result, String partName) {
        EGLMessage message = EGLMessage.createEGLValidationErrorMessage((String)"9001", null, (String[])new String[]{partName, e.getMessage()});
        result.addMessage((IGenerationResultsMessage)message);
    }

    public void buildExceptionMessage(Exception e, IGenerationMessageRequestor result) {
        String text = e.getMessage();
        if (text != null) {
            EGLMessage message = EGLMessage.createEGLValidationErrorMessage((String)"9998", null, (String)text);
            result.addMessage((IGenerationResultsMessage)message);
        }
    }

    public static void buildStackTraceMessages(Throwable e, IGenerationMessageRequestor result) {
        StringOutputBuffer buffer = new StringOutputBuffer();
        PrintWriter writer = new PrintWriter(buffer);
        e.printStackTrace(writer);
        writer.flush();
        String text = buffer.toString();
        StringTokenizer tokenizer = new StringTokenizer(text, "\n\r\f");
        while (tokenizer.hasMoreElements()) {
            char[] token = tokenizer.nextToken().toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            int i = 0;
            while (i < token.length) {
                if (token[i] == '\t') {
                    stringBuffer.append("      ");
                } else {
                    stringBuffer.append(token[i]);
                }
                ++i;
            }
            EGLMessage message = EGLMessage.createEGLValidationErrorMessage((String)"9999", null, (String)stringBuffer.toString());
            result.addMessage((IGenerationResultsMessage)message);
        }
    }

    protected static IGenerationMessageRequestor createMessageRequestor() {
        return new IGenerationMessageRequestor(){
            ArrayList<IGenerationResultsMessage> list = new ArrayList();
            boolean error;

            public void addMessage(IGenerationResultsMessage message) {
                this.list.add(message);
                if (message.isError()) {
                    this.error = true;
                }
            }

            public void addMessages(List<IGenerationResultsMessage> list) {
                Iterator<IGenerationResultsMessage> i = list.iterator();
                while (i.hasNext()) {
                    this.addMessage(i.next());
                }
            }

            public List<IGenerationResultsMessage> getMessages() {
                return this.list;
            }

            public boolean isError() {
                return this.error;
            }

            public void clear() {
                this.error = false;
                this.list = new ArrayList();
            }
        };
    }

    public class GenerationUnit {
        public String[] packageName;
        public String caseSensitiveInternedPartName;

        GenerationUnit(String[] packageName, String caseSensitiveInternedPartName) {
            this.packageName = packageName;
            this.caseSensitiveInternedPartName = caseSensitiveInternedPartName;
        }
    }

    public class GenerationUnitKey {
        private String[] packageName;
        private String caseInsensitiveInternedPartName;

        public GenerationUnitKey(String[] packageName, String caseInsensitiveInternedPartName) {
            this.packageName = packageName;
            this.caseInsensitiveInternedPartName = caseInsensitiveInternedPartName;
        }

        public boolean equals(Object otherObject) {
            if (this == otherObject) {
                return true;
            }
            if (otherObject instanceof GenerationUnitKey) {
                GenerationUnitKey otherGUKey = (GenerationUnitKey)otherObject;
                return otherGUKey.packageName == this.packageName && otherGUKey.caseInsensitiveInternedPartName == this.caseInsensitiveInternedPartName;
            }
            return false;
        }

        public int hashCode() {
            return this.caseInsensitiveInternedPartName.hashCode();
        }
    }
}

