/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.internal.model.EGLPathEntry;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.NameLookup;
import org.eclipse.edt.ide.core.internal.model.OpenableElementInfo;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;

class EGLProjectElementInfo
extends OpenableElementInfo {
    protected NameLookup fNameLookup = null;
    private Object[] fNonEGLResources = null;

    private Object[] computeNonEGLResources(EGLProject project) {
        IPath projectPath = project.getProject().getFullPath();
        boolean srcIsProject = false;
        char[][] exclusionPatterns = null;
        IEGLPathEntry[] classpath = null;
        IPath projectOutput = null;
        try {
            classpath = project.getResolvedEGLPath(true);
            int i = 0;
            while (i < classpath.length) {
                IEGLPathEntry entry = classpath[i];
                if (projectPath.equals((Object)entry.getPath())) {
                    srcIsProject = true;
                    exclusionPatterns = ((EGLPathEntry)entry).fullExclusionPatternChars();
                    break;
                }
                ++i;
            }
            projectOutput = project.getOutputLocation();
            projectPath.equals((Object)projectOutput);
        }
        catch (EGLModelException eGLModelException) {}
        Object[] nonEGLResources = new IResource[5];
        int nonEGLResourcesCounter = 0;
        try {
            IResource[] members = ((IContainer)project.getResource()).members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource res = members[i];
                switch (res.getType()) {
                    case 1: {
                        IPath resFullPath = res.getFullPath();
                        String resName = res.getName();
                        if (Util.isEGLFileName(resName) && this.isEGLPathEntryOrOutputLocation(resFullPath, classpath, projectOutput)) break;
                        if (nonEGLResources.length == nonEGLResourcesCounter) {
                            Object[] objectArray = nonEGLResources;
                            nonEGLResources = new IResource[nonEGLResourcesCounter * 2];
                            System.arraycopy(objectArray, 0, nonEGLResources, 0, nonEGLResourcesCounter);
                        }
                        nonEGLResources[nonEGLResourcesCounter++] = res;
                        break;
                    }
                    case 2: {
                        IPath resFullPath = res.getFullPath();
                        if (srcIsProject && !Util.isExcluded(res, exclusionPatterns) && Util.isValidFolderNameForPackage(res.getName()) || this.isEGLPathEntryOrOutputLocation(resFullPath, classpath, projectOutput) || this.isEGLbinOutputLocation(resFullPath)) break;
                        if (nonEGLResources.length == nonEGLResourcesCounter) {
                            Object[] objectArray = nonEGLResources;
                            nonEGLResources = new IResource[nonEGLResourcesCounter * 2];
                            System.arraycopy(objectArray, 0, nonEGLResources, 0, nonEGLResourcesCounter);
                        }
                        nonEGLResources[nonEGLResourcesCounter++] = res;
                    }
                }
                ++i;
            }
            if (nonEGLResources.length != nonEGLResourcesCounter) {
                Object[] objectArray = nonEGLResources;
                nonEGLResources = new IResource[nonEGLResourcesCounter];
                System.arraycopy(objectArray, 0, nonEGLResources, 0, nonEGLResourcesCounter);
            }
        }
        catch (CoreException coreException) {
            nonEGLResources = NO_NON_EGL_RESOURCES;
            nonEGLResourcesCounter = 0;
        }
        return nonEGLResources;
    }

    protected NameLookup getNameLookup() {
        return this.fNameLookup;
    }

    Object[] getNonEGLResources(EGLProject project) {
        Object[] nonEGLResources = this.fNonEGLResources;
        if (nonEGLResources == null) {
            nonEGLResources = this.computeNonEGLResources(project);
            this.fNonEGLResources = nonEGLResources;
        }
        return nonEGLResources;
    }

    private boolean isEGLPathEntryOrOutputLocation(IPath path, IEGLPathEntry[] resolvedClasspath, IPath projectOutput) {
        if (projectOutput.equals((Object)path)) {
            return true;
        }
        int i = 0;
        int length = resolvedClasspath.length;
        while (i < length) {
            IEGLPathEntry entry = resolvedClasspath[i];
            if (entry.getPath().equals((Object)path)) {
                return true;
            }
            IPath output = entry.getOutputLocation();
            if (output != null && output.equals((Object)path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isEGLbinOutputLocation(IPath path) {
        return path.lastSegment().equalsIgnoreCase("EGLbin");
    }

    protected void setNameLookup(NameLookup newNameLookup) {
        this.fNameLookup = newNameLookup;
    }

    synchronized void setNonEGLResources(Object[] resources) {
        this.fNonEGLResources = resources;
    }
}

