/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import org.eclipse.datatools.connectivity.oda.flatfile.InvalidResourceException;
import org.eclipse.datatools.connectivity.oda.flatfile.ResourceInputStream;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;
import org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers;

public final class ResourceLocator {
    public static ResourceInputStream getResourceInputStream(String homeFolder, String table, String fileURI, Object resourceIdentifiers) throws InvalidResourceException {
        if (homeFolder == null && fileURI == null) {
            throw new InvalidResourceException(2, Messages.getString("connection_MISSING_FILELLOCATION"));
        }
        ResourceInputStream stream = ResourceLocator.getResourceInputStream(fileURI, resourceIdentifiers);
        if (stream != null) {
            return stream;
        }
        stream = ResourceLocator.getResourceInputStream(homeFolder, table);
        return stream;
    }

    public static void validate(String homeFolder, String table, String fileURI, ResourceIdentifiers resourceIdentifiers) throws InvalidResourceException {
        ResourceInputStream in = null;
        try {
            in = ResourceLocator.getResourceInputStream(homeFolder, table, fileURI, resourceIdentifiers);
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static ResourceInputStream getResourceInputStream(String homeFolder, String table) throws InvalidResourceException {
        ResourceInputStream stream = null;
        if (homeFolder != null) {
            ResourceLocator.validateHomeFolder(homeFolder);
            if (table == null) {
                return null;
            }
            File file = new File(String.valueOf(homeFolder) + File.separator + table.trim());
            if (!file.exists()) {
                throw new InvalidResourceException(1, String.valueOf(Messages.getString("query_invalidTableName")) + homeFolder + File.separator + table);
            }
            try {
                stream = new ResourceInputStream(new FileInputStream(file), file.getAbsolutePath());
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new InvalidResourceException(1, String.valueOf(Messages.getString("query_invalidTableName")) + homeFolder + File.separator + table);
            }
        }
        return stream;
    }

    public static ResourceInputStream getResourceInputStream(String fileURI, Object resourceIdentifiers) throws InvalidResourceException {
        ResourceInputStream stream = null;
        if (fileURI != null) {
            try {
                URI uri = new URI(ResourceLocator.convertURI(fileURI));
                if (uri.getScheme() == null && resourceIdentifiers != null) {
                    URI uriResolved = (URI)resourceIdentifiers.getClass().getMethod("resolveApplResource", URI.class).invoke(resourceIdentifiers, uri);
                    uri = uriResolved == null ? uri : uriResolved;
                }
                stream = new ResourceInputStream(uri.toURL().openStream(), fileURI);
            }
            catch (Exception e) {
                throw new InvalidResourceException(1, MessageFormat.format((String)Messages.getString("connection_CANNOT_OPEN_FLAT_FILE_URI"), (Object[])new Object[]{fileURI, e}));
            }
        }
        return stream;
    }

    private static String convertURI(String fileURL) {
        return fileURL.replace('\\', '/');
    }

    public static void validateFileURI(String fileURI, ResourceIdentifiers ri) throws InvalidResourceException {
        if (fileURI == null) {
            throw new InvalidResourceException(2, Messages.getString("connection_MISSING_FILEURI"));
        }
        ResourceInputStream stream = null;
        try {
            stream = ResourceLocator.getResourceInputStream(fileURI, ri);
        }
        catch (Throwable throwable) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void validateHomeFolder(String homeFolder) throws InvalidResourceException {
        if (homeFolder == null) {
            throw new InvalidResourceException(2, Messages.getString("connection_MISSING_HOMEFOLDER"));
        }
        File file = new File(homeFolder);
        if (!file.exists()) {
            throw new InvalidResourceException(1, String.valueOf(Messages.getString("connection_CANNOT_OPEN_FLAT_FILE_DB_DIR")) + homeFolder);
        }
    }
}

