/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model.provisional;

import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;

public class ModelDelta
implements IModelDelta {
    private IModelDelta fParent;
    private Object fElement;
    private int fFlags;
    private ModelDelta[] fNodes = EMPTY_NODES;
    private Object fReplacement;
    private int fIndex = -1;
    private int fChildCount = -1;
    private static final ModelDelta[] EMPTY_NODES = new ModelDelta[0];

    public ModelDelta(Object element, int flags) {
        this.fElement = element;
        this.fFlags = flags;
    }

    public ModelDelta(Object element, Object replacement, int flags) {
        this.fElement = element;
        this.fReplacement = replacement;
        this.fFlags = flags;
    }

    public ModelDelta(Object element, int index, int flags) {
        this.fElement = element;
        this.fIndex = index;
        this.fFlags = flags;
    }

    public ModelDelta(Object element, int index, int flags, int childCount) {
        this.fElement = element;
        this.fIndex = index;
        this.fFlags = flags;
        this.fChildCount = childCount;
    }

    public Object getElement() {
        return this.fElement;
    }

    public int getFlags() {
        return this.fFlags;
    }

    public ModelDelta addNode(Object element, int flags) {
        ModelDelta node = new ModelDelta(element, flags);
        node.setParent(this);
        this.addDelta(node);
        return node;
    }

    public ModelDelta getChildDelta(Object element) {
        if (this.fNodes != null) {
            int i = 0;
            while (i < this.fNodes.length) {
                ModelDelta delta = this.fNodes[i];
                if (element.equals(delta.getElement())) {
                    return delta;
                }
                ++i;
            }
        }
        return null;
    }

    public ModelDelta addNode(Object element, Object replacement, int flags) {
        ModelDelta node = new ModelDelta(element, replacement, flags);
        node.setParent(this);
        this.addDelta(node);
        return node;
    }

    public ModelDelta addNode(Object element, int index, int flags) {
        ModelDelta node = new ModelDelta(element, index, flags);
        node.setParent(this);
        this.addDelta(node);
        return node;
    }

    public ModelDelta addNode(Object element, int index, int flags, int numChildren) {
        ModelDelta node = new ModelDelta(element, index, flags, numChildren);
        node.setParent(this);
        this.addDelta(node);
        return node;
    }

    void setParent(ModelDelta node) {
        this.fParent = node;
    }

    public IModelDelta getParentDelta() {
        return this.fParent;
    }

    public Object getReplacementElement() {
        return this.fReplacement;
    }

    public int getIndex() {
        return this.fIndex;
    }

    public IModelDelta[] getChildDeltas() {
        return this.fNodes;
    }

    private void addDelta(ModelDelta delta) {
        if (this.fNodes.length == 0) {
            this.fNodes = new ModelDelta[]{delta};
        } else {
            ModelDelta[] nodes = new ModelDelta[this.fNodes.length + 1];
            System.arraycopy(this.fNodes, 0, nodes, 0, this.fNodes.length);
            nodes[this.fNodes.length] = delta;
            this.fNodes = nodes;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Model Delta Start\n");
        this.appendDetail("  ", buf, this);
        buf.append("Model Delta End\n");
        return buf.toString();
    }

    private void appendDetail(String indent, StringBuffer buf, IModelDelta delta) {
        buf.append(indent);
        buf.append("Element: ");
        buf.append(delta.getElement());
        buf.append('\n');
        buf.append(indent);
        buf.append("    Flags: ");
        int flags = delta.getFlags();
        if (flags == 0) {
            buf.append("NO_CHANGE");
        } else {
            if ((flags & 1) > 0) {
                buf.append("ADDED | ");
            }
            if ((flags & 0x400) > 0) {
                buf.append("CONTENT | ");
            }
            if ((flags & 0x2000000) > 0) {
                buf.append("COLLAPSE | ");
            }
            if ((flags & 0x100000) > 0) {
                buf.append("EXPAND | ");
            }
            if ((flags & 0x10) > 0) {
                buf.append("INSERTED | ");
            }
            if ((flags & 2) > 0) {
                buf.append("REMOVED | ");
            }
            if ((flags & 8) > 0) {
                buf.append("REPLACED | ");
            }
            if ((flags & 0x200000) > 0) {
                buf.append("SELECT | ");
            }
            if ((flags & 0x800) > 0) {
                buf.append("STATE | ");
            }
            if ((flags & 0x400000) > 0) {
                buf.append("INSTALL | ");
            }
            if ((flags & 0x800000) > 0) {
                buf.append("UNINSTALL | ");
            }
            if ((flags & 0x1000000) > 0) {
                buf.append("REVEAL | ");
            }
            if ((flags & 0x4000000) > 0) {
                buf.append("FORCE | ");
            }
        }
        buf.append('\n');
        buf.append(indent);
        buf.append("    Index: ");
        buf.append(delta.getIndex());
        buf.append(" Child Count: ");
        buf.append(delta.getChildCount());
        buf.append('\n');
        IModelDelta[] nodes = delta.getChildDeltas();
        int i = 0;
        while (i < nodes.length) {
            this.appendDetail(String.valueOf(indent) + "  ", buf, nodes[i]);
            ++i;
        }
    }

    public int getChildCount() {
        return this.fChildCount;
    }

    public void accept(IModelDeltaVisitor visitor) {
        this.doAccept(visitor, 0);
    }

    protected void doAccept(IModelDeltaVisitor visitor, int depth) {
        if (visitor.visit(this, depth)) {
            IModelDelta[] childDeltas = this.getChildDeltas();
            int i = 0;
            while (i < childDeltas.length) {
                ((ModelDelta)childDeltas[i]).doAccept(visitor, depth + 1);
                ++i;
            }
        }
    }

    public void setElement(Object element) {
        this.fElement = element;
    }

    public void setFlags(int flags) {
        this.fFlags = flags;
    }

    public void setIndex(int index) {
        this.fIndex = index;
    }

    public void setChildCount(int count) {
        this.fChildCount = count;
    }
}

