/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.utils;

import org.eclipse.edt.mof.egl.utils.InternUtil;

class StringArrayInternUtil {
    private String[][] stringArrays;
    private int size;
    private int capacity;
    private int threshold;

    public StringArrayInternUtil(int size) {
        if (size < 37) {
            size = 37;
        }
        this.stringArrays = new String[(int)((float)size * 1.5f)][];
        this.capacity = this.stringArrays.length;
        this.threshold = size;
    }

    public String[] intern(String[] stringArray) {
        String[] probe;
        if (stringArray.length == 0) {
            return InternUtil.EMPTY_STRING_ARRAY;
        }
        int index = this.hashCode(stringArray) % this.capacity;
        while ((probe = this.stringArrays[index]) != null) {
            if (this.equalsIgnoreCase(stringArray, probe)) {
                return probe;
            }
            if (++index != this.capacity) continue;
            index = 0;
        }
        int i = 0;
        while (i < stringArray.length) {
            stringArray[i] = InternUtil.intern(stringArray[i]);
            ++i;
        }
        this.stringArrays[index] = stringArray;
        if (++this.size == this.threshold) {
            this.rehash();
        }
        return stringArray;
    }

    private int hashCode(String[] stringArray) {
        String lastComponent = stringArray[stringArray.length - 1];
        int result = 0;
        char[] charArray = lastComponent.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            char current = charArray[i];
            result = 31 * result + Character.toLowerCase(Character.toUpperCase(current));
            ++i;
        }
        return result & Integer.MAX_VALUE;
    }

    private boolean equalsIgnoreCase(String[] stringArray1, String[] stringArray2) {
        if (stringArray1.length != stringArray2.length) {
            return false;
        }
        int i = 0;
        while (i < stringArray1.length) {
            if (!stringArray1[i].equalsIgnoreCase(stringArray2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void rehash() {
        int newCapacity = this.capacity * 2;
        String[][] newStringArrays = new String[newCapacity][];
        int i = 0;
        while (i < this.stringArrays.length) {
            String[] current = this.stringArrays[i];
            if (current != null) {
                int index = this.hashCode(current) % newCapacity;
                while (newStringArrays[index] != null) {
                    if (++index != newCapacity) continue;
                    index = 0;
                }
                newStringArrays[index] = current;
            }
            ++i;
        }
        this.stringArrays = newStringArrays;
        this.capacity = newCapacity;
        this.threshold *= 2;
    }
}

