/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.egl.utils;

class StringInternUtil {
    private String[] strings;
    private int size;
    private int capacity;
    private int threshold;

    public StringInternUtil(int size) {
        if (size < 37) {
            size = 37;
        }
        this.strings = new String[(int)((float)size * 1.5f)];
        this.capacity = this.strings.length;
        this.threshold = size;
    }

    public String intern(String string) {
        String probe;
        int index = this.hashCode(string) % this.capacity;
        while ((probe = this.strings[index]) != null) {
            if (string.equalsIgnoreCase(probe)) {
                return probe;
            }
            if (++index != this.capacity) continue;
            index = 0;
        }
        this.strings[index] = string;
        if (++this.size == this.threshold) {
            this.rehash();
        }
        return string;
    }

    private int hashCode(String string) {
        int result = 0;
        char[] charArray = string.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            char current = charArray[i];
            result = 31 * result + Character.toLowerCase(Character.toUpperCase(current));
            ++i;
        }
        return result & Integer.MAX_VALUE;
    }

    private void rehash() {
        int newCapacity = this.capacity * 2;
        String[] newStrings = new String[newCapacity];
        int i = 0;
        while (i < this.strings.length) {
            String current = this.strings[i];
            if (current != null) {
                int index = this.hashCode(current) % newCapacity;
                while (newStrings[index] != null) {
                    if (++index != newCapacity) continue;
                    index = 0;
                }
                newStrings[index] = current;
            }
            ++i;
        }
        this.strings = newStrings;
        this.capacity = newCapacity;
        this.threshold *= 2;
    }
}

