/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates;

import java.util.List;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.ArrayLiteral;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.IRUtils;

public class ArrayLiteralTemplate
extends JavaScriptTemplate {
    public void genExpression(ArrayLiteral expr, Context ctx, TabbedWriter out) {
        this.genExpr(expr, ctx, out, null);
    }

    public void genTypeBasedExpression(ArrayLiteral expr, Context ctx, TabbedWriter out, Type arg) {
        this.genExpr(expr, ctx, out, arg);
    }

    private void genExpr(ArrayLiteral expr, Context ctx, TabbedWriter out, Type arg) {
        out.print("[");
        if (arg != null) {
            List entries = expr.getEntries();
            Type elementType = ((ArrayType)arg).getElementType();
            boolean firstElement = true;
            for (Expression element : entries) {
                if (firstElement) {
                    firstElement = false;
                } else {
                    out.print(", ");
                }
                ctx.invoke("genExpression", (EObject)IRUtils.makeExprCompatibleToType((Expression)element, (Type)elementType), new Object[]{ctx, out});
            }
        } else {
            ctx.foreach(expr.getEntries(), ',', "genExpression", new Object[]{ctx, out});
        }
        out.print("]");
        if (!expr.getEntries().isEmpty()) {
            out.print(".setType(");
            out.print("\"");
            Expression expression = (Expression)expr.getEntries().get(0);
            ctx.invoke("genSignature", expr.getType(), new Object[]{ctx, out, expression});
            out.print("\"");
            out.print(")");
        }
    }
}

