/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.providers.content.virtual;

import java.util.ArrayList;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.filter.IFilterNode;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.IUDTNode;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.icons.ImageDescription;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.providers.content.virtual.AddObjectRegistry;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.providers.content.virtual.VirtualNode;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IAddObjectProvider;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataTypesPackage;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.resource.ImageDescriptor;

public class UDTNode
extends VirtualNode
implements IUDTNode,
IFilterNode {
    protected boolean isStructuredUDTSupported;
    protected boolean isArrayTypeSupported;
    protected boolean isRowTypeSupported;
    protected boolean isDistinctTypeSupported = this.isDistinctTypeSupported();
    protected ImageDescriptor addObjectDescriptor = null;
    protected String addObjectLabel = null;
    protected EClass addObjectEClass = null;

    public UDTNode(String name, String displayName, Object parent) {
        super(name, displayName, parent);
        this.isStructuredUDTSupported = this.isStructuredUserDefinedTypeSupported();
        this.isArrayTypeSupported = this.isArrayTypeSupported();
        this.isRowTypeSupported = this.isRowTypeSupported();
        IAddObjectProvider provider = AddObjectRegistry.INSTANCE.getProvider(this);
        if (provider != null) {
            this.setAddedObjectValues(provider);
        }
    }

    public String getGroupID() {
        return "core.sql.datatypes.UserDefinedType";
    }

    public String getFilterName() {
        return this.getFilterName("DatatoolsUDTFilterPredicate");
    }

    public ImageDescriptor[] getCreateImageDescriptor() {
        ArrayList<ImageDescriptor> imageDescriptors = new ArrayList<ImageDescriptor>();
        if (this.isDistinctTypeSupported) {
            imageDescriptors.add(ImageDescription.getUDTDescriptor());
        }
        if (this.isStructuredUDTSupported) {
            imageDescriptors.add(ImageDescription.getUDTDescriptor());
        }
        if (this.isArrayTypeSupported) {
            imageDescriptors.add(ImageDescription.getUDTDescriptor());
        }
        if (this.isRowTypeSupported) {
            imageDescriptors.add(ImageDescription.getUDTDescriptor());
        }
        if (this.addObjectDescriptor != null) {
            imageDescriptors.add(this.addObjectDescriptor);
        }
        return imageDescriptors.toArray(new ImageDescriptor[0]);
    }

    public String[] getCreateLabel() {
        ArrayList<String> labels = new ArrayList<String>();
        if (this.isDistinctTypeSupported) {
            labels.add(ResourceLoader.getResourceLoader().queryString("SCHEMA_MANAGEMENT_CREATE_DISTINCT_TYPE"));
        }
        if (this.isStructuredUDTSupported) {
            labels.add(ResourceLoader.getResourceLoader().queryString("SCHEMA_MANAGEMENT_CREATE_STRUCTURED_TYPE"));
        }
        if (this.isArrayTypeSupported) {
            labels.add(ResourceLoader.getResourceLoader().queryString("SCHEMA_MANAGEMENT_CREATE_ARRAY_TYPE"));
        }
        if (this.isRowTypeSupported) {
            labels.add(ResourceLoader.getResourceLoader().queryString("SCHEMA_MANAGEMENT_CREATE_ROW_TYPE"));
        }
        if (this.addObjectLabel != null) {
            labels.add(this.addObjectLabel);
        }
        return labels.toArray(new String[0]);
    }

    public EClass[] getCreateType() {
        ArrayList<EClass> types = new ArrayList<EClass>();
        if (this.isDistinctTypeSupported) {
            types.add(SQLDataTypesPackage.eINSTANCE.getDistinctUserDefinedType());
        }
        if (this.isStructuredUDTSupported) {
            types.add(SQLDataTypesPackage.eINSTANCE.getStructuredUserDefinedType());
        }
        if (this.isArrayTypeSupported) {
            types.add(SQLDataTypesPackage.eINSTANCE.getArrayDataType());
        }
        if (this.isRowTypeSupported) {
            types.add(SQLDataTypesPackage.eINSTANCE.getRowDataType());
        }
        if (this.addObjectEClass != null) {
            types.add(this.addObjectEClass);
        }
        return types.toArray(new EClass[0]);
    }

    public boolean shouldDisplayCreate() {
        return true;
    }

    public boolean shouldDisplayAdd() {
        return false;
    }

    protected boolean isDistinctTypeSupported() {
        Database db;
        boolean isSupported = false;
        Object parent = this.getParent();
        if (parent != null && parent instanceof Schema && (db = ((Schema)parent).getDatabase()) != null) {
            isSupported = this.isCreateDistinctTypeSupported(RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(db));
        }
        return isSupported;
    }

    protected boolean isStructuredUserDefinedTypeSupported() {
        Database db;
        boolean isSupported = false;
        Object parent = this.getParent();
        if (parent != null && parent instanceof Schema && (db = ((Schema)parent).getDatabase()) != null) {
            isSupported = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(db).supportsStructuredUserDefinedType();
        }
        return isSupported;
    }

    protected boolean isArrayTypeSupported() {
        Database db;
        boolean isSupported = false;
        Object parent = this.getParent();
        if (parent != null && parent instanceof Schema && (db = ((Schema)parent).getDatabase()) != null) {
            isSupported = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(db).supportsArrayDataType();
        }
        return isSupported;
    }

    protected boolean isRowTypeSupported() {
        Database db;
        boolean isSupported = false;
        Object parent = this.getParent();
        if (parent != null && parent instanceof Schema && (db = ((Schema)parent).getDatabase()) != null && (isSupported = this.isCreateRowTypeSupported(RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(db)))) {
            isSupported = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(db).supportsRowDataType();
        }
        return isSupported;
    }

    protected void setAddedObjectValues(IAddObjectProvider provider) {
        Object objParent = this.getParent();
        if (objParent != null) {
            this.addObjectDescriptor = provider.getCreateImageDescriptor(objParent);
            this.addObjectLabel = provider.getCreateLabel(objParent);
            this.addObjectEClass = provider.getCreateType(objParent);
        }
    }
}

