/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.utils;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.gen.deployment.javascript.Constants;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.rui.utils.EGLFileResource;
import org.eclipse.edt.ide.rui.utils.EGLResource;

public abstract class FileLocator {
    public static final List<String> RUI_DEVELOPMENT_JAVASCRIPT_FILES = new ArrayList<String>();
    public static final List<String> RUI_RUNTIME_PROPERTIES_FILES;
    protected static final String WEB_CONTENT = "WebContent";
    public static Map RUI_JAVASCRIPT_FILES;
    private List eglProjectPath;
    protected IProject project;
    private String[] resourceLocations;
    private String[] resourceLocationsInEglar;

    static {
        RUI_DEVELOPMENT_JAVASCRIPT_FILES.add("egl_development.js");
        RUI_RUNTIME_PROPERTIES_FILES = new ArrayList<String>();
        RUI_RUNTIME_PROPERTIES_FILES.add("egl/messages/RuiMessages-ar.js");
        RUI_RUNTIME_PROPERTIES_FILES.add("egl/messages/RuiMessages-cs.js");
        RUI_RUNTIME_PROPERTIES_FILES.add("egl/messages/RuiMessages-de.js");
        RUI_RUNTIME_PROPERTIES_FILES.add("egl/messages/RuiMessages-en_US.js");
        RUI_RUNTIME_PROPERTIES_FILES.add("egl/messages/RuiMessages-es.js");
        RUI_RUNTIME_PROPERTIES_FILES.add("egl/messages/RuiMessages-fr.js");
        RUI_RUNTIME_PROPERTIES_FILES.add("egl/messages/RuiMessages-hu.js");
        RUI_RUNTIME_PROPERTIES_FILES.add("egl/messages/RuiMessages-it.js");
        RUI_RUNTIME_PROPERTIES_FILES.add("egl/messages/RuiMessages-ja.js");
        RUI_RUNTIME_PROPERTIES_FILES.add("egl/messages/RuiMessages-ko.js");
        RUI_RUNTIME_PROPERTIES_FILES.add("egl/messages/RuiMessages-pl.js");
        RUI_RUNTIME_PROPERTIES_FILES.add("egl/messages/RuiMessages-pt_BR.js");
        RUI_RUNTIME_PROPERTIES_FILES.add("egl/messages/RuiMessages-ru.js");
        RUI_RUNTIME_PROPERTIES_FILES.add("egl/messages/RuiMessages-zh_HK.js");
        RUI_RUNTIME_PROPERTIES_FILES.add("egl/messages/RuiMessages-zh_TW.js");
        RUI_RUNTIME_PROPERTIES_FILES.add("egl/messages/RuiMessages-zh.js");
        RUI_JAVASCRIPT_FILES = FileLocator.getRUIJavaScriptFiles();
    }

    public FileLocator(IProject project) throws CoreException {
        this.project = project;
        this.eglProjectPath = Util.getEGLProjectPath((IProject)project);
        this.resourceLocations = this.initResourceLocations(project);
        this.resourceLocationsInEglar = this.initResourceLocationsInEglar(project);
    }

    protected FileLocator() {
    }

    public EGLResource findResource(String name) {
        EGLResource result = null;
        for (IEGLProject eglProject : this.eglProjectPath) {
            result = this.doFindResource(name, eglProject);
            if (result != null) break;
        }
        if (result == null && RUI_JAVASCRIPT_FILES.containsKey(name)) {
            result = new EGLFileResource((File)RUI_JAVASCRIPT_FILES.get(name));
        }
        return result;
    }

    protected EGLResource doFindResource(String name, IEGLProject eglProject) {
        String[] resourceLocations = this.getResourceLocations();
        int i = 0;
        while (i < resourceLocations.length) {
            String location = resourceLocations[i];
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(eglProject.getPath().append(location).append(name));
            if (file.exists()) {
                return new EGLFileResource(file.getLocation().toFile());
            }
            ++i;
        }
        return null;
    }

    private static Map<String, File> getRUIJavaScriptFiles() {
        File file;
        byte[] bytes = null;
        File allInOneFile = null;
        FileOutputStream os = null;
        try {
            allInOneFile = File.createTempFile("allInOneFile", "js");
            allInOneFile.deleteOnExit();
            os = new FileOutputStream(allInOneFile);
        }
        catch (IOException iOException) {}
        HashMap<String, File> result = new HashMap<String, File>();
        for (String fileName : RUI_DEVELOPMENT_JAVASCRIPT_FILES) {
            file = FileLocator.doGetRUIJavaScriptFile(fileName);
            if (file == null) continue;
            result.put(fileName, file);
        }
        for (String fileName : Constants.RUI_RUNTIME_JAVASCRIPT_FILES) {
            file = FileLocator.doGetRUIJavaScriptFile(fileName);
            if (file == null) continue;
            result.put(fileName, file);
            if (os == null) continue;
            try {
                DataInputStream is = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                bytes = new byte[is.available()];
                is.readFully(bytes);
                is.close();
                os.write(bytes);
                os.flush();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        }
        if (!result.containsKey("edt_runtime_all.js")) {
            result.put("edt_runtime_all.js", allInOneFile);
        }
        for (String fileName : RUI_RUNTIME_PROPERTIES_FILES) {
            file = FileLocator.doGetRUIJavaScriptFile(fileName);
            if (file == null) continue;
            result.put(fileName, file);
        }
        return result;
    }

    private static File doGetRUIJavaScriptFile(String fileName) {
        File result = null;
        IPath path = new Path("runtime").append(fileName);
        URL resource = Platform.getBundle((String)"org.eclipse.edt.runtime.javascript").getEntry(path.toOSString());
        if (resource != null) {
            try {
                File file = new File(org.eclipse.core.runtime.FileLocator.resolve((URL)resource).getFile());
                if (file.exists()) {
                    result = file;
                }
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    protected abstract String[] initResourceLocations(IProject var1) throws CoreException;

    protected abstract String[] initResourceLocationsInEglar(IProject var1) throws CoreException;

    protected String[] getResourceLocations() {
        return this.resourceLocations;
    }

    public FileComparator getFileComparator() {
        return new FileComparator();
    }

    public class FileComparator
    implements Comparator {
        private Map fileMap = new HashMap();

        private int getLocation(String fileName) {
            if (this.fileMap.containsKey(fileName)) {
                return (Integer)this.fileMap.get(fileName);
            }
            int i = 0;
            for (IEGLProject eglProject : FileLocator.this.eglProjectPath) {
                EGLResource file = FileLocator.this.doFindResource(fileName, eglProject);
                if (file != null) {
                    this.fileMap.put(fileName, new Integer(i));
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public int compare(Object arg0, Object arg1) {
            int file2Location;
            int file1Location = this.getLocation((String)arg0);
            if (file1Location < (file2Location = this.getLocation((String)arg1))) {
                return -1;
            }
            if (file1Location == file2Location) {
                return 0;
            }
            return 1;
        }
    }
}

