/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.guiutils;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class ImageContainer
extends Composite {
    private Image _image = null;
    private boolean _bCleanupImage;

    public ImageContainer(Composite parent) {
        super(parent, 0);
        this.setBackground(ColorConstants.white);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ImageContainer.this._image != null) {
                    e.gc.drawImage(ImageContainer.this._image, 0, 0);
                }
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ImageContainer.this.setSize(((ImageContainer)ImageContainer.this)._image.getBounds().width, ((ImageContainer)ImageContainer.this)._image.getBounds().height);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ImageContainer.this._bCleanupImage && ImageContainer.this._image != null && !ImageContainer.this._image.isDisposed()) {
                    ImageContainer.this._image.dispose();
                }
            }
        });
    }

    public Image getImage() {
        return this._image;
    }

    public boolean isCleanupImage() {
        return this._bCleanupImage;
    }

    public void setImage(Image image) {
        this.setImage(image, false);
    }

    public void setImage(Image image, boolean bCleanupImage) {
        this._image = image;
        this._bCleanupImage = bCleanupImage;
        this.setSize(image.getBounds().width, image.getBounds().height);
    }
}

