/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.jpa.core.JpaNode;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinColumnsComposite<T extends JpaNode>
extends Pane<T> {
    JoinColumnsEditor<T> joinColumnsEditor;
    private AddRemoveListPane<T> listPane;

    public JoinColumnsComposite(Pane<? extends T> parentPane, Composite parent, JoinColumnsEditor<T> joinColumnsEditor) {
        super(parentPane, parent);
        this.joinColumnsEditor = joinColumnsEditor;
        this.initializeLayout2();
    }

    public JoinColumnsComposite(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent, JoinColumnsEditor<T> joinColumnsEditor, boolean automaticallyAlignWidgets) {
        super(parentPane, subjectHolder, parent, automaticallyAlignWidgets);
        this.joinColumnsEditor = joinColumnsEditor;
        this.initializeLayout2();
    }

    public JoinColumnsComposite(PropertyValueModel<? extends T> subjectHolder, Composite parent, WidgetFactory widgetFactory, JoinColumnsEditor<T> joinColumnsEditor) {
        super(subjectHolder, parent, widgetFactory);
        this.joinColumnsEditor = joinColumnsEditor;
        this.initializeLayout2();
    }

    protected void initializeLayout(Composite container) {
    }

    private void initializeLayout2() {
        this.listPane = new AddRemoveListPane((Pane)this, this.getControl(), this.buildJoinColumnsAdapter(), this.buildJoinColumnsListModel(), this.buildSelectedJoinColumnHolder(), this.buildJoinColumnsListLabelProvider(), "org.eclipse.jpt.jpa.ui.mapping_joinTableJoinColumns", false);
    }

    private WritablePropertyValueModel<JoinColumn> buildSelectedJoinColumnHolder() {
        return new SimplePropertyValueModel();
    }

    String buildJoinColumnLabel(ReadOnlyJoinColumn joinColumn) {
        if (joinColumn.isDefault()) {
            return NLS.bind((String)JptUiDetailsMessages.JoinColumnsComposite_mappingBetweenTwoParamsDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedName() == null) {
            if (joinColumn.getSpecifiedReferencedColumnName() == null) {
                return NLS.bind((String)JptUiDetailsMessages.JoinColumnsComposite_mappingBetweenTwoParamsBothDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
            }
            return NLS.bind((String)JptUiDetailsMessages.JoinColumnsComposite_mappingBetweenTwoParamsFirstDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedReferencedColumnName() == null) {
            return NLS.bind((String)JptUiDetailsMessages.JoinColumnsComposite_mappingBetweenTwoParamsSecDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        return NLS.bind((String)JptUiDetailsMessages.JoinColumnsComposite_mappingBetweenTwoParams, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
    }

    private AddRemovePane.Adapter buildJoinColumnsAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                JoinColumnsComposite.this.joinColumnsEditor.addJoinColumn((JpaNode)JoinColumnsComposite.this.getSubject());
            }

            public boolean hasOptionalButton() {
                return true;
            }

            public String optionalButtonText() {
                return JptUiDetailsMessages.JoinColumnsComposite_edit;
            }

            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                JoinColumn joinColumn = (JoinColumn)listSelectionModel.selectedValue();
                JoinColumnsComposite.this.joinColumnsEditor.editJoinColumn((JpaNode)JoinColumnsComposite.this.getSubject(), (ReadOnlyJoinColumn)joinColumn);
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                JoinColumnsComposite.this.joinColumnsEditor.removeJoinColumns((JpaNode)JoinColumnsComposite.this.getSubject(), listSelectionModel.selectedIndices());
            }
        };
    }

    private ListValueModel<ReadOnlyJoinColumn> buildJoinColumnsListModel() {
        return new ItemPropertyListValueModelAdapter(this.buildJoinColumnsListHolder(), new String[]{"specifiedName", "defaultName", "specifiedReferencedColumnName", "defaultReferencedColumnName"});
    }

    private ListValueModel<ReadOnlyJoinColumn> buildJoinColumnsListHolder() {
        ArrayList<ListValueModel<ReadOnlyJoinColumn>> list = new ArrayList<ListValueModel<ReadOnlyJoinColumn>>();
        list.add(this.buildDefaultJoinColumnListHolder());
        list.add(this.buildSpecifiedJoinColumnsListHolder());
        return new CompositeListValueModel(list);
    }

    private ListValueModel<ReadOnlyJoinColumn> buildSpecifiedJoinColumnsListHolder() {
        return new ListAspectAdapter<T, ReadOnlyJoinColumn>(this.getSubjectHolder(), new String[]{this.joinColumnsEditor.getSpecifiedJoinColumnsListPropertyName()}){

            protected ListIterator<ReadOnlyJoinColumn> listIterator_() {
                return JoinColumnsComposite.this.joinColumnsEditor.specifiedJoinColumns((JpaNode)this.subject);
            }

            protected int size_() {
                return JoinColumnsComposite.this.joinColumnsEditor.specifiedJoinColumnsSize((JpaNode)this.subject);
            }
        };
    }

    private ListValueModel<ReadOnlyJoinColumn> buildDefaultJoinColumnListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultJoinColumnHolder());
    }

    private PropertyValueModel<ReadOnlyJoinColumn> buildDefaultJoinColumnHolder() {
        return new PropertyAspectAdapter<T, ReadOnlyJoinColumn>(this.getSubjectHolder(), new String[]{this.joinColumnsEditor.getDefaultPropertyName()}){

            protected ReadOnlyJoinColumn buildValue_() {
                return JoinColumnsComposite.this.joinColumnsEditor.getDefaultJoinColumn((JpaNode)this.subject);
            }
        };
    }

    private ILabelProvider buildJoinColumnsListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                ReadOnlyJoinColumn joinColumn = (ReadOnlyJoinColumn)element;
                return JoinColumnsComposite.this.buildJoinColumnLabel(joinColumn);
            }
        };
    }

    public void installJoinColumnsPaneEnabler(PropertyValueModel<Boolean> joinColumnsPaneEnablerHolder) {
        new PaneEnabler(joinColumnsPaneEnablerHolder, this.listPane);
    }

    public void setSelectedJoinColumn(JoinColumn joinColumn) {
        this.listPane.setSelectedItem((Object)joinColumn);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface JoinColumnsEditor<T> {
        public void addJoinColumn(T var1);

        public void editJoinColumn(T var1, ReadOnlyJoinColumn var2);

        public boolean hasSpecifiedJoinColumns(T var1);

        public ListIterator<ReadOnlyJoinColumn> specifiedJoinColumns(T var1);

        public int specifiedJoinColumnsSize(T var1);

        public ReadOnlyJoinColumn getDefaultJoinColumn(T var1);

        public String getSpecifiedJoinColumnsListPropertyName();

        public String getDefaultPropertyName();

        public void removeJoinColumns(T var1, int[] var2);
    }
}

