/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.JptCommonCoreMessages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPointTools {
    public static String findRequiredAttribute(IConfigurationElement configElement, String attributeName) throws XPointException {
        String val = configElement.getAttribute(attributeName);
        if (val == null) {
            XPointTools.logMissingAttribute(configElement, attributeName);
            throw new XPointException();
        }
        return val;
    }

    public static <T> T instantiate(String pluginId, String extensionPoint, String className, Class<T> interfaze) {
        Class<T> clazz = XPointTools.loadClass(pluginId, extensionPoint, className, interfaze);
        return clazz == null ? null : (T)XPointTools.instantiate(pluginId, extensionPoint, clazz);
    }

    public static <T> T instantiate(String pluginId, String extensionPoint, Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception ex) {
            XPointTools.logFailedInstantiation(ex, pluginId, extensionPoint, clazz.getName());
            return null;
        }
    }

    private static <T> Class<T> loadClass(String pluginId, String extensionPoint, String className, Class<T> interfaze) {
        Class clazz;
        Bundle bundle = Platform.getBundle((String)pluginId);
        try {
            clazz = bundle.loadClass(className);
        }
        catch (Exception ex) {
            XPointTools.logFailedClassLoad(ex, pluginId, extensionPoint, className);
            return null;
        }
        if (interfaze.isAssignableFrom(clazz)) {
            Class clazzT = clazz;
            return clazzT;
        }
        XPointTools.logFailedInterfaceAssignment(pluginId, extensionPoint, className, interfaze.getName());
        return null;
    }

    public static void logDuplicateExtension(String extensionPoint, String nodeName, String value) {
        XPointTools.log(JptCommonCoreMessages.REGISTRY_DUPLICATE, extensionPoint, nodeName, value);
    }

    public static void logMissingAttribute(IConfigurationElement configElement, String attributeName) {
        XPointTools.log(JptCommonCoreMessages.REGISTRY_MISSING_ATTRIBUTE, attributeName, configElement.getName(), configElement.getDeclaringExtension().getExtensionPointUniqueIdentifier(), configElement.getContributor().getName());
    }

    public static void logInvalidValue(IConfigurationElement configElement, String nodeName, String invalidValue) {
        XPointTools.log(JptCommonCoreMessages.REGISTRY_INVALID_VALUE, invalidValue, nodeName, configElement.getDeclaringExtension().getExtensionPointUniqueIdentifier(), configElement.getContributor().getName());
    }

    private static void logFailedClassLoad(Exception ex, String pluginId, String extensionPoint, String className) {
        XPointTools.log(ex, JptCommonCoreMessages.REGISTRY_FAILED_CLASS_LOAD, className, extensionPoint, pluginId);
    }

    private static void logFailedInterfaceAssignment(String pluginId, String extensionPoint, String className, String interfaceName) {
        XPointTools.log(JptCommonCoreMessages.REGISTRY_FAILED_INTERFACE_ASSIGNMENT, className, extensionPoint, pluginId, interfaceName);
    }

    private static void logFailedInstantiation(Exception ex, String pluginId, String extensionPoint, String className) {
        XPointTools.log(ex, JptCommonCoreMessages.REGISTRY_FAILED_INSTANTIATION, className, extensionPoint, pluginId);
    }

    public static void log(String msg, String ... bindings) {
        JptCommonCorePlugin.log(NLS.bind((String)msg, (Object[])bindings));
    }

    public static void log(Throwable ex, String msg, String ... bindings) {
        JptCommonCorePlugin.log(NLS.bind((String)msg, (Object[])bindings), ex);
    }

    public static void log(Throwable ex) {
        JptCommonCorePlugin.log(ex);
    }

    public static final class XPointException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

