/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates.eglx.lang;

import org.eclipse.edt.gen.javascript.CommonUtilities;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.Template;
import org.eclipse.edt.mof.egl.AsExpression;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Operation;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class SmallfloatTypeTemplate
extends JavaScriptTemplate {
    public void genDefaultValue(EGLClass type, Context ctx, TabbedWriter out) {
        out.print("0");
    }

    public void genSignature(EGLClass type, Context ctx, TabbedWriter out) {
        String signature = "f;";
        out.print(signature);
    }

    protected boolean needsConversion(Operation conOp) {
        boolean result = true;
        Type fromType = ((FunctionParameter)conOp.getParameters().get(0)).getType();
        Type toType = conOp.getReturnType();
        if (CommonUtilities.getEglNameForTypeCamelCase((Type)toType).equals(CommonUtilities.getEglNameForTypeCamelCase((Type)fromType))) {
            result = false;
        }
        if (toType.getTypeSignature().equalsIgnoreCase("eglx.lang.ENumber")) {
            result = true;
        } else if (TypeUtils.isNumericType((Type)fromType) && CommonUtilities.isJavaScriptNumber((Type)fromType)) {
            result = conOp.isNarrowConversion();
        }
        return result;
    }

    public void genConversionOperation(EGLClass type, Context ctx, TabbedWriter out, AsExpression arg) {
        if (arg.getConversionOperation() != null && !this.needsConversion(arg.getConversionOperation())) {
            ctx.invoke("genExpression", (EObject)arg.getObjectExpr(), new Object[]{ctx, out});
        } else {
            ctx.invokeSuper((Template)this, "genConversionOperation", (Type)type, new Object[]{ctx, out, arg});
        }
    }

    public void genBinaryExpression(EGLClass type, Context ctx, TabbedWriter out, BinaryExpression arg) {
        out.print(this.getNativeStringPrefixOperation(arg));
        out.print("(");
        ctx.invoke("genExpression", (EObject)arg.getLHS(), new Object[]{ctx, out});
        out.print(this.getNativeStringOperation(arg));
        ctx.invoke("genExpression", (EObject)arg.getRHS(), new Object[]{ctx, out});
        out.print(this.getNativeStringComparisionOperation(arg));
        out.print(")");
    }

    protected String getNativeStringPrefixOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("!=")) {
            return "";
        }
        if (op.equals("%")) {
            return "egl.remainder";
        }
        if (op.equals("**")) {
            return "egl.eglx.lang.EFloat32.pow";
        }
        if (op.equals("/")) {
            return "egl.divide";
        }
        return "";
    }

    protected String getNativeStringOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("+")) {
            return " + ";
        }
        if (op.equals("-")) {
            return " - ";
        }
        if (op.equals("*")) {
            return " * ";
        }
        if (op.equals("/")) {
            return " ,";
        }
        if (op.equals("==")) {
            return " == ";
        }
        if (op.equals("!=")) {
            return " != ";
        }
        if (op.equals("<")) {
            return " < ";
        }
        if (op.equals(">")) {
            return " > ";
        }
        if (op.equals("<=")) {
            return " <= ";
        }
        if (op.equals(">=")) {
            return " >= ";
        }
        if (op.equals("&&")) {
            return " && ";
        }
        if (op.equals("||")) {
            return " || ";
        }
        if (op.equals("::")) {
            return " + ";
        }
        if (op.equals("%")) {
            return ",";
        }
        if (op.equals("**")) {
            return ",";
        }
        return "";
    }

    protected String getNativeStringComparisionOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("==")) {
            return "";
        }
        if (op.equals("!=")) {
            return "";
        }
        if (op.equals("<")) {
            return "";
        }
        if (op.equals(">")) {
            return "";
        }
        if (op.equals("<=")) {
            return "";
        }
        if (op.equals(">=")) {
            return "";
        }
        if (op.equals("%")) {
            return "";
        }
        return "";
    }
}

