/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.HandlerFieldsResolver;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.model.DataFieldPageDataNode;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.model.PageDataNode;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.handlers.BindingHandlerManager;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.InsertDataModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class InsertDataModelBuilder {
    private static InsertDataModelBuilder instance;
    private InsertDataModel insertDataModel;

    public static InsertDataModelBuilder getInstance() {
        if (instance == null) {
            instance = new InsertDataModelBuilder();
        }
        return instance;
    }

    private InsertDataModelBuilder() {
    }

    public InsertDataModel create(PageDataNode node, IProject project, IEditorInput editorInput) {
        this.insertDataModel = new InsertDataModel(project, editorInput);
        if (node instanceof DataFieldPageDataNode) {
            this.handleDataFieldPageDataNode((DataFieldPageDataNode)node);
        }
        return this.insertDataModel;
    }

    private void handleDataFieldPageDataNode(DataFieldPageDataNode dataFieldPageDataNode) {
        String bindingName = dataFieldPageDataNode.getDataBindingName();
        IDataBinding dataBinding = this.findDataBindingByName(bindingName);
        this.insertDataModel.getContext().set("BINDING_NAME", bindingName);
        BindingHandlerManager.getInstance().handle(dataBinding, dataBinding.getType(), this.insertDataModel);
    }

    private IDataBinding findDataBindingByName(String bindingName) {
        IEditorInput editorInput = this.insertDataModel.getEditorInput();
        if (editorInput instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)editorInput;
            HandlerFieldsResolver handlerFieldsResolver = new HandlerFieldsResolver(fileEditorInput.getFile());
            handlerFieldsResolver.resolve();
            Handler handler = handlerFieldsResolver.getRUIHandler();
            if (handler != null) {
                List contents = handler.getContents();
                int i = 0;
                while (i < contents.size()) {
                    if (contents.get(i) instanceof ClassDataDeclaration) {
                        ClassDataDeclaration classDataDeclaration = (ClassDataDeclaration)contents.get(i);
                        List names = classDataDeclaration.getNames();
                        int j = 0;
                        while (j < names.size()) {
                            SimpleName simpleName;
                            IDataBinding dataBinding;
                            Object oName = names.get(j);
                            if (oName instanceof SimpleName && (dataBinding = (simpleName = (SimpleName)oName).resolveDataBinding()) != null && dataBinding.getCaseSensitiveName().equals(bindingName)) {
                                return dataBinding;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public InsertDataModel getInsertDataModel() {
        return this.insertDataModel;
    }
}

