/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.awt.Point;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.edt.compiler.ISystemEnvironment;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeManager;
import org.eclipse.edt.compiler.core.ast.AbstractASTPartVisitor;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.internal.EGLSystemFunctionWord;
import org.eclipse.edt.compiler.internal.core.lookup.System.ContentAssistPartManager;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.ide.core.internal.compiler.SystemEnvironmentManager;
import org.eclipse.edt.ide.core.internal.search.PartDeclarationInfo;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLProposalContextInformation;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.editor.util.EGLModelUtility;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public abstract class EGLAbstractProposalHandler {
    protected static final String PROPOSAL_PART_REFERENCE_STRING = "{0}/{1}/{2} ({3})";
    protected static final String PROPOSAL_VARIABLE_DOT_STRING = "{0} ({1})";
    static final String[] EGLPERSISTENCE = new String[]{"eglx", "persistence"};
    static final String[] EGLLANG = new String[]{"eglx", "lang"};
    private int documentOffset;
    private String prefix;
    protected IEditorPart editor;
    protected ITextViewer viewer;
    protected AnnotationTypeManager annoTypeMgr = null;
    protected ContentAssistPartManager caPartMgr = null;

    public EGLAbstractProposalHandler(ITextViewer viewer, int documentOffset, String prefix) {
        this(viewer, documentOffset, prefix, null);
    }

    public EGLAbstractProposalHandler(ITextViewer viewer, int documentOffset, String prefix, IEditorPart editor) {
        this.viewer = viewer;
        this.documentOffset = documentOffset;
        this.prefix = prefix;
        this.editor = editor;
        if (editor != null) {
            IFileEditorInput editorInput = (IFileEditorInput)editor.getEditorInput();
            ISystemEnvironment env = SystemEnvironmentManager.findSystemEnvironment((IProject)editorInput.getFile().getProject(), null);
            this.annoTypeMgr = env.getAnnotationTypeManager();
            this.caPartMgr = env.getContentAssistPartsManager();
        }
    }

    public IEGLSearchScope createProjectSearchScope() {
        IFileEditorInput editorInput = (IFileEditorInput)this.editor.getEditorInput();
        return this.createSearchScope((IResource)editorInput.getFile().getProject());
    }

    private IEGLSearchScope createSearchScope(IResource resource) {
        IEGLElement[] elements = new IEGLElement[]{EGLCore.create((IResource)resource)};
        return SearchEngine.createEGLSearchScope((IEGLElement[])elements);
    }

    public int getDocumentOffset() {
        return this.documentOffset;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ITextViewer getViewer() {
        return this.viewer;
    }

    protected Node getPart() {
        IEGLDocument document = (IEGLDocument)this.getViewer().getDocument();
        return EGLModelUtility.getPartNode(document, this.getDocumentOffset());
    }

    protected Point getFirstParmSelection(String replacementString) {
        int cursorPosition = replacementString.indexOf(40);
        int selectionLength = replacementString.indexOf(44);
        int closedParenOffset = replacementString.indexOf(41);
        if ((selectionLength = selectionLength > 0 ? selectionLength - cursorPosition - 1 : closedParenOffset - cursorPosition - 1) == 0) {
            cursorPosition = replacementString.length() - 1;
        }
        if (cursorPosition > 0) {
            return new Point(cursorPosition + 1, selectionLength);
        }
        return new Point(replacementString.length(), selectionLength);
    }

    protected boolean containsProperty(final String propertyString, List propertyBlockList) {
        if (propertyBlockList != null) {
            for (SettingsBlock propertyBlock : propertyBlockList) {
                final boolean[] foundMatch = new boolean[1];
                Iterator pIter = propertyBlock.getSettings().iterator();
                while (pIter.hasNext() && !foundMatch[0]) {
                    ((Node)pIter.next()).accept((IASTVisitor)new DefaultASTVisitor(){

                        public boolean visit(Assignment assignment) {
                            foundMatch[0] = assignment.getLeftHandSide().getCanonicalString().equalsIgnoreCase(propertyString);
                            return false;
                        }

                        public boolean visit(SetValuesExpression setValuesExpression) {
                            setValuesExpression.getExpression().accept((IASTVisitor)this);
                            return false;
                        }

                        public boolean visit(AnnotationExpression annotationExpression) {
                            foundMatch[0] = annotationExpression.getName().getCanonicalName().equalsIgnoreCase(propertyString);
                            return false;
                        }

                        public boolean visit(SimpleName name) {
                            foundMatch[0] = name.getCanonicalName().equalsIgnoreCase(propertyString);
                            return false;
                        }
                    });
                }
                if (!foundMatch[0]) continue;
                return true;
            }
        }
        return false;
    }

    public String getPartReferenceAdditionalInformation(String packageName, PartDeclarationInfo part, String partTypeString) {
        String extension = "egl";
        if (part.isBinary()) {
            extension = ".eglxml";
        }
        if (packageName.trim().length() > 0) {
            return MessageFormat.format(PROPOSAL_PART_REFERENCE_STRING, part.getProject(), part.getFolder(), String.valueOf(packageName) + "/" + part.getFileName() + "." + extension, partTypeString);
        }
        return MessageFormat.format(PROPOSAL_PART_REFERENCE_STRING, part.getProject(), part.getFolder(), String.valueOf(part.getFileName()) + "." + extension, partTypeString);
    }

    protected String getAdditionalInfo(ITypeBinding typeBinding) {
        if (Binding.isValidBinding((IBinding)typeBinding)) {
            return typeBinding.getCaseSensitiveName();
        }
        return "";
    }

    protected String getAdditionalInfo(IDataBinding dataBinding) {
        if (dataBinding != null) {
            return this.getAdditionalInfo(dataBinding.getType());
        }
        return "";
    }

    public List getProposals(String[] strings, String additionalInfo) {
        return this.getProposals(strings, additionalInfo, 50, 0);
    }

    public List getProposals(String[] strings, String additionalInfo, int relevance) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        int i = 0;
        while (i < strings.length) {
            if (strings[i].toUpperCase().startsWith(this.getPrefix().toUpperCase())) {
                proposals.add(new EGLCompletionProposal(this.viewer, null, strings[i], additionalInfo, this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), 0, relevance, strings[i].length()));
            }
            ++i;
        }
        return proposals;
    }

    public List getProposals(String[] strings, String additionalInfo, int relevance, int postSelectionLength) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        int i = 0;
        while (i < strings.length) {
            if (strings[i].toUpperCase().startsWith(this.getPrefix().toUpperCase())) {
                proposals.add(new EGLCompletionProposal(this.viewer, null, strings[i], additionalInfo, this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), strings[i].length() - postSelectionLength, relevance, postSelectionLength));
            }
            ++i;
        }
        return proposals;
    }

    protected String getPackageName(PartDeclarationInfo part) {
        String packageName = part.getPackageName() == null || part.getPackageName().length() == 0 ? UINlsStrings.OpenPartDialog_DefaultPackage : part.getPackageName();
        return packageName;
    }

    protected EGLCompletionProposal createPartProposal(PartDeclarationInfo part, String partTypeName) {
        return this.createPartProposal(part, partTypeName, false);
    }

    protected EGLCompletionProposal createPartProposal(PartDeclarationInfo part, String partTypeName, boolean quoted) {
        String packageName = this.getPackageName(part);
        String displayString = this.buildDisplayName(part, partTypeName, packageName);
        boolean hasImportForPartWithADifferentPackage = this.hasImportForPartWithADifferentPackage(part.getPackageName(), part.getPartName());
        String proposalString = this.getProposalString(part, hasImportForPartWithADifferentPackage);
        if (quoted) {
            proposalString = "\"" + proposalString + "\"";
        }
        String importPackageName = null;
        String importPartName = null;
        if (part.getPackageName().length() > 0 && !hasImportForPartWithADifferentPackage) {
            importPackageName = part.getPackageName();
            importPartName = part.getPartName();
        }
        EGLCompletionProposal eglCompletionProposal = new EGLCompletionProposal(this.viewer, displayString, proposalString, this.getPartReferenceAdditionalInformation(part.getPackageName(), part, partTypeName), this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), proposalString.length());
        eglCompletionProposal.setImportPackageName(importPackageName);
        eglCompletionProposal.setImportPartName(importPartName);
        return eglCompletionProposal;
    }

    private boolean hasImportForPartWithADifferentPackage(final String packageName, final String partName) {
        IEGLDocument document = (IEGLDocument)((EGLEditor)this.editor).getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        File newModelEGLFile = document.getNewModelEGLFile();
        final boolean[] result = new boolean[1];
        newModelEGLFile.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(File file) {
                return true;
            }

            public boolean visit(ImportDeclaration importDeclaration) {
                Name name;
                if (!importDeclaration.isOnDemand() && (name = importDeclaration.getName()).isQualifiedName()) {
                    Name qualifier = ((QualifiedName)name).getQualifier();
                    if (name.getIdentifier().equalsIgnoreCase(partName) && !qualifier.getCanonicalName().equalsIgnoreCase(packageName)) {
                        result[0] = true;
                    }
                }
                return false;
            }
        });
        return result[0];
    }

    private String buildDisplayName(PartDeclarationInfo part, String partTypeName, String packageName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(part.getPartName());
        buffer.append(" - ");
        buffer.append(packageName);
        buffer.append(" (");
        buffer.append(partTypeName);
        buffer.append(")");
        return buffer.toString();
    }

    protected String getPackageName(IDataBinding qualifierDataBinding, ITypeBinding typeBinding) {
        IPartBinding declaringPart;
        String[] packageName = typeBinding.getPackageName();
        if (packageName == null && (declaringPart = qualifierDataBinding.getDeclaringPart()) != null) {
            packageName = declaringPart.getPackageName();
        }
        if (packageName != null && packageName.length != 0) {
            StringBuffer result = new StringBuffer();
            int i = 0;
            while (i < packageName.length) {
                result.append(packageName[i]);
                if (i != packageName.length - 1) {
                    result.append(".");
                }
                ++i;
            }
            return result.toString();
        }
        return UINlsStrings.OpenPartDialog_DefaultPackage;
    }

    protected String getPackageName(IPartBinding partBinding) {
        String[] packageName = partBinding.getPackageName();
        if (packageName != null && packageName.length != 0) {
            StringBuffer result = new StringBuffer();
            int i = 0;
            while (i < packageName.length) {
                result.append(packageName[i]);
                if (i != packageName.length - 1) {
                    result.append(".");
                }
                ++i;
            }
            return result.toString();
        }
        return UINlsStrings.OpenPartDialog_DefaultPackage;
    }

    protected String getProposalString(PartDeclarationInfo part, boolean includePackageName) {
        return includePackageName ? String.valueOf(part.getPackageName()) + "." + part.getPartName() : part.getPartName();
    }

    protected String getDisplayString(IFunctionBinding functionBinding) {
        return this.getDisplayString(functionBinding, functionBinding.getParameters().size());
    }

    protected String getDisplayString(IFunctionBinding functionBinding, int numberOfParameters) {
        StringBuffer buffer = new StringBuffer(functionBinding.getCaseSensitiveName());
        buffer.append("(");
        List parms = functionBinding.getParameters();
        Iterator iter = parms.iterator();
        int i = 0;
        while (i < numberOfParameters && iter.hasNext()) {
            IDataBinding parm = (IDataBinding)iter.next();
            buffer.append(parm.getCaseSensitiveName());
            buffer.append(" ");
            buffer.append(parm.getType().getCaseSensitiveName());
            if (i != numberOfParameters - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append(")");
        ITypeBinding returnType = functionBinding.getReturnType();
        if (returnType != null) {
            buffer.append(" - ");
            buffer.append(returnType.getCaseSensitiveName());
        }
        return buffer.toString();
    }

    protected Set getTableUseStatementParts(Node functionContainerPart) {
        final HashSet tables = new HashSet();
        if (functionContainerPart != null) {
            functionContainerPart.accept((IASTVisitor)new AbstractASTPartVisitor(){

                public void visitPart(Part part) {
                    Iterator iter = part.getContents().iterator();
                    while (iter.hasNext()) {
                        ((Node)iter.next()).accept((IASTVisitor)new DefaultASTVisitor(){

                            public boolean visit(UseStatement useStatement) {
                                for (Name nextName : useStatement.getNames()) {
                                    IBinding binding = nextName.resolveBinding();
                                    if (binding == null || IBinding.NOT_FOUND_BINDING == binding || !binding.isTypeBinding() || 5 != ((ITypeBinding)binding).getKind()) continue;
                                    tables.add(binding);
                                }
                                return false;
                            }
                        });
                    }
                }
            });
        }
        return tables;
    }

    protected List createSystemFunctionProposals(EGLSystemFunctionWord systemFunction, boolean addPrefix) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        String prefix = "";
        if (systemFunction.getLibrary().length() > 0 && addPrefix) {
            prefix = String.valueOf(systemFunction.getLibrary()) + ".";
        }
        String upToParensString = String.valueOf(prefix) + systemFunction.getName();
        int[] validArgumentCounts = systemFunction.getValidArgumentCounts();
        if (validArgumentCounts.length > 0) {
            if (validArgumentCounts[0] == -1 && validArgumentCounts.length == 2) {
                validArgumentCounts = this.recalculateValidArgumentCounts(validArgumentCounts[1], systemFunction.getParameterNames().length);
            }
            int i = 0;
            while (i < validArgumentCounts.length) {
                int numberOfArgs = validArgumentCounts[i];
                String[] parms = systemFunction.getParameterNames(numberOfArgs);
                String displayString = systemFunction.toString(numberOfArgs);
                String replaceString = String.valueOf(prefix) + displayString;
                int selectionLength = parms.length > 0 ? parms[0].length() : 0;
                int cursorPosition = parms.length > 0 ? upToParensString.length() + 1 : replaceString.length();
                proposals.add(new EGLCompletionProposal(this.viewer, displayString, replaceString, systemFunction.getAdditonalInformation(), this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), cursorPosition, 40, selectionLength));
                ++i;
            }
        }
        return proposals;
    }

    protected List createFunctionInvocationProposals(IFunctionBinding function, String additionalInformation, int relevance, boolean addPrefix) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        String prefix = "";
        if (function.getDeclarer() != function && addPrefix) {
            prefix = String.valueOf(function.getDeclarer().getCaseSensitiveName()) + ".";
        }
        String upToParensString = String.valueOf(prefix) + function.getCaseSensitiveName();
        int[] validArgumentCounts = function.getValidNumbersOfArguments();
        if (validArgumentCounts.length > 0) {
            if (validArgumentCounts[0] == -1 && validArgumentCounts.length == 2) {
                validArgumentCounts = this.recalculateValidArgumentCounts(validArgumentCounts[1], function.getParameters().size());
            }
            int i = 0;
            while (i < validArgumentCounts.length) {
                int numberOfArgs = validArgumentCounts[i];
                String displayString = this.getDisplayString(function, numberOfArgs);
                String replaceString = String.valueOf(upToParensString) + "(" + this.getParmString(function, numberOfArgs) + ")";
                int selectionLength = numberOfArgs > 0 ? ((IBinding)function.getParameters().get(0)).getName().length() : 0;
                int cursorPosition = numberOfArgs > 0 ? upToParensString.length() + 1 : replaceString.length();
                EGLCompletionProposal completionProposal = new EGLCompletionProposal(this.viewer, displayString, replaceString, additionalInformation, this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), cursorPosition, relevance, selectionLength);
                EGLProposalContextInformation contextInformation = new EGLProposalContextInformation(completionProposal, this.getDocumentOffset() - this.getPrefix().length() + upToParensString.length() + 1, replaceString, this.getParameterListString(function.getParameters()));
                completionProposal.setContextInformation(contextInformation);
                proposals.add(completionProposal);
                ++i;
            }
        }
        return proposals;
    }

    private int[] recalculateValidArgumentCounts(int numberOfArgs, int numberOfParameterNames) {
        int[] validArgumentCounts = new int[numberOfParameterNames - numberOfArgs + 1];
        int i = 0;
        while (i < validArgumentCounts.length) {
            validArgumentCounts[i] = numberOfArgs + i;
            ++i;
        }
        return validArgumentCounts;
    }

    protected String getPartTypeString(ITypeBinding typeBinding) {
        if (typeBinding != null) {
            switch (typeBinding.getKind()) {
                case 3: {
                    return UINlsStrings.CAProposal_Primitive;
                }
                case 6: 
                case 7: {
                    return "record";
                }
                case 5: {
                    return "dataTable";
                }
                case 11: {
                    return "library";
                }
                case 8: {
                    return "form";
                }
                case 9: {
                    return "formGroup";
                }
                case 2: {
                    return UINlsStrings.CAProposal_Array;
                }
                case 22: {
                    return "arrayDictionary";
                }
                case 21: {
                    return "dictionary";
                }
                case 14: {
                    return "service";
                }
                case 15: {
                    return "interface";
                }
            }
            return typeBinding.getPackageQualifiedName();
        }
        return "";
    }

    protected boolean isNewExpression() {
        Node node = ((IEGLDocument)this.getViewer().getDocument()).getNewModelNodeAtOffset(this.getDocumentOffset());
        while (node != null) {
            if (node instanceof NewExpression) {
                return true;
            }
            if (node instanceof FunctionDataDeclaration) {
                return false;
            }
            if (node instanceof ClassDataDeclaration) {
                return false;
            }
            node = node.getParent();
        }
        return false;
    }

    protected String getParmString(IFunctionBinding functionBinding) {
        return this.getParmString(functionBinding, functionBinding.getParameters().size());
    }

    protected String getParmString(IFunctionBinding functionBinding, int numberOfParms) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        List parameters = functionBinding.getParameters();
        Iterator iter = parameters.iterator();
        int i = 0;
        while (i < numberOfParms && iter.hasNext()) {
            IDataBinding parameter = (IDataBinding)iter.next();
            if (!first) {
                buffer.append(", ");
            }
            first = false;
            buffer.append(parameter.getCaseSensitiveName());
            ++i;
        }
        return buffer.toString();
    }

    protected int getFirstParmLength(IFunctionBinding functionBinding) {
        List parameters = functionBinding.getParameters();
        if (parameters != null && !parameters.isEmpty()) {
            return ((IDataBinding)parameters.get(0)).getName().length();
        }
        return 0;
    }

    protected String getParameterListString(List parameters) {
        StringBuffer parameterListSB = new StringBuffer();
        Iterator iter = parameters.iterator();
        while (iter.hasNext()) {
            FunctionParameterBinding pBinding = (FunctionParameterBinding)iter.next();
            parameterListSB.append(this.toString(pBinding));
            if (!iter.hasNext()) continue;
            parameterListSB.append(", ");
        }
        return parameterListSB.toString();
    }

    protected String toString(FunctionParameterBinding binding) {
        StringBuffer sb = new StringBuffer();
        sb.append(binding.getCaseSensitiveName());
        sb.append(" ");
        ITypeBinding type = binding.getType();
        sb.append(StatementValidator.getTypeString((ITypeBinding)type));
        if (binding.isInput()) {
            sb.append(" ");
            sb.append("in");
        } else if (binding.isOutput()) {
            sb.append(" ");
            sb.append("out");
        } else if (binding.isInputOutput()) {
            sb.append(" ");
            sb.append("inOut");
        }
        if (binding.isSQLNullable()) {
            sb.append(" ");
            sb.append("sqlnullable");
        }
        if (binding.isField()) {
            sb.append(" ");
            sb.append("field");
        }
        return sb.toString();
    }

    protected int getLParenOffsetAfter(int offset) {
        int ch = 32;
        try {
            while (ch != 40) {
                ch = this.getViewer().getDocument().getChar(offset++);
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        return offset - 1;
    }
}

