/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.internal.EGLBasePlugin;
import org.eclipse.edt.compiler.internal.EGLNewPropertiesHandler;
import org.eclipse.edt.compiler.internal.EGLPropertyRule;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.edt.ide.ui.internal.util.CapabilityFilterUtility;
import org.eclipse.jface.text.ITextViewer;

public class EGLPropertyNameProposalHandler
extends EGLAbstractProposalHandler {
    protected static final String NUMERIC_LITERAL = "numericLiteral";
    protected static final String LINE = "line";
    protected static final String LINES = "lines";
    protected static final String COLUMN = "column";
    protected static final String LENGTH = "length";
    protected static final String COLUMNS = "columns";
    protected static final String LOW_VALUE = "lowValue";
    protected static final String HIGH_VALUE = "highValue";
    protected static final String TABLE_NAME = "tableName";
    protected static final String VARIABLE_NAME = "variableName";
    protected static final String TABLE_LABEL = "tableLabel";
    protected static final String VALIDATIONBYPASSKEYS_PFN_LIST_PROPOSAL = "pfn";
    protected static final String ROW_CONTENTS = "rowContents";
    protected static final String SQL_CONDITION = "condition";
    private boolean isAnnotationSetting;

    public EGLPropertyNameProposalHandler(ITextViewer viewer, int documentOffset, String prefix, boolean isAnnotationSetting) {
        super(viewer, documentOffset, prefix, null);
        this.isAnnotationSetting = isAnnotationSetting;
    }

    public List getProposals(int location, List propertyBlockList) {
        Collection propertyRules = CapabilityFilterUtility.filterPropertyRules(EGLNewPropertiesHandler.getPropertyRules((int)location));
        return this.getProposals(location, propertyRules, propertyBlockList);
    }

    public List getProposals(Collection propertyRules, List propertyBlockList) {
        return this.getProposals(0, propertyRules, propertyBlockList);
    }

    public List getProposals(int location, Collection propertyRules, List propertyBlockList) {
        boolean vagCompatibility = EGLBasePlugin.getPlugin().getPreferenceStore().getBoolean("VAGCompatibilityOption");
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        if (propertyRules != null) {
            for (EGLPropertyRule propertyRule : propertyRules) {
                String propertyName = propertyRule.getName();
                if (!propertyName.toUpperCase().startsWith(this.getPrefix().toUpperCase()) || !this.checkVagCompatibility(propertyName, vagCompatibility) || this.containsProperty(propertyName, propertyBlockList)) continue;
                proposals.add(this.createProposal(location, propertyRule));
            }
        }
        return proposals;
    }

    private EGLCompletionProposal createProposal(int location, EGLPropertyRule propertyRule) {
        int cursorPosition = 0;
        int selectionLength = 0;
        StringBuffer buffer = new StringBuffer();
        if (propertyRule.isValueless() && !this.isAnnotationSetting || propertyRule.isComplex() && !this.isAnnotationSetting && !propertyRule.getName().equalsIgnoreCase("printFloatingArea") && !propertyRule.getName().equalsIgnoreCase("screenFloatingArea")) {
            buffer.append("@");
        }
        buffer.append(propertyRule.getName());
        if (propertyRule.isComplex() || propertyRule.hasType(7) || this.isAnnotationSetting) {
            if (!propertyRule.isValueless()) {
                buffer.append(" {");
                cursorPosition = buffer.length();
                buffer.append("}");
            }
        } else if (!propertyRule.isValueless()) {
            buffer.append(" = ");
            if (propertyRule.hasType(0)) {
                if (propertyRule.getName().equalsIgnoreCase("helpKey")) {
                    buffer.append(VALIDATIONBYPASSKEYS_PFN_LIST_PROPOSAL);
                    cursorPosition = buffer.length() - 1;
                    selectionLength = 1;
                } else {
                    cursorPosition = buffer.length();
                }
            } else if (propertyRule.hasType(2)) {
                cursorPosition = buffer.length();
            } else if (propertyRule.hasType(1)) {
                cursorPosition = buffer.length() + 1;
                buffer.append("\"\"");
            } else if (propertyRule.hasType(3)) {
                cursorPosition = buffer.length();
                buffer.append(NUMERIC_LITERAL);
                selectionLength = NUMERIC_LITERAL.length();
            } else if (propertyRule.hasType(4)) {
                cursorPosition = buffer.length();
            } else if (propertyRule.hasType(5)) {
                if (propertyRule.getName().equalsIgnoreCase("outline")) {
                    cursorPosition = buffer.length();
                } else {
                    buffer.append("[");
                    cursorPosition = buffer.length();
                    if (!propertyRule.getName().equalsIgnoreCase("keyItems")) {
                        if (propertyRule.getName().equalsIgnoreCase("pageSize")) {
                            buffer.append(LINES);
                            buffer.append(",");
                            buffer.append(COLUMNS);
                            selectionLength = LINES.length();
                        } else if (propertyRule.getName().equalsIgnoreCase("position")) {
                            buffer.append(LINE);
                            buffer.append(",");
                            buffer.append(COLUMN);
                            selectionLength = LINE.length();
                        } else if (propertyRule.getName().equalsIgnoreCase("validValues")) {
                            buffer.append(LOW_VALUE);
                            buffer.append(",");
                            buffer.append(HIGH_VALUE);
                            selectionLength = LOW_VALUE.length();
                        } else if (propertyRule.getName().equalsIgnoreCase("screenSize")) {
                            buffer.append(LINES);
                            buffer.append(",");
                            buffer.append(COLUMNS);
                            selectionLength = LINES.length();
                        } else if (propertyRule.getName().equalsIgnoreCase("screenSizes")) {
                            buffer.append("[");
                            cursorPosition = buffer.length();
                            buffer.append(LINES);
                            buffer.append(",");
                            buffer.append(COLUMNS);
                            selectionLength = LINES.length();
                            buffer.append("]");
                        } else if (propertyRule.getName().equalsIgnoreCase("formSize")) {
                            buffer.append(LINES);
                            buffer.append(",");
                            buffer.append(COLUMNS);
                            selectionLength = LINES.length();
                        } else if (!propertyRule.getName().equalsIgnoreCase("validationBypassFunctions") && !propertyRule.getName().equalsIgnoreCase("validationBypassKeys") && propertyRule.getName().equalsIgnoreCase("segments")) {
                            buffer.append("[");
                            cursorPosition = buffer.length();
                            buffer.append(LINE);
                            buffer.append(",");
                            buffer.append(COLUMN);
                            buffer.append(",");
                            buffer.append(LENGTH);
                            selectionLength = LINE.length();
                            buffer.append("]");
                        }
                    }
                    buffer.append("]");
                }
            } else if (propertyRule.getName().equalsIgnoreCase("contents")) {
                String value = "";
                if (propertyRule.getName().equalsIgnoreCase("contents")) {
                    value = ROW_CONTENTS;
                }
                buffer.append("[[");
                cursorPosition = buffer.length();
                buffer.append(value);
                buffer.append("]]");
                selectionLength = value.length();
            } else if (propertyRule.hasType(8)) {
                if (propertyRule.getName().equalsIgnoreCase("defaultSelectCondition")) {
                    buffer.append("#sqlCondition{");
                    buffer.append(" ");
                    cursorPosition = buffer.length();
                    buffer.append(SQL_CONDITION);
                    buffer.append(" }");
                    selectionLength = SQL_CONDITION.length();
                }
            } else if (propertyRule.hasType(9)) {
                String value1 = "";
                String value2 = "";
                buffer.append("[[");
                if (!propertyRule.getName().equalsIgnoreCase("screenSizes")) {
                    buffer.append("\"");
                }
                if (propertyRule.getName().equalsIgnoreCase("tableNames")) {
                    value1 = TABLE_NAME;
                    value2 = TABLE_LABEL;
                    selectionLength = TABLE_NAME.length();
                } else if (propertyRule.getName().equalsIgnoreCase("tableNameVariables")) {
                    value1 = VARIABLE_NAME;
                    value2 = TABLE_LABEL;
                    selectionLength = VARIABLE_NAME.length();
                } else if (propertyRule.getName().equalsIgnoreCase("screenSizes")) {
                    value1 = LINES;
                    value2 = COLUMNS;
                    selectionLength = LINES.length();
                }
                cursorPosition = buffer.length();
                buffer.append(value1);
                if (propertyRule.getName().equalsIgnoreCase("screenSizes")) {
                    buffer.append(", ");
                    buffer.append(value2);
                } else {
                    buffer.append("\", \"");
                    buffer.append(value2);
                    buffer.append("\"");
                }
                buffer.append("]]");
            } else if (propertyRule.hasType(10)) {
                String value = "";
                buffer.append("[@");
                if (propertyRule.getName().equalsIgnoreCase("linkParms")) {
                    value = "linkParameter";
                } else if (propertyRule.getName().equalsIgnoreCase("hierarchy")) {
                    value = "relationship";
                } else {
                    IAnnotationTypeBinding elementAnnotationType = propertyRule.getElementAnnotationType();
                    if (Binding.isValidBinding((IBinding)elementAnnotationType)) {
                        value = elementAnnotationType.getCaseSensitiveName();
                    }
                }
                buffer.append(value);
                buffer.append(" {");
                cursorPosition = buffer.length();
                buffer.append("}]");
            }
        }
        return new EGLCompletionProposal(this.viewer, propertyRule.getName(), buffer.toString(), this.getAdditionalInfo(location, propertyRule.getName()), this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), cursorPosition, 50, selectionLength);
    }

    private boolean checkVagCompatibility(String propertyName, boolean vagCompatibility) {
        if (vagCompatibility) {
            return true;
        }
        return !propertyName.equalsIgnoreCase("deleteAfterUse") && !propertyName.equalsIgnoreCase("sqlDataCode");
    }

    private String getAdditionalInfo(int location, String propertyName) {
        if (location == 13) {
            if (propertyName.equalsIgnoreCase("helpGroup")) {
                return UINlsStrings.CAProposal_PropertyNameFormGroups;
            }
            if (propertyName.equalsIgnoreCase("validationBypassKeys")) {
                return UINlsStrings.CAProposal_PropertyNameFormGroups;
            }
            if (propertyName.equalsIgnoreCase("helpKey")) {
                return UINlsStrings.CAProposal_PropertyNameFormGroups;
            }
            if (propertyName.equalsIgnoreCase("pfKeyEquate")) {
                return UINlsStrings.CAProposal_PropertyNameFormGroups;
            }
            if (propertyName.equalsIgnoreCase("deleteAfterUse")) {
                return UINlsStrings.CAProposal_PropertyNameDataTables;
            }
            return UINlsStrings.CAProposal_PropertyName;
        }
        return UINlsStrings.CAProposal_PropertyName;
    }
}

