/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import java.util.ArrayList;
import org.eclipse.edt.compiler.core.EGLKeywordHandler;
import org.eclipse.edt.ide.ui.internal.editor.AbstractCodeScanner;
import org.eclipse.edt.ide.ui.internal.preferences.ColorProvider;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.NumberRule;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.util.PropertyChangeEvent;

public class CodeScanner
extends AbstractCodeScanner {
    public static String[] keywords = EGLKeywordHandler.getKeywordNamesToLowerCase();
    private ColorProvider colorProvider = null;

    public CodeScanner(ColorProvider provider) {
        this.colorProvider = provider;
        this.setRules();
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return event.getProperty().equals("egl_keyword") || event.getProperty().equals("egl_keyword_bold") || event.getProperty().equals("egl_string") || event.getProperty().equals("egl_string_bold") || event.getProperty().equals("egl_multi_line_comment") || event.getProperty().equals("egl_multi_line_comment_bold") || event.getProperty().equals("egl_single_line_comment") || event.getProperty().equals("egl_single_line_comment_bold") || event.getProperty().equals("egl_default") || event.getProperty().equals("egl_default_bold");
    }

    public void setRules() {
        Token currentToken = null;
        TextAttribute attr = null;
        ArrayList<Object> rules = new ArrayList<Object>();
        attr = this.colorProvider.getTextAttribute("SINGLE_LINE_COMMENT");
        currentToken = new Token((Object)attr);
        attr = this.colorProvider.getTextAttribute("MULTI_LINE_COMMENT");
        currentToken = new Token((Object)attr);
        attr = this.colorProvider.getTextAttribute("LITERAL");
        currentToken = new Token((Object)attr);
        rules.add(new SingleLineRule("\"", "\"", (IToken)currentToken, '\\'));
        attr = this.colorProvider.getTextAttribute("DEFAULT");
        currentToken = new Token((Object)attr);
        rules.add(new NumberRule((IToken)currentToken));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new AbstractCodeScanner.EGLWhitespaceDetector()));
        AbstractCodeScanner.EGLWordRule wordRule = new AbstractCodeScanner.EGLWordRule(new AbstractCodeScanner.EGLWordDetector(), (IToken)currentToken);
        attr = this.colorProvider.getTextAttribute("KEYWORD");
        currentToken = new Token((Object)attr);
        int i = 0;
        while (i < keywords.length) {
            wordRule.addWord(keywords[i], (IToken)currentToken);
            ++i;
        }
        rules.add((Object)wordRule);
        attr = this.colorProvider.getTextAttribute("DEFAULT");
        currentToken = new Token((Object)attr);
        this.setDefaultReturnToken((IToken)currentToken);
        result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }
}

