/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.quickfix.proposals;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.binding.ClassFieldBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AddStatement;
import org.eclipse.edt.compiler.core.ast.ArrayAccess;
import org.eclipse.edt.compiler.core.ast.DeleteStatement;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.GetByKeyStatement;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OpenStatement;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.ReplaceStatement;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.UsingKeysClause;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLAddStatementFactory;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLDeclareStatementFactory;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLDeleteStatementFactory;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLGetByKeyForUpdateStatementFactory;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLGetByKeyStatementFactory;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLOpenForUpdateStatementFactory;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLOpenStatementFactory;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLReplaceStatementFactory;
import org.eclipse.edt.compiler.internal.sql.statements.EGLSQLStatementFactory;
import org.eclipse.edt.compiler.internal.sql.util.SQLUtility;
import org.eclipse.edt.compiler.internal.util.EGLMessage;
import org.eclipse.edt.ide.core.Logger;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IWorkingCopyCompileRequestor;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompilationResult;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompiler;
import org.eclipse.edt.ide.core.internal.search.PartInfo;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IBuffer;
import org.eclipse.edt.ide.core.model.IBufferFactory;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.IWorkingCopy;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.editor.DocumentAdapter;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.editor.EditorUtility;
import org.eclipse.edt.ide.ui.internal.editor.sql.SQLEditorUtility;
import org.eclipse.edt.ide.ui.internal.editor.sql.SQLIOStatementActionInfo;
import org.eclipse.edt.ide.ui.internal.quickfix.IInvocationContext;
import org.eclipse.edt.ide.ui.internal.quickfix.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractSQLStatementProposal
extends ASTRewriteCorrectionProposal {
    protected EGLEditor editor;
    protected String sqlStatement;
    protected String intoClause;
    protected String usingClause;
    boolean isExecuteStatement = false;
    boolean isForUpdateStatement = false;
    protected boolean addIntoClause = false;
    boolean actionFailed = false;
    boolean hasDynamicArrayError = false;
    ArrayList<String> messages;
    protected SQLIOStatementActionInfo info;
    IDataBinding sqlRecordBinding;

    public AbstractSQLStatementProposal(String name, IEGLFile eglFile, int relevance, Image image, IEGLDocument document) {
        super(name, eglFile, relevance, image, document);
    }

    protected void initialize() {
        this.messages = null;
        this.sqlStatement = null;
        this.usingClause = null;
        this.intoClause = null;
        this.actionFailed = false;
        this.hasDynamicArrayError = false;
    }

    protected ArrayList<String> getMessages() {
        if (this.messages == null) {
            this.messages = new ArrayList();
        }
        return this.messages;
    }

    protected EGLSQLStatementFactory createSQLStatementFactory(Statement statement) {
        String[][] keyItemAndColumnNames;
        this.isExecuteStatement = false;
        this.isForUpdateStatement = false;
        EGLSQLAddStatementFactory statementFactory = null;
        boolean isSelectStatement = false;
        IDataBinding sqlRecordBinding = null;
        ICompilerOptions compileOptions = this.info.getCompilerOption();
        sqlRecordBinding = this.getSqlRecordBinding();
        if (sqlRecordBinding == null) {
            this.actionFailed = true;
            if (!this.hasDynamicArrayError) {
                this.addErrorMessage("1007", new String[]{this.info.getIOType(), "SQL"});
            }
            return null;
        }
        if (statement instanceof AddStatement) {
            statementFactory = new EGLSQLAddStatementFactory(sqlRecordBinding, this.info.getIOObjectName(), compileOptions);
        } else if (statement instanceof DeleteStatement) {
            keyItemAndColumnNames = this.getKeyItemAndColumnNames(sqlRecordBinding);
            statementFactory = new EGLSQLDeleteStatementFactory(sqlRecordBinding, this.info.getIOObjectName(), keyItemAndColumnNames, this.info.isNoCursor(), compileOptions);
        } else if (this.info.getStatement() instanceof GetByKeyStatement) {
            keyItemAndColumnNames = this.getKeyItemAndColumnNames(sqlRecordBinding);
            if (this.isGetForUpdateStatement()) {
                statementFactory = new EGLSQLGetByKeyForUpdateStatementFactory(sqlRecordBinding, this.info.getIOObjectName(), null, keyItemAndColumnNames, false, compileOptions);
                this.isForUpdateStatement = true;
            } else {
                statementFactory = new EGLSQLGetByKeyStatementFactory(sqlRecordBinding, this.info.getIOObjectName(), null, keyItemAndColumnNames, this.info.isDynamicArrayRecord(), compileOptions);
            }
            isSelectStatement = true;
        } else if (this.info.getStatement() instanceof OpenStatement) {
            keyItemAndColumnNames = this.getKeyItemAndColumnNames(sqlRecordBinding);
            if (this.isOpenForUpdateStatement()) {
                statementFactory = new EGLSQLOpenForUpdateStatementFactory(sqlRecordBinding, this.info.getIOObjectName(), null, keyItemAndColumnNames, compileOptions);
                this.isForUpdateStatement = true;
            } else {
                statementFactory = new EGLSQLOpenStatementFactory(sqlRecordBinding, this.info.getIOObjectName(), null, keyItemAndColumnNames, compileOptions);
            }
            isSelectStatement = true;
        } else if (statement instanceof ReplaceStatement) {
            keyItemAndColumnNames = this.getKeyItemAndColumnNames(sqlRecordBinding);
            statementFactory = new EGLSQLReplaceStatementFactory(sqlRecordBinding, this.info.getIOObjectName(), keyItemAndColumnNames, this.info.isNoCursor(), compileOptions);
        }
        if (statementFactory != null && isSelectStatement) {
            EGLSQLDeclareStatementFactory factory = (EGLSQLDeclareStatementFactory)statementFactory;
            if (this.addIntoClause) {
                factory.setBuildIntoClauseForEditor(true);
                factory.setAddIntoClauseToStatement(false);
            } else {
                factory.setBuildIntoClause(false);
            }
        }
        return statementFactory;
    }

    protected IDataBinding getSqlRecordBinding() {
        this.sqlRecordBinding = this.info.getSqlRecordBinding();
        if (this.sqlRecordBinding != null && this.sqlRecordBinding != IBinding.NOT_FOUND_BINDING) {
            return this.sqlRecordBinding;
        }
        return null;
    }

    protected IDataBinding searchForPart() {
        if (!this.actionFailed) {
            PartInfo partInfo;
            IPart sqlRecordPart;
            IEGLSearchScope scope = SQLEditorUtility.createScope(this.editor);
            List parts = SQLEditorUtility.getSQLRecords(this.editor, this.info.getIOObjectName(), 0, scope);
            if (parts.size() > 0 && (sqlRecordPart = SQLEditorUtility.resolvePart(partInfo = (PartInfo)parts.get(0), scope)) != null) {
                this.sqlRecordBinding = this.getSQLRecordBindingFromPart(sqlRecordPart);
                if (this.sqlRecordBinding != null && this.sqlRecordBinding != IBinding.NOT_FOUND_BINDING) {
                    this.addInfoMessage("1024", new String[]{this.info.getIOObjectName(), "SQL"});
                    if (parts.size() > 1) {
                        this.addInfoMessage("1016", new String[]{this.info.getIOObjectName(), "SQL"});
                    }
                    this.addInfoMessage("1006", new String[]{sqlRecordPart.getElementName(), sqlRecordPart.getEGLFile().getPath().toOSString(), "SQL"});
                    return this.sqlRecordBinding;
                }
            }
            if (SQLEditorUtility.saveEditors()) {
                sqlRecordPart = SQLEditorUtility.getSQLRecordPartFromSelectionDialog(this.editor, scope);
                this.sqlRecordBinding = this.getSQLRecordBindingFromPart(sqlRecordPart);
                if (this.sqlRecordBinding != null && this.sqlRecordBinding != IBinding.NOT_FOUND_BINDING) {
                    return this.sqlRecordBinding;
                }
            }
        }
        return null;
    }

    public IDataBinding getSQLRecordBindingFromPart(IPart sqlRecordPart) {
        ClassFieldBinding binding = null;
        IEGLDocument document = null;
        IEGLFile workingCopy = null;
        if (sqlRecordPart != null) {
            try {
                try {
                    IEGLFile coreEGLFile = sqlRecordPart.getEGLFile();
                    Node node = null;
                    final Node[] nodeType = new Node[1];
                    int offset = sqlRecordPart.getSourceRange().getOffset();
                    workingCopy = (IEGLFile)coreEGLFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
                    IBuffer buffer = workingCopy.getBuffer();
                    document = (IEGLDocument)((DocumentAdapter)buffer).getDocument();
                    node = document.getNewModelNodeAtOffset(offset);
                    if (node != null && node instanceof Record && SQLUtility.isSQLRecordPart((Record)((Record)node))) {
                        Record record;
                        ITypeBinding typeBinding;
                        this.getBoundASTNode(document, sqlRecordPart.getElementName(), node.getOffset(), (IFile)coreEGLFile.getResource(), new IBoundNodeProcessor(){

                            @Override
                            public void processBoundNode(Node boundNode, Node containerNode) {
                                nodeType[0] = boundNode;
                            }
                        });
                        if (nodeType[0] != null && (typeBinding = (ITypeBinding)(record = (Record)nodeType[0]).getName().resolveBinding()) != null && typeBinding != IBinding.NOT_FOUND_BINDING) {
                            binding = new ClassFieldBinding(typeBinding.getCaseSensitiveName(), null, typeBinding);
                        }
                    }
                }
                catch (EGLModelException e) {
                    e.printStackTrace();
                    if (workingCopy != null) {
                        workingCopy.destroy();
                    }
                }
            }
            finally {
                if (workingCopy != null) {
                    workingCopy.destroy();
                }
            }
        }
        return binding;
    }

    protected void addErrorMessage(String messageID) {
        this.getMessages().add(EGLMessage.createEGLEditorErrorMessage((ResourceBundle)this.getResourceBundle(), (String)messageID).getBuiltMessage());
    }

    protected void addErrorMessage(String messageID, String[] inserts) {
        this.getMessages().add(EGLMessage.createEGLEditorErrorMessage((ResourceBundle)this.getResourceBundle(), (String)messageID, (String[])inserts).getBuiltMessage());
    }

    protected void addInfoMessage(String messageID) {
        this.getMessages().add(EGLMessage.createEGLEditorInformationalMessage((ResourceBundle)this.getResourceBundle(), (String)messageID).getBuiltMessage());
    }

    protected void addInfoMessage(String messageID, String[] inserts) {
        this.getMessages().add(EGLMessage.createEGLEditorInformationalMessage((ResourceBundle)this.getResourceBundle(), (String)messageID, (String[])inserts).getBuiltMessage());
    }

    private ResourceBundle getResourceBundle() {
        return UINlsStrings.getResourceBundleForConstructedKeys();
    }

    protected boolean hasEGLSQLStatementErrors() {
        boolean isValid = true;
        if (this.info.getStatement() == null) {
            this.addErrorMessage("1014");
            this.addInfoMessage("1023", new String[]{"SQL"});
            isValid = false;
        }
        return isValid;
    }

    protected boolean ensureSQLStatementIsNotCloseOrDelete() {
        if (this.isCloseStatement()) {
            this.addErrorMessage("1022");
            return false;
        }
        return true;
    }

    protected boolean ensureExplicitSQLStatementAllowed() {
        if (this.isExplicitSQLStatementAllowed()) {
            return true;
        }
        if (!this.shouldIssueExplicitSQLStatementNotAllowedMessage()) {
            return true;
        }
        this.addErrorMessage("1013", new String[]{this.info.getIOType()});
        return false;
    }

    protected boolean ensureIntoClauseNotSpecified() {
        if (this.info.isDynamicArrayRecord() && this.isGetStatement() && this.info.getIntoClauseNode() != null) {
            this.addErrorMessage("1026");
            return false;
        }
        return true;
    }

    protected boolean ensureSQLRecordVariableIsSpecified() {
        if (this.isSQLRecordVariableSpecified()) {
            return true;
        }
        this.addErrorMessage("1015", new String[]{this.info.getIOType()});
        return false;
    }

    public boolean isAddIntoClause() {
        return this.addIntoClause;
    }

    protected boolean isAddStatement() {
        return this.info.getIOType().equalsIgnoreCase("add");
    }

    protected boolean isCloseStatement() {
        return this.info.getIOType().equalsIgnoreCase("close");
    }

    protected boolean isGetStatement() {
        return this.info.getIOType().equalsIgnoreCase("get");
    }

    protected boolean isGetByPositionStatement() {
        return this.info.getIOType().equalsIgnoreCase("get by position");
    }

    protected boolean isGetForUpdateStatement() {
        return this.info.getIOType().equalsIgnoreCase("get forUpdate");
    }

    protected boolean isOpenForUpdateStatement() {
        return this.info.getIOType().equalsIgnoreCase("open forUpdate");
    }

    private boolean isDynamicArraySupported() {
        return this.isGetStatement();
    }

    protected boolean isSQLStatementSpecified() {
        return this.info.getSqlStatement() != null;
    }

    protected boolean isPreparedStatementReferenceSpecified() {
        return this.info.hasPreparedStatementReference();
    }

    protected boolean isExplicitSQLStatementAllowed() {
        return !this.isCloseStatement() && !this.isGetByPositionStatement();
    }

    protected boolean isSQLRecordVariableSpecified() {
        boolean isSpecified;
        boolean bl = isSpecified = !this.info.getStatement().getIOObjects().isEmpty();
        if (!isSpecified && this.info.getStatement() instanceof DeleteStatement) {
            isSpecified = ((DeleteStatement)this.info.getStatement()).getDataSource().getExpression() != null;
        }
        return isSpecified;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IDataBinding getSQLRecordBindingFromTarget() {
        Expression recordVar;
        List exprList = this.info.getStatement().getIOObjects();
        if (exprList.isEmpty()) {
            if (!(this.info.getStatement() instanceof DeleteStatement)) return null;
            DeleteStatement deleteStatement = (DeleteStatement)this.info.getStatement();
            recordVar = deleteStatement.getDataSource().getExpression();
        } else {
            recordVar = (Expression)exprList.get(0);
        }
        if (recordVar instanceof ArrayAccess) {
            this.info.setDynamicArrayRecord(true);
        }
        this.info.setSqlRecordVariable(recordVar);
        this.info.setIOObjectName(recordVar.getCanonicalString());
        IDataBinding dataBinding = recordVar.resolveDataBinding();
        if (SQLUtility.isEntityRecord((IDataBinding)dataBinding)) {
            this.info.setIOObjectName(dataBinding.getName());
            return dataBinding;
        }
        if (!SQLUtility.isBasicRecord((IDataBinding)dataBinding)) return null;
        this.info.setIOObjectName(dataBinding.getName());
        return dataBinding;
    }

    protected boolean ensureSQLStatementIsNotSpecified() {
        if (this.isSQLStatementSpecified()) {
            this.addErrorMessage("1010", new String[]{this.info.getIOType(), "SQL"});
            return false;
        }
        return true;
    }

    protected boolean ensurePreparedStatementReferenceIsNotSpecified() {
        if (this.isPreparedStatementReferenceSpecified()) {
            this.addErrorMessage("1011");
            return false;
        }
        return true;
    }

    protected boolean ensureDynamicArrayAllowed() {
        if (this.info.isDynamicArrayRecord() && !this.isDynamicArraySupported()) {
            if (this.isAddStatement() && this.shouldIssueExplicitSQLStatementNotAllowedMessage()) {
                this.hasDynamicArrayError = this.issueExplicitSQLStatementNotAllowedWithDynamicArray();
            } else {
                this.addErrorMessage("1008", new String[]{this.info.getIOType()});
                this.hasDynamicArrayError = true;
            }
            if (this.hasDynamicArrayError) {
                return false;
            }
        }
        return true;
    }

    protected boolean shouldIssueExplicitSQLStatementNotAllowedMessage() {
        return !this.isGetByPositionStatement();
    }

    protected boolean issueExplicitSQLStatementNotAllowedWithDynamicArray() {
        this.addErrorMessage("1009");
        return true;
    }

    protected void getBoundASTNode(IEGLDocument document, String name, int offset, IFile file, IBoundNodeProcessor boundNodeProcessor) {
        IProject proj = file.getProject();
        String[] pkgName = EditorUtility.getPackageName(file);
        IWorkingCopy[] currRegedWCs = EGLCore.getSharedWorkingCopies((IBufferFactory)EGLUI.getBufferFactory());
        BoundNodeWorkingCopyCompileRequestor requestor = new BoundNodeWorkingCopyCompileRequestor(document, offset, file, boundNodeProcessor);
        if (name != null) {
            WorkingCopyCompiler.getInstance().compilePart(proj, pkgName, file, currRegedWCs, name, (IWorkingCopyCompileRequestor)requestor);
        } else {
            WorkingCopyCompiler.getInstance().compileAllParts(proj, pkgName, file, currRegedWCs, (IWorkingCopyCompileRequestor)requestor);
        }
    }

    protected String getStatementText() {
        StringBuffer buffer = new StringBuffer();
        String indentString = String.valueOf(this.determineIndentString()) + "\t";
        if (this.addIntoClause && this.intoClause != null) {
            this.addIntoClause(buffer, indentString);
        }
        this.addSQLStatement(buffer, indentString);
        if (this.isExecuteStatement) {
            buffer.append(" ");
        }
        return buffer.toString();
    }

    private void addSQLStatement(StringBuffer buffer, String indentString) {
        if (this.info.isShouldAddSQLStatement() || this.isResetAction()) {
            if (this.sqlStatement == null) {
                return;
            }
            this.sqlStatement = this.trimTrailingCRLF(this.sqlStatement);
            if (!this.isExecuteStatement) {
                buffer.append(" ");
                if (this.usingClause != null) {
                    this.usingClause = this.trimTrailingCRLF(this.usingClause);
                    buffer.append(this.usingClause);
                    buffer.append(" ");
                }
                buffer.append("with");
            }
            if (!this.isExecuteStatement || !this.isResetAction()) {
                buffer.append("\r\n");
                buffer.append(indentString);
            } else {
                buffer.append("\t");
            }
            buffer.append("#sql{");
            buffer.append("\r\n");
            List lines = this.getLineList(this.sqlStatement);
            for (String line : lines) {
                buffer.append(indentString);
                buffer.append("\t");
                buffer.append(line);
            }
            buffer.append("\r\n");
            buffer.append(indentString);
            buffer.append("}");
        }
    }

    private String trimTrailingCRLF(String str) {
        int index = str.length();
        if (index > 2 && str.endsWith("\r\n")) {
            return str.substring(0, index - 2);
        }
        return str;
    }

    private String determineIndentString() {
        int position = this.info.getStatement().getOffset();
        String line = this.getLineText(position);
        int index = line.indexOf(line.trim());
        return line.substring(0, index);
    }

    private String getLineText(int position) {
        String text = "";
        try {
            IRegion region = this.info.getDocument().getLineInformationOfOffset(position);
            text = this.info.getDocument().get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException e) {
            Logger.log((Object)this, (Throwable)e);
        }
        return text;
    }

    private void addIntoClause(StringBuffer buffer, String indentString) {
        if (this.isResetAction()) {
            buffer.append("\t");
        } else {
            buffer.append("\r\n");
            buffer.append(indentString);
        }
        List lines = this.getLineList(this.intoClause);
        Iterator iter = lines.iterator();
        while (iter.hasNext()) {
            String line = (String)iter.next();
            buffer.append(line);
            if (!iter.hasNext()) continue;
            buffer.append(indentString);
        }
    }

    protected boolean isResetAction() {
        return false;
    }

    private List getLineList(String string) {
        ArrayList<String> lines = new ArrayList<String>();
        String workingString = string;
        while (workingString != null && workingString.length() > 0) {
            String line;
            int index = workingString.indexOf("\r\n");
            if (index > 0) {
                line = workingString.substring(0, index + 2);
                workingString = workingString.substring(index + 2);
            } else {
                line = workingString;
                workingString = "";
            }
            lines.add(line);
        }
        return lines;
    }

    protected String[][] getKeyItemAndColumnNames(IDataBinding sqlRecordBinding) {
        if (this.info.getUsingKeysNode() != null) {
            return this.getKeyItemAndColumnNames((UsingKeysClause)this.info.getUsingKeysNode(), sqlRecordBinding);
        }
        return null;
    }

    private String[][] getKeyItemAndColumnNames(UsingKeysClause keyClause, IDataBinding sqlRecordBinding) {
        String[][] keyItemAndColumnNames = null;
        List usingKeys = keyClause.getExpressions();
        if (!usingKeys.isEmpty()) {
            keyItemAndColumnNames = new String[usingKeys.size()][2];
            int i = 0;
            while (i < usingKeys.size()) {
                String columnName = null;
                Expression key = (Expression)usingKeys.get(i);
                keyItemAndColumnNames[i][0] = key.getCanonicalString();
                IDataBinding itemBinding = ((Expression)usingKeys.get(i)).resolveDataBinding();
                if (SQLUtility.isValid((IDataBinding)itemBinding)) {
                    columnName = SQLUtility.getColumnName((IDataBinding)itemBinding, (IDataBinding)sqlRecordBinding);
                }
                if (columnName == null) {
                    columnName = key.isName() ? ((Name)key).getIdentifier() : key.getCanonicalString();
                }
                keyItemAndColumnNames[i][1] = columnName;
                ++i;
            }
        }
        return keyItemAndColumnNames;
    }

    protected IPartBinding getEnclosingPartBinding(Node boundNode) {
        IBinding binding;
        Name name;
        while (!(boundNode instanceof Part)) {
            boundNode = boundNode.getParent();
        }
        if (boundNode instanceof Part && (name = ((Part)boundNode).getName()) != null && (binding = name.resolveBinding()) instanceof IPartBinding) {
            return (IPartBinding)binding;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Statement SQLStatementFinder(IInvocationContext context) {
        astNode = context.getCoveringNode();
        if (astNode == null || !(astNode instanceof Statement)) ** GOTO lbl6
        return (Statement)astNode;
lbl-1000:
        // 1 sources

        {
            if (!((astNode = astNode.getParent()) instanceof Statement)) continue;
            return (Statement)astNode;
lbl6:
            // 2 sources

            ** while (!(astNode instanceof NestedFunction) && !(astNode instanceof Part))
        }
lbl7:
        // 1 sources

        return null;
    }

    public class BoundNodeWorkingCopyCompileRequestor
    implements IWorkingCopyCompileRequestor {
        IEGLDocument document;
        int documentOffset;
        IBoundNodeProcessor boundNodeProcessor;

        protected BoundNodeWorkingCopyCompileRequestor(IEGLDocument document, int documentOffset, IFile file, IBoundNodeProcessor boundNodeProcessor) {
            this.document = document;
            this.documentOffset = documentOffset;
            this.boundNodeProcessor = boundNodeProcessor;
        }

        public void acceptResult(WorkingCopyCompilationResult result) {
            Node nodeAtOffset = this.document.getNewModelNodeAtOffset(this.documentOffset, result.getBoundPart());
            if (nodeAtOffset != null) {
                this.boundNodeProcessor.processBoundNode(nodeAtOffset, result.getBoundPart());
            }
        }
    }

    protected static interface IBoundNodeProcessor {
        public void processBoundNode(Node var1, Node var2);
    }
}

