/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.preferences;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.edt.ide.core.Logger;
import org.eclipse.edt.ide.core.utils.EclipseUtilities;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.wizards.FolderSelectionDialog;
import org.eclipse.edt.ide.ui.internal.wizards.IStatusChangeListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class GenerationSettingsComposite
extends Composite {
    protected IResource resource;
    protected final IPreferenceStore prefStore;
    protected IEclipsePreferences projectPrefs;
    protected final String dirPropertyID;
    protected final String argPropertyID;
    protected final String preferenceID;
    protected final IStatusChangeListener statusListener;
    protected Button browseInside;
    protected Text genInsideDirectory;
    protected Text genArguments;
    protected String originalGenDir;
    private StatusInfo latestStatus = new StatusInfo();

    public GenerationSettingsComposite(Composite parent, int style, IResource resource, IPreferenceStore prefStore, IEclipsePreferences projectPrefs, String dirPropertyID, String argPropertyID, String preferenceID, IStatusChangeListener statusListener) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.resource = resource;
        this.prefStore = prefStore;
        this.projectPrefs = projectPrefs;
        this.dirPropertyID = dirPropertyID;
        this.argPropertyID = argPropertyID;
        this.preferenceID = preferenceID;
        this.statusListener = statusListener;
        this.createContents();
        this.init();
    }

    private void createContents() {
        Group group = new Group((Composite)this, 0);
        group.setText(UINlsStrings.genSettingsGroupLabel);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        group.setFont(this.getFont());
        GridData data = new GridData(1808);
        data.horizontalIndent = 0;
        group.setLayoutData((Object)data);
        if (this.resource == null) {
            Composite c = new Composite((Composite)group, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            c.setLayout((Layout)layout);
            c.setFont(group.getFont());
            data = new GridData(1808);
            data.horizontalIndent = 0;
            c.setLayoutData((Object)data);
            new Label(c, 16384).setText(UINlsStrings.genDefaultGenDir);
            this.genInsideDirectory = new Text(c, 2048);
            data = new GridData(768);
            this.genInsideDirectory.setLayoutData((Object)data);
            if (this.statusListener != null) {
                this.genInsideDirectory.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        String text = GenerationSettingsComposite.this.genInsideDirectory.getText().trim();
                        if (text.length() == 0) {
                            GenerationSettingsComposite.this.latestStatus.setError(UINlsStrings.genSettingsValidationDefaultBlank);
                            GenerationSettingsComposite.this.statusListener.statusChanged(GenerationSettingsComposite.this.latestStatus);
                            return;
                        }
                        if (!new Path(text).isValidPath(text)) {
                            GenerationSettingsComposite.this.latestStatus.setError(UINlsStrings.genSettingsValidationDefaultInvalid);
                            GenerationSettingsComposite.this.statusListener.statusChanged(GenerationSettingsComposite.this.latestStatus);
                            return;
                        }
                        if (text.charAt(0) == '/') {
                            GenerationSettingsComposite.this.latestStatus.setError(UINlsStrings.genSettingsValidationDefaultRetlative);
                            GenerationSettingsComposite.this.statusListener.statusChanged(GenerationSettingsComposite.this.latestStatus);
                            return;
                        }
                        String[] stringArray = new Path(text).segments();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String segment = stringArray[n2];
                            IStatus status = ResourcesPlugin.getWorkspace().validateName(segment, 2);
                            if (!status.isOK()) {
                                GenerationSettingsComposite.this.latestStatus.setError(UINlsStrings.genSettingsValidationInvalid);
                                GenerationSettingsComposite.this.statusListener.statusChanged(status);
                                return;
                            }
                            ++n2;
                        }
                        if (GenerationSettingsComposite.this.latestStatus != null && !GenerationSettingsComposite.this.latestStatus.isOK()) {
                            GenerationSettingsComposite.this.latestStatus.setOK();
                            GenerationSettingsComposite.this.statusListener.statusChanged(GenerationSettingsComposite.this.latestStatus);
                            return;
                        }
                    }
                });
            }
        } else {
            Composite cIn = new Composite((Composite)group, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            cIn.setLayout((Layout)layout);
            cIn.setFont(group.getFont());
            data = new GridData(768);
            data.horizontalIndent = 0;
            cIn.setLayoutData((Object)data);
            this.genInsideDirectory = new Text(cIn, 2048);
            data = new GridData(768);
            this.genInsideDirectory.setLayoutData((Object)data);
            this.browseInside = new Button(cIn, 8);
            this.browseInside.setText("...");
            this.browseInside.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object result;
                    IResource initialSelection;
                    FolderSelectionDialog dialog = new FolderSelectionDialog(GenerationSettingsComposite.this.browseInside.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                    dialog.setAllowMultiple(false);
                    String currentValue = GenerationSettingsComposite.this.genInsideDirectory.getText();
                    if (currentValue.length() > 0 && (initialSelection = currentValue.charAt(0) == '/' ? ResourcesPlugin.getWorkspace().getRoot().findMember(currentValue) : GenerationSettingsComposite.this.resource.getProject().findMember(currentValue)) != null) {
                        dialog.setInitialSelection(initialSelection);
                    }
                    dialog.setTitle(UINlsStrings.genDirSelectionTitle);
                    dialog.setMessage(UINlsStrings.genDirSelectionMsg);
                    dialog.setInput(ResourcesPlugin.getWorkspace().getRoot());
                    if (dialog.open() == 0 && (result = dialog.getResult()[0]) instanceof IContainer) {
                        IContainer container = (IContainer)result;
                        if (!(container instanceof IProject) && container.getProject().equals((Object)GenerationSettingsComposite.this.resource.getProject())) {
                            GenerationSettingsComposite.this.genInsideDirectory.setText(container.getProjectRelativePath().toString());
                        } else {
                            GenerationSettingsComposite.this.genInsideDirectory.setText(container.getFullPath().toString());
                        }
                    }
                }
            });
            if (this.statusListener != null) {
                this.genInsideDirectory.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        String text = GenerationSettingsComposite.this.genInsideDirectory.getText().trim();
                        if (text.length() == 0) {
                            GenerationSettingsComposite.this.latestStatus.setError(UINlsStrings.genSettingsValidationBlank);
                            GenerationSettingsComposite.this.statusListener.statusChanged(GenerationSettingsComposite.this.latestStatus);
                            return;
                        }
                        Path path = new Path(text);
                        if (!path.isValidPath(text)) {
                            GenerationSettingsComposite.this.latestStatus.setError(UINlsStrings.genSettingsValidationInvalid);
                            GenerationSettingsComposite.this.statusListener.statusChanged(GenerationSettingsComposite.this.latestStatus);
                            return;
                        }
                        if (!(text.charAt(0) != '/' || path.segmentCount() >= 1 && ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0)).exists())) {
                            GenerationSettingsComposite.this.latestStatus.setError(UINlsStrings.genSettingsValidationProject);
                            GenerationSettingsComposite.this.statusListener.statusChanged(GenerationSettingsComposite.this.latestStatus);
                            return;
                        }
                        String[] stringArray = path.segments();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String segment = stringArray[n2];
                            IStatus status = ResourcesPlugin.getWorkspace().validateName(segment, 2);
                            if (!status.isOK()) {
                                GenerationSettingsComposite.this.latestStatus.setError(UINlsStrings.genSettingsValidationInvalid);
                                GenerationSettingsComposite.this.statusListener.statusChanged(status);
                                return;
                            }
                            ++n2;
                        }
                        if (GenerationSettingsComposite.this.latestStatus != null && !GenerationSettingsComposite.this.latestStatus.isOK()) {
                            GenerationSettingsComposite.this.latestStatus.setOK();
                            GenerationSettingsComposite.this.statusListener.statusChanged(GenerationSettingsComposite.this.latestStatus);
                            return;
                        }
                    }
                });
            }
            Group argGroup = new Group((Composite)this, 0);
            argGroup.setText(UINlsStrings.genArguments);
            GridLayout argLayout = new GridLayout();
            argLayout.numColumns = 1;
            argGroup.setLayout((Layout)argLayout);
            argGroup.setFont(this.getFont());
            GridData argData = new GridData(1808);
            argData.horizontalIndent = 0;
            argGroup.setLayoutData((Object)argData);
            this.genArguments = new Text((Composite)argGroup, 2048);
            data = new GridData(768);
            data.horizontalIndent = 5;
            this.genArguments.setLayoutData((Object)data);
        }
    }

    private void init() {
        if (this.resource == null) {
            this.genInsideDirectory.setText(this.prefStore.getString(this.preferenceID));
        } else {
            String genDir = ProjectSettingsUtility.getGenerationDirectory((IResource)this.resource, (IPreferenceStore)this.prefStore, (IEclipsePreferences)this.projectPrefs, (String)this.dirPropertyID, (String)this.preferenceID);
            if ((genDir = EclipseUtilities.convertFromInternalPath((String)genDir)).length() == 0) {
                genDir = this.resource.getProject().getFullPath().toString();
            }
            this.genInsideDirectory.setText(genDir);
            String genArgument = ProjectSettingsUtility.getGenerationArgument((IResource)this.resource, (IPreferenceStore)this.prefStore, (IEclipsePreferences)this.projectPrefs, (String)this.argPropertyID);
            this.genArguments.setText(genArgument);
        }
        this.originalGenDir = this.genInsideDirectory.getText();
    }

    public void performDefaults() {
        this.latestStatus.setOK();
        this.statusListener.statusChanged(this.latestStatus);
        this.init();
    }

    public boolean performOK() {
        if (this.resource == null) {
            this.prefStore.setValue(this.preferenceID, this.genInsideDirectory.getText());
            if (!this.genInsideDirectory.getText().equalsIgnoreCase(this.originalGenDir)) {
                try {
                    ProjectSettingsUtility.setBuildFlag(null);
                }
                catch (BackingStoreException e) {
                    Logger.log((Object)"GenerationSettingsComposite.performOk", (String)NLS.bind((String)UINlsStrings.genSettingsSaveError, (Object)this.resource.getFullPath().toString()), (Throwable)e);
                    return false;
                }
            }
        } else {
            try {
                String value = this.getGenerationDiretory();
                if (!value.equalsIgnoreCase(this.originalGenDir)) {
                    ProjectSettingsUtility.setBuildFlag((IResource)this.resource);
                }
                value = EclipseUtilities.convertToInternalPath((String)value);
                ProjectSettingsUtility.setGenerationDirectory((IResource)this.resource, (String)value, (IEclipsePreferences)this.projectPrefs, (String)this.dirPropertyID);
                String argValue = this.getArgValue();
                if (argValue != null) {
                    ProjectSettingsUtility.setGenerationArgument((IResource)this.resource, (String)argValue, (IEclipsePreferences)this.projectPrefs, (String)this.argPropertyID);
                }
            }
            catch (BackingStoreException e) {
                Logger.log((Object)"GenerationSettingsComposite.performOk", (String)NLS.bind((String)UINlsStrings.genSettingsSaveError, (Object)this.resource.getFullPath().toString()), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public void removePreferencesForAResource() {
        if (this.projectPrefs != null) {
            try {
                ProjectSettingsUtility.setGenerationDirectory((IResource)this.resource, null, (IEclipsePreferences)this.projectPrefs, (String)this.dirPropertyID);
                ProjectSettingsUtility.setGenerationArgument((IResource)this.resource, null, (IEclipsePreferences)this.projectPrefs, (String)this.argPropertyID);
            }
            catch (BackingStoreException e) {
                Logger.log((Object)"GenerationSettingsComposite.removePreferencesForAResource", (String)NLS.bind((String)UINlsStrings.CompilerPropertyPage_errorCleaningUpPrefStore, (Object)this.resource.getFullPath().toString()), (Throwable)e);
            }
        }
    }

    public void removePreferencesForAllResources() {
        if (this.projectPrefs != null) {
            try {
                Preferences propertyPrefs = this.projectPrefs.node(this.dirPropertyID);
                propertyPrefs.clear();
                propertyPrefs.flush();
                propertyPrefs = this.projectPrefs.node(this.argPropertyID);
                propertyPrefs.clear();
                propertyPrefs.flush();
            }
            catch (BackingStoreException e) {
                Logger.log((Object)"GenerationSettingsComposite.removePreferencesForAllResources", (String)NLS.bind((String)UINlsStrings.CompilerPropertyPage_errorCleaningUpPrefStore, (Object)this.resource.getFullPath().toString()), (Throwable)e);
            }
        }
    }

    public void performRemoval() {
        if (this.statusListener != null) {
            this.latestStatus.setOK();
            this.statusListener.statusChanged(this.latestStatus);
        }
    }

    public void performAddition() {
        this.genInsideDirectory.setText(this.genInsideDirectory.getText());
    }

    public String getGenerationDiretory() {
        String value = this.genInsideDirectory.getText();
        if (value.equals(this.resource.getProject().getFullPath().toString())) {
            value = "";
        }
        return value;
    }

    public String getArgValue() {
        if (this.genArguments == null) {
            return null;
        }
        return this.genArguments.getText().trim();
    }

    public String getDirPropertyID() {
        return this.dirPropertyID;
    }

    public String getArgPropertyID() {
        return this.argPropertyID;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public void setProjectPrefs(IEclipsePreferences projectPrefs) {
        this.projectPrefs = projectPrefs;
    }
}

