/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.eglx.lang;

import eglx.lang.AnyException;
import eglx.lang.ENumber;
import eglx.lang.NumericOverflowException;
import eglx.lang.TypeCastException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.runtime.java.eglx.lang.EAny;
import org.eclipse.edt.runtime.java.eglx.lang.EBigint;
import org.eclipse.edt.runtime.java.eglx.lang.EFloat;
import org.eclipse.edt.runtime.java.eglx.lang.EInt;
import org.eclipse.edt.runtime.java.eglx.lang.ESmallfloat;
import org.eclipse.edt.runtime.java.eglx.lang.ESmallint;
import org.eclipse.edt.runtime.java.eglx.lang.EString;

public class EDecimal
extends AnyBoxedObject<BigDecimal>
implements ENumber {
    private static final long serialVersionUID = 10L;
    private static final BigDecimal[][] MAX_DIGIT_ORIENTED_BD_VALUES = new BigDecimal[34][];
    private static final BigDecimal[][] MIN_DIGIT_ORIENTED_BD_VALUES;
    private static final BigDecimal[][] MAX_BYTE_ORIENTED_BD_VALUES;
    private static final BigDecimal[][] MIN_BYTE_ORIENTED_BD_VALUES;
    public static final int TRUNCATE_BD = 1;
    public static final int ROUND_BD = 4;
    public static final int BIGDECIMAL_RESULT_SCALE = 32;
    private static final long[] MAX_DIGIT_ORIENTED_LONG_VALUES;
    private static final long[] MIN_DIGIT_ORIENTED_LONG_VALUES;
    public static final BigInteger[] MAX_DIGIT_ORIENTED_BI_VALUES;
    public static final BigInteger[] MIN_DIGIT_ORIENTED_BI_VALUES;
    private int maxPrecision;
    private int maxDecimals;

    static {
        EDecimal.MAX_DIGIT_ORIENTED_BD_VALUES[0] = new BigDecimal[1];
        EDecimal.MAX_DIGIT_ORIENTED_BD_VALUES[0][0] = BigDecimal.ZERO;
        MIN_DIGIT_ORIENTED_BD_VALUES = new BigDecimal[34][];
        EDecimal.MIN_DIGIT_ORIENTED_BD_VALUES[0] = new BigDecimal[1];
        EDecimal.MIN_DIGIT_ORIENTED_BD_VALUES[0][0] = BigDecimal.ZERO;
        int i = 1;
        while (i < 34) {
            EDecimal.MAX_DIGIT_ORIENTED_BD_VALUES[i] = new BigDecimal[i + 1];
            EDecimal.MIN_DIGIT_ORIENTED_BD_VALUES[i] = new BigDecimal[i + 1];
            ++i;
        }
        MAX_BYTE_ORIENTED_BD_VALUES = new BigDecimal[3][];
        EDecimal.MAX_BYTE_ORIENTED_BD_VALUES[0] = new BigDecimal[5];
        EDecimal.MAX_BYTE_ORIENTED_BD_VALUES[0][0] = BigDecimal.ZERO;
        EDecimal.MAX_BYTE_ORIENTED_BD_VALUES[1] = new BigDecimal[10];
        EDecimal.MAX_BYTE_ORIENTED_BD_VALUES[1][0] = BigDecimal.ZERO;
        EDecimal.MAX_BYTE_ORIENTED_BD_VALUES[2] = new BigDecimal[19];
        EDecimal.MAX_BYTE_ORIENTED_BD_VALUES[2][0] = BigDecimal.ZERO;
        MIN_BYTE_ORIENTED_BD_VALUES = new BigDecimal[3][];
        EDecimal.MIN_BYTE_ORIENTED_BD_VALUES[0] = new BigDecimal[5];
        EDecimal.MIN_BYTE_ORIENTED_BD_VALUES[0][0] = BigDecimal.ZERO;
        EDecimal.MIN_BYTE_ORIENTED_BD_VALUES[1] = new BigDecimal[10];
        EDecimal.MIN_BYTE_ORIENTED_BD_VALUES[1][0] = BigDecimal.ZERO;
        EDecimal.MIN_BYTE_ORIENTED_BD_VALUES[2] = new BigDecimal[19];
        EDecimal.MIN_BYTE_ORIENTED_BD_VALUES[2][0] = BigDecimal.ZERO;
        long[] lArray = new long[20];
        lArray[1] = 9L;
        lArray[2] = 99L;
        lArray[3] = 999L;
        lArray[4] = 9999L;
        lArray[5] = 99999L;
        lArray[6] = 999999L;
        lArray[7] = 9999999L;
        lArray[8] = 99999999L;
        lArray[9] = 999999999L;
        lArray[10] = 9999999999L;
        lArray[11] = 99999999999L;
        lArray[12] = 999999999999L;
        lArray[13] = 9999999999999L;
        lArray[14] = 99999999999999L;
        lArray[15] = 999999999999999L;
        lArray[16] = 9999999999999999L;
        lArray[17] = 99999999999999999L;
        lArray[18] = 999999999999999999L;
        lArray[19] = Long.MAX_VALUE;
        MAX_DIGIT_ORIENTED_LONG_VALUES = lArray;
        long[] lArray2 = new long[20];
        lArray2[1] = -9L;
        lArray2[2] = -99L;
        lArray2[3] = -999L;
        lArray2[4] = -9999L;
        lArray2[5] = -99999L;
        lArray2[6] = -999999L;
        lArray2[7] = -9999999L;
        lArray2[8] = -99999999L;
        lArray2[9] = -999999999L;
        lArray2[10] = -9999999999L;
        lArray2[11] = -99999999999L;
        lArray2[12] = -999999999999L;
        lArray2[13] = -9999999999999L;
        lArray2[14] = -99999999999999L;
        lArray2[15] = -999999999999999L;
        lArray2[16] = -9999999999999999L;
        lArray2[17] = -99999999999999999L;
        lArray2[18] = -999999999999999999L;
        lArray2[19] = Long.MIN_VALUE;
        MIN_DIGIT_ORIENTED_LONG_VALUES = lArray2;
        MAX_DIGIT_ORIENTED_BI_VALUES = new BigInteger[]{BigInteger.ZERO, BigInteger.valueOf(9L), BigInteger.valueOf(99L), BigInteger.valueOf(999L), BigInteger.valueOf(9999L), BigInteger.valueOf(99999L), BigInteger.valueOf(999999L), BigInteger.valueOf(9999999L), BigInteger.valueOf(99999999L), BigInteger.valueOf(999999999L), BigInteger.valueOf(9999999999L), BigInteger.valueOf(99999999999L), BigInteger.valueOf(999999999999L), BigInteger.valueOf(9999999999999L), BigInteger.valueOf(99999999999999L), BigInteger.valueOf(999999999999999L), BigInteger.valueOf(9999999999999999L), BigInteger.valueOf(99999999999999999L), BigInteger.valueOf(999999999999999999L), new BigInteger("9999999999999999999"), new BigInteger("99999999999999999999"), new BigInteger("999999999999999999999"), new BigInteger("9999999999999999999999"), new BigInteger("99999999999999999999999"), new BigInteger("999999999999999999999999"), new BigInteger("9999999999999999999999999"), new BigInteger("99999999999999999999999999"), new BigInteger("999999999999999999999999999"), new BigInteger("9999999999999999999999999999"), new BigInteger("99999999999999999999999999999"), new BigInteger("999999999999999999999999999999"), new BigInteger("9999999999999999999999999999999"), new BigInteger("99999999999999999999999999999999"), new BigInteger("999999999999999999999999999999999")};
        MIN_DIGIT_ORIENTED_BI_VALUES = new BigInteger[]{BigInteger.ZERO, MAX_DIGIT_ORIENTED_BI_VALUES[1].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[2].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[3].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[4].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[5].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[6].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[7].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[8].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[9].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[10].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[11].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[12].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[13].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[14].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[15].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[16].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[17].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[18].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[19].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[20].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[21].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[22].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[23].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[24].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[25].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[26].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[27].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[28].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[29].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[30].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[31].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[32].negate(), MAX_DIGIT_ORIENTED_BI_VALUES[33].negate()};
    }

    public int getPrecision() {
        return this.maxPrecision;
    }

    public int getDecimals() {
        return this.maxDecimals;
    }

    private EDecimal(BigDecimal value) {
        super(value);
        if (value != null) {
            this.maxPrecision = value.precision();
            this.maxDecimals = value.scale();
        }
    }

    private EDecimal(BigDecimal value, int precision) {
        super(value);
        if (value != null) {
            this.maxPrecision = precision;
        }
    }

    private EDecimal(BigDecimal value, int precision, int decimals) {
        super(value);
        if (value != null) {
            this.maxPrecision = precision;
            this.maxDecimals = decimals;
        }
    }

    public String toString() {
        return EString.asString((BigDecimal)this.object, new Integer[0]);
    }

    public static EDecimal ezeBox(BigDecimal value) {
        return new EDecimal(value);
    }

    public static EDecimal ezeBox(BigDecimal value, int precision, int decimals) {
        return new EDecimal(value, precision, decimals);
    }

    public static BigDecimal getMaxValue(int length, int decimals) {
        BigDecimal max = MAX_DIGIT_ORIENTED_BD_VALUES[length][decimals];
        if (max == null) {
            EDecimal.MAX_DIGIT_ORIENTED_BD_VALUES[length][decimals] = max = new BigDecimal(MAX_DIGIT_ORIENTED_BI_VALUES[length], decimals);
        }
        return max;
    }

    public static BigDecimal getMinValue(int length, int decimals) {
        BigDecimal min = MIN_DIGIT_ORIENTED_BD_VALUES[length][decimals];
        if (min == null) {
            BigDecimal max = EDecimal.getMaxValue(length, decimals);
            EDecimal.MIN_DIGIT_ORIENTED_BD_VALUES[length][decimals] = min = max.negate();
        }
        return min;
    }

    private static BigDecimal handleNumericOverflow(BigDecimal value, int precision, int scale, boolean ignoreOverflow) throws AnyException {
        BigDecimal result = value;
        if (!ignoreOverflow) {
            throw new NumericOverflowException();
        }
        BigDecimal divisor = new BigDecimal(BigInteger.ONE, -(precision - scale));
        result = value.subtract(value.divide(divisor, 0, 1).multiply(divisor));
        return result;
    }

    public static Object ezeCast(Object value, Object[] constraints) throws AnyException {
        Integer[] args = new Integer[constraints.length];
        System.arraycopy(constraints, 0, args, 0, args.length);
        return EDecimal.ezeCast(value, args);
    }

    public static BigDecimal ezeCast(Object value, Integer ... args) throws AnyException {
        return (BigDecimal)EAny.ezeCast(value, "asDecimal", EDecimal.class, new Class[]{Integer[].class}, args);
    }

    public static boolean ezeIsa(Object value, Integer ... args) {
        boolean isa = value instanceof EDecimal;
        if (isa) {
            if (args.length != 0) {
                boolean bl = isa = ((EDecimal)value).getPrecision() == args[0].intValue();
                if (isa && args.length == 1) {
                    isa = ((EDecimal)value).getDecimals() == 0;
                } else if (isa && args.length == 2) {
                    isa = ((EDecimal)value).getDecimals() == args[1].intValue();
                }
            }
        } else {
            isa = value instanceof BigDecimal;
            if (isa && args.length != 0) {
                boolean bl = isa = ((BigDecimal)value).precision() == args[0].intValue();
                if (isa && args.length == 1) {
                    isa = ((BigDecimal)value).scale() == 0;
                } else if (isa && args.length == 2) {
                    isa = ((BigDecimal)value).scale() == args[1].intValue();
                }
            }
        }
        return isa;
    }

    public static BigDecimal asDecimal(Short value, Integer ... args) throws AnyException {
        if (value == null) {
            return null;
        }
        if (args.length == 2) {
            return EDecimal.asDecimal(BigDecimal.valueOf(value.shortValue()), (int)args[0], (int)args[1]);
        }
        return BigDecimal.valueOf(value.shortValue());
    }

    public static BigDecimal asDecimal(ESmallint value, Integer ... args) throws AnyException {
        if (value == null) {
            return null;
        }
        if (args.length == 2) {
            return EDecimal.asDecimal(BigDecimal.valueOf(((Short)value.ezeUnbox()).shortValue()), (int)args[0], (int)args[1]);
        }
        return BigDecimal.valueOf(((Short)value.ezeUnbox()).shortValue());
    }

    public static BigDecimal asDecimal(Integer value, Integer ... args) throws AnyException {
        if (value == null) {
            return null;
        }
        if (args.length == 2) {
            return EDecimal.asDecimal(BigDecimal.valueOf(value.intValue()), (int)args[0], (int)args[1]);
        }
        return BigDecimal.valueOf(value.intValue());
    }

    public static BigDecimal asDecimal(EInt value, Integer ... args) throws AnyException {
        if (value == null) {
            return null;
        }
        if (args.length == 2) {
            return EDecimal.asDecimal(BigDecimal.valueOf(((Integer)value.ezeUnbox()).intValue()), (int)args[0], (int)args[1]);
        }
        return BigDecimal.valueOf(((Integer)value.ezeUnbox()).intValue());
    }

    public static BigDecimal asDecimal(Long value, Integer ... args) throws AnyException {
        if (value == null) {
            return null;
        }
        if (args.length == 2) {
            return EDecimal.asDecimal(BigDecimal.valueOf(value), (int)args[0], (int)args[1]);
        }
        return BigDecimal.valueOf(value);
    }

    public static BigDecimal asDecimal(EBigint value, Integer ... args) throws AnyException {
        if (value == null) {
            return null;
        }
        if (args.length == 2) {
            return EDecimal.asDecimal(BigDecimal.valueOf((Long)value.ezeUnbox()), (int)args[0], (int)args[1]);
        }
        return BigDecimal.valueOf((Long)value.ezeUnbox());
    }

    public static BigDecimal asDecimal(Float value, Integer ... args) throws AnyException {
        if (value == null) {
            return null;
        }
        if (args.length == 2) {
            return EDecimal.asDecimal(BigDecimal.valueOf(value.floatValue()), (int)args[0], (int)args[1]);
        }
        return BigDecimal.valueOf(value.floatValue());
    }

    public static BigDecimal asDecimal(ESmallfloat value, Integer ... args) throws AnyException {
        if (value == null) {
            return null;
        }
        if (args.length == 2) {
            return EDecimal.asDecimal(BigDecimal.valueOf(((Float)value.ezeUnbox()).floatValue()), (int)args[0], (int)args[1]);
        }
        return BigDecimal.valueOf(((Float)value.ezeUnbox()).floatValue());
    }

    public static BigDecimal asDecimal(Double value, Integer ... args) throws AnyException {
        if (value == null) {
            return null;
        }
        if (args.length == 2) {
            return EDecimal.asDecimal(BigDecimal.valueOf(value), (int)args[0], (int)args[1]);
        }
        return BigDecimal.valueOf(value);
    }

    public static BigDecimal asDecimal(EFloat value, Integer ... args) throws AnyException {
        if (value == null) {
            return null;
        }
        if (args.length == 2) {
            return EDecimal.asDecimal(BigDecimal.valueOf((Double)value.ezeUnbox()), (int)args[0], (int)args[1]);
        }
        return BigDecimal.valueOf((Double)value.ezeUnbox());
    }

    public static BigDecimal asDecimal(BigDecimal value, Integer ... args) throws AnyException {
        if (value == null) {
            return null;
        }
        if (args.length == 2) {
            return EDecimal.asDecimal(value, (int)args[0], (int)args[1]);
        }
        return value;
    }

    public static BigDecimal asDecimal(EDecimal value, Integer ... args) throws AnyException {
        if (value == null) {
            return null;
        }
        if (args.length == 2) {
            return EDecimal.asDecimal((BigDecimal)value.ezeUnbox(), (int)args[0], (int)args[1]);
        }
        return (BigDecimal)value.ezeUnbox();
    }

    public static BigDecimal asDecimal(BigDecimal value, int precision, int scale) throws AnyException {
        if (value == null) {
            return null;
        }
        return EDecimal.asDecimal(value, EDecimal.getMaxValue(precision, scale), EDecimal.getMinValue(precision, scale), precision, scale, false);
    }

    public static BigDecimal asDecimal(EDecimal value, int precision, int scale) throws AnyException {
        if (value == null) {
            return null;
        }
        return EDecimal.asDecimal((BigDecimal)value.ezeUnbox(), EDecimal.getMaxValue(precision, scale), EDecimal.getMinValue(precision, scale), precision, scale, false);
    }

    public static BigDecimal asDecimal(BigDecimal value, BigDecimal max, BigDecimal min, int precision, int scale) throws AnyException {
        if (value == null || max == null || min == null) {
            return null;
        }
        return EDecimal.asDecimal(value, max, min, precision, scale, false);
    }

    public static BigDecimal asDecimal(BigDecimal value, BigDecimal max, BigDecimal min, int precision, int scale, boolean ignoreOverflow) throws AnyException {
        if (value == null || max == null || min == null) {
            return null;
        }
        BigDecimal result = value;
        if (scale < value.scale()) {
            result = value.setScale(scale, 1);
        }
        if (ignoreOverflow) {
            return result;
        }
        if (result.compareTo(max) <= 0 && result.compareTo(min) >= 0) {
            return result;
        }
        return EDecimal.handleNumericOverflow(value, precision, scale, ignoreOverflow);
    }

    public static BigDecimal asDecimal(BigInteger value, int precision, int scale) throws AnyException {
        if (value == null) {
            return null;
        }
        return EDecimal.asDecimal(new BigDecimal(value), EDecimal.getMaxValue(precision, scale), EDecimal.getMinValue(precision, scale), precision, scale, false);
    }

    public static BigDecimal asDecimal(Number value, Integer ... args) throws AnyException {
        if (value == null) {
            return null;
        }
        if (args.length == 2) {
            return EDecimal.asDecimal(BigDecimal.valueOf(value.doubleValue()), (int)args[0], (int)args[1]);
        }
        return BigDecimal.valueOf(value.doubleValue());
    }

    public static BigDecimal asDecimal(ENumber value, Integer ... args) throws AnyException {
        if (value == null) {
            return null;
        }
        if (args.length == 2) {
            return EDecimal.asDecimal(BigDecimal.valueOf(((Number)value.ezeUnbox()).doubleValue()), (int)args[0], (int)args[1]);
        }
        return BigDecimal.valueOf(((Number)value.ezeUnbox()).doubleValue());
    }

    public static BigDecimal asDecimal(String value, Integer ... args) throws AnyException {
        if (value == null) {
            return null;
        }
        try {
            return EDecimal.asDecimal(new BigDecimal(value), args);
        }
        catch (NumberFormatException numberFormatException) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "string";
            tcx.castToName = "decimal";
            throw tcx.fillInMessage("EGL0007E", value, tcx.actualTypeName, tcx.castToName);
        }
    }

    public static BigDecimal asDecimal(EString value, Integer ... args) throws AnyException {
        if (value == null) {
            return null;
        }
        return EDecimal.asDecimal((String)value.ezeUnbox(), args);
    }

    public static EDecimal asNumber(BigDecimal value, Integer ... args) throws AnyException {
        if (value == null) {
            return null;
        }
        if (args.length == 2) {
            return EDecimal.ezeBox(value, args[0], args[1]);
        }
        return EDecimal.ezeBox(value);
    }

    public static EDecimal asNumber(EDecimal value, Integer ... args) throws AnyException {
        if (value == null) {
            return null;
        }
        return value;
    }

    public static BigDecimal plus(BigDecimal op1, BigDecimal op2) {
        return op1.add(op2);
    }

    public static BigDecimal minus(BigDecimal op1, BigDecimal op2) {
        return op1.subtract(op2);
    }

    public static BigDecimal divide(BigDecimal op1, BigDecimal op2) {
        return op1.divide(op2, 32, 1);
    }

    public static BigDecimal multiply(BigDecimal op1, BigDecimal op2) {
        return op1.multiply(op2);
    }

    public static BigDecimal remainder(BigDecimal op1, BigDecimal op2) {
        return op1.remainder(op2);
    }

    public static double power(BigDecimal op1, BigDecimal op2) throws AnyException {
        return StrictMath.pow(op1.doubleValue(), op2.doubleValue());
    }

    public static int compareTo(BigDecimal op1, BigDecimal op2) throws AnyException {
        if (op1 == null && op2 == null) {
            return 0;
        }
        return op1.compareTo(op2);
    }

    public static boolean equals(BigDecimal op1, BigDecimal op2) {
        if (op1 == null && op2 == null) {
            return true;
        }
        if (op1 == null || op2 == null) {
            return false;
        }
        return op1.compareTo(op2) == 0;
    }

    public static boolean notEquals(BigDecimal op1, BigDecimal op2) {
        return !EDecimal.equals(op1, op2);
    }
}

