/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascriptdev.ide;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.gen.CommandParameter;
import org.eclipse.edt.gen.Generator;
import org.eclipse.edt.gen.javascriptdev.JavaScriptDevGenerator;
import org.eclipse.edt.ide.compiler.gen.GenerationReport;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.edt.ide.core.utils.EclipseUtilities;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.utils.LoadPartException;

public class EclipseJavaScriptDevGenerator
extends JavaScriptDevGenerator {
    private static final String DEV_MODE_SUFFIX = "_devMode";
    private final IFile eglFile;
    private final Part part;
    private final IGenerator generatorProvider;

    public EclipseJavaScriptDevGenerator(IFile eglFile, Part part, IGenerator generator) {
        this.eglFile = eglFile;
        this.part = part;
        this.generatorProvider = generator;
    }

    protected List<Part> loadEGLParts(ICompiler compiler) throws LoadPartException {
        ArrayList<Part> parts = new ArrayList<Part>();
        parts.add(this.part);
        return parts;
    }

    protected void writeFile(Part part, Generator generator) throws Exception {
        String outputFolder = (String)((CommandParameter)this.parameterMapping.get("output")).getValue();
        if (EclipseUtilities.shouldWriteFileInEclipse((String)outputFolder)) {
            IFile outputFile = EclipseUtilities.writeFileInEclipse((Part)part, (String)outputFolder, (IFile)this.eglFile, (String)generator.getResult().toString(), (String)generator.getRelativeFileName(part));
            GenerationReport.writeFile((Part)part, (IFile)this.eglFile, (Generator)generator, (String)DEV_MODE_SUFFIX);
            generator.processFile(outputFile.getFullPath().toString());
        } else {
            super.writeFile(part, generator);
        }
    }
}

