/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.symbols;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.context.symbol.ERuntimeSource;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.designtime.symbols.AbstractDataModelVariableFactory;
import org.eclipse.jst.jsf.designtime.symbols.FileContextUtil;
import org.eclipse.jst.jsf.designtime.symbols.JSFSymbolFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultDataTableSymbolFactory {
    private final AbstractDataModelVariableFactory _dataModelSymbolFactory;

    public DefaultDataTableSymbolFactory(AbstractDataModelVariableFactory dataModelSymbolFactory) {
        assert (dataModelSymbolFactory != null);
        this._dataModelSymbolFactory = dataModelSymbolFactory;
    }

    public ISymbol createSymbolForDataTableValue(String symbolName, Element dataTableElement, IStructuredDocumentContext context) {
        String elText = AbstractDataModelVariableFactory.getELText(dataTableElement);
        IFile file = FileContextUtil.deriveIFileFromContext((IAdaptable)context);
        if (elText != null && file != null) {
            IStructuredDocumentContext elContext = IStructuredDocumentContextFactory.INSTANCE.getContext(context.getStructuredDocument(), (Node)dataTableElement.getAttributeNode("value"));
            IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
            ValueType valueExpr = new JSFSymbolFactory().getValueTypeFromEL(elText, elContext, file);
            if (valueExpr != null) {
                return this._dataModelSymbolFactory.createFromType(symbolName, valueExpr, javaProject);
            }
        }
        return this._dataModelSymbolFactory.getSymbolFactory().createDefaultSymbol(symbolName, ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, null);
    }
}

