/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import org.eclipse.edt.compiler.binding.DataTableBinding;
import org.eclipse.edt.compiler.binding.FixedStructureBindingCompletor;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.IPartSubTypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemsCompletor;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeBindingImpl;
import org.eclipse.edt.compiler.core.ast.DataTable;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.DataTableScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class DataTableBindingCompletor
extends FixedStructureBindingCompletor {
    private DataTableBinding tableBinding;
    private IProblemRequestor problemRequestor;

    public DataTableBindingCompletor(Scope currentScope, DataTableBinding tableBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(tableBinding, currentScope, dependencyRequestor, problemRequestor, compilerOptions);
        this.tableBinding = tableBinding;
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(DataTable table) {
        table.getName().setBinding(this.tableBinding);
        this.tableBinding.setPrivate(table.isPrivate());
        table.accept(this.getPartSubTypeAndAnnotationCollector());
        this.processSubType();
        table.accept(new StructureItemsCompletor(this.currentScope, this.tableBinding, table.getName().getCanonicalName(), this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
        this.tableBinding.clearSimpleNamesToDataBindingsMap();
        this.processSettingsBlocks();
        return false;
    }

    @Override
    public void endVisit(DataTable dataTable) {
        this.tableBinding.setValid(true);
    }

    @Override
    protected IPartSubTypeAnnotationTypeBinding getDefaultSubType() {
        try {
            return new AnnotationTypeBindingImpl((FlexibleRecordBinding)this.currentScope.findPackage(InternUtil.intern((String)"eglx")).resolvePackage(InternUtil.intern((String)"lang")).resolveType(InternUtil.intern((String)"BasicTable")), this.tableBinding);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    @Override
    protected Scope getFixedStructureScope() {
        return new DataTableScope(this.currentScope, this.tableBinding);
    }
}

