/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import org.eclipse.edt.compiler.binding.AnnotationBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.FixedRecordBinding;
import org.eclipse.edt.compiler.binding.FixedStructureBindingCompletor;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartSubTypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.binding.StructureItemsCompletor;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeBindingImpl;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.FixedStructureScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.NullScope;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.lookup.TypeBindingScope;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class FixedRecordBindingCompletor
extends FixedStructureBindingCompletor {
    private FixedRecordBinding recordBinding;
    private IProblemRequestor problemRequestor;

    public FixedRecordBindingCompletor(Scope currentScope, FixedRecordBinding recordBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(recordBinding, currentScope, dependencyRequestor, problemRequestor, compilerOptions);
        this.recordBinding = recordBinding;
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(Record record) {
        record.getName().setBinding(this.recordBinding);
        this.recordBinding.setPrivate(record.isPrivate());
        record.accept(this.getPartSubTypeAndAnnotationCollector());
        this.processSubType();
        record.accept(new StructureItemsCompletor(this.currentScope, this.recordBinding, record.getName().getCanonicalName(), this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
        this.recordBinding.clearSimpleNamesToDataBindingsMap();
        this.processSettingsBlocks();
        return false;
    }

    @Override
    protected Scope getFixedStructureScope() {
        return new FixedStructureScope(this.currentScope, this.recordBinding);
    }

    @Override
    public void endVisit(Record record) {
        this.recordBinding.setValid(true);
        record.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(Record record) {
                return true;
            }

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                FixedRecordBindingCompletor.this.processResolvableProperties(settingsBlock, null);
                return false;
            }

            @Override
            public boolean visit(StructureItem structureItem) {
                if (structureItem.hasSettingsBlock()) {
                    IBinding binding = structureItem.resolveBinding();
                    if (!Binding.isValidBinding(binding) || !binding.isDataBinding()) {
                        return false;
                    }
                    IDataBinding dataBinding = (IDataBinding)binding;
                    FixedRecordBindingCompletor.this.processResolvableProperties(structureItem.getSettingsBlock(), dataBinding);
                }
                if (FixedRecordBindingCompletor.this.isUIRecord()) {
                    FixedRecordBindingCompletor.this.processResolvableProperties(structureItem);
                }
                return false;
            }
        });
        this.addSqlNullableAnnotations();
    }

    private void addSqlNullableAnnotations() {
        if (!AbstractBinder.annotationIs(this.recordBinding.getSubType(), new String[]{"egl", "io", "sql"}, "SQLRecord")) {
            return;
        }
        IAnnotationBinding aBinding = this.recordBinding.getAnnotation(new String[]{"egl", "io", "sql"}, "isSqlNullable");
        if (aBinding == null) {
            return;
        }
        if (aBinding != null && Boolean.YES == aBinding.getValue()) {
            IDataBinding[] fields = this.recordBinding.getFields();
            int i = 0;
            while (i < fields.length) {
                if (fields[i].getAnnotation(new String[]{"egl", "io", "sql"}, "isSqlNullable") == null) {
                    fields[i].addAnnotation(aBinding);
                }
                ++i;
            }
        }
    }

    private void processResolvableProperties(StructureItem item) {
        if (item.hasType()) {
            ITypeBinding type = item.getType().resolveTypeBinding();
            if (type == null || type == IBinding.NOT_FOUND_BINDING) {
                return;
            }
            if ((type = type.getBaseType()).getKind() == 17 && item.getName() != null) {
                this.processResolvableProperties(item.getName().resolveDataBinding(), item.getType());
                return;
            }
            if (type.getKind() == 6) {
                if (item.getName() != null && item.getName().resolveDataBinding() != null && item.getName().resolveDataBinding() != IBinding.NOT_FOUND_BINDING) {
                    this.processResolvablePropertiesInStructItemBinding((StructureItemBinding)item.getName().resolveDataBinding(), item.getType());
                } else if (item.resolveBinding() != null && item.resolveBinding() != IBinding.NOT_FOUND_BINDING) {
                    this.processResolvablePropertiesInStructItemBinding((StructureItemBinding)item.resolveBinding(), item.getType());
                }
            }
        }
    }

    private void processResolvablePropertiesInStructItemBinding(StructureItemBinding binding, Node node) {
        this.processResolvableProperties(binding, node);
        for (StructureItemBinding itemBinding : binding.getChildren()) {
            this.processResolvablePropertiesInStructItemBinding(itemBinding, node);
        }
    }

    private void processResolvableProperties(IDataBinding dataBinding, Node node) {
        Object value;
        IAnnotationBinding annotation = dataBinding.getAnnotation(new String[]{"egl", "ui"}, "NumElementsItem");
        if (annotation != null) {
            value = annotation.getValue();
            annotation = new AnnotationBinding(InternUtil.internCaseSensitive((String)"NumElementsItem"), this.recordBinding, new AnnotationTypeBindingImpl((FlexibleRecordBinding)this.currentScope.findPackage(InternUtil.intern((String)"egl")).resolvePackage(InternUtil.intern((String)"ui")).resolveType(InternUtil.intern((String)"NumElementsItem")), this.recordBinding));
            dataBinding.addAnnotation(annotation);
            annotation.setValue(this.resolveNumElementsItem(node, value, dataBinding, null), null, null, this.compilerOptions, false);
        }
        if ((annotation = dataBinding.getAnnotation(new String[]{"egl", "ui"}, "SelectedIndexItem")) != null) {
            value = annotation.getValue();
            annotation = new AnnotationBinding(InternUtil.internCaseSensitive((String)"SelectedIndexItem"), this.recordBinding, new AnnotationTypeBindingImpl((FlexibleRecordBinding)this.currentScope.findPackage(InternUtil.intern((String)"egl")).resolvePackage(InternUtil.intern((String)"ui")).resolveType(InternUtil.intern((String)"SelectedIndexItem")), this.recordBinding));
            dataBinding.addAnnotation(annotation);
            annotation.setValue(this.resolveSelectedIndexItem(node, value, dataBinding, null), null, null, this.compilerOptions, false);
        }
    }

    private void processResolvableProperties(SettingsBlock block, final IDataBinding dataBinding) {
        block.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                return true;
            }

            @Override
            public boolean visit(Assignment assignment) {
                IAnnotationBinding annotation = assignment.resolveBinding();
                if (annotation != null) {
                    FixedRecordBindingCompletor.this.processResolvableProperty(annotation.getAnnotationType(), annotation.getValue(), dataBinding, assignment.getRightHandSide());
                    if (FixedRecordBindingCompletor.this.isUIRecord()) {
                        assignment.getRightHandSide().accept(new DefaultASTVisitor(){

                            @Override
                            public boolean visit(ArrayLiteral arrayLiteral) {
                                return true;
                            }

                            @Override
                            public boolean visit(SetValuesExpression setValuesExpression) {
                                IDataBinding exprData = setValuesExpression.getExpression().resolveDataBinding();
                                if (exprData != null && exprData != IBinding.NOT_FOUND_BINDING) {
                                    FixedRecordBindingCompletor.this.processResolvableProperties(setValuesExpression.getSettingsBlock(), exprData);
                                }
                                return false;
                            }
                        });
                    }
                }
                return false;
            }

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                IDataBinding exprData = setValuesExpression.getExpression().resolveDataBinding();
                if (exprData != null && exprData != IBinding.NOT_FOUND_BINDING) {
                    FixedRecordBindingCompletor.this.processResolvableProperties(setValuesExpression.getSettingsBlock(), exprData);
                }
                return false;
            }
        });
    }

    private void processResolvableProperty(IAnnotationTypeBinding annotationType, Object value, IDataBinding dataBinding, Expression expr) {
        if (dataBinding == null || value == null) {
            return;
        }
        IAnnotationBinding annotation = dataBinding.getAnnotation(annotationType);
        if (this.isUIRecord()) {
            if (annotation == null) {
                if (FixedRecordBindingCompletor.annotationIs(dataBinding.getType(), new String[]{"egl", "ui", "webTransaction"}, "LinkParameter") && InternUtil.intern((String)"valueRef") == annotationType.getName()) {
                    ((IAnnotationBinding)dataBinding.findData(InternUtil.intern((String)"valueRef"))).setValue(this.resolveValueRef(expr, value, dataBinding, null), null, null, this.compilerOptions, false);
                    return;
                }
                return;
            }
            if (FixedRecordBindingCompletor.annotationIs(annotationType, new String[]{"egl", "ui"}, "NumElementsItem")) {
                annotation.setValue(this.resolveNumElementsItem(expr, value, dataBinding, null), null, null, this.compilerOptions, false);
                return;
            }
            if (FixedRecordBindingCompletor.annotationIs(annotationType, new String[]{"egl", "ui"}, "SelectedIndexItem")) {
                annotation.setValue(this.resolveSelectedIndexItem(expr, value, dataBinding, null), null, null, this.compilerOptions, false);
                return;
            }
        }
        if (FixedRecordBindingCompletor.annotationIs(annotationType, new String[]{"egl", "core"}, "redefines") && dataBinding.getKind() == 5) {
            Scope saveScope = this.currentScope;
            this.currentScope = new TypeBindingScope(NullScope.INSTANCE, ((StructureItemBinding)dataBinding).getEnclosingStructureBinding(), null);
            annotation.setValue(this.resolveRedefines(expr, value, dataBinding, null), null, null, this.compilerOptions, false);
            this.currentScope = saveScope;
            return;
        }
    }

    private boolean isUIRecord() {
        return this.recordBinding.getAnnotation(new String[]{"egl", "ui", "webTransaction"}, "VGUIRecord") != null;
    }

    @Override
    protected IPartSubTypeAnnotationTypeBinding getDefaultSubType() {
        return null;
    }
}

