/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import org.eclipse.edt.compiler.binding.FunctionContainerBindingCompletor;
import org.eclipse.edt.compiler.binding.IPartSubTypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.ServiceBinding;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;

public class ServiceBindingCompletor
extends FunctionContainerBindingCompletor {
    private ServiceBinding serviceBinding;

    public ServiceBindingCompletor(Scope currentScope, ServiceBinding serviceBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(serviceBinding, currentScope, dependencyRequestor, problemRequestor, compilerOptions);
        this.serviceBinding = serviceBinding;
    }

    @Override
    public boolean visit(Service service) {
        service.getName().setBinding(this.serviceBinding);
        service.getName().setTypeBinding(this.serviceBinding);
        service.accept(this.getPartSubTypeAndAnnotationCollector());
        this.serviceBinding.setPrivate(service.isPrivate());
        this.addImplicitFieldsFromAnnotations();
        for (Name nextName : service.getImplementedInterfaces()) {
            try {
                ITypeBinding typeBinding = this.bindTypeName(nextName);
                this.serviceBinding.addExtenedInterface(typeBinding);
                if (15 == typeBinding.getKind()) continue;
                this.problemRequestor.acceptProblem(nextName, 7801);
            }
            catch (ResolutionException e) {
                this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            }
        }
        return true;
    }

    @Override
    protected IPartSubTypeAnnotationTypeBinding getDefaultSubType() {
        return null;
    }

    @Override
    public void endVisit(Service service) {
        this.processSettingsBlocks();
        this.endVisitFunctionContainer(service);
    }
}

