/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.FixedRecordBinding;
import org.eclipse.edt.compiler.binding.FixedStructureBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.DataTable;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.PrimitiveType;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.NullProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.DataBindingScope;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultBinder;
import org.eclipse.edt.compiler.internal.core.lookup.FixedStructureScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class StructureItemsCompletor
extends AbstractBinder {
    private static final int MAX_STRUCTURE_DEPTH = 45;
    private IProblemRequestor problemRequestor;
    private Stack structureItemsStack = new Stack();
    private StructureItemBindingAndLevel topBindingAndLevel;
    private FixedStructureBinding fixedStructureBinding;
    private String canonicalFixedStructureName;
    private boolean visitingFirstItem = true;
    private boolean firstItemHasLevel;
    private Map namesFor = new HashMap();

    public StructureItemsCompletor(Scope currentScope, FixedStructureBinding fixedStructureBinding, String canonicalFixedStructureName, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, fixedStructureBinding, dependencyRequestor, compilerOptions);
        this.problemRequestor = problemRequestor;
        this.fixedStructureBinding = fixedStructureBinding;
        this.canonicalFixedStructureName = canonicalFixedStructureName;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean visit(StructureItem structureItem) {
        caseSensitiveFieldName = this.getCaseSensitiveFieldName(structureItem);
        typeBinding = null;
        if (structureItem.hasType()) {
            block34: {
                try {
                    typeBinding = this.bindType(structureItem.getType());
                    if (typeBinding.getBaseType().getKind() != 6) break block34;
                    fixedBinding = (FixedRecordBinding)typeBinding.getBaseType();
                    this.fixedStructureBinding.addReferencedStructure(fixedBinding);
                    if (!this.loopExists(fixedBinding)) break block34;
                    this.problemRequestor.acceptProblem((Node)structureItem.getType(), 5072, new String[]{fixedBinding.getCaseSensitiveName()});
                    if (structureItem.getName() != null) {
                        structureItem.getName().setBinding(IBinding.NOT_FOUND_BINDING);
                    }
                    structureItem.getType().accept(new DefaultASTVisitor(){

                        @Override
                        public boolean visit(NameType nameType) {
                            nameType.getName().setBinding(IBinding.NOT_FOUND_BINDING);
                            return false;
                        }

                        @Override
                        public boolean visit(ArrayType arrayType) {
                            arrayType.setTypeBinding(null);
                            return false;
                        }
                    });
                    return false;
                }
                catch (ResolutionException e) {
                    this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
                    if (structureItem.hasSettingsBlock()) {
                        StructureItemsCompletor.bindNamesToNotFound(structureItem.getSettingsBlock());
                    }
                    return false;
                }
            }
            if (!this.isNullable(typeBinding)) ** GOTO lbl29
            this.problemRequestor.acceptProblem(structureItem.getType(), 3430);
            typeBinding = typeBinding.getBaseType();
        } else {
            typeBinding = PrimitiveTypeBinding.getInstance(Primitive.CHAR, -1);
            if (structureItem.hasOccurs()) {
                typeBinding = ArrayTypeBinding.getInstance(typeBinding);
            }
        }
lbl29:
        // 5 sources

        if (typeBinding.getKind() == 6) {
            otherFixedRecord = (FixedRecordBinding)typeBinding;
            if ((typeBinding = this.getFixedRecordTypeBinding(structureItem, otherFixedRecord)) == null) {
                return false;
            }
        } else if (typeBinding.getKind() != 17) {
            if (typeBinding.getKind() == 2) {
                arrayType = (ArrayTypeBinding)typeBinding;
                elementType = arrayType.getElementType();
                if (elementType.getKind() == 6) {
                    typeBinding = this.getFixedRecordTypeBinding(structureItem, (FixedRecordBinding)elementType);
                    if (typeBinding == null) {
                        return false;
                    }
                    typeBinding = ArrayTypeBinding.getInstance(typeBinding.copyTypeBinding());
                } else if (elementType.getKind() != 17 && elementType.getKind() != 3) {
                    this.problemRequestor.acceptProblem((Node)(structureItem.getType().isArrayType() != false ? ((ArrayType)structureItem.getType()).getElementType() : structureItem.getType()), 5061, new String[]{elementType.getCaseSensitiveName()});
                    return false;
                }
            } else if (typeBinding.getKind() != 3 && !structureItem.isEmbedded()) {
                this.problemRequestor.acceptProblem((Node)structureItem.getType(), 5061, new String[]{typeBinding.getCaseSensitiveName()});
                return false;
            }
        }
        if (this.visitingFirstItem) {
            this.firstItemHasLevel = structureItem.hasLevel();
            this.visitingFirstItem = false;
        }
        if ((newItemBinding = this.createStructureItemBinding(caseSensitiveFieldName, structureItem, typeBinding)) == null) {
            return false;
        }
        if (structureItem.hasInitializer()) {
            newItemBinding.setInitialValue(StructureItemsCompletor.getConstantValue(structureItem.getInitializer(), NullProblemRequestor.getInstance(), true));
        }
        newItemAndLevel = null;
        if (structureItem.hasLevel()) {
            newItemAndLevel = new StructureItemBindingAndLevel(structureItem, newItemBinding, Integer.parseInt(structureItem.getLevel()), structureItem.getSettingsBlock(), this.getName(structureItem), false);
            if (!this.firstItemHasLevel) {
                this.problemRequestor.acceptProblem(this.getNodeForErrors(structureItem), 5063, new String[]{this.getCanonicalName(structureItem)});
            }
        } else {
            newItemAndLevel = new StructureItemBindingAndLevel(structureItem, newItemBinding, 10, structureItem.getSettingsBlock(), this.getName(structureItem), false);
            if (this.firstItemHasLevel) {
                this.problemRequestor.acceptProblem(this.getNodeForErrors(structureItem), 5063, new String[]{this.getCanonicalName(structureItem)});
            }
        }
        if (!structureItem.isEmbedded()) ** GOTO lbl85
        if (newItemBinding.getType().getKind() == 6) {
            structureItem.setBinding(newItemBinding);
            structureItems = ((FixedRecordBinding)newItemBinding.getType()).getStructureItems();
            if (structureItems.isEmpty()) {
                this.problemRequestor.acceptProblem((Node)structureItem.getType(), 5062, new String[]{structureItem.getType().getCanonicalName()});
            }
            iter = structureItems.iterator();
            while (iter.hasNext()) {
                this.handleItem(new StructureItemBindingAndLevel(structureItem, (StructureItemBinding)iter.next(), newItemAndLevel.level, null, this.getName(structureItem), true));
            }
            itemCompletor = new ItemCompletor(this.currentScope, newItemBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
            structureItem.accept(itemCompletor);
        } else {
            if (newItemBinding.getType().getKind() == 7) {
                this.problemRequestor.acceptProblem(structureItem.getType(), 4028);
            } else {
                this.problemRequestor.acceptProblem((Node)structureItem.getType(), 5060, new String[]{structureItem.getType().getCanonicalName()});
            }
            return false;
lbl85:
            // 1 sources

            this.handleItem(newItemAndLevel);
            if (structureItem.isFiller()) {
                structureItem.setBinding(newItemBinding);
            } else {
                structureItem.getName().setBinding(newItemBinding);
            }
        }
        return false;
    }

    private Name getName(StructureItem sItem) {
        if (sItem.isEmbedded()) {
            return this.getName(sItem.getType());
        }
        if (!sItem.isFiller()) {
            return sItem.getName();
        }
        return null;
    }

    private Name getName(Type type) {
        final Name[] result = new Name[1];
        type.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(NameType nameType) {
                result[0] = nameType.getName();
                return false;
            }
        });
        return result[0];
    }

    private String getCanonicalName(StructureItem sItem) {
        if (sItem.isEmbedded()) {
            Name name = this.getName(sItem.getType());
            return name == null ? sItem.getType().getCanonicalName() : name.getCanonicalName();
        }
        if (sItem.isFiller()) {
            return "*";
        }
        return sItem.getName().getCanonicalName();
    }

    private Node getNodeForErrors(StructureItem sItem) {
        if (sItem.isEmbedded()) {
            return sItem.getType();
        }
        if (sItem.isFiller()) {
            return sItem;
        }
        return sItem.getName();
    }

    private String getCaseSensitiveFieldName(StructureItem item) {
        if (item.isEmbedded()) {
            return null;
        }
        if (item.isFiller()) {
            return InternUtil.internCaseSensitive((String)"*");
        }
        return item.getName().getCaseSensitiveIdentifier();
    }

    /*
     * Enabled aggressive block sorting
     */
    private StructureItemBinding createStructureItemBinding(String caseSensitiveFieldName, StructureItem structureItem, ITypeBinding typeBinding) {
        StructureItemBinding result;
        int occurs = -1;
        if (typeBinding.getKind() == 2) {
            ArrayTypeBinding arrayTypeBinding = (ArrayTypeBinding)typeBinding;
            if (structureItem.hasType()) {
                ArrayType arrayTypeAST = (ArrayType)structureItem.getType();
                if (!arrayTypeAST.hasInitialSize()) {
                    this.problemRequestor.acceptProblem(structureItem, 4027);
                    return null;
                }
                Expression initialSizeExpr = arrayTypeAST.getInitialSize();
                AbstractBinder.OccursValueFinder occursFinder = new AbstractBinder.OccursValueFinder(this.problemRequestor, InternUtil.intern((String)caseSensitiveFieldName));
                initialSizeExpr.accept(occursFinder);
                occurs = occursFinder.getOccursValue();
                if (occurs == -1) {
                    return null;
                }
                typeBinding = arrayTypeBinding.getElementType();
                if (typeBinding.getKind() == 2) {
                    this.problemRequestor.acceptProblem(structureItem, 0);
                    return null;
                }
            } else if (structureItem.hasOccurs()) {
                occurs = Integer.parseInt(structureItem.getOccurs());
                typeBinding = arrayTypeBinding.getElementType();
            }
        }
        switch (typeBinding.getKind()) {
            case 6: {
                if (structureItem.isEmbedded()) {
                    result = new StructureItemBinding(caseSensitiveFieldName, this.fixedStructureBinding, typeBinding);
                } else {
                    PrimitiveTypeBinding charType = PrimitiveTypeBinding.getInstance(Primitive.CHAR, -1);
                    result = new StructureItemBinding(caseSensitiveFieldName, this.fixedStructureBinding, charType);
                }
                Iterator iter = ((FixedRecordBinding)typeBinding).getStructureItems().iterator();
                while (iter.hasNext()) {
                    result.addChild((StructureItemBinding)iter.next());
                }
                break;
            }
            default: {
                result = new StructureItemBinding(caseSensitiveFieldName, this.fixedStructureBinding, typeBinding);
            }
        }
        if (occurs >= 1) {
            result.setOccurs(occurs);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private void handleItem(StructureItemBindingAndLevel newItemAndLevel) {
        block6: {
            block7: {
                block5: {
                    if (!this.structureItemsStack.isEmpty()) break block5;
                    this.addToRecord(newItemAndLevel);
                    break block6;
                }
                if (newItemAndLevel.level != this.topBindingAndLevel.level) break block7;
                this.popTopItemAndAdd(newItemAndLevel);
                break block6;
            }
            if (newItemAndLevel.level <= this.topBindingAndLevel.level) ** GOTO lbl15
            this.addToTopItem(newItemAndLevel);
            break block6;
lbl-1000:
            // 1 sources

            {
                this.popFromItemStack();
                if (this.structureItemsStack.isEmpty()) break;
                this.topBindingAndLevel = (StructureItemBindingAndLevel)this.structureItemsStack.peek();
lbl15:
                // 2 sources

                ** while (newItemAndLevel.level < this.topBindingAndLevel.level)
            }
lbl16:
            // 2 sources

            if (this.structureItemsStack.isEmpty()) {
                this.problemRequestor.acceptProblem(this.getNodeForErrors(newItemAndLevel.structureItem), 5064, new String[]{Integer.toString(newItemAndLevel.level)});
            } else if (this.topBindingAndLevel.level == newItemAndLevel.level) {
                this.popTopItemAndAdd(newItemAndLevel);
            } else {
                this.problemRequestor.acceptProblem(this.getNodeForErrors(newItemAndLevel.structureItem), 5064, new String[]{Integer.toString(newItemAndLevel.level)});
            }
        }
    }

    private void popAllFromItemsStack() {
        while (!this.structureItemsStack.isEmpty()) {
            this.popFromItemStack();
        }
    }

    private void popFromItemStack() {
        StructureItemBindingAndLevel completed = (StructureItemBindingAndLevel)this.structureItemsStack.pop();
        if (completed.settingsBlock != null) {
            ItemCompletor itemCompletor = new ItemCompletor(this.currentScope, completed.structureItemBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
            completed.settingsBlock.accept(itemCompletor);
        }
    }

    private void popTopItemAndAdd(StructureItemBindingAndLevel newItemAndLevel) {
        this.popFromItemStack();
        if (this.structureItemsStack.isEmpty()) {
            this.addItem(this.fixedStructureBinding, newItemAndLevel);
        } else {
            this.addItem(((StructureItemBindingAndLevel)this.structureItemsStack.peek()).structureItemBinding, newItemAndLevel);
        }
        this.structureItemsStack.push(newItemAndLevel);
        this.topBindingAndLevel = newItemAndLevel;
    }

    private void addToRecord(StructureItemBindingAndLevel newItemAndLevel) {
        this.addItem(this.fixedStructureBinding, newItemAndLevel);
        this.topBindingAndLevel = newItemAndLevel;
        this.structureItemsStack.push(newItemAndLevel);
    }

    private void addToTopItem(StructureItemBindingAndLevel newItemAndLevel) {
        ITypeBinding tBinding;
        Type type;
        if (!this.topBindingAndLevel.structureItemBinding.getChildren().isEmpty() && (type = this.topBindingAndLevel.structureItem.getType()) != null && (tBinding = type.resolveTypeBinding()) != null && IBinding.NOT_FOUND_BINDING != tBinding && 6 == tBinding.getKind()) {
            this.problemRequestor.acceptProblem((Node)this.topBindingAndLevel.nameNode, 5065, new String[]{this.topBindingAndLevel.structureItem.getType().getCanonicalName(), this.topBindingAndLevel.nameNode.getCanonicalName()});
        }
        this.addItem(this.topBindingAndLevel.structureItemBinding, newItemAndLevel);
        this.structureItemsStack.push(newItemAndLevel);
        this.topBindingAndLevel = newItemAndLevel;
    }

    private boolean nameIsDefined(Object parent, String name) {
        if ("*".equals(name)) {
            return false;
        }
        HashSet<String> definedNames = (HashSet<String>)this.namesFor.get(parent);
        if (definedNames == null) {
            definedNames = new HashSet<String>();
            definedNames.add(name);
            this.namesFor.put(parent, definedNames);
            return false;
        }
        if (definedNames.contains(name)) {
            return true;
        }
        definedNames.add(name);
        return false;
    }

    private void requestDuplicateNameProblem(StructureItemBindingAndLevel itemAndLevel) {
        if (itemAndLevel.isFromEmbeddedRecord) {
            this.problemRequestor.acceptProblem((Node)itemAndLevel.nameNode, 4411, new String[]{this.canonicalFixedStructureName, itemAndLevel.structureItemBinding.getName(), itemAndLevel.nameNode.getCanonicalName()});
        } else {
            this.problemRequestor.acceptProblem((Node)itemAndLevel.nameNode, 4407, new String[]{this.canonicalFixedStructureName, itemAndLevel.nameNode.getCanonicalName()});
        }
    }

    private void addItem(FixedStructureBinding parent, StructureItemBindingAndLevel child) {
        if (this.nameIsDefined(parent, child.structureItemBinding.getName())) {
            this.requestDuplicateNameProblem(child);
        } else {
            this.fixedStructureBinding.addStructureItem(child.structureItemBinding);
            child.structureItemBinding.setParentItem(null);
        }
    }

    private void addItem(StructureItemBinding parent, StructureItemBindingAndLevel child) {
        if (this.structureItemsStack.size() > 44) {
            this.problemRequestor.acceptProblem(this.getNodeForErrors(child.structureItem), 5066, new String[]{Integer.toString(45)});
        }
        if (this.nameIsDefined(parent, child.structureItemBinding.getName())) {
            this.requestDuplicateNameProblem(child);
        } else {
            parent.addChild(child.structureItemBinding);
        }
    }

    private ITypeBinding getFixedRecordTypeBinding(StructureItem structureItem, FixedStructureBinding otherFixedRecord) {
        if (!otherFixedRecord.isValid()) {
            otherFixedRecord = (FixedStructureBinding)otherFixedRecord.realize();
        }
        otherFixedRecord = (FixedStructureBinding)otherFixedRecord.copyTypeBinding();
        return otherFixedRecord;
    }

    @Override
    public boolean visit(Record record) {
        return true;
    }

    @Override
    public boolean visit(DataTable dataTable) {
        return true;
    }

    @Override
    public void endVisit(Record record) {
        this.popAllFromItemsStack();
    }

    @Override
    public void endVisit(DataTable dataTable) {
        this.popAllFromItemsStack();
    }

    public boolean loopExists(FixedRecordBinding recType) {
        if (recType.containsReferenceTo(this.fixedStructureBinding)) {
            return true;
        }
        return !recType.isValid && (recType = (FixedRecordBinding)recType.realize()).containsReferenceTo(this.fixedStructureBinding);
    }

    @Override
    public ITypeBinding bindType(Type type) throws ResolutionException {
        PrimitiveTypeBinding primTypeBinding;
        PrimitiveType primitiveType;
        if (type.getKind() == 1 && !(primitiveType = (PrimitiveType)type).hasPrimLength() && !primitiveType.hasPrimPattern() && (primTypeBinding = (PrimitiveTypeBinding)primitiveType.resolveTypeBinding()).getLength() == 0) {
            return PrimitiveTypeBinding.getInstance(primTypeBinding.getPrimitive(), -1);
        }
        return super.bindType(type);
    }

    public class ItemCompletor
    extends DefaultBinder {
        private StructureItemBinding itemBinding;

        public ItemCompletor(Scope currentScope, StructureItemBinding itemBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
            super(currentScope, itemBinding.getDeclaringPart(), dependencyRequestor, problemRequestor, compilerOptions);
            this.itemBinding = itemBinding;
        }

        @Override
        public boolean visit(StructureItem structureItem) {
            if (structureItem.hasSettingsBlock()) {
                structureItem.getSettingsBlock().accept(this);
            }
            return false;
        }

        @Override
        public boolean visit(SettingsBlock settingsBlock) {
            DataBindingScope itemScope = new DataBindingScope(this.currentScope, this.itemBinding);
            AnnotationLeftHandScope annotationScope = new AnnotationLeftHandScope(itemScope, this.itemBinding, this.itemBinding.getType(), this.itemBinding, -1, this.itemBinding.getDeclaringPart());
            settingsBlock.accept(new SettingsBlockAnnotationBindingsCompletor(new FixedStructureScope(this.currentScope, StructureItemsCompletor.this.fixedStructureBinding), this.itemBinding.getDeclaringPart(), annotationScope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
            return false;
        }
    }

    private static class StructureItemBindingAndLevel {
        StructureItem structureItem;
        StructureItemBinding structureItemBinding;
        int level;
        SettingsBlock settingsBlock;
        Name nameNode;
        boolean isFromEmbeddedRecord;
        String embeddedRecordName;

        StructureItemBindingAndLevel(StructureItem structureItem, StructureItemBinding structureItemBinding, int level, SettingsBlock settingsBlock, Name nameNode, boolean isFromEmbeddedRecord) {
            this.structureItem = structureItem;
            this.structureItemBinding = structureItemBinding;
            this.level = level;
            this.settingsBlock = settingsBlock;
            this.nameNode = nameNode;
            this.isFromEmbeddedRecord = isFromEmbeddedRecord;
        }
    }
}

