/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.Collections;
import java.util.Map;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;

public abstract class TypeBinding
extends Binding
implements ITypeBinding {
    private String[] packageName;
    private boolean isReference;
    private boolean isNullable;
    private transient ITypeBinding nonNullableInstance;
    private transient ITypeBinding nullableType;

    public TypeBinding(String caseSensitiveInternedName, String[] packageName) {
        super(caseSensitiveInternedName);
        this.packageName = packageName;
    }

    protected TypeBinding(TypeBinding old) {
        super(old);
        this.packageName = old.packageName;
        this.isReference = old.isReference;
        this.isNullable = old.isNullable;
        this.nonNullableInstance = old.nonNullableInstance;
        this.nullableType = old.nullableType;
    }

    public TypeBinding(String caseSensitiveInternedName) {
        super(caseSensitiveInternedName);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public String[] getPackageName() {
        return this.packageName;
    }

    @Override
    public IDataBinding findData(String simpleName) {
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    public IDataBinding findPublicData(String simpleName) {
        return this.findData(simpleName);
    }

    @Override
    public Map getSimpleNamesToDataBindingsMap() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public IFunctionBinding findFunction(String simpleName) {
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    public IFunctionBinding findPublicFunction(String simpleName) {
        return this.findFunction(simpleName);
    }

    @Override
    public boolean isReference() {
        return this.isReference;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public boolean isDynamicallyAccessible() {
        return this.isDynamic();
    }

    @Override
    public boolean isReferentiallyEqual(ITypeBinding anotherTypeBinding) {
        return false;
    }

    @Override
    public boolean isPackageBinding() {
        return false;
    }

    @Override
    public boolean isFunctionBinding() {
        return false;
    }

    @Override
    public boolean isTypeBinding() {
        return true;
    }

    @Override
    public boolean isDataBinding() {
        return false;
    }

    @Override
    public boolean isAnnotationBinding() {
        return false;
    }

    @Override
    public boolean isPartBinding() {
        return false;
    }

    @Override
    public ITypeBinding copyTypeBinding() {
        throw new UnsupportedOperationException("copyTypeBinding() not overriden for " + this.getClass().getName());
    }

    @Override
    public boolean isNullable() {
        return this.isNullable;
    }

    public void setNullable(boolean value) {
        this.isNullable = value;
    }

    @Override
    public ITypeBinding getNullableInstance() {
        if (this.isNullable()) {
            return this;
        }
        if (this.nullableType == null) {
            this.nullableType = this.primGetNullableInstance();
            ((TypeBinding)this.nullableType).nonNullableInstance = this;
        }
        return this.nullableType;
    }

    public abstract ITypeBinding primGetNullableInstance();

    @Override
    public String getPackageQualifiedName() {
        StringBuffer result = new StringBuffer();
        String[] packageName = this.getPackageName();
        if (packageName != null) {
            int i = 0;
            while (i < packageName.length) {
                result.append(packageName[i]);
                result.append('.');
                ++i;
            }
        }
        result.append(this.getCaseSensitiveName());
        return result.toString();
    }

    @Override
    public ITypeBinding getNonNullableInstance() {
        if (this.isNullable()) {
            return this.nonNullableInstance;
        }
        return this;
    }

    @Override
    public boolean isInstantiable() {
        return this.isReference();
    }

    @Override
    public void clear() {
        super.clear();
        this.isNullable = false;
        this.nonNullableInstance = null;
        this.nullableType = null;
    }
}

