/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding.annotationType;

import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IFieldAccessAnnotationValidationRule;

public class JavaScriptObjectFieldAccessValidator
implements IFieldAccessAnnotationValidationRule {
    @Override
    public boolean validateLValue(Expression lValue, IDataBinding fieldBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (this.hasGetterButNotSetter(fieldBinding)) {
            problemRequestor.acceptProblem((Node)lValue, 3423, new String[]{fieldBinding.getCaseSensitiveName()});
            return false;
        }
        return true;
    }

    @Override
    public boolean validateRValue(Expression rValue, IDataBinding fieldBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (this.hasSetterButNotGetter(fieldBinding)) {
            problemRequestor.acceptProblem((Node)rValue, 3424, new String[]{fieldBinding.getCaseSensitiveName()});
            return false;
        }
        return true;
    }

    private boolean hasGetterButNotSetter(IDataBinding binding) {
        IAnnotationBinding aBinding = binding.getAnnotation(new String[]{"egl", "rui"}, "JavaScriptProperty");
        if (aBinding != null) {
            return aBinding.findData("getMethod") != IBinding.NOT_FOUND_BINDING && aBinding.findData("setMethod") == IBinding.NOT_FOUND_BINDING;
        }
        return false;
    }

    private boolean hasSetterButNotGetter(IDataBinding binding) {
        IAnnotationBinding aBinding = binding.getAnnotation(new String[]{"egl", "rui"}, "JavaScriptProperty");
        if (aBinding != null) {
            return aBinding.findData("setMethod") != IBinding.NOT_FOUND_BINDING && aBinding.findData("getMethod") == IBinding.NOT_FOUND_BINDING;
        }
        return false;
    }
}

