/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.NodeNameUtility;
import org.eclipse.edt.compiler.core.ast.SyntaxError;
import org.eclipse.edt.compiler.internal.core.builder.DefaultProblemRequestor;

public class AccumulatingSyntaxErrorMessageRequestor
implements ISyntaxErrorRequestor {
    private Map syntaxErrors = new Hashtable();

    public Map getSyntaxErrors() {
        return this.syntaxErrors;
    }

    private String[] getTerminalInserts(int terminalType) {
        String terminalName = NodeNameUtility.getTerminalName(terminalType);
        String[] inserts = new String[]{terminalName};
        return inserts;
    }

    private String[] getNonTerminalInserts(int nonTerminalType) {
        String nonTerminalName = NodeNameUtility.getNonterminalName(nonTerminalType);
        String[] inserts = new String[]{nonTerminalName};
        return inserts;
    }

    @Override
    public void incorrectNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2101, startOffset, endOffset, new int[]{nonTerminalType}), DefaultProblemRequestor.getMessageFromBundle(2101, this.getNonTerminalInserts(nonTerminalType)));
    }

    @Override
    public void incorrectPhrase(int nonTerminalType, int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2112, startOffset, endOffset, new int[]{nonTerminalType}), DefaultProblemRequestor.getMessageFromBundle(2112, this.getNonTerminalInserts(nonTerminalType)));
    }

    @Override
    public void incorrectPreviousNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2103, startOffset, endOffset, new int[]{nonTerminalType}), DefaultProblemRequestor.getMessageFromBundle(2103, this.getNonTerminalInserts(nonTerminalType)));
    }

    @Override
    public void incorrectPreviousTerminal(int terminalType, int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2108, startOffset, endOffset, new int[]{terminalType}), DefaultProblemRequestor.getMessageFromBundle(2108, this.getTerminalInserts(terminalType)));
    }

    @Override
    public void incorrectTerminal(int terminalType, int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2105, startOffset, endOffset, new int[]{terminalType}), DefaultProblemRequestor.getMessageFromBundle(2105, this.getTerminalInserts(terminalType)));
    }

    @Override
    public void keywordAsName(int terminalType, int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(3019, startOffset, endOffset, new int[]{terminalType}), DefaultProblemRequestor.getMessageFromBundle(3019, this.getTerminalInserts(terminalType)));
    }

    @Override
    public void missingNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2100, startOffset, endOffset, new int[]{nonTerminalType}), DefaultProblemRequestor.getMessageFromBundle(2100, this.getNonTerminalInserts(nonTerminalType)));
    }

    @Override
    public void missingPreviousNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2102, startOffset, endOffset, new int[]{nonTerminalType}), DefaultProblemRequestor.getMessageFromBundle(2102, this.getNonTerminalInserts(nonTerminalType)));
    }

    @Override
    public void missingPreviousTerminal(int terminalType, int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2107, startOffset, endOffset, new int[]{terminalType}), DefaultProblemRequestor.getMessageFromBundle(2107, this.getTerminalInserts(terminalType)));
    }

    @Override
    public void missingScopeCloser(int terminalType, int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2110, startOffset, endOffset, new int[]{terminalType}), DefaultProblemRequestor.getMessageFromBundle(2110, this.getTerminalInserts(terminalType)));
    }

    @Override
    public void missingTerminal(int terminalType, int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2104, startOffset, endOffset, new int[]{terminalType}), DefaultProblemRequestor.getMessageFromBundle(2104, this.getTerminalInserts(terminalType)));
    }

    @Override
    public void unexpectedPhrase(int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2111, startOffset, endOffset), DefaultProblemRequestor.getMessageFromBundle(2111, new String[0]));
    }

    @Override
    public void unexpectedPreviousTerminal(int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2109, startOffset, endOffset), DefaultProblemRequestor.getMessageFromBundle(2109, new String[0]));
    }

    @Override
    public void unexpectedTerminal(int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2106, startOffset, endOffset), DefaultProblemRequestor.getMessageFromBundle(2106, new String[0]));
    }

    @Override
    public void panicPhrase(int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2113, startOffset, endOffset), DefaultProblemRequestor.getMessageFromBundle(2113, new String[0]));
    }

    @Override
    public void tooManyErrors() {
        this.syntaxErrors.put(new SyntaxError(2114, 0, 0), DefaultProblemRequestor.getMessageFromBundle(2114, new String[0]));
    }

    @Override
    public void invalidEscapeSequence(int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2205, startOffset, endOffset), DefaultProblemRequestor.getMessageFromBundle(2205, new String[0]));
    }

    @Override
    public void unclosedBlockComment(int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2201, startOffset, endOffset), DefaultProblemRequestor.getMessageFromBundle(2201, new String[0]));
    }

    @Override
    public void unclosedDLI(int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2204, startOffset, endOffset), DefaultProblemRequestor.getMessageFromBundle(2204, new String[0]));
    }

    @Override
    public void unclosedSQL(int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2202, startOffset, endOffset), DefaultProblemRequestor.getMessageFromBundle(2202, new String[0]));
    }

    @Override
    public void unclosedSQLCondition(int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2202, startOffset, endOffset), DefaultProblemRequestor.getMessageFromBundle(2202, new String[0]));
    }

    @Override
    public void unclosedString(int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2200, startOffset, endOffset), DefaultProblemRequestor.getMessageFromBundle(2200, new String[0]));
    }

    @Override
    public void whitespaceInDLI(int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2208, startOffset, endOffset), DefaultProblemRequestor.getMessageFromBundle(2208, new String[0]));
    }

    @Override
    public void whitespaceInSQL(int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2206, startOffset, endOffset), DefaultProblemRequestor.getMessageFromBundle(2206, new String[0]));
    }

    @Override
    public void whitespaceInSQLCondition(int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2207, startOffset, endOffset), DefaultProblemRequestor.getMessageFromBundle(2207, new String[0]));
    }

    @Override
    public void invalidCharacterInHexLiteral(int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2209, startOffset, endOffset), DefaultProblemRequestor.getMessageFromBundle(2209, new String[0]));
    }

    @Override
    public void missingEndForPart(int startOffset, int endOffset) {
        this.syntaxErrors.put(new SyntaxError(2003, startOffset, endOffset), DefaultProblemRequestor.getMessageFromBundle(2003, new String[0]));
    }
}

