/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Type;

public class AsExpression
extends Expression {
    private Expression expr;
    private Type type;
    private Expression stringLiteral;

    public AsExpression(Expression expr, Type type, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.expr = expr;
        expr.setParent(this);
        this.type = type;
        type.setParent(this);
    }

    public AsExpression(Expression expr, Expression stringLiteral, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.expr = expr;
        expr.setParent(this);
        this.stringLiteral = stringLiteral;
        stringLiteral.setParent(this);
    }

    public Expression getExpression() {
        return this.expr;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public Type getType() {
        return this.type;
    }

    public boolean hasStringLiteral() {
        return this.stringLiteral != null;
    }

    public Expression getStringLiteral() {
        return this.stringLiteral;
    }

    @Override
    public String getCanonicalString() {
        StringBuffer result = new StringBuffer();
        result.append(this.expr.getCanonicalString());
        result.append(" ");
        result.append("as");
        result.append(" ");
        result.append(this.type == null ? this.stringLiteral.getCanonicalString() : this.type.getCanonicalName());
        return result.toString();
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.expr.accept(visitor);
            if (this.type != null) {
                this.type.accept(visitor);
            } else {
                this.stringLiteral.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return this.type == null ? new AsExpression((Expression)this.expr.clone(), (Expression)this.stringLiteral.clone(), this.getOffset(), this.getOffset() + this.getLength()) : new AsExpression((Expression)this.expr.clone(), (Type)this.type.clone(), this.getOffset(), this.getOffset() + this.getLength());
    }
}

