/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;

public class Assignment
extends Node {
    private Operator operator;
    private Expression lhs;
    private Expression rhs;
    private IAnnotationBinding annotationBinding;

    public Assignment(Operator operator, Expression lhs, Expression rhs, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.operator = operator;
        this.lhs = lhs;
        lhs.setParent(this);
        this.rhs = rhs;
        rhs.setParent(this);
    }

    public IAnnotationBinding resolveBinding() {
        return this.annotationBinding;
    }

    public void setBinding(IAnnotationBinding binding) {
        this.annotationBinding = binding;
    }

    public Expression getLeftHandSide() {
        return this.lhs;
    }

    public Expression getRightHandSide() {
        return this.rhs;
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.lhs.accept(visitor);
            this.rhs.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new Assignment(this.operator, (Expression)this.lhs.clone(), (Expression)this.rhs.clone(), this.getOffset(), this.getOffset() + this.getLength());
    }

    public static class Operator {
        private String token;
        public static final Operator ASSIGN = new Operator("=");
        public static final Operator TIMES = new Operator("*=");
        public static final Operator TIMESTIMES = new Operator("**=");
        public static final Operator DIVIDE = new Operator("/=");
        public static final Operator MODULO = new Operator("%=");
        public static final Operator PLUS = new Operator("+=");
        public static final Operator MINUS = new Operator("-=");
        public static final Operator OR = new Operator("|=");
        public static final Operator AND = new Operator("&=");
        public static final Operator XOR = new Operator("xor=");
        public static final Operator CONCAT = new Operator("::=");
        public static final Operator NULLCONCAT = new Operator("?:=");
        private static final Map CODES = new HashMap(16);

        static {
            Operator[] ops = new Operator[]{ASSIGN, TIMES, TIMESTIMES, DIVIDE, MODULO, PLUS, MINUS, OR, AND, XOR, CONCAT, NULLCONCAT};
            int i = 0;
            while (i < ops.length) {
                CODES.put(ops[i].toString(), ops[i]);
                ++i;
            }
        }

        private Operator(String token) {
            this.token = token;
        }

        public String toString() {
            return this.token;
        }

        public static Operator toOperator(String token) {
            return (Operator)CODES.get(token);
        }
    }
}

